You are an HTML customization assistant. Your task is to take the **Customization instructions** provided below and apply them to the **Reference HTML template**. Generate the updated HTML code based on the instructions.

**Customization Instructions**

1. Change the title in the head element from "Invoice template" to "Professional Business Invoice"
2. Update the company name from "My company name" and "My Company" to "Artemis Digital Solutions"
3. Change the invoice number from "23123123123" to "INV-2024-0578"
4. Update the invoice date to "April 15, 2024" and the due date to "May 5, 2024"
5. Change the line-end border color from "#f0c29e" (orange-ish) to "#6c8ebf" (blue)
6. Replace the first invoice item with "Website Development - Phase 1" with price "$3,500" and quantity "1" for a total of "$3,500"
7. Update the payment method PayPal email to "payments@artemisdigital.com"
8. Change the tax rate from 19% to 21% and update the calculated amounts accordingly
9. Update the Terms content to "Payment due within 20 days. Late payments are subject to a 2% monthly fee."
10. Update the signature name from "John Doe" to "Sarah Johnson" and title from "CEO" to "Director of Operations"

**Reference HTML Template**

```html
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Invoice template</title>

    <style>
      /* Base styles */
      * {
        box-sizing: border-box;
      }
      body {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        font-size: 14px;
        line-height: 1.42857143;
        color: #333;
        background-color: #fff;
        margin: 0;
      }
      h1,
      h2,
      h3,
      h4,
      h5,
      h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
      }
      h1,
      .h1,
      h2,
      .h2,
      h3,
      .h3 {
        margin-top: 10px !important;
        margin-bottom: 10px;
      }
      h1,
      .h1 {
        font-size: 36px;
      }
      h3,
      .h3 {
        font-size: 24px;
      }
      h4,
      .h4 {
        font-size: 18px;
      }
      h5,
      .h5 {
        font-size: 14px;
      }
      h6,
      .h6 {
        font-size: 12px;
      }
      p {
        margin: 0 0 10px;
      }
      small {
        font-size: 85%;
      }

      /* Grid system */
      .container {
        padding-right: 15px;
        padding-left: 15px;
        margin-right: auto;
        margin-left: auto;
        width: 1170px;
      }
      .row {
        margin-right: -15px;
        margin-left: -15px;
      }
      .row:before,
      .row:after {
        display: table;
        content: " ";
      }
      .row:after {
        clear: both;
      }
      .col-xs-1,
      .col-xs-2,
      .col-xs-3,
      .col-xs-4,
      .col-xs-5,
      .col-xs-6,
      .col-xs-7,
      .col-xs-8,
      .col-xs-9,
      .col-xs-10,
      .col-xs-11,
      .col-xs-12 {
        position: relative;
        min-height: 1px;
        padding-right: 15px;
        padding-left: 15px;
        float: left;
      }
      .col-xs-12 {
        width: 100%;
      }
      .col-xs-10 {
        width: 83.33333333%;
      }
      .col-xs-9 {
        width: 75%;
      }
      .col-xs-8 {
        width: 66.66666667%;
      }
      .col-xs-6 {
        width: 50%;
      }
      .col-xs-4 {
        width: 33.33333333%;
      }
      .col-xs-3 {
        width: 25%;
      }
      .col-xs-2 {
        width: 16.66666667%;
      }
      .col-xs-offset-8 {
        margin-left: 66.66666667%;
      }

      /* Utility classes */
      .text-center {
        text-align: center;
      }
      .text-right {
        text-align: right;
      }
      .text-justify {
        text-align: justify;
      }
      .text-muted {
        color: #777;
      }
      .img-fluid {
        max-width: 100%;
        height: auto;
      }

      /* Custom invoice styles */
      .mt-2 {
        margin-top: 10px;
      }
      .mt-4 {
        margin-top: 20px;
      }
      .mb-2 {
        margin-bottom: 20px;
      }
      .mb-4 {
        margin-bottom: 20px;
      }
      .my-2 {
        margin: 0 10px;
      }
      .my-4 {
        margin: 0 20px;
      }
      .mx-2 {
        margin: 10px 0;
      }
      .mx-4 {
        margin: 20px 0;
      }
      .py-2 {
        padding: 0 10px;
      }
      .py-4 {
        padding: 0 20px;
      }
      .d-block {
        display: block;
      }
      .font-weight-light {
        font-weight: 100;
      }
      .font-weight-bold {
        font-weight: bold;
      }

      .line {
        border-bottom: 2px solid #000;
        width: 100%;
      }
      .line-light {
        width: 100%;
        border-bottom: 1px solid #949597;
      }
      .line-end {
        width: 100%;
        border-bottom: 2px solid #f0c29e;
      }

      .data {
        background-color: #dcdddf;
      }
      .data .data-box {
        margin-top: 60px;
      }
      .data .data-box .data-separator {
        border-top: 1px solid #949597;
        width: 10%;
      }

      .content {
        background-color: #f1f1f1;
      }

      .without-margin {
        margin: 0 !important;
      }

      .qr-code {
        margin: 0 auto;
        display: block;
      }

      /* Page break for printing */
      .page {
        page-break-after: always;
        page-break-inside: avoid;
      }

      .row-equal {
        display: table;
        width: 100%;
      }
      .row-equal .col-equal {
        float: none;
        display: table-cell;
        vertical-align: top;
      }
      .spacer-lg {
        margin: 20px;
        display: block;
      }
    </style>
  </head>

  <body>
    <div id="app" class="container invoice page">
      <div class="row row-equal">
        <!-- data -->
        <div class="col-xs-4 data py-4 col-equal">
          <div class="spacer-lg">&nbsp;</div>
          <div class="line mb-4"></div>
          <h1>INVOICE</h1>

          <div class="data-box">
            <div class="data-separator d-block"></div>
            <h4 class="text-muted font-weight-light">No.</h4>
            <h4 class="font-weight-bold">23123123123</h4>
          </div>
          <div class="data-box">
            <div class="data-separator d-block"></div>
            <h4 class="text-muted font-weight-light">INVOICE DATE</h4>
            <h4 class="font-weight-bold">January 05, 2018</h4>
          </div>
          <div class="data-box">
            <div class="data-separator d-block"></div>
            <h4 class="text-muted font-weight-light">DUE DATE</h4>
            <h4 class="font-weight-bold">January 25, 2018</h4>
          </div>
          <div class="data-box">
            <h5 class="font-weight-bold">TERMS</h5>
            <p>Mollit elit reprehenderit consectetur cupidatat anim qui deserunt duis. Veniam laboris id veniam in eu.</p>
          </div>
          <div class="data-box">
            <h5 class="font-weight-bold">PAYMENT METHODS</h5>
            <h6 class="font-weight-light">PAYPAL</h6>
            <p>paypal@example.com</p>
            <h6 class="font-weight-light">ACCOUNTING NUMBER</h6>
            <p>1234567890988</p>
            <h6 class="font-weight-light">QR CODE</h6>
            <!-- Original image tag preserved -->
            <img src="qr.png" alt="" class="img-fluid qr-code" />
          </div>
          <div class="data-box align-text-bottom">
            <h1 class="font-weight-bold text-center">My company name</h1>
          </div>
        </div>
        <!-- end data -->

        <!-- content -->
        <div class="col-xs-8 content py-4 col-equal">
          <div class="spacer-lg">&nbsp;</div>
          <div class="line mb-4"></div>
          <!-- header -->
          <div class="header">
            <div class="row">
              <div class="col-xs-6 from">
                <span class="d-block font-weight-light">FROM:</span>
                <h3>My Company</h3>
                <span class="d-block font-weight-light">123.123.12312</span>
                <span class="d-block font-weight-light">Address sasd asdas</span>
                <span class="d-block font-weight-light">315 234 5677</span>
                <span class="d-block font-weight-light">john@mycompany.com</span>
              </div>
              <div class="col-xs-6 to">
                <span class="d-block font-weight-light">TO:</span>
                <h3>Customer</h3>
                <span class="d-block font-weight-light">123.123.12312</span>
                <span class="d-block font-weight-light">Address sasd asdas</span>
                <span class="d-block font-weight-light">315 234 5677</span>
                <span class="d-block font-weight-light">customer@people.com</span>
              </div>
            </div>
          </div>
          <!-- end header -->

          <!-- note -->
          <div class="row mt-4">
            <div class="col-xs-12">
              <p class="text-justify">Quis sunt mollit nostrud aliqua consectetur voluptate eiusmod proident aute laboris non reprehenderit magna qui. Esse occaecat laboris laborum dolore excepteur enim laboris.</p>
            </div>
          </div>
          <!-- end note -->

          <!-- items-header -->
          <div class="items-header">
            <div class="row mt-4 items-header font-weight-bold">
              <div class="col-xs-12 mx-2">
                <div class="line"></div>
              </div>
              <div class="col-xs-6">DESCRIPTION</div>
              <div class="col-xs-2 text-center">PRICE</div>
              <div class="col-xs-2 text-center">QUANTITY</div>
              <div class="col-xs-2 text-right">TOTAL</div>
              <div class="col-xs-12 mx-2">
                <div class="line"></div>
              </div>
            </div>
          </div>
          <!-- end items-header -->

          <!-- items -->
          <div class="items">
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line-light"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-6">
                <p class="without-margin">Item of the invoice</p>
                <p class="without-margin text-muted">
                  <small>Date: 2018-02-14</small>
                </p>
              </div>
              <div class="col-xs-2 text-center">$ 2.000</div>
              <div class="col-xs-2 text-center">2</div>
              <div class="col-xs-2 text-right">$ 4.000</div>
            </div>
          </div>
          <!-- end items -->

          <!-- values -->
          <div class="values">
            <div class="row">
              <div class="col-xs-12 mx-2">
                <div class="line"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-10 font-weight-bold">SUBTOTAL</div>
              <div class="col-xs-2 text-right font-weight-bold">$ 24.000</div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-10">Discount 10%</div>
              <div class="col-xs-2 text-right">-($ 2.400)</div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-10">Taxes 19%</div>
              <div class="col-xs-2 text-right">$ 4.104</div>
              <div class="col-xs-12 mx-2">
                <div class="line-end"></div>
              </div>
            </div>
            <div class="row mt-2 list-content">
              <div class="col-xs-9">
                <h3 class="font-weight-bold">TOTAL</h3>
              </div>
              <div class="col-xs-3 text-right">
                <h3 class="font-weight-bold">$ 25.704</h3>
              </div>
            </div>
          </div>
          <!-- end values -->

          <!-- signature -->
          <div class="signature my-4">
            <div class="row">
              <div class="col-xs-4 col-xs-offset-8 text-right">
                <!-- Original image tag preserved -->
                <img src="hj.png" alt="" class="img-fluid" />
              </div>
              <div class="col-xs-12 text-right">
                <h4 class="font-weight-bold">John Doe</h4>
                <span class="d-block font-weight-light">CEO</span>
              </div>
            </div>
          </div>
          <!-- end signature -->

          <!-- gratitude -->
          <div class="gratitude text-center my-4">
            <p class="text-muted">If you have any question about this invoice, please contact John Doe to email jhon@mycompany.com, or to the mobile phone (057) 310 671 3456.</p>
            <h3>Thank you</h3>
          </div>
          <!-- end gratitude -->

          <!-- pagination -->
          <div class="invoice-pagination text-right">
            <p class="text-muted text-right">Page 1 of 1</p>
          </div>
          <!-- end pagination -->
        </div>
        <!-- end content -->
      </div>
    </div>
  </body>
</html>
```

Output only the complete updated HTML template with the applied changes.
