/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.mailer.AsyncResponse;
import org.simplejavamail.internal.batchsupport.AsyncResponseImpl;
import org.simplejavamail.internal.batchsupport.concurrent.NamedRunnable;
import org.simplejavamail.internal.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncOperationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncOperationHelper.class);

    private AsyncOperationHelper() {
    }

    static AsyncResponse executeAsync(@NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync(Executors.newSingleThreadExecutor(), processName, operation, true);
    }

    static AsyncResponse executeAsync(@NotNull ExecutorService executorService, @NotNull String processName, @NotNull Runnable operation) {
        return AsyncOperationHelper.executeAsync(executorService, processName, operation, false);
    }

    private static AsyncResponse executeAsync(final @NotNull ExecutorService executorService, final @NotNull String processName, final @NotNull Runnable operation, final boolean shutDownExecutorService) {
        final AtomicReference<AsyncResponseImpl> asyncResponseRef = new AtomicReference<AsyncResponseImpl>();
        Preconditions.assumeTrue((!executorService.isShutdown() ? 1 : 0) != 0, (String)"cannot send async email, executor service is already shut down!");
        asyncResponseRef.set(new AsyncResponseImpl(executorService.submit(new NamedRunnable(processName){

            @Override
            public void run() {
                try {
                    operation.run();
                    ((AsyncResponseImpl)asyncResponseRef.get()).delegateSuccessHandling();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to run " + processName, (Throwable)e);
                    ((AsyncResponseImpl)asyncResponseRef.get()).delegateExceptionHandling(e);
                    throw e;
                }
                finally {
                    if (shutDownExecutorService) {
                        executorService.shutdown();
                    }
                }
            }
        })));
        return (AsyncResponse)asyncResponseRef.get();
    }
}

