/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.bbottema.clusteredobjectpool.core.ClusterConfig;
import org.bbottema.clusteredobjectpool.core.ResourcePool;
import org.bbottema.clusteredobjectpool.core.ResourcePools;
import org.bbottema.clusteredobjectpool.core.api.LoadBalancingStrategy;
import org.bbottema.clusteredobjectpool.core.api.ResourceKey;
import org.bbottema.clusteredobjectpool.util.CompositeFuturesAsFutureTask;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.GenericObjectPool;
import org.bbottema.genericobjectpool.PoolConfig;
import org.bbottema.genericobjectpool.PoolableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClusters<ClusterKey, PoolKey, T> {
    @NotNull
    private final Map<ClusterKey, ResourcePools<PoolKey, T>> resourceClusters;
    @NotNull
    private final ClusterConfig<PoolKey, T> clusterConfig;
    @NotNull
    private final LoadBalancingStrategy<ResourcePool<PoolKey, T>, Collection<ResourcePool<PoolKey, T>>> loadBalancingStrategy;

    public ResourceClusters(ClusterConfig<PoolKey, T> clusterConfig) {
        if (clusterConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.<init> must not be null");
        }
        this.resourceClusters = new HashMap<ClusterKey, ResourcePools<PoolKey, T>>();
        this.clusterConfig = clusterConfig;
        this.loadBalancingStrategy = clusterConfig.getLoadBalancingStrategy();
    }

    public void registerResourcePool(ResourceKey<ClusterKey, PoolKey> key) {
        if (key == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.registerResourcePool must not be null");
        }
        this.registerResourcePool(key, this.clusterConfig.getDefaultExpirationPolicy(), this.clusterConfig.getDefaultCorePoolSize(), this.clusterConfig.getDefaultMaxPoolSize());
    }

    public void registerResourcePool(@NotNull ResourceKey<ClusterKey, PoolKey> key, @NotNull ExpirationPolicy<T> expirationPolicy, int corePoolSize, int maxPoolSize) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.registerResourcePool must not be null");
        }
        if (expirationPolicy == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/clusteredobjectpool/core/ResourceClusters.registerResourcePool must not be null");
        }
        ResourcePools cluster = this.findOrCreateCluster(key.getClusterKey());
        if (cluster.containsPool(key.getPoolKey())) {
            throw new IllegalArgumentException("Pool already exists for " + key);
        }
        GenericObjectPool pool = new GenericObjectPool(PoolConfig.builder().corePoolsize(corePoolSize).maxPoolsize(maxPoolSize).expirationPolicy(expirationPolicy).build(), this.clusterConfig.getAllocatorFactory().create(key.getPoolKey()));
        cluster.add(new ResourcePool(key.getPoolKey(), pool));
    }

    public boolean isPoolRegistered(@NotNull ResourceKey<ClusterKey, PoolKey> key) {
        if (key == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.isPoolRegistered must not be null");
        }
        return this.resourceClusters.containsKey(key.getClusterKey()) && this.resourceClusters.get(key.getClusterKey()).containsPool(key.getPoolKey());
    }

    @Nullable
    public PoolableObject<T> claimResourceFromCluster(ClusterKey clusterKey) throws InterruptedException {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.claimResourceFromCluster must not be null");
        }
        return this.cycleToNextPool(clusterKey).claim(this.clusterConfig.getClaimTimeout());
    }

    @Nullable
    public PoolableObject<T> claimResourceFromPool(ResourceKey<ClusterKey, PoolKey> key) throws InterruptedException {
        if (key == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.claimResourceFromPool must not be null");
        }
        ResourcePools<PoolKey, T> cluster = this.findOrCreateCluster(key.getClusterKey());
        if (!cluster.containsPool(key.getPoolKey())) {
            this.registerResourcePool(key);
        }
        return cluster.claimResource(key.getPoolKey(), this.clusterConfig.getClaimTimeout());
    }

    public int countLiveResources() {
        int total = 0;
        for (ResourcePools<PoolKey, T> resourcePools : this.resourceClusters.values()) {
            total += resourcePools.currentlyAllocated();
        }
        return total;
    }

    public synchronized Future<?> shutDown() {
        Future<Void> future = this.shutdownPool(null);
        if (future == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourceClusters.shutDown must not return null");
        }
        return future;
    }

    public synchronized Future<Void> shutdownPool(@Nullable PoolKey key) {
        ArrayList<Future<Void>> poolsShuttingDown = new ArrayList<Future<Void>>();
        for (ResourcePools<PoolKey, T> resourcePools : this.resourceClusters.values()) {
            poolsShuttingDown.add(resourcePools.shutdownPool(key));
        }
        Future<Void> future = CompositeFuturesAsFutureTask.ofFutures(poolsShuttingDown);
        if (future == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourceClusters.shutdownPool must not return null");
        }
        return future;
    }

    private synchronized ResourcePools<PoolKey, T> findOrCreateCluster(ClusterKey clusterKey) {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.findOrCreateCluster must not be null");
        }
        if (!this.resourceClusters.containsKey(clusterKey)) {
            Collection<ResourcePool<PoolKey, T>> collectionForCycling = this.loadBalancingStrategy.createCollectionForCycling();
            this.resourceClusters.put(clusterKey, new ResourcePools<PoolKey, T>(collectionForCycling));
        }
        ResourcePools<PoolKey, T> resourcePools = this.resourceClusters.get(clusterKey);
        if (resourcePools == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourceClusters.findOrCreateCluster must not return null");
        }
        return resourcePools;
    }

    private synchronized ResourcePool<PoolKey, T> cycleToNextPool(ClusterKey clusterKey) {
        if (clusterKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/clusteredobjectpool/core/ResourceClusters.cycleToNextPool must not be null");
        }
        ResourcePools<PoolKey, T> cluster = this.findOrCreateCluster(clusterKey);
        if (cluster.getClusterCollection().isEmpty()) {
            throw new IllegalStateException(String.format("Cluster contains no pools to draw from for key '%s'", cluster));
        }
        ResourcePool<PoolKey, T> resourcePool = this.loadBalancingStrategy.cycle(cluster.getClusterCollection());
        if (resourcePool == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourceClusters.cycleToNextPool must not return null");
        }
        return resourcePool;
    }

    public ClusterConfig<PoolKey, T> getClusterConfig() {
        ClusterConfig<PoolKey, T> clusterConfig = this.clusterConfig;
        if (clusterConfig == null) {
            throw new IllegalStateException("NotNull method org/bbottema/clusteredobjectpool/core/ResourceClusters.getClusterConfig must not return null");
        }
        return clusterConfig;
    }
}

