/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.factory.IncomingPhoneNumberFactory;
import com.twilio.sdk.resource.instance.IncomingPhoneNumber;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class IncomingPhoneNumberList
extends ListResource<IncomingPhoneNumber, TwilioRestClient>
implements IncomingPhoneNumberFactory {
    public static final String TYPE_LOCAL = "Local";
    public static final String TYPE_TOLLFREE = "TollFree";
    public static final String TYPE_MOBILE = "Mobile";
    public String type = null;

    public IncomingPhoneNumberList(TwilioRestClient client) {
        super(client);
    }

    public IncomingPhoneNumberList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    public IncomingPhoneNumberList(TwilioRestClient client, String type, Map<String, String> filters) {
        super(client, filters);
        this.type = type;
    }

    public IncomingPhoneNumberList(TwilioRestClient client, String type) {
        super(client);
        this.type = type;
    }

    @Override
    protected String getResourceLocation() {
        if (this.type != null) {
            return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/IncomingPhoneNumbers/" + this.type + ".json";
        }
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/IncomingPhoneNumbers.json";
    }

    @Override
    protected IncomingPhoneNumber makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new IncomingPhoneNumber(client, params);
    }

    @Override
    protected String getListKey() {
        return "incoming_phone_numbers";
    }

    @Override
    public IncomingPhoneNumber create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioRestClient)this.getClient(), response.toMap());
    }

    @Override
    public IncomingPhoneNumber create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioRestClient)this.getClient(), response.toMap());
    }
}

