/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.ipmessaging;

import com.twilio.sdk.TwilioIPMessagingClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Credential
extends NextGenInstanceResource<TwilioIPMessagingClient> {
    public Credential(TwilioIPMessagingClient client, String sid) {
        super(client);
        if (StringUtils.isEmpty((CharSequence)sid)) {
            throw new IllegalArgumentException("sid cannot be null");
        }
        this.setProperty("sid", sid);
    }

    public Credential(TwilioIPMessagingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getType() {
        return this.getProperty("type");
    }

    public Calendar getDateCreated() {
        return this.parseCalendar(this.getProperty("date_created"));
    }

    public Calendar getDateUpdated() {
        return this.parseCalendar(this.getProperty("date_updated"));
    }

    public String getUrl() {
        return this.getProperty("url");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioIPMessagingClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Credentials/" + this.getSid();
    }
}

