/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser.impl;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlAsofJoin;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlBinaryStringLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlDescribeTable;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcDataTypeName;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonEncoding;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonValueReturning;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLambda;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMapTypeNameSpec;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.Span;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.impl.ParseException;
import org.apache.calcite.sql.parser.impl.SimpleCharStream;
import org.apache.calcite.sql.parser.impl.SqlParserImplConstants;
import org.apache.calcite.sql.parser.impl.SqlParserImplTokenManager;
import org.apache.calcite.sql.parser.impl.Token;
import org.apache.calcite.sql.parser.impl.TokenMgrError;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class SqlParserImpl
extends SqlAbstractParserImpl
implements SqlParserImplConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();
    private static final char BACKSLASH = '\\';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String DQ = "\"";
    private static final String DQDQ = "\"\"";
    private static final SqlLiteral LITERAL_ZERO = SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_ONE = SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_MINUS_ONE = SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static SqlAbstractParserImpl.Metadata metadata;
    private Casing unquotedCasing;
    private Casing quotedCasing;
    private int identifierMaxLength;
    private SqlConformance conformance;
    public static final SqlParserImplFactory FACTORY;
    public SqlParserImplTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[446];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private static int[] jj_la1_15;
    private static int[] jj_la1_16;
    private static int[] jj_la1_17;
    private static int[] jj_la1_18;
    private static int[] jj_la1_19;
    private static int[] jj_la1_20;
    private static int[] jj_la1_21;
    private static int[] jj_la1_22;
    private static int[] jj_la1_23;
    private static int[] jj_la1_24;
    private final JJCalls[] jj_2_rtns = new JJCalls[118];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    @Override
    public SqlParseException normalizeException(Throwable ex) {
        try {
            if (ex instanceof ParseException) {
                ex = this.cleanupParseException((ParseException)ex);
            }
            return this.convertException(ex);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlAbstractParserImpl.Metadata getMetadata() {
        Class<SqlParserImpl> clazz = SqlParserImpl.class;
        synchronized (SqlParserImpl.class) {
            if (metadata == null) {
                metadata = new SqlAbstractParserImpl.MetadataImpl(new SqlParserImpl(new StringReader("")));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metadata;
        }
    }

    @Override
    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    @Override
    public void switchTo(SqlAbstractParserImpl.LexicalState state) {
        int stateOrdinal = Arrays.asList(SqlParserImplTokenManager.lexStateNames).indexOf(state.name());
        this.token_source.SwitchTo(stateOrdinal);
    }

    @Override
    public void setQuotedCasing(Casing quotedCasing) {
        this.quotedCasing = quotedCasing;
    }

    @Override
    public void setUnquotedCasing(Casing unquotedCasing) {
        this.unquotedCasing = unquotedCasing;
    }

    @Override
    public void setIdentifierMaxLength(int identifierMaxLength) {
        this.identifierMaxLength = identifierMaxLength;
    }

    @Override
    public void setConformance(SqlConformance conformance) {
        this.conformance = conformance;
    }

    @Override
    public SqlNode parseSqlExpressionEof() throws Exception {
        return this.SqlExpressionEof();
    }

    @Override
    public SqlNode parseSqlStmtEof() throws Exception {
        return this.SqlStmtEof();
    }

    @Override
    public SqlNodeList parseSqlStmtList() throws Exception {
        return this.SqlStmtList();
    }

    @Override
    public SqlNode parseArray() throws SqlParseException {
        this.switchTo(SqlAbstractParserImpl.LexicalState.BQID);
        try {
            return this.ArrayLiteral();
        }
        catch (ParseException ex) {
            throw this.normalizeException(ex);
        }
        catch (TokenMgrError ex) {
            throw this.normalizeException(ex);
        }
    }

    private SqlNode extend(SqlNode table, SqlNodeList extendList) {
        return SqlStdOperatorTable.EXTEND.createCall(Span.of(table, extendList).pos(), table, extendList);
    }

    private TimeUnit warn(TimeUnit timeUnit) throws ParseException {
        String token = this.getToken((int)0).image.toUpperCase(Locale.ROOT);
        this.warnings.add(SqlUtil.newContextException(this.getPos(), Static.RESOURCE.nonStandardFeatureUsed(token)));
        return timeUnit;
    }

    void debug_message1() throws ParseException {
        LOGGER.info("{} , {}", (Object)this.getToken((int)0).image, (Object)this.getToken((int)1).image);
    }

    String unquotedIdentifier() throws ParseException {
        return SqlParserUtil.toCase(this.getToken((int)0).image, this.unquotedCasing);
    }

    public final SqlNode ExtendedTableRef() throws ParseException {
        this.UnusedExtension();
        return null;
    }

    public final SqlNode TableOverOpt() throws ParseException {
        return null;
    }

    public final void SqlSelectKeywords(List<SqlLiteral> keywords) throws ParseException {
        this.E();
    }

    public final void SqlInsertKeywords(List<SqlLiteral> keywords) throws ParseException {
        this.E();
    }

    public final SqlNode FloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
        SqlNode node = this.StandardFloorCeilOptions(s, floorFlag);
        return node;
    }

    void E() throws ParseException {
    }

    List startList(Object o) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        return list;
    }

    @Override
    protected SqlParserPos getPos() throws ParseException {
        return new SqlParserPos(this.token.beginLine, this.token.beginColumn, this.token.endLine, this.token.endColumn);
    }

    Span span() throws ParseException {
        return Span.of(this.getPos());
    }

    void checkQueryExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (exprContext) {
            case ACCEPT_NON_QUERY: 
            case ACCEPT_SUB_QUERY: 
            case ACCEPT_CURSOR: {
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalQueryExpression());
            }
        }
    }

    void checkNonQueryExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (exprContext) {
            case ACCEPT_QUERY: {
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalNonQueryExpression());
            }
        }
    }

    SqlNode checkNotJoin(SqlNode e) throws ParseException {
        if (e instanceof SqlJoin) {
            throw SqlUtil.newContextException(e.getParserPosition(), Static.RESOURCE.illegalJoinExpression());
        }
        return e;
    }

    SqlParseException convertException(Throwable ex) throws ParseException {
        if (ex instanceof SqlParseException) {
            return (SqlParseException)ex;
        }
        SqlParserPos pos = null;
        int[][] expectedTokenSequences = null;
        String[] tokenImage = null;
        if (ex instanceof ParseException) {
            ParseException pex = (ParseException)ex;
            expectedTokenSequences = pex.expectedTokenSequences;
            tokenImage = pex.tokenImage;
            if (pex.currentToken != null) {
                Token token = pex.currentToken.next;
                if (!token.image.equals("1") && this.getMetadata().isKeyword(token.image) && SqlParserUtil.allowsIdentifier(tokenImage, expectedTokenSequences)) {
                    String expecting = ex.getMessage().substring(ex.getMessage().indexOf("Was expecting"));
                    String errorMsg = String.format("Incorrect syntax near the keyword '%s' at line %d, column %d.\n%s", token.image, token.beginLine, token.beginColumn, expecting);
                    ex = new ParseException(errorMsg);
                }
                pos = new SqlParserPos(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
            }
        } else if (ex instanceof TokenMgrError) {
            expectedTokenSequences = null;
            tokenImage = null;
            Pattern pattern = Pattern.compile("(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (matcher.matches()) {
                int line = Integer.parseInt(matcher.group(1));
                int column = Integer.parseInt(matcher.group(2));
                pos = new SqlParserPos(line, column, line, column);
            }
        } else if (ex instanceof CalciteContextException) {
            CalciteContextException ece = (CalciteContextException)ex;
            pos = new SqlParserPos(ece.getPosLine(), ece.getPosColumn(), ece.getEndPosLine(), ece.getEndPosColumn());
            ex = ece.getCause();
        }
        return new SqlParseException(ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
    }

    ParseException cleanupParseException(ParseException ex) throws ParseException {
        if (ex.expectedTokenSequences == null) {
            return ex;
        }
        int iIdentifier = Arrays.asList(ex.tokenImage).indexOf("<IDENTIFIER>");
        ArrayList<int[]> prefixList = new ArrayList<int[]>();
        for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
            int[] seq = ex.expectedTokenSequences[i];
            int j = seq.length - 1;
            int i1 = seq[j];
            if (i1 != iIdentifier) continue;
            int[] prefix = new int[j];
            System.arraycopy(seq, 0, prefix, 0, j);
            prefixList.add(prefix);
        }
        if (prefixList.isEmpty()) {
            return ex;
        }
        int[][] prefixes = (int[][])prefixList.toArray((T[])new int[prefixList.size()][]);
        ArrayList<int[]> list = new ArrayList<int[]>();
        SqlAbstractParserImpl.Metadata metadata = this.getMetadata();
        for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
            int[] seq = ex.expectedTokenSequences[i];
            String tokenImage = ex.tokenImage[seq[seq.length - 1]];
            String token = SqlParserUtil.getTokenVal(tokenImage);
            if (token == null || !metadata.isNonReservedKeyword(token)) {
                list.add(seq);
                continue;
            }
            boolean match = this.matchesPrefix(seq, prefixes);
            if (match) continue;
            list.add(seq);
        }
        ex.expectedTokenSequences = (int[][])list.toArray((T[])new int[list.size()][]);
        return ex;
    }

    boolean matchesPrefix(int[] seq, int[][] prefixes) throws ParseException {
        block0: for (int[] prefix : prefixes) {
            if (seq.length != prefix.length + 1) continue;
            for (int k = 0; k < prefix.length; ++k) {
                if (prefix[k] != seq[k]) continue block0;
            }
            return true;
        }
        return false;
    }

    public final SqlNode ExprOrJoinOrOrderedQuery(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.jj_2_1(2)) {
            SqlNode e = this.Query(exprContext);
            e = this.OrderByLimitOpt(e);
            return e;
        }
        if (this.jj_2_2(1)) {
            SqlNode e = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: 
                    case 114: 
                    case 228: 
                    case 265: 
                    case 284: 
                    case 307: 
                    case 358: 
                    case 398: 
                    case 484: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block6;
                    }
                }
                e = this.JoinTable(e);
            }
            list.add(e);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 197: 
                    case 274: 
                    case 530: 
                    case 668: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block7;
                    }
                }
                this.AddSetOpQuery(list, exprContext);
            }
            return SqlParserUtil.toTree(list);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.QueryOrExpr(exprContext);
        e = this.OrderByLimitOpt(e);
        return e;
    }

    public final SqlNode OrderByLimitOpt(SqlNode e) throws ParseException {
        SqlNodeList orderBy;
        Span s = Span.of();
        SqlNode[] offsetFetch = new SqlNode[]{null, null};
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderBy = this.OrderBy(e.isA(SqlKind.QUERY));
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                orderBy = null;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 210: 
            case 313: 
            case 382: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 313: {
                        this.LimitClause(s, offsetFetch);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 382: {
                                this.OffsetClause(s, offsetFetch);
                                break block3;
                            }
                        }
                        this.jj_la1[3] = this.jj_gen;
                        break block3;
                    }
                    case 382: {
                        this.OffsetClause(s, offsetFetch);
                        block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 210: 
                            case 313: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 313: {
                                        this.LimitClause(s, offsetFetch);
                                        if (this.conformance.isOffsetLimitAllowed()) break block3;
                                        throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.offsetLimitNotAllowed());
                                    }
                                    case 210: {
                                        this.FetchClause(offsetFetch);
                                        break block14;
                                    }
                                    default: {
                                        this.jj_la1[4] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break;
                            }
                        }
                        break block3;
                    }
                    case 210: {
                        this.FetchClause(offsetFetch);
                        break block3;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        if (orderBy != null || offsetFetch[0] != null || offsetFetch[1] != null) {
            return new SqlOrderBy(this.getPos(), e, Util.first(orderBy, SqlNodeList.EMPTY), offsetFetch[0], offsetFetch[1]);
        }
        return e;
    }

    public final void OffsetClause(Span s, SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(382);
        s.add(this);
        offsetFetch[0] = this.UnsignedNumericLiteralOrParam();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 493: 
            case 496: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 493: {
                        this.jj_consume_token(493);
                        break block0;
                    }
                    case 496: {
                        this.jj_consume_token(496);
                        break block0;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final void FetchClause(SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(210);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 213: {
                this.jj_consume_token(213);
                break;
            }
            case 363: {
                this.jj_consume_token(363);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 493: {
                this.jj_consume_token(493);
                break;
            }
            case 496: {
                this.jj_consume_token(496);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(387);
    }

    public final void LimitClause(Span s, SqlNode[] offsetFetch) throws ParseException {
        this.jj_consume_token(313);
        s.add(this);
        if (this.jj_2_3(2)) {
            String error;
            offsetFetch[0] = this.UnsignedNumericLiteralOrParam();
            this.jj_consume_token(745);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 149: 
                case 718: 
                case 719: 
                case 720: 
                case 749: {
                    offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
                    error = "count";
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    error = "ALL";
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (!this.conformance.isLimitStartCountAllowed()) {
                throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.limitStartCountOrAllNotAllowed(error));
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 149: 
                case 718: 
                case 719: 
                case 720: 
                case 749: {
                    offsetFetch[1] = this.UnsignedNumericLiteralOrParam();
                    break;
                }
                case 10: {
                    this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final SqlNode LeafQuery(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 518: {
                this.checkQueryExpression(exprContext);
                SqlSelect e = this.SqlSelect();
                return e;
            }
            case 688: 
            case 689: {
                SqlNode e = this.TableConstructor();
                return e;
            }
            case 620: {
                SqlNode e = this.ExplicitTable(this.getPos());
                return e;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode ParenthesizedExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.jj_consume_token(733);
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                exprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                exprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
            }
        }
        SqlNode e = this.ExprOrJoinOrOrderedQuery(exprContext);
        this.jj_consume_token(734);
        exprContext.throwIfNotCompatible(e);
        return e;
    }

    public final SqlNodeList ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlAbstractParserImpl.ExprContext firstExprContext = exprContext;
        this.jj_consume_token(733);
        Span s = this.span();
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
            }
        }
        SqlNode e = this.OrderedQueryOrExpr(firstExprContext);
        list.add(e);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(745);
            this.checkNonQueryExpression(exprContext);
            this.AddExpression(list, exprContext);
        }
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final SqlNodeList ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        Span s;
        ArrayList<SqlNode> list;
        block16: {
            SqlNode e;
            list = new ArrayList<SqlNode>();
            SqlAbstractParserImpl.ExprContext firstExprContext = exprContext;
            this.jj_consume_token(733);
            s = this.span();
            switch (exprContext) {
                case ACCEPT_SUB_QUERY: {
                    firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                    break;
                }
                case ACCEPT_CURSOR: {
                    firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 125: 
                case 126: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 160: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 184: 
                case 187: 
                case 192: 
                case 194: 
                case 196: 
                case 198: 
                case 199: 
                case 200: 
                case 203: 
                case 204: 
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 214: 
                case 216: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 243: 
                case 246: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 323: 
                case 326: 
                case 328: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 362: 
                case 363: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 402: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 422: 
                case 423: 
                case 424: 
                case 425: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 432: 
                case 434: 
                case 436: 
                case 439: 
                case 440: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 450: 
                case 451: 
                case 460: 
                case 464: 
                case 466: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 484: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: 
                case 497: 
                case 498: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 518: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 527: 
                case 529: 
                case 533: 
                case 534: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 596: 
                case 598: 
                case 599: 
                case 601: 
                case 602: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 611: 
                case 614: 
                case 619: 
                case 620: 
                case 621: 
                case 623: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 647: 
                case 652: 
                case 653: 
                case 654: 
                case 655: 
                case 657: 
                case 658: 
                case 659: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 675: 
                case 677: 
                case 678: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 687: 
                case 688: 
                case 689: 
                case 691: 
                case 692: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 708: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 715: 
                case 716: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 724: 
                case 725: 
                case 726: 
                case 727: 
                case 728: 
                case 730: 
                case 731: 
                case 733: 
                case 735: 
                case 736: 
                case 737: 
                case 738: 
                case 749: 
                case 755: 
                case 756: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    e = this.OrderedQueryOrExpr(firstExprContext);
                    list.add(e);
                    break;
                }
                case 151: {
                    e = this.Default();
                    list.add(e);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 745: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(745);
                this.checkNonQueryExpression(exprContext);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.Expression(exprContext);
                        list.add(e);
                        continue block15;
                    }
                    case 151: {
                        e = this.Default();
                        list.add(e);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final List<SqlNode> UnquantifiedFunctionParameterList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        List<SqlNode> args = this.FunctionParameterList(exprContext);
        args.remove(0);
        return args;
    }

    public final List<SqlNode> FunctionParameterList(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(733);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 173: {
                SqlLiteral qualifier = this.AllOrDistinct();
                list.add(qualifier);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                list.add(null);
            }
        }
        this.AddArg0(list, exprContext);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(745);
            this.checkNonQueryExpression(exprContext);
            this.AddArg(list, exprContext);
        }
        this.jj_consume_token(734);
        return list;
    }

    public final SqlLiteral AllOrDistinct() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 173: {
                this.jj_consume_token(173);
                return SqlSelectKeyword.DISTINCT.symbol(this.getPos());
            }
            case 10: {
                this.jj_consume_token(10);
                return SqlSelectKeyword.ALL.symbol(this.getPos());
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void AddArg0(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e;
        SqlIdentifier name;
        SqlAbstractParserImpl.ExprContext firstExprContext;
        switch (exprContext) {
            case ACCEPT_SUB_QUERY: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR;
                break;
            }
            case ACCEPT_CURSOR: {
                firstExprContext = SqlAbstractParserImpl.ExprContext.ACCEPT_ALL;
                break;
            }
            default: {
                firstExprContext = exprContext;
            }
        }
        if (this.jj_2_4(2)) {
            name = this.SimpleIdentifier();
            this.jj_consume_token(762);
        } else {
            name = null;
        }
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: {
                e = this.Default();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                if (this.jj_2_5(Integer.MAX_VALUE)) {
                    e = this.LambdaExpression();
                    break;
                }
                if (this.jj_2_6(3)) {
                    e = this.TableParam();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 518: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 620: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 688: 
                    case 689: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 708: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.PartitionedQueryOrQueryOrExpr(firstExprContext);
                        break block4;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(Span.of(name, e).pos(), e, name);
        }
        list.add(e);
    }

    public final void AddArg(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e;
        SqlIdentifier name;
        if (this.jj_2_7(2)) {
            name = this.SimpleIdentifier();
            this.jj_consume_token(762);
        } else {
            name = null;
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 151: {
                e = this.Default();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                if (this.jj_2_8(Integer.MAX_VALUE)) {
                    e = this.LambdaExpression();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.Expression(exprContext);
                        break block0;
                    }
                    case 620: {
                        e = this.TableParam();
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(Span.of(name, e).pos(), e, name);
        }
        list.add(e);
    }

    public final SqlNode Default() throws ParseException {
        this.jj_consume_token(151);
        return SqlStdOperatorTable.DEFAULT.createCall(this.getPos(), new SqlNode[0]);
    }

    public final SqlNode SqlQueryEof() throws ParseException {
        SqlNode query = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        this.jj_consume_token(0);
        return query;
    }

    public final SqlNodeList SqlStmtList() throws ParseException {
        ArrayList<SqlNode> stmtList = new ArrayList<SqlNode>();
        SqlNode stmt = this.SqlStmt();
        stmtList.add(stmt);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 743: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(743);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 125: 
                case 126: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 184: 
                case 187: 
                case 192: 
                case 194: 
                case 196: 
                case 198: 
                case 199: 
                case 200: 
                case 203: 
                case 204: 
                case 205: 
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 214: 
                case 216: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 243: 
                case 246: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 269: 
                case 270: 
                case 271: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 323: 
                case 326: 
                case 328: 
                case 329: 
                case 333: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 362: 
                case 363: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 402: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 422: 
                case 423: 
                case 424: 
                case 425: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 432: 
                case 434: 
                case 436: 
                case 439: 
                case 440: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 450: 
                case 451: 
                case 460: 
                case 464: 
                case 466: 
                case 467: 
                case 469: 
                case 470: 
                case 471: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 484: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: 
                case 497: 
                case 498: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 518: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 527: 
                case 528: 
                case 529: 
                case 533: 
                case 534: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 596: 
                case 598: 
                case 599: 
                case 601: 
                case 602: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 611: 
                case 614: 
                case 619: 
                case 620: 
                case 621: 
                case 623: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 647: 
                case 652: 
                case 653: 
                case 654: 
                case 655: 
                case 657: 
                case 658: 
                case 659: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 674: 
                case 675: 
                case 676: 
                case 677: 
                case 678: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 687: 
                case 688: 
                case 689: 
                case 691: 
                case 692: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 708: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 715: 
                case 716: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 724: 
                case 725: 
                case 726: 
                case 727: 
                case 728: 
                case 730: 
                case 731: 
                case 733: 
                case 735: 
                case 736: 
                case 737: 
                case 738: 
                case 749: 
                case 755: 
                case 756: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    stmt = this.SqlStmt();
                    stmtList.add(stmt);
                    continue block6;
                }
            }
            this.jj_la1[27] = this.jj_gen;
        }
        this.jj_consume_token(0);
        return new SqlNodeList(stmtList, Span.of(stmtList).pos());
    }

    public final SqlNode SqlStmt() throws ParseException {
        SqlNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 471: 
            case 528: {
                stmt = this.SqlSetOption(Span.of(), null);
                break;
            }
            case 13: {
                stmt = this.SqlAlter();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 620: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 708: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                stmt = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                break;
            }
            case 205: {
                stmt = this.SqlExplain();
                break;
            }
            case 165: {
                stmt = this.SqlDescribe();
                break;
            }
            case 269: 
            case 676: {
                stmt = this.SqlInsert();
                break;
            }
            case 159: {
                stmt = this.SqlDelete();
                break;
            }
            case 674: {
                stmt = this.SqlUpdate();
                break;
            }
            case 333: {
                stmt = this.SqlMerge();
                break;
            }
            case 51: {
                stmt = this.SqlProcedureCall();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final SqlNode SqlStmtEof() throws ParseException {
        SqlNode stmt = this.SqlStmt();
        this.jj_consume_token(0);
        return stmt;
    }

    public final SqlNodeList ParenthesizedKeyValueOptionCommaList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddKeyValueOption(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddKeyValueOption(list);
        }
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddKeyValueOption(List<SqlNode> list) throws ParseException {
        SqlNode key;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                key = this.SimpleIdentifier();
                break;
            }
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: {
                key = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(746);
        SqlNode value = this.StringLiteral();
        list.add(key);
        list.add(value);
    }

    public final void AddOptionValue(List<SqlNode> list) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: 
            case 718: 
            case 719: 
            case 720: 
            case 755: 
            case 756: {
                SqlLiteral value = this.NumericLiteral();
                list.add(value);
                break;
            }
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: {
                SqlNode value = this.StringLiteral();
                list.add(value);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SqlNodeList ParenthesizedLiteralOptionCommaList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddOptionValue(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddOptionValue(list);
        }
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddHint(List<SqlNode> hints) throws ParseException {
        SqlHint.HintOptionFormat optionFormat;
        SqlNodeList hintOptions;
        SqlIdentifier hintName = this.SimpleIdentifier();
        if (this.jj_2_9(5)) {
            hintOptions = this.ParenthesizedKeyValueOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.KV_LIST;
        } else if (this.jj_2_10(3)) {
            hintOptions = this.ParenthesizedSimpleIdentifierList();
            optionFormat = SqlHint.HintOptionFormat.ID_LIST;
        } else if (this.jj_2_11(3)) {
            hintOptions = this.ParenthesizedLiteralOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 733: {
                    this.jj_consume_token(733);
                    this.jj_consume_token(734);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            hintOptions = SqlNodeList.EMPTY;
            optionFormat = SqlHint.HintOptionFormat.EMPTY;
        }
        hints.add(new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions, optionFormat));
    }

    public final SqlNode TableHints(SqlIdentifier tableName) throws ParseException {
        ArrayList<SqlNode> hints = new ArrayList<SqlNode>();
        this.jj_consume_token(774);
        this.AddHint(hints);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddHint(hints);
        }
        this.jj_consume_token(775);
        SqlParserPos pos = Span.of(tableName).addAll(hints).end(this);
        SqlNodeList hintList = new SqlNodeList(hints, pos);
        return new SqlTableRef(pos, tableName, hintList);
    }

    public final SqlSelect SqlSelect() throws ParseException {
        SqlNode qualify;
        SqlNodeList windowDecls;
        SqlNode having;
        SqlNodeList groupBy;
        SqlNode where;
        SqlNode fromClause;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        ArrayList<SqlNode> hints = new ArrayList<SqlNode>();
        this.jj_consume_token(518);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 774: {
                this.jj_consume_token(774);
                this.AddHint(hints);
                block33: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block33;
                        }
                    }
                    this.jj_consume_token(745);
                    this.AddHint(hints);
                }
                this.jj_consume_token(775);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.SqlSelectKeywords(keywords);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 603: {
                this.jj_consume_token(603);
                keywords.add(SqlSelectKeyword.STREAM.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 173: {
                SqlLiteral keyword = this.AllOrDistinct();
                keywords.add(keyword);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        SqlNodeList keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
        this.AddSelectItem(selectList);
        block34: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block34;
                }
            }
            this.jj_consume_token(745);
            this.AddSelectItem(selectList);
        }
        block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 227: {
                this.jj_consume_token(227);
                fromClause = this.FromClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 705: {
                        where = this.Where();
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        where = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 241: {
                        groupBy = this.GroupBy();
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        groupBy = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 245: {
                        having = this.Having();
                        break;
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                        having = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 707: {
                        windowDecls = this.Window();
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        windowDecls = null;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 446: {
                        qualify = this.Qualify();
                        break block15;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                qualify = null;
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.E();
                fromClause = null;
                where = null;
                groupBy = null;
                having = null;
                windowDecls = null;
                qualify = null;
            }
        }
        return new SqlSelect(s.end(this), keywordList, new SqlNodeList(selectList, Span.of(selectList).pos()), fromClause, where, groupBy, having, windowDecls, qualify, null, null, null, new SqlNodeList(hints, this.getPos()));
    }

    public final SqlNode SqlExplain() throws ParseException {
        SqlExplainFormat format;
        SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        this.jj_consume_token(205);
        this.jj_consume_token(429);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 200: 
            case 260: {
                detailLevel = this.ExplainDetailLevel();
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        SqlExplain.Depth depth = this.ExplainDepth();
        if (this.jj_2_12(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(714);
            format = SqlExplainFormat.XML;
        } else if (this.jj_2_13(2)) {
            this.jj_consume_token(23);
            this.jj_consume_token(285);
            format = SqlExplainFormat.JSON;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    this.jj_consume_token(175);
                    format = SqlExplainFormat.DOT;
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    format = SqlExplainFormat.TEXT;
                }
            }
        }
        this.jj_consume_token(218);
        SqlNode stmt = this.SqlQueryOrDml();
        return new SqlExplain(this.getPos(), stmt, detailLevel.symbol(SqlParserPos.ZERO), depth.symbol(SqlParserPos.ZERO), format.symbol(SqlParserPos.ZERO), this.nDynamicParams);
    }

    public final SqlNode SqlQueryOrDml() throws ParseException {
        SqlNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 620: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 708: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                stmt = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
                break;
            }
            case 269: 
            case 676: {
                stmt = this.SqlInsert();
                break;
            }
            case 159: {
                stmt = this.SqlDelete();
                break;
            }
            case 674: {
                stmt = this.SqlUpdate();
                break;
            }
            case 333: {
                stmt = this.SqlMerge();
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    public final SqlExplain.Depth ExplainDepth() throws ParseException {
        if (this.jj_2_14(2)) {
            this.jj_consume_token(708);
            this.jj_consume_token(662);
            return SqlExplain.Depth.TYPE;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: {
                this.jj_consume_token(708);
                this.jj_consume_token(256);
                return SqlExplain.Depth.PHYSICAL;
            }
            case 710: {
                this.jj_consume_token(710);
                this.jj_consume_token(256);
                return SqlExplain.Depth.LOGICAL;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        return SqlExplain.Depth.PHYSICAL;
    }

    public final SqlExplainLevel ExplainDetailLevel() throws ParseException {
        SqlExplainLevel level = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(33);
                level = SqlExplainLevel.NO_ATTRIBUTES;
                break;
            }
            case 260: {
                this.jj_consume_token(260);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        level = SqlExplainLevel.ALL_ATTRIBUTES;
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                    }
                }
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return level;
    }

    public final SqlNode SqlDescribe() throws ParseException {
        this.jj_consume_token(165);
        Span s = this.span();
        if (this.jj_2_15(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    this.jj_consume_token(133);
                    break;
                }
                case 58: {
                    this.jj_consume_token(58);
                    break;
                }
                case 505: {
                    this.jj_consume_token(505);
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            SqlIdentifier id = this.CompoundIdentifier();
            return new SqlDescribeSchema(s.end(id), id);
        }
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            SqlIdentifier column;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 620: {
                    this.jj_consume_token(620);
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                }
            }
            SqlIdentifier table = this.CompoundIdentifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 54: 
                case 58: 
                case 59: 
                case 62: 
                case 63: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 75: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 187: 
                case 192: 
                case 194: 
                case 198: 
                case 199: 
                case 200: 
                case 212: 
                case 213: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 246: 
                case 248: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 302: 
                case 308: 
                case 309: 
                case 310: 
                case 318: 
                case 320: 
                case 321: 
                case 323: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 343: 
                case 344: 
                case 350: 
                case 351: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 367: 
                case 372: 
                case 374: 
                case 375: 
                case 377: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 436: 
                case 439: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 451: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 494: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 514: 
                case 515: 
                case 516: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 529: 
                case 533: 
                case 534: 
                case 538: 
                case 539: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 598: 
                case 599: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 621: 
                case 623: 
                case 626: 
                case 628: 
                case 629: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 652: 
                case 653: 
                case 654: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 671: 
                case 672: 
                case 677: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 716: 
                case 717: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    column = this.SimpleIdentifier();
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    column = null;
                }
            }
            return new SqlDescribeTable(s.add(table).addIf(column).pos(), table, column);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 269: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 620: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 708: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 599: {
                        this.jj_consume_token(599);
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                    }
                }
                SqlNode stmt = this.SqlQueryOrDml();
                SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
                SqlExplain.Depth depth = SqlExplain.Depth.PHYSICAL;
                SqlExplainFormat format = SqlExplainFormat.TEXT;
                return new SqlExplain(s.end(stmt), stmt, detailLevel.symbol(SqlParserPos.ZERO), depth.symbol(SqlParserPos.ZERO), format.symbol(SqlParserPos.ZERO), this.nDynamicParams);
            }
        }
        this.jj_la1[56] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode SqlProcedureCall() throws ParseException {
        this.jj_consume_token(51);
        Span s = this.span();
        SqlNode routineCall = this.NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_PROCEDURE, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.PROCEDURE_CALL.createCall(s.end(routineCall), routineCall);
    }

    public final SqlNode NamedRoutineCall(SqlFunctionCategory routineType, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        SqlIdentifier name = this.CompoundIdentifier();
        Span s = this.span();
        this.jj_consume_token(733);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 620: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 708: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                this.AddArg0(list, exprContext);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(745);
                    this.checkNonQueryExpression(exprContext);
                    this.AddArg(list, exprContext);
                }
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        return this.createCall(name, s.end(this), routineType, null, list);
    }

    public final SqlNode TableParam() throws ParseException {
        SqlNodeList orderList;
        SqlNodeList partitionList;
        Span s = this.span();
        SqlNode tableRef = this.ExplicitTable(this.getPos());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 413: {
                this.jj_consume_token(413);
                this.jj_consume_token(49);
                partitionList = this.SimpleIdentifierOrList();
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderList = this.OrderByOfSetSemanticsTable();
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        return this.CreateSetSemanticsTableIfNeeded(s, tableRef, partitionList, orderList);
    }

    public final SqlNode PartitionedQueryOrQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.OrderedQueryOrExpr(exprContext);
        e = this.PartitionedByAndOrderBy(e);
        return e;
    }

    public final SqlNode PartitionedByAndOrderBy(SqlNode e) throws ParseException {
        SqlNodeList orderList;
        SqlNodeList partitionList;
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 413: {
                this.jj_consume_token(413);
                this.jj_consume_token(49);
                partitionList = this.SimpleIdentifierOrList();
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderList = this.OrderByOfSetSemanticsTable();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        return this.CreateSetSemanticsTableIfNeeded(s, e, partitionList, orderList);
    }

    public final SqlNodeList OrderByOfSetSemanticsTable() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(392);
        Span s = this.span();
        this.jj_consume_token(49);
        if (this.jj_2_18(2)) {
            this.jj_consume_token(733);
            this.AddOrderItem(list);
            while (this.jj_2_17(2)) {
                this.jj_consume_token(745);
                this.AddOrderItem(list);
            }
            this.jj_consume_token(734);
            return new SqlNodeList(list, s.addAll(list).pos());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                this.AddOrderItem(list);
                return new SqlNodeList(list, s.addAll(list).pos());
            }
        }
        this.jj_la1[63] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode CreateSetSemanticsTableIfNeeded(Span s, SqlNode e, SqlNodeList partitionList, SqlNodeList orderList) throws ParseException {
        if (partitionList.isEmpty() && orderList.isEmpty()) {
            return e;
        }
        return SqlStdOperatorTable.SET_SEMANTICS_TABLE.createCall(s.pos(), e, partitionList, orderList);
    }

    public final SqlNode SqlInsert() throws ParseException {
        SqlNodeList columnList;
        SqlNode tableRef;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 269: {
                this.jj_consume_token(269);
                break;
            }
            case 676: {
                this.jj_consume_token(676);
                keywords.add(SqlInsertKeyword.UPSERT.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        this.SqlInsertKeywords(keywords);
        SqlNodeList keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
        this.jj_consume_token(277);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 774: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
                tableRef = tableName;
            }
        }
        if (this.jj_2_19(5)) {
            tableRef = this.ExtendTable(tableRef);
        }
        if (this.jj_2_20(2)) {
            Pair<SqlNodeList, SqlNodeList> p = this.ParenthesizedCompoundIdentifierList();
            if (!((SqlNodeList)p.right).isEmpty()) {
                tableRef = this.extend(tableRef, (SqlNodeList)p.right);
            }
            columnList = !((SqlNodeList)p.left).isEmpty() ? (SqlNodeList)p.left : null;
        } else {
            columnList = null;
        }
        SqlNode source = this.OrderedQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        return new SqlInsert(s.end(source), keywordList, tableRef, source, columnList);
    }

    public final SqlNode SqlDelete() throws ParseException {
        SqlNode where;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(159);
        Span s = this.span();
        this.jj_consume_token(227);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 774: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: 
            case 733: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                alias = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 705: {
                where = this.Where();
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                where = null;
            }
        }
        return new SqlDelete(s.add(tableRef).addIf(alias).addIf(where).pos(), tableRef, where, null, alias);
    }

    public final SqlNode SqlUpdate() throws ParseException {
        SqlNode where;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(674);
        Span s = this.span();
        SqlNodeList targetColumnList = new SqlNodeList(s.pos());
        SqlNodeList sourceExpressionList = new SqlNodeList(s.pos());
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 774: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: 
            case 733: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                alias = null;
            }
        }
        this.jj_consume_token(528);
        SqlIdentifier id = this.CompoundIdentifier();
        targetColumnList.add(id);
        this.jj_consume_token(746);
        this.AddExpression(sourceExpressionList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(745);
            id = this.CompoundIdentifier();
            targetColumnList.add(id);
            this.jj_consume_token(746);
            this.AddExpression(sourceExpressionList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 705: {
                where = this.Where();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                where = null;
            }
        }
        SqlParserPos pos = s.addAll(targetColumnList).addAll(sourceExpressionList).addIf(where).pos();
        return new SqlUpdate(pos, tableRef, targetColumnList, sourceExpressionList, where, null, alias);
    }

    public final SqlNode SqlMerge() throws ParseException {
        SqlInsert insertCall;
        SqlUpdate updateCall;
        SqlIdentifier alias;
        SqlNode tableRef;
        this.jj_consume_token(333);
        Span s = this.span();
        this.jj_consume_token(277);
        SqlIdentifier tableName = this.CompoundTableIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 774: {
                tableRef = this.TableHints(tableName);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                tableRef = tableName;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: 
            case 733: {
                tableRef = this.ExtendTable(tableRef);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                    }
                }
                alias = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                alias = null;
            }
        }
        this.jj_consume_token(683);
        SqlNode sourceTableRef = this.TableRef();
        this.jj_consume_token(385);
        SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        if (this.jj_2_21(2)) {
            updateCall = this.WhenMatchedClause(tableRef, alias);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 703: {
                    insertCall = this.WhenNotMatchedClause(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    insertCall = null;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 703: {
                    updateCall = null;
                    insertCall = this.WhenNotMatchedClause(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        SqlParserPos pos = s.addIf(updateCall).addIf(insertCall).pos();
        return new SqlMerge(pos, tableRef, condition, sourceTableRef, updateCall, insertCall, null, alias);
    }

    public final SqlUpdate WhenMatchedClause(SqlNode table, SqlIdentifier alias) throws ParseException {
        SqlNodeList updateColumnList = new SqlNodeList(SqlParserPos.ZERO);
        SqlNodeList updateExprList = new SqlNodeList(SqlParserPos.ZERO);
        this.jj_consume_token(703);
        Span s = this.span();
        this.jj_consume_token(323);
        this.jj_consume_token(624);
        this.jj_consume_token(674);
        this.jj_consume_token(528);
        SqlIdentifier id = this.CompoundIdentifier();
        updateColumnList.add(id);
        this.jj_consume_token(746);
        this.AddExpression(updateExprList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            id = this.CompoundIdentifier();
            updateColumnList.add(id);
            this.jj_consume_token(746);
            this.AddExpression(updateExprList, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        return new SqlUpdate(s.addAll(updateExprList).pos(), table, updateColumnList, updateExprList, null, null, alias);
    }

    public final SqlInsert WhenNotMatchedClause(SqlNode table) throws ParseException {
        SqlNode rowConstructor;
        Span valuesSpan;
        ArrayList<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
        this.jj_consume_token(703);
        this.jj_consume_token(368);
        this.jj_consume_token(323);
        this.jj_consume_token(624);
        this.jj_consume_token(269);
        Span insertSpan = this.span();
        this.SqlInsertKeywords(keywords);
        SqlNodeList keywordList = new SqlNodeList(keywords, insertSpan.end(this));
        SqlNodeList insertColumnList = this.jj_2_22(2) ? this.ParenthesizedSimpleIdentifierList() : null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                this.jj_consume_token(733);
                this.jj_consume_token(689);
                valuesSpan = this.span();
                rowConstructor = this.RowConstructor();
                this.jj_consume_token(734);
                break;
            }
            case 689: {
                this.jj_consume_token(689);
                valuesSpan = this.span();
                rowConstructor = this.RowConstructor();
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SqlCall insertValues = SqlStdOperatorTable.VALUES.createCall(valuesSpan.end(this), rowConstructor);
        return new SqlInsert(insertSpan.end(this), keywordList, table, insertValues, insertColumnList);
    }

    public final void AddSelectItem(List<SqlNode> list) throws ParseException {
        SqlNode e = this.SelectExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 725: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlIdentifier id;
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 330: {
                                this.jj_consume_token(330);
                                e = SqlInternalOperators.MEASURE.createCall(e.getParserPosition(), e);
                                break block3;
                            }
                        }
                        this.jj_la1[85] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        id = this.SimpleIdentifier();
                        break;
                    }
                    case 725: {
                        id = this.SimpleIdentifierFromStringLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[87] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                list.add(SqlStdOperatorTable.AS.createCall(this.span().end(e), e, id));
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                list.add(e);
            }
        }
    }

    public final SqlNode SelectExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 758: {
                this.jj_consume_token(758);
                return SqlIdentifier.star(this.getPos());
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                return e;
            }
        }
        this.jj_la1[89] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral Natural() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 358: {
                this.jj_consume_token(358);
                return SqlLiteral.createBoolean(true, this.getPos());
            }
        }
        this.jj_la1[90] = this.jj_gen;
        return SqlLiteral.createBoolean(false, this.getPos());
    }

    public final SqlLiteral JoinType() throws ParseException {
        JoinType joinType;
        boolean asof = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 284: {
                this.jj_consume_token(284);
                joinType = JoinType.INNER;
                break;
            }
            case 265: {
                this.jj_consume_token(265);
                this.jj_consume_token(284);
                joinType = JoinType.INNER;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                this.jj_consume_token(284);
                joinType = JoinType.ASOF;
                break;
            }
            case 307: {
                this.jj_consume_token(307);
                block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: 
                    case 398: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 398: {
                                this.jj_consume_token(398);
                                break block9;
                            }
                            case 24: {
                                this.jj_consume_token(24);
                                asof = true;
                                break block9;
                            }
                        }
                        this.jj_la1[91] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                joinType = asof ? JoinType.LEFT_ASOF : JoinType.LEFT;
                break;
            }
            case 484: {
                this.jj_consume_token(484);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 398: {
                        this.jj_consume_token(398);
                        break;
                    }
                    default: {
                        this.jj_la1[93] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                joinType = JoinType.RIGHT;
                break;
            }
            case 228: {
                this.jj_consume_token(228);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 398: {
                        this.jj_consume_token(398);
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                    }
                }
                this.jj_consume_token(284);
                joinType = JoinType.FULL;
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                this.jj_consume_token(284);
                joinType = JoinType.CROSS;
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return joinType.symbol(this.getPos());
    }

    public final SqlNode FromClause() throws ParseException {
        SqlNode e = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 114: 
                case 228: 
                case 265: 
                case 284: 
                case 307: 
                case 358: 
                case 398: 
                case 484: 
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block3;
                }
            }
            e = this.JoinOrCommaTable(e);
        }
        return e;
    }

    public final SqlNode JoinOrCommaTable(SqlNode e) throws ParseException {
        if (this.jj_2_23(2)) {
            this.jj_consume_token(745);
            SqlLiteral joinType = JoinType.COMMA.symbol(this.getPos());
            SqlNode e2 = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
            return new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 114: 
            case 228: 
            case 265: 
            case 284: 
            case 307: 
            case 358: 
            case 398: 
            case 484: {
                SqlNode e2 = this.JoinTable(e);
                return e2;
            }
        }
        this.jj_la1[97] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode JoinTable(SqlNode e) throws ParseException {
        SqlNode matchCondition = null;
        if (this.jj_2_24(4)) {
            SqlLiteral natural = this.Natural();
            SqlLiteral joinType = this.JoinType();
            SqlNode e2 = this.TableRef1(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY_OR_JOIN);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 325: 
                case 385: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 325: {
                            this.jj_consume_token(325);
                            matchCondition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                            break;
                        }
                        default: {
                            this.jj_la1[98] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(385);
                    SqlLiteral on = JoinConditionType.ON.symbol(this.getPos());
                    SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    JoinType type = joinType.getValueAs(JoinType.class);
                    if (matchCondition != null) {
                        if (type != JoinType.ASOF && type != JoinType.LEFT_ASOF) {
                            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.matchConditionRequiresAsof());
                        }
                        return new SqlAsofJoin(joinType.getParserPosition(), e, natural, joinType, e2, on, condition, matchCondition);
                    }
                    if (type == JoinType.ASOF || type == JoinType.LEFT_ASOF) {
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.asofRequiresMatchCondition());
                    }
                    return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, on, condition);
                }
                case 683: {
                    this.jj_consume_token(683);
                    SqlLiteral using = JoinConditionType.USING.symbol(this.getPos());
                    SqlNodeList list = this.ParenthesizedSimpleIdentifierList();
                    return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, using, new SqlNodeList(list, Span.of(using).end(this)));
                }
            }
            this.jj_la1[99] = this.jj_gen;
            return new SqlJoin(joinType.getParserPosition(), e, natural, joinType, e2, JoinConditionType.NONE.symbol(joinType.getParserPosition()), null);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 114: {
                this.jj_consume_token(114);
                SqlLiteral joinType = JoinType.CROSS.symbol(this.getPos());
                this.jj_consume_token(17);
                SqlNode e2 = this.TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.applyNotAllowed());
                }
                return new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
            }
            case 398: {
                this.jj_consume_token(398);
                SqlLiteral joinType = JoinType.LEFT.symbol(this.getPos());
                this.jj_consume_token(17);
                SqlNode e2 = this.TableRef2(true);
                if (!this.conformance.isApplyAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.applyNotAllowed());
                }
                return new SqlJoin(joinType.getParserPosition(), e, SqlLiteral.createBoolean(false, joinType.getParserPosition()), joinType, e2, JoinConditionType.ON.symbol(SqlParserPos.ZERO), SqlLiteral.createBoolean(true, joinType.getParserPosition()));
            }
        }
        this.jj_la1[100] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode TableRef() throws ParseException {
        SqlNode e = this.TableRef3(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY, false);
        return e;
    }

    public final SqlNode TableRef1(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.TableRef3(exprContext, false);
        return e;
    }

    public final SqlNode TableRef2(boolean lateral) throws ParseException {
        SqlNode e = this.TableRef3(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY, lateral);
        return e;
    }

    public final SqlNode TableRef3(SqlAbstractParserImpl.ExprContext exprContext, boolean lateral) throws ParseException {
        SqlNode tableRef;
        SqlUnnestOperator unnestOp = SqlStdOperatorTable.UNNEST;
        if (this.jj_2_26(2)) {
            SqlIdentifier tableName = this.CompoundTableIdentifier();
            Span s = this.span();
            if (this.jj_2_25(3)) {
                tableRef = this.ImplicitTableFunctionCallArgs(tableName);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 774: {
                        tableRef = this.TableHints(tableName);
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                        tableRef = tableName;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 206: 
                    case 733: {
                        tableRef = this.ExtendTable(tableRef);
                        break;
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                    }
                }
                tableRef = this.Over(tableRef);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 218: {
                        tableRef = this.Snapshot(tableRef);
                        break;
                    }
                    default: {
                        this.jj_la1[103] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 327: {
                        tableRef = this.MatchRecognize(tableRef);
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                        break;
                    }
                }
            }
        } else if (this.jj_2_27(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 304: {
                    this.jj_consume_token(304);
                    lateral = true;
                    break;
                }
                default: {
                    this.jj_la1[105] = this.jj_gen;
                }
            }
            tableRef = this.ParenthesizedExpression(exprContext);
            tableRef = this.Over(tableRef);
            tableRef = this.addLateral(tableRef, lateral);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 327: {
                    tableRef = this.MatchRecognize(tableRef);
                    break;
                }
                default: {
                    this.jj_la1[106] = this.jj_gen;
                    break;
                }
            }
        } else if (this.jj_2_28(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 304: {
                    this.jj_consume_token(304);
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                }
            }
            this.jj_consume_token(673);
            Span s = this.span();
            SqlNodeList args = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 708: {
                    this.jj_consume_token(708);
                    this.jj_consume_token(395);
                    unnestOp = SqlStdOperatorTable.UNNEST_WITH_ORDINALITY;
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                }
            }
            tableRef = unnestOp.createCall(s.end(this), (List<? extends SqlNode>)args);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 304: 
                case 620: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 304: {
                            this.jj_consume_token(304);
                            lateral = true;
                            break;
                        }
                        default: {
                            this.jj_la1[109] = this.jj_gen;
                        }
                    }
                    tableRef = this.TableFunctionCall();
                    tableRef = this.addLateral(tableRef, lateral);
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    if (this.jj_2_29(1)) {
                        tableRef = this.ExtendedTableRef();
                        break;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_30(2)) {
            tableRef = this.Pivot(tableRef);
        }
        if (this.jj_2_31(2)) {
            tableRef = this.Unpivot(tableRef);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNodeList columnAliasList;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                    }
                }
                SqlIdentifier alias = this.SimpleIdentifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 733: {
                        columnAliasList = this.ParenthesizedSimpleIdentifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[112] = this.jj_gen;
                        columnAliasList = null;
                    }
                }
                this.checkNotJoin(tableRef);
                if (columnAliasList == null) {
                    tableRef = SqlStdOperatorTable.AS.createCall(Span.of(tableRef).end(this), tableRef, alias);
                    break;
                }
                ArrayList<SqlNode> idList = new ArrayList<SqlNode>();
                idList.add(tableRef);
                idList.add(alias);
                idList.addAll(columnAliasList.getList());
                tableRef = SqlStdOperatorTable.AS.createCall(Span.of(tableRef).end(this), idList);
                break;
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 622: {
                tableRef = this.Tablesample(tableRef);
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
            }
        }
        return tableRef;
    }

    public final SqlNode Tablesample(SqlNode tableRef) throws ParseException {
        boolean isRepeatable = false;
        int repeatableSeed = 0;
        this.jj_consume_token(622);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 610: {
                this.jj_consume_token(610);
                this.jj_consume_token(733);
                SqlNode sample = this.StringLiteral();
                this.jj_consume_token(734);
                String sampleName = SqlLiteral.unchain(sample).getValueAs(String.class);
                SqlSampleSpec sampleSpec = SqlSampleSpec.createNamed(sampleName);
                SqlLiteral sampleLiteral = SqlLiteral.createSample(sampleSpec, s.end(this));
                return SqlStdOperatorTable.TABLESAMPLE.createCall(s.add(tableRef).end(this), tableRef, sampleLiteral);
            }
            case 40: 
            case 617: {
                boolean isBernoulli;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        isBernoulli = true;
                        break;
                    }
                    case 617: {
                        this.jj_consume_token(617);
                        isBernoulli = false;
                        break;
                    }
                    default: {
                        this.jj_la1[115] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(733);
                SqlNumericLiteral samplePercentage = this.UnsignedNumericLiteral();
                this.jj_consume_token(734);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 469: {
                        this.jj_consume_token(469);
                        this.jj_consume_token(733);
                        repeatableSeed = this.IntLiteral();
                        this.jj_consume_token(734);
                        isRepeatable = true;
                        break;
                    }
                    default: {
                        this.jj_la1[116] = this.jj_gen;
                    }
                }
                BigDecimal rate = samplePercentage.bigDecimalValue().divide(ONE_HUNDRED);
                SqlSampleSpec tableSampleSpec = isRepeatable ? SqlSampleSpec.createTableSample(isBernoulli, rate, repeatableSeed) : SqlSampleSpec.createTableSample(isBernoulli, rate);
                SqlLiteral tableSampleLiteral = SqlLiteral.createSample(tableSampleSpec, s.end(this));
                return SqlStdOperatorTable.TABLESAMPLE.createCall(s.end(this), tableRef, tableSampleLiteral);
            }
        }
        this.jj_la1[117] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode ExtendTable(SqlNode tableRef) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 206: {
                this.jj_consume_token(206);
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
            }
        }
        SqlNodeList extendList = this.ExtendList();
        return this.extend(tableRef, extendList);
    }

    public final SqlNodeList ExtendList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(733);
        Span s = this.span();
        this.AddColumnType(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddColumnType(list);
        }
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddColumnType(List<SqlNode> list) throws ParseException {
        SqlIdentifier name = this.CompoundIdentifier();
        SqlDataTypeSpec type = this.DataType();
        boolean nullable = this.NotNullOpt();
        list.add(name);
        list.add(type.withNullable(nullable, this.getPos()));
    }

    public final void AddCompoundIdentifierType(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
        boolean nullable;
        SqlDataTypeSpec type;
        SqlIdentifier name = this.CompoundIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 453: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 536: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 637: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 693: 
            case 694: 
            case 695: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                type = this.DataType();
                nullable = this.NotNullOpt();
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                type = null;
                nullable = true;
            }
        }
        if (type != null) {
            if (!this.conformance.allowExtend()) {
                throw SqlUtil.newContextException(type.getParserPosition(), Static.RESOURCE.extendNotAllowed());
            }
            extendList.add(name);
            extendList.add(type.withNullable(nullable, this.getPos()));
        }
        list.add(name);
    }

    public final SqlNode ImplicitTableFunctionCallArgs(SqlIdentifier name) throws ParseException {
        ArrayList<SqlNode> tableFuncArgs = new ArrayList<SqlNode>();
        Span s = this.span();
        this.jj_consume_token(733);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 620: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 708: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                this.AddArg0(tableFuncArgs, SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[121] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(745);
                    this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR);
                    this.AddArg(tableFuncArgs, SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR);
                }
            }
            default: {
                this.jj_la1[122] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        SqlParserPos pos = s.end(this);
        SqlCall call = this.createCall(name, pos, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, null, tableFuncArgs);
        return SqlStdOperatorTable.COLLECTION_TABLE.createCall(pos, call);
    }

    public final SqlNode TableFunctionCall() throws ParseException {
        SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION;
        this.jj_consume_token(620);
        Span s = this.span();
        this.jj_consume_token(733);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 540: {
                this.jj_consume_token(540);
                funcType = SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION;
                break;
            }
            default: {
                this.jj_la1[123] = this.jj_gen;
            }
        }
        SqlNode call = this.NamedRoutineCall(funcType, SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.COLLECTION_TABLE.createCall(s.end(this), call);
    }

    public final SqlNode ExplicitTable(SqlParserPos pos) throws ParseException {
        this.jj_consume_token(620);
        SqlIdentifier tableRef = this.CompoundIdentifier();
        return SqlStdOperatorTable.EXPLICIT_TABLE.createCall(pos, tableRef);
    }

    public final SqlNode TableConstructor() throws ParseException {
        Span s;
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 689: {
                this.jj_consume_token(689);
                s = this.span();
                break;
            }
            case 688: {
                this.jj_consume_token(688);
                s = this.span();
                if (this.conformance.isValueAllowed()) break;
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.valueNotAllowed());
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddRowConstructor(list);
        while (this.jj_2_32(2)) {
            this.jj_consume_token(745);
            this.AddRowConstructor(list);
        }
        return SqlStdOperatorTable.VALUES.createCall(s.end(this), list);
    }

    public final void AddRowConstructor(List<SqlNode> list) throws ParseException {
        SqlNode e = this.RowConstructor();
        list.add(e);
    }

    public final SqlNode RowConstructor() throws ParseException {
        SqlNodeList valueList;
        Span s;
        if (this.jj_2_33(3)) {
            this.jj_consume_token(733);
            s = this.span();
            this.jj_consume_token(493);
            valueList = this.ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
            this.jj_consume_token(734);
            s.add(this);
        } else if (this.jj_2_34(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 493: {
                    this.jj_consume_token(493);
                    s = this.span();
                    break;
                }
                default: {
                    this.jj_la1[125] = this.jj_gen;
                    s = Span.of();
                }
            }
            valueList = this.ParenthesizedQueryOrCommaListWithDefault(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 125: 
                case 126: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 160: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 184: 
                case 187: 
                case 192: 
                case 194: 
                case 196: 
                case 198: 
                case 199: 
                case 200: 
                case 203: 
                case 204: 
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 214: 
                case 216: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 243: 
                case 246: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 323: 
                case 326: 
                case 328: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 362: 
                case 363: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 402: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 422: 
                case 423: 
                case 424: 
                case 425: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 432: 
                case 434: 
                case 436: 
                case 439: 
                case 440: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 450: 
                case 451: 
                case 460: 
                case 464: 
                case 466: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 484: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: 
                case 497: 
                case 498: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 527: 
                case 529: 
                case 533: 
                case 534: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 596: 
                case 598: 
                case 599: 
                case 601: 
                case 602: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 611: 
                case 614: 
                case 619: 
                case 621: 
                case 623: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 647: 
                case 652: 
                case 653: 
                case 654: 
                case 655: 
                case 657: 
                case 658: 
                case 659: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 675: 
                case 677: 
                case 678: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 687: 
                case 691: 
                case 692: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 715: 
                case 716: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 724: 
                case 725: 
                case 726: 
                case 727: 
                case 728: 
                case 730: 
                case 731: 
                case 733: 
                case 735: 
                case 736: 
                case 737: 
                case 738: 
                case 749: 
                case 755: 
                case 756: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    SqlNode value = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
                    s = Span.of(value);
                    valueList = new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)value), value.getParserPosition());
                    break;
                }
                default: {
                    this.jj_la1[126] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return SqlStdOperatorTable.ROW.createCall(s.end(valueList), (List<? extends SqlNode>)valueList);
    }

    public final SqlNode Where() throws ParseException {
        this.jj_consume_token(705);
        SqlNode condition = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return condition;
    }

    public final SqlNodeList GroupBy() throws ParseException {
        boolean distinct;
        this.jj_consume_token(241);
        Span s = this.span();
        this.jj_consume_token(49);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 173: {
                this.jj_consume_token(173);
                distinct = true;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                distinct = false;
                break;
            }
            default: {
                this.jj_la1[127] = this.jj_gen;
                distinct = false;
            }
        }
        ImmutableList list = this.GroupingElementList();
        SqlParserPos pos = s.end(this);
        ImmutableList list2 = distinct ? ImmutableList.of((Object)SqlInternalOperators.GROUP_BY_DISTINCT.createCall(pos, (List<? extends SqlNode>)list)) : list;
        return new SqlNodeList((Collection<? extends SqlNode>)list2, pos);
    }

    public final List<SqlNode> GroupingElementList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddGroupingElement(list);
        while (this.jj_2_35(2)) {
            this.jj_consume_token(745);
            this.AddGroupingElement(list);
        }
        return list;
    }

    public final void AddGroupingElement(List<SqlNode> list) throws ParseException {
        if (this.jj_2_36(2)) {
            this.jj_consume_token(243);
            Span s = this.span();
            this.jj_consume_token(529);
            this.jj_consume_token(733);
            List<SqlNode> subList = this.GroupingElementList();
            this.jj_consume_token(734);
            list.add(SqlStdOperatorTable.GROUPING_SETS.createCall(s.end(this), subList));
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 488: {
                    this.jj_consume_token(488);
                    Span s = this.span();
                    this.jj_consume_token(733);
                    SqlNodeList nodes = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    this.jj_consume_token(734);
                    list.add(SqlStdOperatorTable.ROLLUP.createCall(s.end(this), nodes.getList()));
                    break;
                }
                case 115: {
                    this.jj_consume_token(115);
                    Span s = this.span();
                    this.jj_consume_token(733);
                    SqlNodeList nodes = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    this.jj_consume_token(734);
                    list.add(SqlStdOperatorTable.CUBE.createCall(s.end(this), nodes.getList()));
                    break;
                }
                default: {
                    this.jj_la1[128] = this.jj_gen;
                    if (this.jj_2_37(3)) {
                        this.jj_consume_token(733);
                        Span s = this.span();
                        this.jj_consume_token(734);
                        list.add(new SqlNodeList(s.end(this)));
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 35: 
                        case 36: 
                        case 40: 
                        case 48: 
                        case 50: 
                        case 53: 
                        case 54: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 74: 
                        case 75: 
                        case 78: 
                        case 79: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 91: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 148: 
                        case 149: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 160: 
                        case 161: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 169: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 178: 
                        case 181: 
                        case 182: 
                        case 184: 
                        case 187: 
                        case 192: 
                        case 194: 
                        case 196: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 203: 
                        case 204: 
                        case 208: 
                        case 209: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 216: 
                        case 217: 
                        case 219: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 237: 
                        case 238: 
                        case 240: 
                        case 242: 
                        case 243: 
                        case 246: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 264: 
                        case 267: 
                        case 270: 
                        case 271: 
                        case 275: 
                        case 276: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 289: 
                        case 290: 
                        case 291: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 302: 
                        case 303: 
                        case 305: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 314: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 323: 
                        case 326: 
                        case 328: 
                        case 329: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 338: 
                        case 339: 
                        case 340: 
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 361: 
                        case 362: 
                        case 363: 
                        case 367: 
                        case 368: 
                        case 369: 
                        case 370: 
                        case 371: 
                        case 372: 
                        case 373: 
                        case 374: 
                        case 375: 
                        case 377: 
                        case 379: 
                        case 380: 
                        case 389: 
                        case 390: 
                        case 393: 
                        case 395: 
                        case 396: 
                        case 399: 
                        case 402: 
                        case 403: 
                        case 404: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 414: 
                        case 415: 
                        case 416: 
                        case 417: 
                        case 418: 
                        case 422: 
                        case 423: 
                        case 424: 
                        case 425: 
                        case 427: 
                        case 428: 
                        case 429: 
                        case 430: 
                        case 432: 
                        case 434: 
                        case 436: 
                        case 439: 
                        case 440: 
                        case 442: 
                        case 443: 
                        case 445: 
                        case 447: 
                        case 448: 
                        case 450: 
                        case 451: 
                        case 460: 
                        case 464: 
                        case 466: 
                        case 467: 
                        case 469: 
                        case 470: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 477: 
                        case 478: 
                        case 479: 
                        case 480: 
                        case 481: 
                        case 484: 
                        case 485: 
                        case 486: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 492: 
                        case 493: 
                        case 494: 
                        case 495: 
                        case 497: 
                        case 498: 
                        case 503: 
                        case 504: 
                        case 505: 
                        case 506: 
                        case 508: 
                        case 509: 
                        case 510: 
                        case 513: 
                        case 514: 
                        case 515: 
                        case 516: 
                        case 519: 
                        case 521: 
                        case 522: 
                        case 523: 
                        case 524: 
                        case 525: 
                        case 526: 
                        case 527: 
                        case 529: 
                        case 533: 
                        case 534: 
                        case 537: 
                        case 538: 
                        case 539: 
                        case 540: 
                        case 541: 
                        case 547: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 553: 
                        case 554: 
                        case 555: 
                        case 556: 
                        case 557: 
                        case 558: 
                        case 559: 
                        case 560: 
                        case 561: 
                        case 562: 
                        case 563: 
                        case 564: 
                        case 565: 
                        case 566: 
                        case 567: 
                        case 568: 
                        case 569: 
                        case 570: 
                        case 571: 
                        case 572: 
                        case 573: 
                        case 574: 
                        case 575: 
                        case 576: 
                        case 577: 
                        case 578: 
                        case 579: 
                        case 580: 
                        case 581: 
                        case 582: 
                        case 583: 
                        case 584: 
                        case 585: 
                        case 586: 
                        case 587: 
                        case 588: 
                        case 589: 
                        case 590: 
                        case 591: 
                        case 592: 
                        case 593: 
                        case 594: 
                        case 595: 
                        case 596: 
                        case 598: 
                        case 599: 
                        case 601: 
                        case 602: 
                        case 604: 
                        case 605: 
                        case 606: 
                        case 607: 
                        case 610: 
                        case 611: 
                        case 614: 
                        case 619: 
                        case 621: 
                        case 623: 
                        case 626: 
                        case 627: 
                        case 628: 
                        case 629: 
                        case 630: 
                        case 631: 
                        case 632: 
                        case 633: 
                        case 634: 
                        case 639: 
                        case 641: 
                        case 642: 
                        case 643: 
                        case 644: 
                        case 645: 
                        case 646: 
                        case 647: 
                        case 652: 
                        case 653: 
                        case 654: 
                        case 655: 
                        case 657: 
                        case 658: 
                        case 659: 
                        case 661: 
                        case 662: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 667: 
                        case 669: 
                        case 670: 
                        case 671: 
                        case 672: 
                        case 675: 
                        case 677: 
                        case 678: 
                        case 679: 
                        case 680: 
                        case 681: 
                        case 682: 
                        case 684: 
                        case 685: 
                        case 686: 
                        case 687: 
                        case 691: 
                        case 692: 
                        case 697: 
                        case 699: 
                        case 701: 
                        case 702: 
                        case 711: 
                        case 712: 
                        case 713: 
                        case 714: 
                        case 715: 
                        case 716: 
                        case 717: 
                        case 718: 
                        case 719: 
                        case 720: 
                        case 724: 
                        case 725: 
                        case 726: 
                        case 727: 
                        case 728: 
                        case 730: 
                        case 731: 
                        case 733: 
                        case 735: 
                        case 736: 
                        case 737: 
                        case 738: 
                        case 749: 
                        case 755: 
                        case 756: 
                        case 782: 
                        case 783: 
                        case 784: 
                        case 785: 
                        case 786: 
                        case 787: 
                        case 789: {
                            this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                            break block0;
                        }
                    }
                    this.jj_la1[129] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final SqlNodeList ExpressionCommaList(Span s, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddExpressions(list, exprContext);
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddExpressions(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.AddExpression(list, exprContext);
        while (this.jj_2_38(2)) {
            this.jj_consume_token(745);
            this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
    }

    public final SqlNode Having() throws ParseException {
        this.jj_consume_token(245);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return e;
    }

    public final SqlNodeList Window() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(707);
        Span s = this.span();
        this.AddWindowSpec(list);
        while (this.jj_2_39(2)) {
            this.jj_consume_token(745);
            this.AddWindowSpec(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddWindowSpec(List<SqlNode> list) throws ParseException {
        SqlIdentifier id = this.SimpleIdentifier();
        this.jj_consume_token(23);
        SqlWindow e = this.WindowSpecification();
        e.setDeclName(id);
        list.add(e);
    }

    public final SqlWindow WindowSpecification() throws ParseException {
        SqlLiteral allowPartial;
        SqlLiteral exclude;
        SqlNode upperBound;
        SqlNode lowerBound;
        SqlLiteral isRows;
        SqlNodeList orderList;
        SqlNodeList partitionList;
        SqlIdentifier id;
        this.jj_consume_token(733);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                id = this.SimpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
                id = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 413: {
                this.jj_consume_token(413);
                Span s1 = this.span();
                this.jj_consume_token(49);
                partitionList = this.ExpressionCommaList(s1, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[131] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderList = this.OrderBy(true);
                break;
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 449: 
            case 496: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 496: {
                        this.jj_consume_token(496);
                        isRows = SqlLiteral.createBoolean(true, this.getPos());
                        break;
                    }
                    case 449: {
                        this.jj_consume_token(449);
                        isRows = SqlLiteral.createBoolean(false, this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[133] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        lowerBound = this.WindowRange();
                        this.jj_consume_token(15);
                        upperBound = this.WindowRange();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        lowerBound = this.WindowRange();
                        upperBound = null;
                        break;
                    }
                    default: {
                        this.jj_la1[134] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                exclude = this.WindowExclusion();
                break;
            }
            default: {
                this.jj_la1[135] = this.jj_gen;
                isRows = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                exclude = SqlWindow.createExcludeNoOthers(this.getPos());
                upperBound = null;
                lowerBound = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                Span s2 = this.span();
                this.jj_consume_token(412);
                allowPartial = SqlLiteral.createBoolean(true, s2.end(this));
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                Span s2 = this.span();
                this.jj_consume_token(412);
                allowPartial = SqlLiteral.createBoolean(false, s2.end(this));
                break;
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
                allowPartial = null;
            }
        }
        this.jj_consume_token(734);
        return SqlWindow.create(null, id, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial, exclude, s.end(this));
    }

    public final SqlNode WindowRange() throws ParseException {
        if (this.jj_2_40(2)) {
            this.jj_consume_token(117);
            Span s = this.span();
            this.jj_consume_token(493);
            return SqlWindow.createCurrentRow(s.end(this));
        }
        if (this.jj_2_41(2)) {
            this.jj_consume_token(664);
            Span s = this.span();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 436: {
                    this.jj_consume_token(436);
                    return SqlWindow.createUnboundedPreceding(s.end(this));
                }
                case 217: {
                    this.jj_consume_token(217);
                    return SqlWindow.createUnboundedFollowing(s.end(this));
                }
            }
            this.jj_la1[137] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 436: {
                        this.jj_consume_token(436);
                        return SqlWindow.createPreceding(e, this.getPos());
                    }
                    case 217: {
                        this.jj_consume_token(217);
                        return SqlWindow.createFollowing(e, this.getPos());
                    }
                }
                this.jj_la1[138] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral WindowExclusion() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 199: {
                this.jj_consume_token(199);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: {
                        this.jj_consume_token(117);
                        this.jj_consume_token(493);
                        return SqlWindow.createExcludeCurrentRow(this.getPos());
                    }
                    case 364: {
                        this.jj_consume_token(364);
                        this.jj_consume_token(396);
                        return SqlWindow.createExcludeNoOthers(this.getPos());
                    }
                    case 241: {
                        this.jj_consume_token(241);
                        return SqlWindow.createExcludeGroup(this.getPos());
                    }
                    case 626: {
                        this.jj_consume_token(626);
                        return SqlWindow.createExcludeTies(this.getPos());
                    }
                }
                this.jj_la1[140] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[141] = this.jj_gen;
        return SqlWindow.createExcludeNoOthers(SqlParserPos.ZERO);
    }

    public final SqlNode Qualify() throws ParseException {
        this.jj_consume_token(446);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return e;
    }

    public final SqlNodeList OrderBy(boolean accept) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(392);
        Span s = this.span();
        if (!accept) {
            throw SqlUtil.newContextException(s.pos(), Static.RESOURCE.illegalOrderBy());
        }
        this.jj_consume_token(49);
        this.AddOrderItem(list);
        while (this.jj_2_42(2)) {
            this.jj_consume_token(745);
            this.AddOrderItem(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddOrderItem(List<SqlNode> list) throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 164: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        break block0;
                    }
                    case 164: {
                        this.jj_consume_token(164);
                        e = SqlStdOperatorTable.DESC.createCall(this.getPos(), e);
                        break block0;
                    }
                }
                this.jj_la1[142] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
            }
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 374: {
                if (this.jj_2_43(2)) {
                    this.jj_consume_token(374);
                    this.jj_consume_token(213);
                    e = SqlStdOperatorTable.NULLS_FIRST.createCall(this.getPos(), e);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 374: {
                        this.jj_consume_token(374);
                        this.jj_consume_token(302);
                        e = SqlStdOperatorTable.NULLS_LAST.createCall(this.getPos(), e);
                        break block7;
                    }
                }
                this.jj_la1[144] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
            }
        }
        list.add(e);
    }

    public final SqlNode Over(SqlNode tableRef) throws ParseException {
        SqlNode over = this.TableOverOpt();
        if (over != null) {
            return SqlStdOperatorTable.OVER.createCall(this.getPos(), this.checkNotJoin(tableRef), over);
        }
        return tableRef;
    }

    SqlNode addLateral(SqlNode tableRef, boolean lateral) throws ParseException {
        return lateral ? SqlStdOperatorTable.LATERAL.createCall(this.getPos(), this.checkNotJoin(tableRef)) : tableRef;
    }

    public final SqlSnapshot Snapshot(SqlNode tableRef) throws ParseException {
        Span s = this.span();
        this.jj_consume_token(218);
        this.jj_consume_token(618);
        this.jj_consume_token(23);
        this.jj_consume_token(381);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return new SqlSnapshot(s.end(this), tableRef, e);
    }

    public final SqlNode Pivot(SqlNode tableRef) throws ParseException {
        ArrayList<SqlNode> aggList = new ArrayList<SqlNode>();
        ArrayList<SqlNode> valueList = new ArrayList<SqlNode>();
        this.jj_consume_token(427);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        this.jj_consume_token(733);
        this.AddPivotAgg(aggList);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(745);
            this.AddPivotAgg(aggList);
        }
        this.jj_consume_token(218);
        SqlNodeList axisList = this.SimpleIdentifierOrList();
        this.jj_consume_token(258);
        this.jj_consume_token(733);
        Span s2 = this.span();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                this.AddPivotValue(valueList);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[147] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(745);
                    this.AddPivotValue(valueList);
                }
            }
            default: {
                this.jj_la1[148] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        SqlNodeList inList = new SqlNodeList(valueList, s2.end(this));
        this.jj_consume_token(734);
        return new SqlPivot(s.end(this), tableRef, new SqlNodeList(aggList, SqlParserPos.sum(aggList)), axisList, inList);
    }

    public final void AddPivotAgg(List<SqlNode> list) throws ParseException {
        SqlNode e = this.NamedFunctionCall();
        if (this.getToken((int)1).kind != 745 && this.getToken((int)1).kind != 218) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                default: {
                    this.jj_la1[149] = this.jj_gen;
                }
            }
            SqlIdentifier alias = this.SimpleIdentifier();
            list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
        } else {
            list.add(e);
        }
    }

    public final void AddPivotValue(List<SqlNode> list) throws ParseException {
        SqlNode e = this.RowConstructor();
        SqlNodeList tuple = SqlParserUtil.stripRow(e);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[150] = this.jj_gen;
                    }
                }
                SqlIdentifier alias = this.SimpleIdentifier();
                list.add(SqlStdOperatorTable.AS.createCall(Span.of(tuple).end(this), tuple, alias));
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
                list.add(tuple);
            }
        }
    }

    public final SqlNode Unpivot(SqlNode tableRef) throws ParseException {
        boolean includeNulls;
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        this.jj_consume_token(671);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 259: {
                this.jj_consume_token(259);
                this.jj_consume_token(374);
                includeNulls = true;
                break;
            }
            case 199: {
                this.jj_consume_token(199);
                this.jj_consume_token(374);
                includeNulls = false;
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
                includeNulls = false;
            }
        }
        this.jj_consume_token(733);
        SqlNodeList measureList = this.SimpleIdentifierOrList();
        this.jj_consume_token(218);
        SqlNodeList axisList = this.SimpleIdentifierOrList();
        this.jj_consume_token(258);
        this.jj_consume_token(733);
        Span s2 = this.span();
        this.AddUnpivotValue(values);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(745);
            this.AddUnpivotValue(values);
        }
        this.jj_consume_token(734);
        SqlNodeList inList = new SqlNodeList(values, s2.end(this));
        this.jj_consume_token(734);
        return new SqlUnpivot(s.end(this), tableRef, includeNulls, measureList, axisList, inList);
    }

    public final void AddUnpivotValue(List<SqlNode> list) throws ParseException {
        SqlNodeList columnList = this.SimpleIdentifierOrList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                SqlNode values = this.RowConstructor();
                SqlNodeList valueList = SqlParserUtil.stripRow(values);
                list.add(SqlStdOperatorTable.AS.createCall(Span.of(columnList).end(this), columnList, valueList));
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
                list.add(columnList);
            }
        }
    }

    public final SqlMatchRecognize MatchRecognize(SqlNode tableRef) throws ParseException {
        SqlNodeList subsetList;
        SqlLiteral interval;
        SqlLiteral isStrictEnds;
        SqlLiteral isStrictStarts;
        SqlNode after;
        SqlLiteral rowsPerMatch;
        SqlNodeList measureList;
        SqlNodeList orderList;
        SqlNodeList partitionList;
        this.jj_consume_token(327);
        Span s = this.span();
        this.checkNotJoin(tableRef);
        this.jj_consume_token(733);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 413: {
                this.jj_consume_token(413);
                Span s2 = this.span();
                this.jj_consume_token(49);
                partitionList = this.ExpressionCommaList(s2, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                partitionList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderList = this.OrderBy(true);
                break;
            }
            default: {
                this.jj_la1[156] = this.jj_gen;
                orderList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 331: {
                this.jj_consume_token(331);
                measureList = this.MeasureColumnCommaList(this.span());
                break;
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
                measureList = SqlNodeList.EMPTY;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 386: {
                this.jj_consume_token(386);
                Span s0 = this.span();
                this.jj_consume_token(493);
                this.jj_consume_token(420);
                this.jj_consume_token(322);
                rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(s0.end(this));
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                Span s0 = this.span();
                this.jj_consume_token(496);
                this.jj_consume_token(420);
                this.jj_consume_token(322);
                rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(s0.end(this));
                break;
            }
            default: {
                this.jj_la1[158] = this.jj_gen;
                rowsPerMatch = null;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                Span s1 = this.span();
                this.jj_consume_token(322);
                this.jj_consume_token(535);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 638: {
                        this.jj_consume_token(638);
                        if (this.jj_2_45(2)) {
                            this.jj_consume_token(363);
                            this.jj_consume_token(493);
                            after = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW.symbol(s1.end(this));
                            break block13;
                        }
                        if (this.jj_2_46(2)) {
                            this.jj_consume_token(213);
                            SqlIdentifier var = this.SimpleIdentifier();
                            after = SqlMatchRecognize.SKIP_TO_FIRST.createCall(s1.end(var), var);
                            break block13;
                        }
                        if (this.jj_2_44(2)) {
                            this.jj_consume_token(302);
                        }
                        SqlIdentifier var = this.SimpleIdentifier();
                        after = SqlMatchRecognize.SKIP_TO_LAST.createCall(s1.end(var), var);
                        break block13;
                    }
                    case 417: {
                        this.jj_consume_token(417);
                        this.jj_consume_token(302);
                        this.jj_consume_token(493);
                        after = SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW.symbol(s1.end(this));
                        break block13;
                    }
                }
                this.jj_la1[159] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[160] = this.jj_gen;
                after = null;
            }
        }
        this.jj_consume_token(419);
        this.jj_consume_token(733);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 767: {
                this.jj_consume_token(767);
                isStrictStarts = SqlLiteral.createBoolean(true, this.getPos());
                break;
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
                isStrictStarts = SqlLiteral.createBoolean(false, this.getPos());
            }
        }
        SqlNode pattern = this.PatternExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 768: {
                this.jj_consume_token(768);
                isStrictEnds = SqlLiteral.createBoolean(true, this.getPos());
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
                isStrictEnds = SqlLiteral.createBoolean(false, this.getPos());
            }
        }
        this.jj_consume_token(734);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 709: {
                this.jj_consume_token(709);
                interval = this.IntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                interval = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 609: {
                this.jj_consume_token(609);
                subsetList = this.SubsetDefinitionCommaList(this.span());
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                subsetList = SqlNodeList.EMPTY;
            }
        }
        this.jj_consume_token(155);
        SqlNodeList patternDefList = this.PatternDefinitionCommaList(this.span());
        this.jj_consume_token(734);
        return new SqlMatchRecognize(s.end(this), tableRef, pattern, isStrictStarts, isStrictEnds, patternDefList, measureList, after, subsetList, rowsPerMatch, partitionList, orderList, interval);
    }

    public final SqlNodeList MeasureColumnCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddMeasureColumn(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddMeasureColumn(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddMeasureColumn(List<SqlNode> list) throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(23);
        SqlIdentifier alias = this.SimpleIdentifier();
        list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
    }

    public final SqlNode PatternExpression() throws ParseException {
        SqlNode left = this.PatternTerm();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 766: {
                    break;
                }
                default: {
                    this.jj_la1[166] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(766);
            SqlNode right = this.PatternTerm();
            left = SqlStdOperatorTable.PATTERN_ALTER.createCall(Span.of(left).end(right), left, right);
        }
        return left;
    }

    public final SqlNode PatternTerm() throws ParseException {
        SqlNode left = this.PatternFactor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 54: 
                case 58: 
                case 59: 
                case 62: 
                case 63: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 75: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 187: 
                case 192: 
                case 194: 
                case 198: 
                case 199: 
                case 200: 
                case 212: 
                case 213: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 246: 
                case 248: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 302: 
                case 308: 
                case 309: 
                case 310: 
                case 318: 
                case 320: 
                case 321: 
                case 323: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 343: 
                case 344: 
                case 350: 
                case 351: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 367: 
                case 372: 
                case 374: 
                case 375: 
                case 377: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 426: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 436: 
                case 439: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 451: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 494: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 514: 
                case 515: 
                case 516: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 529: 
                case 533: 
                case 534: 
                case 538: 
                case 539: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 598: 
                case 599: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 621: 
                case 623: 
                case 626: 
                case 628: 
                case 629: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 652: 
                case 653: 
                case 654: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 671: 
                case 672: 
                case 677: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 716: 
                case 717: 
                case 733: 
                case 739: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    break;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    break block3;
                }
            }
            SqlNode right = this.PatternFactor();
            left = SqlStdOperatorTable.PATTERN_CONCAT.createCall(Span.of(left).end(right), left, right);
        }
        return left;
    }

    public final SqlNode PatternFactor() throws ParseException {
        SqlLiteral reluctant;
        SqlLiteral endNum;
        SqlLiteral startNum;
        SqlNode e = this.PatternPrimary();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 739: 
            case 749: 
            case 755: 
            case 758: {
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 758: {
                        this.jj_consume_token(758);
                        startNum = LITERAL_ZERO;
                        endNum = LITERAL_MINUS_ONE;
                        break;
                    }
                    case 755: {
                        this.jj_consume_token(755);
                        startNum = LITERAL_ONE;
                        endNum = LITERAL_MINUS_ONE;
                        break;
                    }
                    case 749: {
                        this.jj_consume_token(749);
                        startNum = LITERAL_ZERO;
                        endNum = LITERAL_ONE;
                        break;
                    }
                    case 739: {
                        this.jj_consume_token(739);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 149: 
                            case 718: 
                            case 719: 
                            case 720: {
                                startNum = this.UnsignedNumericLiteral();
                                block14 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 745: {
                                        this.jj_consume_token(745);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 149: 
                                            case 718: 
                                            case 719: 
                                            case 720: {
                                                endNum = this.UnsignedNumericLiteral();
                                                break block14;
                                            }
                                        }
                                        this.jj_la1[168] = this.jj_gen;
                                        endNum = LITERAL_MINUS_ONE;
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[169] = this.jj_gen;
                                        endNum = startNum;
                                    }
                                }
                                this.jj_consume_token(740);
                                break block3;
                            }
                            case 745: {
                                this.jj_consume_token(745);
                                endNum = this.UnsignedNumericLiteral();
                                this.jj_consume_token(740);
                                startNum = LITERAL_MINUS_ONE;
                                break block3;
                            }
                            case 756: {
                                this.jj_consume_token(756);
                                SqlNode extra = this.PatternExpression();
                                this.jj_consume_token(756);
                                this.jj_consume_token(740);
                                return SqlStdOperatorTable.PATTERN_CONCAT.createCall(Span.of(e).end(this), e, SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(Span.of(extra).end(this), extra));
                            }
                        }
                        this.jj_la1[170] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[171] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 749: {
                        this.jj_consume_token(749);
                        reluctant = SqlLiteral.createBoolean(startNum.intValue(true) != endNum.intValue(true), SqlParserPos.ZERO);
                        break block0;
                    }
                }
                this.jj_la1[172] = this.jj_gen;
                reluctant = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
                return e;
            }
        }
        return SqlStdOperatorTable.PATTERN_QUANTIFIER.createCall(this.span().end(e), e, startNum, endNum, reluctant);
    }

    public final SqlNode PatternPrimary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlIdentifier e = this.SimpleIdentifier();
                return e;
            }
            case 733: {
                this.jj_consume_token(733);
                SqlNode e = this.PatternExpression();
                this.jj_consume_token(734);
                return e;
            }
            case 739: {
                this.jj_consume_token(739);
                Span s = this.span();
                this.jj_consume_token(756);
                SqlNode e = this.PatternExpression();
                this.jj_consume_token(756);
                this.jj_consume_token(740);
                return SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(s.end(this), e);
            }
            case 426: {
                this.jj_consume_token(426);
                Span s = this.span();
                ArrayList<SqlNode> list = new ArrayList<SqlNode>();
                this.jj_consume_token(733);
                SqlNode e = this.PatternExpression();
                list.add(e);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[174] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(745);
                    e = this.PatternExpression();
                    list.add(e);
                }
                this.jj_consume_token(734);
                return SqlStdOperatorTable.PATTERN_PERMUTE.createCall(s.end(this), list);
            }
        }
        this.jj_la1[175] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNodeList SubsetDefinitionCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.AddSubsetDefinition(list);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddSubsetDefinition(list);
        }
        return new SqlNodeList(list, s.addAll(list).pos());
    }

    public final void AddSubsetDefinition(List<SqlNode> list) throws ParseException {
        SqlIdentifier var = this.SimpleIdentifier();
        this.jj_consume_token(746);
        this.jj_consume_token(733);
        SqlNodeList varList = this.ExpressionCommaList(this.span(), SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(734);
        list.add(SqlStdOperatorTable.EQUALS.createCall(this.span().end(var), var, varList));
    }

    public final SqlNodeList PatternDefinitionCommaList(Span s) throws ParseException {
        ArrayList<SqlNode> eList = new ArrayList<SqlNode>();
        SqlNode e = this.PatternDefinition();
        eList.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            e = this.PatternDefinition();
            eList.add(e);
        }
        return new SqlNodeList(eList, s.addAll(eList).pos());
    }

    public final SqlNode PatternDefinition() throws ParseException {
        SqlIdentifier var = this.SimpleIdentifier();
        this.jj_consume_token(23);
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.AS.createCall(Span.of(var, e).pos(), e, var);
    }

    public final SqlNode SqlExpressionEof() throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(0);
        return e;
    }

    public final SqlNode QueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNodeList withList = null;
        ArrayList<Object> list = new ArrayList<Object>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: {
                withList = this.WithList();
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        SqlNode e = this.LeafQueryOrExpr(exprContext);
        list.add(e);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 197: 
                case 274: 
                case 530: 
                case 668: {
                    break;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    break block6;
                }
            }
            this.AddSetOpQuery(list, exprContext);
        }
        return this.addWith(withList, SqlParserUtil.toTree(list));
    }

    public final SqlNode Query(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNodeList withList = null;
        ArrayList<Object> list = new ArrayList<Object>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: {
                withList = this.WithList();
                break;
            }
            default: {
                this.jj_la1[180] = this.jj_gen;
            }
        }
        SqlNode e = this.LeafQuery(exprContext);
        list.add(e);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 197: 
                case 274: 
                case 530: 
                case 668: {
                    break;
                }
                default: {
                    this.jj_la1[181] = this.jj_gen;
                    break block6;
                }
            }
            this.AddSetOpQuery(list, exprContext);
        }
        return this.addWith(withList, SqlParserUtil.toTree(list));
    }

    SqlNode addWith(SqlNodeList withList, SqlNode e) throws ParseException {
        return withList == null ? e : new SqlWith(withList.getParserPosition(), withList, e);
    }

    public final void AddSetOpQueryOrExpr(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (list.size() == 1 && !((SqlNode)list.get(0)).isA(SqlKind.QUERY)) {
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        }
        SqlBinaryOperator op = this.BinaryQueryOperator();
        SqlParserPos pos = this.getPos();
        this.checkQueryExpression(exprContext);
        SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
    }

    public final void AddSetOpQuery(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (list.size() == 1 && !((SqlNode)list.get(0)).isA(SqlKind.QUERY)) {
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        }
        SqlBinaryOperator op = this.BinaryQueryOperator();
        SqlParserPos pos = this.getPos();
        this.checkQueryExpression(exprContext);
        SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
    }

    public final SqlNodeList WithList() throws ParseException {
        ArrayList<SqlWithItem> list = new ArrayList<SqlWithItem>();
        boolean recursive = false;
        this.jj_consume_token(708);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 454: {
                this.jj_consume_token(454);
                recursive = true;
                break;
            }
            default: {
                this.jj_la1[182] = this.jj_gen;
            }
        }
        Span s = this.span();
        this.AddWithItem(list, SqlLiteral.createBoolean(recursive, this.getPos()));
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[183] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(745);
            this.AddWithItem(list, SqlLiteral.createBoolean(recursive, this.getPos()));
        }
        return new SqlNodeList(list, s.end(this));
    }

    public final void AddWithItem(List<SqlWithItem> list, SqlLiteral recursive) throws ParseException {
        SqlNodeList columnList;
        SqlIdentifier id = this.SimpleIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                columnList = this.ParenthesizedSimpleIdentifierList();
                break;
            }
            default: {
                this.jj_la1[184] = this.jj_gen;
                columnList = null;
            }
        }
        this.jj_consume_token(23);
        SqlNode definition = this.ParenthesizedExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        list.add(new SqlWithItem(id.getParserPosition(), id, columnList, definition, recursive));
    }

    public final SqlNode LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 518: 
            case 620: 
            case 688: 
            case 689: {
                SqlNode e = this.LeafQuery(exprContext);
                return e;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNode e = this.Expression(exprContext);
                return e;
            }
        }
        this.jj_la1[185] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void AddExpression(List<SqlNode> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        SqlNode e = this.Expression(exprContext);
        list.add(e);
    }

    public final SqlNode Expression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        List<Object> list = this.Expression2(exprContext);
        return SqlParserUtil.toTree(list);
    }

    public final void AddExpression2b(List<Object> list, SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 203: 
                case 368: 
                case 669: 
                case 755: 
                case 756: {
                    break;
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                    break block3;
                }
            }
            SqlPrefixOperator op = this.PrefixRowOperator();
            this.checkNonQueryExpression(exprContext);
            list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
        }
        SqlNode e = this.Expression3(exprContext);
        list.add(e);
        while (this.jj_2_47(2)) {
            this.jj_consume_token(744);
            SqlNode ext = this.RowExpressionExtension();
            list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.DOT, this.getPos()));
            list.add(ext);
        }
    }

    public final List<Object> Expression2(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<Object> list3 = new ArrayList<Object>();
        Span s = this.span();
        this.AddExpression2b(list, exprContext);
        if (this.jj_2_55(2)) {
            block52: do {
                SqlNode e;
                SqlOperator op;
                if (this.jj_2_50(2)) {
                    this.checkNonQueryExpression(exprContext);
                    block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 368: {
                            this.jj_consume_token(368);
                            this.jj_consume_token(258);
                            op = SqlStdOperatorTable.NOT_IN;
                            break;
                        }
                        case 258: {
                            this.jj_consume_token(258);
                            op = SqlStdOperatorTable.IN;
                            break;
                        }
                        case 746: 
                        case 747: 
                        case 748: 
                        case 751: 
                        case 752: 
                        case 753: 
                        case 754: {
                            SqlKind k = this.comp();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 537: {
                                    this.jj_consume_token(537);
                                    op = SqlStdOperatorTable.some(k);
                                    break block0;
                                }
                                case 16: {
                                    this.jj_consume_token(16);
                                    op = SqlStdOperatorTable.some(k);
                                    break block0;
                                }
                                case 10: {
                                    this.jj_consume_token(10);
                                    op = SqlStdOperatorTable.all(k);
                                    break block0;
                                }
                            }
                            this.jj_la1[187] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[188] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    s.clear().add(this);
                    SqlNodeList nodeList = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_NONCURSOR);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    s.add(nodeList);
                    if (nodeList.size() == 1) {
                        SqlNode item = nodeList.get(0);
                        if (item.isA(SqlKind.QUERY)) {
                            list.add(item);
                            continue;
                        }
                        list.add(nodeList);
                        continue;
                    }
                    list.add(nodeList);
                    continue;
                }
                if (this.jj_2_51(2)) {
                    this.checkNonQueryExpression(exprContext);
                    block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 368: {
                            this.jj_consume_token(368);
                            this.jj_consume_token(41);
                            op = SqlStdOperatorTable.NOT_BETWEEN;
                            s.clear().add(this);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 29: 
                                case 616: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 616: {
                                            this.jj_consume_token(616);
                                            op = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
                                            break block10;
                                        }
                                        case 29: {
                                            this.jj_consume_token(29);
                                            break block10;
                                        }
                                    }
                                    this.jj_la1[189] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[190] = this.jj_gen;
                            break;
                        }
                        case 41: {
                            this.jj_consume_token(41);
                            op = SqlStdOperatorTable.BETWEEN;
                            s.clear().add(this);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 29: 
                                case 616: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 616: {
                                            this.jj_consume_token(616);
                                            op = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
                                            break block10;
                                        }
                                        case 29: {
                                            this.jj_consume_token(29);
                                            break block10;
                                        }
                                    }
                                    this.jj_la1[191] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            this.jj_la1[192] = this.jj_gen;
                            break;
                        }
                        default: {
                            this.jj_la1[193] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.AddExpression2b(list3, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list3);
                    list3.clear();
                    continue;
                }
                if (this.jj_2_52(2)) {
                    this.checkNonQueryExpression(exprContext);
                    s.clear().add(this);
                    block28 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 368: {
                            this.jj_consume_token(368);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 311: {
                                    this.jj_consume_token(311);
                                    op = SqlStdOperatorTable.NOT_LIKE;
                                    break block28;
                                }
                                case 253: {
                                    this.jj_consume_token(253);
                                    op = SqlLibraryOperators.NOT_ILIKE;
                                    break block28;
                                }
                                case 485: {
                                    this.jj_consume_token(485);
                                    op = SqlLibraryOperators.NOT_RLIKE;
                                    break block28;
                                }
                                case 532: {
                                    this.jj_consume_token(532);
                                    this.jj_consume_token(638);
                                    op = SqlStdOperatorTable.NOT_SIMILAR_TO;
                                    break block28;
                                }
                            }
                            this.jj_la1[194] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        case 311: {
                            this.jj_consume_token(311);
                            op = SqlStdOperatorTable.LIKE;
                            break;
                        }
                        case 253: {
                            this.jj_consume_token(253);
                            op = SqlLibraryOperators.ILIKE;
                            break;
                        }
                        case 485: {
                            this.jj_consume_token(485);
                            op = SqlLibraryOperators.RLIKE;
                            break;
                        }
                        case 532: {
                            this.jj_consume_token(532);
                            this.jj_consume_token(638);
                            op = SqlStdOperatorTable.SIMILAR_TO;
                            break;
                        }
                        default: {
                            this.jj_la1[195] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    List<Object> list2 = this.Expression2(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list2);
                    if (!this.jj_2_48(2)) continue;
                    this.jj_consume_token(195);
                    e = this.Expression3(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    s.clear().add(this);
                    list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.ESCAPE, s.pos()));
                    list.add(e);
                    continue;
                }
                if (this.jj_2_53(3)) {
                    op = this.BinaryRowOperator();
                    this.checkNonQueryExpression(exprContext);
                    list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
                    this.AddExpression2b(list, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 741: {
                        SqlOperator itemOp;
                        this.jj_consume_token(741);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 382: {
                                this.jj_consume_token(382);
                                itemOp = SqlLibraryOperators.OFFSET;
                                this.jj_consume_token(733);
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                this.jj_consume_token(734);
                                break;
                            }
                            case 394: {
                                this.jj_consume_token(394);
                                itemOp = SqlLibraryOperators.ORDINAL;
                                this.jj_consume_token(733);
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                this.jj_consume_token(734);
                                break;
                            }
                            case 499: {
                                this.jj_consume_token(499);
                                itemOp = SqlLibraryOperators.SAFE_OFFSET;
                                this.jj_consume_token(733);
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                this.jj_consume_token(734);
                                break;
                            }
                            case 500: {
                                this.jj_consume_token(500);
                                itemOp = SqlLibraryOperators.SAFE_ORDINAL;
                                this.jj_consume_token(733);
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                this.jj_consume_token(734);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 32: 
                            case 33: 
                            case 35: 
                            case 36: 
                            case 40: 
                            case 48: 
                            case 50: 
                            case 53: 
                            case 54: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 74: 
                            case 75: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 91: 
                            case 93: 
                            case 94: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 139: 
                            case 140: 
                            case 141: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 148: 
                            case 149: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 160: 
                            case 161: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 169: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 177: 
                            case 178: 
                            case 181: 
                            case 182: 
                            case 184: 
                            case 187: 
                            case 192: 
                            case 194: 
                            case 196: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 203: 
                            case 204: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 219: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 230: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 237: 
                            case 238: 
                            case 240: 
                            case 242: 
                            case 243: 
                            case 246: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 264: 
                            case 267: 
                            case 270: 
                            case 271: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 286: 
                            case 287: 
                            case 288: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 302: 
                            case 303: 
                            case 305: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 314: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 320: 
                            case 321: 
                            case 323: 
                            case 326: 
                            case 328: 
                            case 329: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 338: 
                            case 339: 
                            case 340: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 377: 
                            case 379: 
                            case 380: 
                            case 389: 
                            case 390: 
                            case 393: 
                            case 395: 
                            case 396: 
                            case 399: 
                            case 402: 
                            case 403: 
                            case 404: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 414: 
                            case 415: 
                            case 416: 
                            case 417: 
                            case 418: 
                            case 422: 
                            case 423: 
                            case 424: 
                            case 425: 
                            case 427: 
                            case 428: 
                            case 429: 
                            case 430: 
                            case 432: 
                            case 434: 
                            case 436: 
                            case 439: 
                            case 440: 
                            case 442: 
                            case 443: 
                            case 445: 
                            case 447: 
                            case 448: 
                            case 450: 
                            case 451: 
                            case 460: 
                            case 464: 
                            case 466: 
                            case 467: 
                            case 469: 
                            case 470: 
                            case 472: 
                            case 473: 
                            case 474: 
                            case 477: 
                            case 478: 
                            case 479: 
                            case 480: 
                            case 481: 
                            case 484: 
                            case 485: 
                            case 486: 
                            case 489: 
                            case 490: 
                            case 491: 
                            case 492: 
                            case 493: 
                            case 494: 
                            case 495: 
                            case 497: 
                            case 498: 
                            case 503: 
                            case 504: 
                            case 505: 
                            case 506: 
                            case 508: 
                            case 509: 
                            case 510: 
                            case 513: 
                            case 514: 
                            case 515: 
                            case 516: 
                            case 519: 
                            case 521: 
                            case 522: 
                            case 523: 
                            case 524: 
                            case 525: 
                            case 526: 
                            case 527: 
                            case 529: 
                            case 533: 
                            case 534: 
                            case 537: 
                            case 538: 
                            case 539: 
                            case 540: 
                            case 541: 
                            case 547: 
                            case 548: 
                            case 549: 
                            case 550: 
                            case 551: 
                            case 552: 
                            case 553: 
                            case 554: 
                            case 555: 
                            case 556: 
                            case 557: 
                            case 558: 
                            case 559: 
                            case 560: 
                            case 561: 
                            case 562: 
                            case 563: 
                            case 564: 
                            case 565: 
                            case 566: 
                            case 567: 
                            case 568: 
                            case 569: 
                            case 570: 
                            case 571: 
                            case 572: 
                            case 573: 
                            case 574: 
                            case 575: 
                            case 576: 
                            case 577: 
                            case 578: 
                            case 579: 
                            case 580: 
                            case 581: 
                            case 582: 
                            case 583: 
                            case 584: 
                            case 585: 
                            case 586: 
                            case 587: 
                            case 588: 
                            case 589: 
                            case 590: 
                            case 591: 
                            case 592: 
                            case 593: 
                            case 594: 
                            case 595: 
                            case 596: 
                            case 598: 
                            case 599: 
                            case 601: 
                            case 602: 
                            case 604: 
                            case 605: 
                            case 606: 
                            case 607: 
                            case 610: 
                            case 611: 
                            case 614: 
                            case 619: 
                            case 621: 
                            case 623: 
                            case 626: 
                            case 627: 
                            case 628: 
                            case 629: 
                            case 630: 
                            case 631: 
                            case 632: 
                            case 633: 
                            case 634: 
                            case 639: 
                            case 641: 
                            case 642: 
                            case 643: 
                            case 644: 
                            case 645: 
                            case 646: 
                            case 647: 
                            case 652: 
                            case 653: 
                            case 654: 
                            case 655: 
                            case 657: 
                            case 658: 
                            case 659: 
                            case 661: 
                            case 662: 
                            case 664: 
                            case 665: 
                            case 666: 
                            case 667: 
                            case 669: 
                            case 670: 
                            case 671: 
                            case 672: 
                            case 675: 
                            case 677: 
                            case 678: 
                            case 679: 
                            case 680: 
                            case 681: 
                            case 682: 
                            case 684: 
                            case 685: 
                            case 686: 
                            case 687: 
                            case 691: 
                            case 692: 
                            case 697: 
                            case 699: 
                            case 701: 
                            case 702: 
                            case 711: 
                            case 712: 
                            case 713: 
                            case 714: 
                            case 715: 
                            case 716: 
                            case 717: 
                            case 718: 
                            case 719: 
                            case 720: 
                            case 724: 
                            case 725: 
                            case 726: 
                            case 727: 
                            case 728: 
                            case 730: 
                            case 731: 
                            case 733: 
                            case 735: 
                            case 736: 
                            case 737: 
                            case 738: 
                            case 749: 
                            case 755: 
                            case 756: 
                            case 782: 
                            case 783: 
                            case 784: 
                            case 785: 
                            case 786: 
                            case 787: 
                            case 789: {
                                itemOp = SqlStdOperatorTable.ITEM;
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                break;
                            }
                            default: {
                                this.jj_la1[196] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(742);
                        list.add(new SqlParserUtil.ToTreeListItem(itemOp, this.getPos()));
                        list.add(e);
                        while (this.jj_2_49(2)) {
                            this.jj_consume_token(744);
                            SqlIdentifier p = this.SimpleIdentifier();
                            list.add(new SqlParserUtil.ToTreeListItem(SqlStdOperatorTable.DOT, this.getPos()));
                            list.add(p);
                        }
                        continue block52;
                    }
                    case 219: 
                    case 279: {
                        this.checkNonQueryExpression(exprContext);
                        op = this.PostfixRowOperator();
                        list.add(new SqlParserUtil.ToTreeListItem(op, this.getPos()));
                        break;
                    }
                    default: {
                        this.jj_la1[197] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            } while (this.jj_2_54(2));
            return list;
        }
        return list;
    }

    public final SqlKind comp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 748: {
                this.jj_consume_token(748);
                return SqlKind.LESS_THAN;
            }
            case 751: {
                this.jj_consume_token(751);
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case 747: {
                this.jj_consume_token(747);
                return SqlKind.GREATER_THAN;
            }
            case 752: {
                this.jj_consume_token(752);
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
            case 746: {
                this.jj_consume_token(746);
                return SqlKind.EQUALS;
            }
            case 753: {
                this.jj_consume_token(753);
                return SqlKind.NOT_EQUALS;
            }
            case 754: {
                this.jj_consume_token(754);
                if (!this.conformance.isBangEqualAllowed()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.bangEqualNotAllowed());
                }
                return SqlKind.NOT_EQUALS;
            }
        }
        this.jj_la1[198] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode Expression3(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        if (this.jj_2_57(2)) {
            SqlNode e = this.AtomicRowExpression();
            this.checkNonQueryExpression(exprContext);
            return e;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 129: {
                SqlNode e = this.CursorExpression(exprContext);
                return e;
            }
        }
        this.jj_la1[200] = this.jj_gen;
        if (this.jj_2_58(3)) {
            this.jj_consume_token(493);
            Span s = this.span();
            SqlNodeList list = this.ParenthesizedQueryOrCommaList(exprContext);
            if (exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_ALL && exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR && !this.conformance.allowExplicitRowValueConstructor()) {
                throw SqlUtil.newContextException(s.end(list), Static.RESOURCE.illegalRowExpression());
            }
            return SqlStdOperatorTable.ROW.createCall(list);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 493: 
            case 733: {
                Span rowSpan;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 493: {
                        this.jj_consume_token(493);
                        rowSpan = this.span();
                        break;
                    }
                    default: {
                        this.jj_la1[199] = this.jj_gen;
                        rowSpan = null;
                    }
                }
                SqlNodeList list1 = this.ParenthesizedQueryOrCommaList(exprContext);
                if (rowSpan != null) {
                    return SqlStdOperatorTable.ROW.createCall(rowSpan.end(list1), (List<? extends SqlNode>)list1);
                }
                if (this.jj_2_56(2)) {
                    SqlCall call;
                    SqlIntervalQualifier e = this.IntervalQualifier();
                    if (list1.size() == 1 && list1.get(0) instanceof SqlCall && (call = (SqlCall)list1.get(0)).getKind() == SqlKind.MINUS && call.operandCount() == 2) {
                        return SqlStdOperatorTable.MINUS_DATE.createCall(Span.of(list1).end(this), new SqlNode[]{call.operand(0), call.operand(1), e});
                    }
                    throw SqlUtil.newContextException(this.span().end(list1), Static.RESOURCE.illegalMinusDate());
                }
                if (list1.size() == 1) {
                    return list1.get(0).clone(list1.getParserPosition());
                }
                return SqlStdOperatorTable.ROW.createCall(this.span().end(list1), (List<? extends SqlNode>)list1);
            }
        }
        this.jj_la1[201] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode LambdaExpression() throws ParseException {
        SqlNodeList parameters = this.SimpleIdentifierOrListOrEmpty();
        this.jj_consume_token(757);
        Span s = this.span();
        SqlNode expression = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return new SqlLambda(s.end(this), parameters, expression);
    }

    public final SqlNodeList SimpleIdentifierOrListOrEmpty() throws ParseException {
        if (this.jj_2_59(2)) {
            this.jj_consume_token(733);
            this.jj_consume_token(734);
            return SqlNodeList.EMPTY;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 733: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNodeList list = this.SimpleIdentifierOrList();
                return list;
            }
        }
        this.jj_la1[202] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlOperator periodOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 401: {
                this.jj_consume_token(401);
                return SqlStdOperatorTable.OVERLAPS;
            }
        }
        this.jj_la1[203] = this.jj_gen;
        if (this.jj_2_60(2)) {
            this.jj_consume_token(255);
            this.jj_consume_token(435);
            return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 435: {
                this.jj_consume_token(435);
                return SqlStdOperatorTable.PRECEDES;
            }
            case 255: {
                this.jj_consume_token(255);
                this.jj_consume_token(613);
                return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;
            }
            case 613: {
                this.jj_consume_token(613);
                return SqlStdOperatorTable.SUCCEEDS;
            }
            case 193: {
                this.jj_consume_token(193);
                return SqlStdOperatorTable.PERIOD_EQUALS;
            }
        }
        this.jj_la1[204] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCollation CollateClause() throws ParseException {
        this.jj_consume_token(80);
        this.jj_consume_token(788);
        return new SqlCollation(this.getToken((int)0).image, SqlCollation.Coercibility.EXPLICIT);
    }

    public final SqlNode UnsignedNumericLiteralOrParam() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: 
            case 718: 
            case 719: 
            case 720: {
                e = this.UnsignedNumericLiteral();
                break;
            }
            case 749: {
                e = this.DynamicParam();
                break;
            }
            default: {
                this.jj_la1[205] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode RowExpressionExtension() throws ParseException {
        SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
        SqlIdentifier p = this.SimpleIdentifier();
        if (this.jj_2_63(Integer.MAX_VALUE)) {
            Object args;
            SqlLiteral quantifier;
            Span s = this.span();
            if (this.jj_2_61(2)) {
                this.jj_consume_token(733);
                this.jj_consume_token(758);
                quantifier = null;
                args = ImmutableList.of((Object)SqlIdentifier.star(this.getPos()));
                this.jj_consume_token(734);
            } else if (this.jj_2_62(2)) {
                this.jj_consume_token(733);
                this.jj_consume_token(734);
                quantifier = null;
                args = ImmutableList.of();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 733: {
                        args = this.FunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        quantifier = (SqlLiteral)args.get(0);
                        args.remove(0);
                        break;
                    }
                    default: {
                        this.jj_la1[206] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return this.createCall(p, s.end(this), funcType, quantifier, (Iterable<? extends SqlNode>)args);
        }
        return p;
    }

    public final SqlCall StringAggFunctionCall() throws ParseException {
        Pair<SqlParserPos, SqlOperator> nullTreatment;
        SqlLiteral qualifier;
        SqlAggFunction op;
        Span s;
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                s = this.span();
                op = SqlLibraryOperators.ARRAY_AGG;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                s = this.span();
                op = SqlLibraryOperators.ARRAY_CONCAT_AGG;
                break;
            }
            case 242: {
                this.jj_consume_token(242);
                s = this.span();
                op = SqlLibraryOperators.GROUP_CONCAT;
                break;
            }
            case 604: {
                this.jj_consume_token(604);
                s = this.span();
                op = SqlLibraryOperators.STRING_AGG;
                break;
            }
            default: {
                this.jj_la1[207] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(733);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 173: {
                qualifier = this.AllOrDistinct();
                break;
            }
            default: {
                this.jj_la1[208] = this.jj_gen;
                qualifier = null;
            }
        }
        this.AddArg(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[209] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(745);
            this.checkNonQueryExpression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            this.AddArg(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 252: 
            case 472: {
                nullTreatment = this.NullTreatment();
                break;
            }
            default: {
                this.jj_la1[210] = this.jj_gen;
                nullTreatment = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                SqlNodeList orderBy = this.OrderBy(true);
                args.add(orderBy);
                break;
            }
            default: {
                this.jj_la1[211] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 521: {
                this.jj_consume_token(521);
                Span s2 = this.span();
                SqlNode separator = this.StringLiteral();
                args.add(SqlInternalOperators.SEPARATOR.createCall(s2.end(this), separator));
                break;
            }
            default: {
                this.jj_la1[212] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        SqlCall call = op.createCall(qualifier, s.end(this), args);
        if (nullTreatment != null) {
            call = ((SqlOperator)nullTreatment.right).createCall((SqlParserPos)nullTreatment.left, call);
        }
        return call;
    }

    public final SqlCall PercentileFunctionCall() throws ParseException {
        SqlAggFunction op;
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 422: {
                this.jj_consume_token(422);
                op = SqlStdOperatorTable.PERCENTILE_CONT;
                break;
            }
            case 423: {
                this.jj_consume_token(423);
                op = SqlStdOperatorTable.PERCENTILE_DISC;
                break;
            }
            default: {
                this.jj_la1[213] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddArg(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 734: {
                this.jj_consume_token(734);
                return op.createCall(s.end(this), args);
            }
            case 745: {
                Pair<SqlParserPos, SqlOperator> nullTreatment;
                this.jj_consume_token(745);
                SqlLiteral e = this.NumericLiteral();
                args.add(e);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 252: 
                    case 472: {
                        nullTreatment = this.NullTreatment();
                        break;
                    }
                    default: {
                        this.jj_la1[214] = this.jj_gen;
                        nullTreatment = null;
                    }
                }
                this.jj_consume_token(734);
                op = op == SqlStdOperatorTable.PERCENTILE_CONT ? SqlLibraryOperators.PERCENTILE_CONT2 : SqlLibraryOperators.PERCENTILE_DISC2;
                SqlCall call = op.createCall(s.end(this), args);
                if (nullTreatment != null) {
                    call = ((SqlOperator)nullTreatment.right).createCall((SqlParserPos)nullTreatment.left, call);
                }
                return call;
            }
        }
        this.jj_la1[215] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode AtomicRowExpression() throws ParseException {
        SqlNode e;
        if (this.jj_2_64(2)) {
            e = this.LiteralOrIntervalExpression();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 749: {
                    e = this.DynamicParam();
                    break;
                }
                default: {
                    this.jj_la1[216] = this.jj_gen;
                    if (this.jj_2_65(2)) {
                        e = this.BuiltinFunctionCall();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 738: {
                            e = this.JdbcFunctionCall();
                            break block0;
                        }
                        case 352: {
                            e = this.MultisetConstructor();
                            break block0;
                        }
                        case 19: {
                            e = this.ArrayConstructor();
                            break block0;
                        }
                    }
                    this.jj_la1[217] = this.jj_gen;
                    if (this.jj_2_66(3)) {
                        e = this.MapConstructor();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 425: {
                            e = this.PeriodConstructor();
                            break block0;
                        }
                    }
                    this.jj_la1[218] = this.jj_gen;
                    if (this.jj_2_67(Integer.MAX_VALUE)) {
                        e = this.NamedFunctionCall();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 128: 
                        case 316: 
                        case 317: 
                        case 527: 
                        case 619: 
                        case 678: {
                            e = this.ContextVariable();
                            break block0;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 20: 
                        case 21: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 36: 
                        case 40: 
                        case 48: 
                        case 50: 
                        case 54: 
                        case 58: 
                        case 59: 
                        case 62: 
                        case 63: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 75: 
                        case 79: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 91: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 130: 
                        case 132: 
                        case 133: 
                        case 135: 
                        case 136: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 148: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 161: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 169: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 178: 
                        case 181: 
                        case 182: 
                        case 187: 
                        case 192: 
                        case 194: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 212: 
                        case 213: 
                        case 217: 
                        case 219: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 237: 
                        case 238: 
                        case 240: 
                        case 242: 
                        case 246: 
                        case 248: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 264: 
                        case 267: 
                        case 270: 
                        case 271: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 302: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 318: 
                        case 320: 
                        case 321: 
                        case 323: 
                        case 329: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 338: 
                        case 339: 
                        case 340: 
                        case 343: 
                        case 344: 
                        case 350: 
                        case 351: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 361: 
                        case 367: 
                        case 372: 
                        case 374: 
                        case 375: 
                        case 377: 
                        case 380: 
                        case 389: 
                        case 390: 
                        case 393: 
                        case 395: 
                        case 396: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 414: 
                        case 415: 
                        case 416: 
                        case 417: 
                        case 418: 
                        case 427: 
                        case 428: 
                        case 429: 
                        case 430: 
                        case 436: 
                        case 439: 
                        case 442: 
                        case 443: 
                        case 445: 
                        case 447: 
                        case 448: 
                        case 451: 
                        case 467: 
                        case 469: 
                        case 470: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 477: 
                        case 478: 
                        case 479: 
                        case 480: 
                        case 481: 
                        case 485: 
                        case 486: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 492: 
                        case 494: 
                        case 503: 
                        case 504: 
                        case 505: 
                        case 506: 
                        case 508: 
                        case 509: 
                        case 510: 
                        case 514: 
                        case 515: 
                        case 516: 
                        case 519: 
                        case 521: 
                        case 522: 
                        case 523: 
                        case 524: 
                        case 525: 
                        case 526: 
                        case 529: 
                        case 533: 
                        case 534: 
                        case 538: 
                        case 539: 
                        case 541: 
                        case 547: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 553: 
                        case 554: 
                        case 555: 
                        case 556: 
                        case 557: 
                        case 558: 
                        case 559: 
                        case 560: 
                        case 561: 
                        case 562: 
                        case 563: 
                        case 564: 
                        case 565: 
                        case 566: 
                        case 567: 
                        case 568: 
                        case 569: 
                        case 570: 
                        case 571: 
                        case 572: 
                        case 573: 
                        case 574: 
                        case 575: 
                        case 576: 
                        case 577: 
                        case 578: 
                        case 579: 
                        case 580: 
                        case 581: 
                        case 582: 
                        case 583: 
                        case 584: 
                        case 585: 
                        case 586: 
                        case 587: 
                        case 588: 
                        case 589: 
                        case 590: 
                        case 591: 
                        case 592: 
                        case 593: 
                        case 594: 
                        case 595: 
                        case 598: 
                        case 599: 
                        case 604: 
                        case 605: 
                        case 606: 
                        case 607: 
                        case 610: 
                        case 621: 
                        case 623: 
                        case 626: 
                        case 628: 
                        case 629: 
                        case 631: 
                        case 632: 
                        case 633: 
                        case 634: 
                        case 639: 
                        case 641: 
                        case 642: 
                        case 643: 
                        case 644: 
                        case 645: 
                        case 646: 
                        case 652: 
                        case 653: 
                        case 654: 
                        case 661: 
                        case 662: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 667: 
                        case 671: 
                        case 672: 
                        case 677: 
                        case 679: 
                        case 680: 
                        case 681: 
                        case 682: 
                        case 684: 
                        case 685: 
                        case 686: 
                        case 697: 
                        case 699: 
                        case 701: 
                        case 702: 
                        case 711: 
                        case 712: 
                        case 713: 
                        case 714: 
                        case 716: 
                        case 717: 
                        case 782: 
                        case 783: 
                        case 784: 
                        case 785: 
                        case 786: 
                        case 787: 
                        case 789: {
                            e = this.CompoundIdentifier();
                            break block0;
                        }
                        case 362: {
                            e = this.NewSpecification();
                            break block0;
                        }
                        case 56: {
                            e = this.CaseExpression();
                            break block0;
                        }
                        case 117: 
                        case 363: {
                            e = this.SequenceExpression();
                            break block0;
                        }
                    }
                    this.jj_la1[219] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return e;
    }

    public final SqlNode CaseExpression() throws ParseException {
        SqlNode elseClause;
        SqlNode caseIdentifier;
        Span whenSpan = Span.of();
        Span thenSpan = Span.of();
        ArrayList<SqlNodeList> whenList = new ArrayList<SqlNodeList>();
        ArrayList<SqlNodeList> thenList = new ArrayList<SqlNodeList>();
        this.jj_consume_token(56);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 184: 
            case 187: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 203: 
            case 204: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 243: 
            case 246: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 275: 
            case 276: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 314: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 323: 
            case 326: 
            case 328: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 362: 
            case 363: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 377: 
            case 379: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 402: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 422: 
            case 423: 
            case 424: 
            case 425: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 439: 
            case 440: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 450: 
            case 451: 
            case 460: 
            case 464: 
            case 466: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 484: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 497: 
            case 498: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 529: 
            case 533: 
            case 534: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 596: 
            case 598: 
            case 599: 
            case 601: 
            case 602: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 611: 
            case 614: 
            case 619: 
            case 621: 
            case 623: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 630: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 647: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 657: 
            case 658: 
            case 659: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 675: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 691: 
            case 692: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 715: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 733: 
            case 735: 
            case 736: 
            case 737: 
            case 738: 
            case 749: 
            case 755: 
            case 756: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                caseIdentifier = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                break;
            }
            default: {
                this.jj_la1[220] = this.jj_gen;
                caseIdentifier = null;
            }
        }
        block9: while (true) {
            this.jj_consume_token(703);
            whenSpan.add(this);
            SqlNode e = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            if (e.size() == 1) {
                e = e.get(0);
            }
            whenList.add((SqlNodeList)e);
            this.jj_consume_token(624);
            thenSpan.add(this);
            e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
            thenList.add((SqlNodeList)e);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 703: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[221] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 185: {
                this.jj_consume_token(185);
                elseClause = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                break;
            }
            default: {
                this.jj_la1[222] = this.jj_gen;
                elseClause = null;
            }
        }
        this.jj_consume_token(188);
        return SqlCase.createSwitched(s.end(this), caseIdentifier, new SqlNodeList(whenList, whenSpan.addAll(whenList).pos()), new SqlNodeList(thenList, thenSpan.addAll(thenList).pos()), elseClause);
    }

    public final SqlCall SequenceExpression() throws ParseException {
        Span s;
        SqlOperator f;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 363: {
                this.jj_consume_token(363);
                f = SqlStdOperatorTable.NEXT_VALUE;
                s = this.span();
                break;
            }
            default: {
                this.jj_la1[223] = this.jj_gen;
                if (this.jj_2_68(3)) {
                    this.jj_consume_token(117);
                    f = SqlStdOperatorTable.CURRENT_VALUE;
                    s = this.span();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(688);
        this.jj_consume_token(218);
        SqlIdentifier sequenceRef = this.CompoundIdentifier();
        return f.createCall(s.end(sequenceRef), sequenceRef);
    }

    public final SqlSetOption SqlSetOption(Span s, String scope) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 528: {
                SqlNode val;
                this.jj_consume_token(528);
                s.add(this);
                SqlIdentifier name = this.CompoundIdentifier();
                this.jj_consume_token(746);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 134: 
                    case 137: 
                    case 149: 
                    case 209: 
                    case 276: 
                    case 371: 
                    case 627: 
                    case 630: 
                    case 657: 
                    case 670: 
                    case 687: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 755: 
                    case 756: {
                        val = this.Literal();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        val = this.SimpleIdentifier();
                        break;
                    }
                    case 385: {
                        this.jj_consume_token(385);
                        val = new SqlIdentifier(this.token.image.toUpperCase(Locale.ROOT), this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[224] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new SqlSetOption(s.end(val), scope, (SqlNode)name, val);
            }
            case 471: {
                SqlIdentifier name;
                this.jj_consume_token(471);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        name = this.CompoundIdentifier();
                        break;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        name = new SqlIdentifier(this.token.image.toUpperCase(Locale.ROOT), this.getPos());
                        break;
                    }
                    default: {
                        this.jj_la1[225] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new SqlSetOption(s.end(name), scope, (SqlNode)name, null);
            }
        }
        this.jj_la1[226] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlAlter SqlAlter() throws ParseException {
        this.jj_consume_token(13);
        Span s = this.span();
        String scope = this.Scope();
        SqlSetOption alterNode = this.SqlSetOption(s, scope);
        return alterNode;
    }

    public final String Scope() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 617: {
                this.jj_consume_token(617);
                break;
            }
            case 526: {
                this.jj_consume_token(526);
                break;
            }
            default: {
                this.jj_la1[227] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase(Locale.ROOT);
    }

    public final SqlNode Literal() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 134: 
            case 137: 
            case 149: 
            case 209: 
            case 371: 
            case 627: 
            case 630: 
            case 657: 
            case 670: 
            case 687: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 735: 
            case 736: 
            case 737: 
            case 755: 
            case 756: {
                e = this.NonIntervalLiteral();
                break;
            }
            case 276: {
                e = this.IntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode NonIntervalLiteral() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 149: 
            case 718: 
            case 719: 
            case 720: 
            case 755: 
            case 756: {
                e = this.NumericLiteral();
                break;
            }
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: {
                e = this.StringLiteral();
                break;
            }
            case 209: 
            case 371: 
            case 657: 
            case 670: {
                e = this.SpecialLiteral();
                break;
            }
            case 134: 
            case 137: 
            case 627: 
            case 630: 
            case 687: 
            case 735: 
            case 736: 
            case 737: {
                e = this.DateTimeLiteral();
                break;
            }
            default: {
                this.jj_la1[229] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNode LiteralOrIntervalExpression() throws ParseException {
        SqlNode e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 276: {
                e = this.IntervalLiteralOrExpression();
                break;
            }
            case 134: 
            case 137: 
            case 149: 
            case 209: 
            case 371: 
            case 627: 
            case 630: 
            case 657: 
            case 670: 
            case 687: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 735: 
            case 736: 
            case 737: 
            case 755: 
            case 756: {
                e = this.NonIntervalLiteral();
                break;
            }
            default: {
                this.jj_la1[230] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final SqlNumericLiteral UnsignedNumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 718: {
                this.jj_consume_token(718);
                return SqlLiteral.createExactNumeric(this.token.image, this.getPos());
            }
            case 720: {
                this.jj_consume_token(720);
                return SqlLiteral.createExactNumeric(this.token.image, this.getPos());
            }
            case 149: {
                this.jj_consume_token(149);
                String p = this.SimpleStringLiteral();
                return SqlParserUtil.parseDecimalLiteral(SqlParserUtil.trim(p, " "), this.getPos());
            }
            case 719: {
                this.jj_consume_token(719);
                return SqlLiteral.createApproxNumeric(this.token.image, this.getPos());
            }
        }
        this.jj_la1[231] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral NumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: {
                this.jj_consume_token(755);
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return num;
            }
            case 756: {
                this.jj_consume_token(756);
                Span s = this.span();
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return SqlLiteral.createNegative(num, s.end(this));
            }
            case 149: 
            case 718: 
            case 719: 
            case 720: {
                SqlNumericLiteral num = this.UnsignedNumericLiteral();
                return num;
            }
        }
        this.jj_la1[232] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral SpecialLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 657: {
                this.jj_consume_token(657);
                return SqlLiteral.createBoolean(true, this.getPos());
            }
            case 209: {
                this.jj_consume_token(209);
                return SqlLiteral.createBoolean(false, this.getPos());
            }
            case 670: {
                this.jj_consume_token(670);
                return SqlLiteral.createUnknown(this.getPos());
            }
            case 371: {
                this.jj_consume_token(371);
                return SqlLiteral.createNull(this.getPos());
            }
        }
        this.jj_la1[233] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode StringLiteral() throws ParseException {
        char unicodeEscapeChar = '\u0000';
        String charSet = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 724: {
                String p;
                this.jj_consume_token(724);
                ArrayList<SqlBinaryStringLiteral> frags = new ArrayList<SqlBinaryStringLiteral>();
                try {
                    p = SqlParserUtil.trim(this.token.image, "xX'");
                    frags.add(SqlLiteral.createBinaryString(p, this.getPos()));
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalBinaryString(this.token.image));
                }
                block35: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 725: {
                            break;
                        }
                        default: {
                            this.jj_la1[234] = this.jj_gen;
                            break block35;
                        }
                    }
                    this.jj_consume_token(725);
                    try {
                        p = SqlParserUtil.trim(this.token.image, "'");
                        frags.add(SqlLiteral.createBinaryString(p, this.getPos()));
                    }
                    catch (NumberFormatException ex) {
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalBinaryString(this.token.image));
                    }
                }
                assert (!frags.isEmpty());
                if (frags.size() == 1) {
                    return (SqlNode)frags.get(0);
                }
                SqlParserPos pos2 = SqlParserPos.sum(frags);
                return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, frags);
            }
            case 725: 
            case 726: 
            case 727: {
                SqlCharStringLiteral literal;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 726: {
                        this.jj_consume_token(726);
                        charSet = SqlParserUtil.getCharacterSet(this.token.image);
                        break;
                    }
                    case 725: {
                        this.jj_consume_token(725);
                        break;
                    }
                    case 727: {
                        this.jj_consume_token(727);
                        unicodeEscapeChar = '\\';
                        charSet = "UTF16";
                        break;
                    }
                    default: {
                        this.jj_la1[235] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                ArrayList<SqlCharStringLiteral> frags = new ArrayList<SqlCharStringLiteral>();
                String p = SqlParserUtil.parseString(this.token.image);
                try {
                    literal = SqlLiteral.createCharString(p, charSet, this.getPos());
                    frags.add(literal);
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
                block36: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 725: {
                            break;
                        }
                        default: {
                            this.jj_la1[236] = this.jj_gen;
                            break block36;
                        }
                    }
                    this.jj_consume_token(725);
                    p = SqlParserUtil.parseString(this.token.image);
                    try {
                        literal = SqlLiteral.createCharString(p, charSet, this.getPos());
                        frags.add(literal);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 663: {
                        this.jj_consume_token(663);
                        this.jj_consume_token(725);
                        if (unicodeEscapeChar == '\u0000') {
                            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unicodeEscapeUnexpected());
                        }
                        String s = SqlParserUtil.parseString(this.token.image);
                        unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
                        break;
                    }
                    default: {
                        this.jj_la1[237] = this.jj_gen;
                    }
                }
                assert (!frags.isEmpty());
                if (frags.size() == 1) {
                    SqlLiteral lit = (SqlLiteral)frags.get(0);
                    return lit.unescapeUnicode(unicodeEscapeChar);
                }
                SqlNode[] rands = frags.toArray(new SqlNode[0]);
                for (int i = 0; i < rands.length; ++i) {
                    rands[i] = ((SqlLiteral)rands[i]).unescapeUnicode(unicodeEscapeChar);
                }
                SqlParserPos pos2 = SqlParserPos.sum(rands);
                return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, rands);
            }
            case 728: {
                String p;
                this.jj_consume_token(728);
                try {
                    p = SqlParserUtil.parseCString(this.getToken((int)0).image);
                }
                catch (SqlParserUtil.MalformedUnicodeEscape e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unicodeEscapeMalformed(e.i));
                }
                return SqlLiteral.createCharString(p, "UTF16", this.getPos());
            }
            case 730: {
                this.jj_consume_token(730);
                String p = SqlParserUtil.stripQuotes(this.getToken((int)0).image, DQ, DQ, "\\\"", Casing.UNCHANGED);
                try {
                    return SqlLiteral.createCharString(p, charSet, this.getPos());
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
            }
            case 731: {
                this.jj_consume_token(731);
                String p = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "'", "'", "\\'", Casing.UNCHANGED);
                try {
                    return SqlLiteral.createCharString(p, charSet, this.getPos());
                }
                catch (UnsupportedCharsetException e) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.unknownCharacterSet(charSet));
                }
            }
        }
        this.jj_la1[238] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String SimpleStringLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 725: {
                this.jj_consume_token(725);
                return SqlParserUtil.parseString(this.token.image);
            }
            case 731: {
                this.jj_consume_token(731);
                return SqlParserUtil.stripQuotes(this.token.image, "'", "'", "\\'", Casing.UNCHANGED);
            }
            case 730: {
                this.jj_consume_token(730);
                return SqlParserUtil.stripQuotes(this.token.image, DQ, DQ, "\\\"", Casing.UNCHANGED);
            }
        }
        this.jj_la1[239] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral DateTimeLiteral() throws ParseException {
        boolean local = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 735: {
                this.jj_consume_token(735);
                this.jj_consume_token(725);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(740);
                return SqlParserUtil.parseDateLiteral(p, this.getPos());
            }
            case 736: {
                this.jj_consume_token(736);
                this.jj_consume_token(725);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(740);
                return SqlParserUtil.parseTimeLiteral(p, this.getPos());
            }
            case 737: {
                this.jj_consume_token(737);
                Span s = this.span();
                this.jj_consume_token(725);
                String p = SqlParserUtil.parseString(this.token.image);
                this.jj_consume_token(740);
                return SqlParserUtil.parseTimestampLiteral(p, s.end(this));
            }
            case 134: {
                this.jj_consume_token(134);
                Span s = this.span();
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("DATE", p, s.end(this));
            }
            case 137: {
                this.jj_consume_token(137);
                Span s = this.span();
                String p = this.SimpleStringLiteral();
                return SqlLiteral.createUnknown("DATETIME", p, s.end(this));
            }
        }
        this.jj_la1[242] = this.jj_gen;
        if (this.jj_2_69(2)) {
            this.jj_consume_token(627);
            Span s = this.span();
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("TIME", p, s.end(this));
        }
        if (this.jj_2_70(2)) {
            this.jj_consume_token(687);
            Span s = this.span();
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("UUID", p, s.end(this));
        }
        if (this.jj_2_71(2)) {
            this.jj_consume_token(630);
            Span s = this.span();
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("TIMESTAMP", p, s.end(this));
        }
        if (this.jj_2_72(2)) {
            this.jj_consume_token(627);
            Span s = this.span();
            this.jj_consume_token(708);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 315: {
                    this.jj_consume_token(315);
                    local = true;
                    break;
                }
                default: {
                    this.jj_la1[240] = this.jj_gen;
                }
            }
            this.jj_consume_token(627);
            this.jj_consume_token(717);
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("TIME WITH " + (local ? "LOCAL " : "") + "TIME ZONE", p, s.end(this));
        }
        if (this.jj_2_73(2)) {
            this.jj_consume_token(630);
            Span s = this.span();
            this.jj_consume_token(708);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 315: {
                    this.jj_consume_token(315);
                    local = true;
                    break;
                }
                default: {
                    this.jj_la1[241] = this.jj_gen;
                }
            }
            this.jj_consume_token(627);
            this.jj_consume_token(717);
            String p = this.SimpleStringLiteral();
            return SqlLiteral.createUnknown("TIMESTAMP WITH " + (local ? "LOCAL " : "") + "TIME ZONE", p, s.end(this));
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode DateTimeConstructorCall() throws ParseException {
        SqlFunctionCategory funcType = SqlFunctionCategory.TIMEDATE;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            case 627: {
                this.jj_consume_token(627);
                break;
            }
            case 137: {
                this.jj_consume_token(137);
                break;
            }
            case 630: {
                this.jj_consume_token(630);
                break;
            }
            default: {
                this.jj_la1[243] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        SqlIdentifier qualifiedName = new SqlIdentifier(this.unquotedIdentifier(), this.getPos());
        List<SqlNode> args = this.FunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        SqlLiteral quantifier = (SqlLiteral)args.get(0);
        args.remove(0);
        return this.createCall(qualifiedName, s.end(this), funcType, quantifier, args);
    }

    public final SqlNode MultisetConstructor() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(352);
        Span s = this.span();
        if (this.jj_2_74(2)) {
            this.jj_consume_token(733);
            SqlNode e = this.LeafQueryOrExpr(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
            this.jj_consume_token(734);
            return SqlStdOperatorTable.MULTISET_QUERY.createCall(s.end(this), e);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 741: {
                this.jj_consume_token(741);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[244] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(745);
                    this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                }
                this.jj_consume_token(742);
                return SqlStdOperatorTable.MULTISET_VALUE.createCall(s.end(this), args);
            }
        }
        this.jj_la1[245] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode ArrayConstructor() throws ParseException {
        this.jj_consume_token(19);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                SqlNodeList args;
                if (this.jj_2_75(2)) {
                    this.jj_consume_token(733);
                    this.jj_consume_token(734);
                    args = SqlNodeList.EMPTY;
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 733: {
                            args = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_ALL);
                            break;
                        }
                        default: {
                            this.jj_la1[246] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (args.size() == 1 && args.get(0).isA(SqlKind.QUERY)) {
                    return SqlStdOperatorTable.ARRAY_QUERY.createCall(s.end(this), args.get(0));
                }
                return SqlLibraryOperators.ARRAY.createCall(s.end(this), args.getList());
            }
            case 741: {
                SqlNodeList args;
                this.jj_consume_token(741);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        args = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[247] = this.jj_gen;
                        args = SqlNodeList.EMPTY;
                    }
                }
                this.jj_consume_token(742);
                return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(s.end(this), args.getList());
            }
        }
        this.jj_la1[248] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall ArrayLiteral() throws ParseException {
        List list;
        this.jj_consume_token(739);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 134: 
            case 137: 
            case 149: 
            case 209: 
            case 276: 
            case 371: 
            case 627: 
            case 630: 
            case 657: 
            case 670: 
            case 687: 
            case 718: 
            case 719: 
            case 720: 
            case 724: 
            case 725: 
            case 726: 
            case 727: 
            case 728: 
            case 730: 
            case 731: 
            case 735: 
            case 736: 
            case 737: 
            case 755: 
            case 756: {
                SqlNode e = this.Literal();
                list = this.startList(e);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[249] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(745);
                    e = this.Literal();
                    list.add(e);
                }
            }
            case 739: {
                SqlCall e = this.ArrayLiteral();
                list = this.startList(e);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[250] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(745);
                    e = this.ArrayLiteral();
                    list.add(e);
                }
            }
            default: {
                this.jj_la1[251] = this.jj_gen;
                list = Collections.emptyList();
            }
        }
        this.jj_consume_token(740);
        return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(s.end(this), list);
    }

    public final SqlNode MapConstructor() throws ParseException {
        this.jj_consume_token(321);
        Span s = this.span();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                SqlNodeList args;
                if (this.jj_2_76(2)) {
                    this.jj_consume_token(733);
                    this.jj_consume_token(734);
                    args = SqlNodeList.EMPTY;
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 733: {
                            args = this.ParenthesizedQueryOrCommaList(SqlAbstractParserImpl.ExprContext.ACCEPT_ALL);
                            break;
                        }
                        default: {
                            this.jj_la1[252] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                if (args.size() == 1 && args.get(0).isA(SqlKind.QUERY)) {
                    return SqlStdOperatorTable.MAP_QUERY.createCall(s.end(this), args.get(0));
                }
                return SqlLibraryOperators.MAP.createCall(s.end(this), args.getList());
            }
            case 741: {
                SqlNodeList args;
                this.jj_consume_token(741);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        args = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[253] = this.jj_gen;
                        args = SqlNodeList.EMPTY;
                    }
                }
                this.jj_consume_token(742);
                return SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(s.end(this), args.getList());
            }
        }
        this.jj_la1[254] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlNode PeriodConstructor() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(425);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.ROW.createCall(s.end(this), args);
    }

    public final SqlLiteral IntervalLiteral() throws ParseException {
        int sign = 1;
        this.jj_consume_token(276);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: 
            case 756: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 756: {
                        this.jj_consume_token(756);
                        sign = -1;
                        break block0;
                    }
                    case 755: {
                        this.jj_consume_token(755);
                        sign = 1;
                        break block0;
                    }
                }
                this.jj_la1[255] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[256] = this.jj_gen;
            }
        }
        String p = this.SimpleStringLiteral();
        SqlIntervalQualifier intervalQualifier = this.IntervalQualifier();
        return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier), sign, p, intervalQualifier);
    }

    public final SqlNode IntervalLiteralOrExpression() throws ParseException {
        int sign = 1;
        this.jj_consume_token(276);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 755: 
            case 756: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 756: {
                        this.jj_consume_token(756);
                        sign = -1;
                        break block0;
                    }
                    case 755: {
                        this.jj_consume_token(755);
                        sign = 1;
                        break block0;
                    }
                }
                this.jj_la1[257] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[258] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 725: 
            case 730: 
            case 731: {
                String p = this.SimpleStringLiteral();
                SqlIntervalQualifier intervalQualifier = this.IntervalQualifier();
                return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier), sign, p, intervalQualifier);
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 718: 
            case 719: 
            case 720: 
            case 733: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlNode e;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 733: {
                        this.jj_consume_token(733);
                        e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        this.jj_consume_token(734);
                        break;
                    }
                    case 149: 
                    case 718: 
                    case 719: 
                    case 720: {
                        e = this.UnsignedNumericLiteral();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.CompoundIdentifier();
                        break;
                    }
                    default: {
                        this.jj_la1[259] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                SqlIntervalQualifier intervalQualifier = this.IntervalQualifierStart();
                if (sign == -1) {
                    e = SqlStdOperatorTable.UNARY_MINUS.createCall(e.getParserPosition(), e);
                }
                return SqlStdOperatorTable.INTERVAL.createCall(s.end(this), e, intervalQualifier);
            }
        }
        this.jj_la1[260] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Year() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: {
                this.jj_consume_token(715);
                return TimeUnit.YEAR;
            }
            case 716: {
                this.jj_consume_token(716);
                return this.warn(TimeUnit.YEAR);
            }
        }
        this.jj_la1[261] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Quarter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 447: {
                this.jj_consume_token(447);
                return TimeUnit.QUARTER;
            }
            case 448: {
                this.jj_consume_token(448);
                return this.warn(TimeUnit.QUARTER);
            }
        }
        this.jj_la1[262] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Month() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 349: {
                this.jj_consume_token(349);
                return TimeUnit.MONTH;
            }
            case 350: {
                this.jj_consume_token(350);
                return this.warn(TimeUnit.MONTH);
            }
        }
        this.jj_la1[263] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Week() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 701: {
                this.jj_consume_token(701);
                return TimeUnit.WEEK;
            }
            case 702: {
                this.jj_consume_token(702);
                return this.warn(TimeUnit.WEEK);
            }
        }
        this.jj_la1[264] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Day() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 142: {
                this.jj_consume_token(142);
                return TimeUnit.DAY;
            }
            case 145: {
                this.jj_consume_token(145);
                return this.warn(TimeUnit.DAY);
            }
        }
        this.jj_la1[265] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Hour() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 249: {
                this.jj_consume_token(249);
                return TimeUnit.HOUR;
            }
            case 250: {
                this.jj_consume_token(250);
                return this.warn(TimeUnit.HOUR);
            }
        }
        this.jj_la1[266] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Minute() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 342: {
                this.jj_consume_token(342);
                return TimeUnit.MINUTE;
            }
            case 343: {
                this.jj_consume_token(343);
                return this.warn(TimeUnit.MINUTE);
            }
        }
        this.jj_la1[267] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TimeUnit Second() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 513: {
                this.jj_consume_token(513);
                return TimeUnit.SECOND;
            }
            case 514: {
                this.jj_consume_token(514);
                return this.warn(TimeUnit.SECOND);
            }
        }
        this.jj_la1[268] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlIntervalQualifier IntervalQualifier() throws ParseException {
        TimeUnit end;
        int startPrec;
        Span s;
        TimeUnit start;
        int secondFracPrec = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 715: 
            case 716: {
                start = this.Year();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_77(2)) {
                    this.jj_consume_token(638);
                    end = this.Month();
                    break;
                }
                end = null;
                break;
            }
            case 447: 
            case 448: {
                start = this.Quarter();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 349: 
            case 350: {
                start = this.Month();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 701: 
            case 702: {
                start = this.Week();
                s = this.span();
                startPrec = this.PrecisionOpt();
                end = null;
                break;
            }
            case 142: 
            case 145: {
                start = this.Day();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_78(2)) {
                    this.jj_consume_token(638);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 249: 
                        case 250: {
                            end = this.Hour();
                            break block0;
                        }
                        case 342: 
                        case 343: {
                            end = this.Minute();
                            break block0;
                        }
                        case 513: 
                        case 514: {
                            end = this.Second();
                            secondFracPrec = this.PrecisionOpt();
                            break block0;
                        }
                    }
                    this.jj_la1[269] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                end = null;
                break;
            }
            case 249: 
            case 250: {
                start = this.Hour();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_79(2)) {
                    this.jj_consume_token(638);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 342: 
                        case 343: {
                            end = this.Minute();
                            break block0;
                        }
                        case 513: 
                        case 514: {
                            end = this.Second();
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 733: {
                                    this.jj_consume_token(733);
                                    secondFracPrec = this.UnsignedIntLiteral();
                                    this.jj_consume_token(734);
                                    break block0;
                                }
                            }
                            this.jj_la1[270] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_la1[271] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                end = null;
                break;
            }
            case 342: 
            case 343: {
                start = this.Minute();
                s = this.span();
                startPrec = this.PrecisionOpt();
                if (this.jj_2_80(2)) {
                    this.jj_consume_token(638);
                    end = this.Second();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 733: {
                            this.jj_consume_token(733);
                            secondFracPrec = this.UnsignedIntLiteral();
                            this.jj_consume_token(734);
                            break block0;
                        }
                    }
                    this.jj_la1[272] = this.jj_gen;
                    break;
                }
                end = null;
                break;
            }
            case 513: 
            case 514: {
                start = this.Second();
                s = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 733: {
                        this.jj_consume_token(733);
                        startPrec = this.UnsignedIntLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 745: {
                                this.jj_consume_token(745);
                                secondFracPrec = this.UnsignedIntLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[273] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(734);
                        break;
                    }
                    default: {
                        this.jj_la1[274] = this.jj_gen;
                        startPrec = -1;
                    }
                }
                end = null;
                break;
            }
            default: {
                this.jj_la1[275] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIntervalQualifier(start, startPrec, end, secondFracPrec, s.end(this));
    }

    public final SqlIntervalQualifier IntervalQualifierStart() throws ParseException {
        Span s;
        TimeUnit start;
        int startPrec = -1;
        int secondFracPrec = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 142: 
            case 145: 
            case 249: 
            case 250: 
            case 342: 
            case 343: 
            case 349: 
            case 350: 
            case 447: 
            case 448: 
            case 701: 
            case 702: 
            case 715: 
            case 716: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 715: 
                    case 716: {
                        start = this.Year();
                        break;
                    }
                    case 447: 
                    case 448: {
                        start = this.Quarter();
                        break;
                    }
                    case 349: 
                    case 350: {
                        start = this.Month();
                        break;
                    }
                    case 701: 
                    case 702: {
                        start = this.Week();
                        break;
                    }
                    case 142: 
                    case 145: {
                        start = this.Day();
                        break;
                    }
                    case 249: 
                    case 250: {
                        start = this.Hour();
                        break;
                    }
                    case 342: 
                    case 343: {
                        start = this.Minute();
                        break;
                    }
                    default: {
                        this.jj_la1[276] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s = this.span();
                startPrec = this.PrecisionOpt();
                break;
            }
            case 513: 
            case 514: {
                start = this.Second();
                s = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 733: {
                        this.jj_consume_token(733);
                        startPrec = this.UnsignedIntLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 745: {
                                this.jj_consume_token(745);
                                secondFracPrec = this.UnsignedIntLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[277] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(734);
                        break block0;
                    }
                }
                this.jj_la1[278] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[279] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIntervalQualifier(start, startPrec, null, secondFracPrec, s.end(this));
    }

    public final SqlIntervalQualifier TimeUnitOrName() throws ParseException {
        if (this.jj_2_81(2)) {
            SqlIntervalQualifier intervalQualifier = this.TimeUnit();
            return intervalQualifier;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlIdentifier unitName = this.SimpleIdentifier();
                return new SqlIntervalQualifier(unitName.getSimple(), unitName.getParserPosition());
            }
        }
        this.jj_la1[280] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlIntervalQualifier TimeUnit() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 356: {
                this.jj_consume_token(356);
                return new SqlIntervalQualifier(TimeUnit.NANOSECOND, null, this.getPos());
            }
            case 338: {
                this.jj_consume_token(338);
                return new SqlIntervalQualifier(TimeUnit.MICROSECOND, null, this.getPos());
            }
            case 339: {
                this.jj_consume_token(339);
                return new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, this.getPos());
            }
            case 513: {
                this.jj_consume_token(513);
                return new SqlIntervalQualifier(TimeUnit.SECOND, null, this.getPos());
            }
            case 342: {
                this.jj_consume_token(342);
                return new SqlIntervalQualifier(TimeUnit.MINUTE, null, this.getPos());
            }
            case 249: {
                this.jj_consume_token(249);
                return new SqlIntervalQualifier(TimeUnit.HOUR, null, this.getPos());
            }
            case 142: {
                this.jj_consume_token(142);
                return new SqlIntervalQualifier(TimeUnit.DAY, null, this.getPos());
            }
            case 143: {
                this.jj_consume_token(143);
                return new SqlIntervalQualifier(TimeUnit.DOW, null, this.getPos());
            }
            case 144: {
                this.jj_consume_token(144);
                return new SqlIntervalQualifier(TimeUnit.DOY, null, this.getPos());
            }
            case 177: {
                this.jj_consume_token(177);
                return new SqlIntervalQualifier(TimeUnit.DOW, null, this.getPos());
            }
            case 178: {
                this.jj_consume_token(178);
                return new SqlIntervalQualifier(TimeUnit.DOY, null, this.getPos());
            }
            case 280: {
                this.jj_consume_token(280);
                return new SqlIntervalQualifier(TimeUnit.ISODOW, null, this.getPos());
            }
            case 281: {
                this.jj_consume_token(281);
                return new SqlIntervalQualifier(TimeUnit.ISOYEAR, null, this.getPos());
            }
            case 701: {
                this.jj_consume_token(701);
                Span span = this.span();
                if (this.jj_2_82(2)) {
                    this.jj_consume_token(733);
                    String w = this.weekdayName();
                    this.jj_consume_token(734);
                    return new SqlIntervalQualifier(w, span.end(this));
                }
                return new SqlIntervalQualifier(TimeUnit.WEEK, null, this.getPos());
            }
            case 349: {
                this.jj_consume_token(349);
                return new SqlIntervalQualifier(TimeUnit.MONTH, null, this.getPos());
            }
            case 447: {
                this.jj_consume_token(447);
                return new SqlIntervalQualifier(TimeUnit.QUARTER, null, this.getPos());
            }
            case 715: {
                this.jj_consume_token(715);
                return new SqlIntervalQualifier(TimeUnit.YEAR, null, this.getPos());
            }
            case 192: {
                this.jj_consume_token(192);
                return new SqlIntervalQualifier(TimeUnit.EPOCH, null, this.getPos());
            }
            case 148: {
                this.jj_consume_token(148);
                return new SqlIntervalQualifier(TimeUnit.DECADE, null, this.getPos());
            }
            case 62: {
                this.jj_consume_token(62);
                return new SqlIntervalQualifier(TimeUnit.CENTURY, null, this.getPos());
            }
            case 340: {
                this.jj_consume_token(340);
                return new SqlIntervalQualifier(TimeUnit.MILLENNIUM, null, this.getPos());
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String weekdayName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 615: {
                this.jj_consume_token(615);
                return "WEEK_SUNDAY";
            }
            case 348: {
                this.jj_consume_token(348);
                return "WEEK_MONDAY";
            }
            case 660: {
                this.jj_consume_token(660);
                return "WEEK_TUESDAY";
            }
            case 700: {
                this.jj_consume_token(700);
                return "WEEK_WEDNESDAY";
            }
            case 625: {
                this.jj_consume_token(625);
                return "WEEK_THURSDAY";
            }
            case 226: {
                this.jj_consume_token(226);
                return "WEEK_FRIDAY";
            }
            case 501: {
                this.jj_consume_token(501);
                return "WEEK_SATURDAY";
            }
        }
        this.jj_la1[282] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlDynamicParam DynamicParam() throws ParseException {
        this.jj_consume_token(749);
        return new SqlDynamicParam(this.nDynamicParams++, this.getPos());
    }

    public final void AddIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
        SqlParserPos pos;
        String id;
        char unicodeEscapeChar = '\\';
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 787: {
                this.jj_consume_token(787);
                id = this.unquotedIdentifier();
                pos = this.getPos();
                break;
            }
            case 786: {
                this.jj_consume_token(786);
                id = this.unquotedIdentifier();
                pos = this.getPos();
                break;
            }
            case 783: {
                this.jj_consume_token(783);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, DQ, DQ, DQDQ, this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 784: {
                this.jj_consume_token(784);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "`", "`", "``", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 785: {
                this.jj_consume_token(785);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "`", "`", "\\`", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 782: {
                this.jj_consume_token(782);
                id = SqlParserUtil.stripQuotes(this.getToken((int)0).image, "[", "]", "]]", this.quotedCasing);
                pos = this.getPos().withQuoting(true);
                break;
            }
            case 789: {
                this.jj_consume_token(789);
                Span span = this.span();
                String image = this.getToken((int)0).image;
                image = image.substring(image.indexOf(34));
                image = SqlParserUtil.stripQuotes(image, DQ, DQ, DQDQ, this.quotedCasing);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 663: {
                        this.jj_consume_token(663);
                        this.jj_consume_token(725);
                        String s = SqlParserUtil.parseString(this.token.image);
                        unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
                        break;
                    }
                    default: {
                        this.jj_la1[283] = this.jj_gen;
                    }
                }
                pos = span.end(this).withQuoting(true);
                SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
                lit = lit.unescapeUnicode(unicodeEscapeChar);
                id = lit.toValue();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: {
                id = this.NonReservedKeyWord();
                pos = this.getPos();
                break;
            }
            default: {
                this.jj_la1[284] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (id.length() > this.identifierMaxLength) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.identifierTooLong(id, this.identifierMaxLength));
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
    }

    public final void AddTableIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
        this.AddIdentifierSegment(names, positions);
        int n = names.size();
        if (n > 0 && positions.size() == n && names.get(n - 1).contains(".") && positions.get(n - 1).isQuoted() && this.conformance.splitQuotedTableName()) {
            String[] splitNames;
            String name = names.remove(n - 1);
            SqlParserPos pos = positions.remove(n - 1);
            for (String splitName : splitNames = name.split("\\.")) {
                names.add(splitName);
                positions.add(pos);
            }
        }
    }

    public final String Identifier() throws ParseException {
        ArrayList<String> names = new ArrayList<String>();
        this.AddIdentifierSegment(names, null);
        return (String)names.get(0);
    }

    public final SqlIdentifier SimpleIdentifier() throws ParseException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<SqlParserPos> positions = new ArrayList<SqlParserPos>();
        this.AddIdentifierSegment(names, positions);
        return new SqlIdentifier((String)names.get(0), (SqlParserPos)positions.get(0));
    }

    public final SqlIdentifier SimpleIdentifierFromStringLiteral() throws ParseException {
        this.jj_consume_token(725);
        if (!this.conformance.allowCharLiteralAlias()) {
            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.charLiteralAliasNotValid());
        }
        String s = SqlParserUtil.parseString(this.token.image);
        return new SqlIdentifier(s, this.getPos());
    }

    public final void AddSimpleIdentifiers(List<SqlNode> list) throws ParseException {
        SqlIdentifier id = this.SimpleIdentifier();
        list.add(id);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[285] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            id = this.SimpleIdentifier();
            list.add(id);
        }
    }

    public final SqlNodeList ParenthesizedSimpleIdentifierList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        this.jj_consume_token(733);
        Span s = this.span();
        this.AddSimpleIdentifiers(list);
        this.jj_consume_token(734);
        return new SqlNodeList(list, s.end(this));
    }

    public final SqlNodeList SimpleIdentifierOrList() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                SqlIdentifier id = this.SimpleIdentifier();
                return new SqlNodeList(Collections.singletonList(id), id.getParserPosition());
            }
            case 733: {
                SqlNodeList list = this.ParenthesizedSimpleIdentifierList();
                return list;
            }
        }
        this.jj_la1[286] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlIdentifier CompoundIdentifier() throws ParseException {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<SqlParserPos> posList = new ArrayList<SqlParserPos>();
        boolean star = false;
        this.AddIdentifierSegment(nameList, posList);
        while (this.jj_2_83(2)) {
            this.jj_consume_token(744);
            this.AddIdentifierSegment(nameList, posList);
        }
        if (this.jj_2_84(2)) {
            this.jj_consume_token(744);
            this.jj_consume_token(758);
            star = true;
            nameList.add("");
            posList.add(this.getPos());
        }
        SqlParserPos pos = SqlParserPos.sum(posList);
        if (star) {
            return SqlIdentifier.star(nameList, pos, posList);
        }
        return new SqlIdentifier(nameList, null, pos, posList);
    }

    public final SqlIdentifier CompoundTableIdentifier() throws ParseException {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<SqlParserPos> posList = new ArrayList<SqlParserPos>();
        this.AddTableIdentifierSegment(nameList, posList);
        while (this.jj_2_85(2)) {
            this.jj_consume_token(744);
            this.AddTableIdentifierSegment(nameList, posList);
        }
        SqlParserPos pos = SqlParserPos.sum(posList);
        return new SqlIdentifier(nameList, null, pos, posList);
    }

    public final void AddCompoundIdentifierTypes(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
        this.AddCompoundIdentifierType(list, extendList);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[287] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddCompoundIdentifierType(list, extendList);
        }
    }

    public final Pair<SqlNodeList, SqlNodeList> ParenthesizedCompoundIdentifierList() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        ArrayList<SqlNode> extendList = new ArrayList<SqlNode>();
        this.jj_consume_token(733);
        Span s = this.span();
        this.AddCompoundIdentifierTypes(list, extendList);
        this.jj_consume_token(734);
        return Pair.of(new SqlNodeList(list, s.end(this)), new SqlNodeList(extendList, s.end(this)));
    }

    public final SqlNode NewSpecification() throws ParseException {
        this.jj_consume_token(362);
        Span s = this.span();
        SqlNode routineCall = this.NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return SqlStdOperatorTable.NEW.createCall(s.end(routineCall), routineCall);
    }

    public final int UnsignedIntLiteral() throws ParseException {
        Token t = this.jj_consume_token(718);
        try {
            return Integer.parseInt(t.image);
        }
        catch (NumberFormatException ex) {
            throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
        }
    }

    public final int IntLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 718: 
            case 755: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 718: {
                        t = this.jj_consume_token(718);
                        break;
                    }
                    case 755: {
                        this.jj_consume_token(755);
                        t = this.jj_consume_token(718);
                        break;
                    }
                    default: {
                        this.jj_la1[288] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    return Integer.parseInt(t.image);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
                }
            }
            case 756: {
                this.jj_consume_token(756);
                Token t = this.jj_consume_token(718);
                try {
                    return -Integer.parseInt(t.image);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));
                }
            }
        }
        this.jj_la1[289] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlDataTypeSpec DataType() throws ParseException {
        SqlTypeNameSpec typeName = this.TypeName();
        Span s = Span.of(typeName.getParserPos());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 352: {
                    break;
                }
                default: {
                    this.jj_la1[290] = this.jj_gen;
                    break block3;
                }
            }
            typeName = this.CollectionsTypeName(typeName);
        }
        return new SqlDataTypeSpec(typeName, s.add(typeName.getParserPos()).pos());
    }

    public final SqlTypeNameSpec TypeName() throws ParseException {
        SqlTypeNameSpec typeNameSpec;
        Span s = Span.of();
        if (this.jj_2_86(2)) {
            typeNameSpec = this.SqlTypeName(s);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 493: {
                    typeNameSpec = this.RowTypeName();
                    break;
                }
                default: {
                    this.jj_la1[291] = this.jj_gen;
                    if (this.jj_2_87(2)) {
                        typeNameSpec = this.MapTypeName();
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 20: 
                        case 21: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 36: 
                        case 40: 
                        case 48: 
                        case 50: 
                        case 54: 
                        case 58: 
                        case 59: 
                        case 62: 
                        case 63: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 75: 
                        case 79: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 91: 
                        case 93: 
                        case 94: 
                        case 96: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 130: 
                        case 132: 
                        case 133: 
                        case 135: 
                        case 136: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 148: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 161: 
                        case 163: 
                        case 164: 
                        case 166: 
                        case 167: 
                        case 169: 
                        case 172: 
                        case 174: 
                        case 175: 
                        case 177: 
                        case 178: 
                        case 181: 
                        case 182: 
                        case 187: 
                        case 192: 
                        case 194: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 212: 
                        case 213: 
                        case 217: 
                        case 219: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 237: 
                        case 238: 
                        case 240: 
                        case 242: 
                        case 246: 
                        case 248: 
                        case 250: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 264: 
                        case 267: 
                        case 270: 
                        case 271: 
                        case 278: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 285: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 302: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 318: 
                        case 320: 
                        case 321: 
                        case 323: 
                        case 329: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 338: 
                        case 339: 
                        case 340: 
                        case 343: 
                        case 344: 
                        case 350: 
                        case 351: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 361: 
                        case 367: 
                        case 372: 
                        case 374: 
                        case 375: 
                        case 377: 
                        case 380: 
                        case 389: 
                        case 390: 
                        case 393: 
                        case 395: 
                        case 396: 
                        case 399: 
                        case 403: 
                        case 404: 
                        case 406: 
                        case 407: 
                        case 408: 
                        case 409: 
                        case 410: 
                        case 411: 
                        case 412: 
                        case 414: 
                        case 415: 
                        case 416: 
                        case 417: 
                        case 418: 
                        case 427: 
                        case 428: 
                        case 429: 
                        case 430: 
                        case 436: 
                        case 439: 
                        case 442: 
                        case 443: 
                        case 445: 
                        case 447: 
                        case 448: 
                        case 451: 
                        case 467: 
                        case 469: 
                        case 470: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 477: 
                        case 478: 
                        case 479: 
                        case 480: 
                        case 481: 
                        case 485: 
                        case 486: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 492: 
                        case 494: 
                        case 503: 
                        case 504: 
                        case 505: 
                        case 506: 
                        case 508: 
                        case 509: 
                        case 510: 
                        case 514: 
                        case 515: 
                        case 516: 
                        case 519: 
                        case 521: 
                        case 522: 
                        case 523: 
                        case 524: 
                        case 525: 
                        case 526: 
                        case 529: 
                        case 533: 
                        case 534: 
                        case 538: 
                        case 539: 
                        case 541: 
                        case 547: 
                        case 548: 
                        case 549: 
                        case 550: 
                        case 551: 
                        case 552: 
                        case 553: 
                        case 554: 
                        case 555: 
                        case 556: 
                        case 557: 
                        case 558: 
                        case 559: 
                        case 560: 
                        case 561: 
                        case 562: 
                        case 563: 
                        case 564: 
                        case 565: 
                        case 566: 
                        case 567: 
                        case 568: 
                        case 569: 
                        case 570: 
                        case 571: 
                        case 572: 
                        case 573: 
                        case 574: 
                        case 575: 
                        case 576: 
                        case 577: 
                        case 578: 
                        case 579: 
                        case 580: 
                        case 581: 
                        case 582: 
                        case 583: 
                        case 584: 
                        case 585: 
                        case 586: 
                        case 587: 
                        case 588: 
                        case 589: 
                        case 590: 
                        case 591: 
                        case 592: 
                        case 593: 
                        case 594: 
                        case 595: 
                        case 598: 
                        case 599: 
                        case 604: 
                        case 605: 
                        case 606: 
                        case 607: 
                        case 610: 
                        case 621: 
                        case 623: 
                        case 626: 
                        case 628: 
                        case 629: 
                        case 631: 
                        case 632: 
                        case 633: 
                        case 634: 
                        case 639: 
                        case 641: 
                        case 642: 
                        case 643: 
                        case 644: 
                        case 645: 
                        case 646: 
                        case 652: 
                        case 653: 
                        case 654: 
                        case 661: 
                        case 662: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 667: 
                        case 671: 
                        case 672: 
                        case 677: 
                        case 679: 
                        case 680: 
                        case 681: 
                        case 682: 
                        case 684: 
                        case 685: 
                        case 686: 
                        case 697: 
                        case 699: 
                        case 701: 
                        case 702: 
                        case 711: 
                        case 712: 
                        case 713: 
                        case 714: 
                        case 716: 
                        case 717: 
                        case 782: 
                        case 783: 
                        case 784: 
                        case 785: 
                        case 786: 
                        case 787: 
                        case 789: {
                            SqlIdentifier typeName = this.CompoundIdentifier();
                            typeNameSpec = new SqlUserDefinedTypeNameSpec(typeName, s.end(this));
                            break block0;
                        }
                    }
                    this.jj_la1[292] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeNameSpec;
    }

    public final SqlTypeNameSpec SqlTypeName(Span s) throws ParseException {
        SqlTypeNameSpec sqlTypeNameSpec;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 46: 
            case 176: 
            case 215: 
            case 234: 
            case 272: 
            case 273: 
            case 453: 
            case 536: 
            case 637: 
            case 687: 
            case 695: {
                sqlTypeNameSpec = this.SqlTypeName1(s);
                break;
            }
            case 43: 
            case 693: {
                sqlTypeNameSpec = this.SqlTypeName2(s);
                break;
            }
            case 16: 
            case 147: 
            case 149: 
            case 376: {
                sqlTypeNameSpec = this.SqlTypeName3(s);
                break;
            }
            case 64: 
            case 66: 
            case 694: {
                sqlTypeNameSpec = this.CharacterTypeName(s);
                break;
            }
            case 134: 
            case 627: 
            case 630: {
                sqlTypeNameSpec = this.DateTimeTypeName();
                break;
            }
            default: {
                this.jj_la1[293] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sqlTypeNameSpec;
    }

    public final SqlTypeNameSpec SqlTypeName1(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 234: {
                this.jj_consume_token(234);
                if (!this.conformance.allowGeometry()) {
                    throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.geometryDisabled());
                }
                s.add(this);
                sqlTypeName = SqlTypeName.GEOMETRY;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                s.add(this);
                sqlTypeName = SqlTypeName.BOOLEAN;
                break;
            }
            case 272: 
            case 273: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 273: {
                        this.jj_consume_token(273);
                        break;
                    }
                    case 272: {
                        this.jj_consume_token(272);
                        break;
                    }
                    default: {
                        this.jj_la1[294] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                sqlTypeName = SqlTypeName.INTEGER;
                break;
            }
            case 637: {
                this.jj_consume_token(637);
                s.add(this);
                sqlTypeName = SqlTypeName.TINYINT;
                break;
            }
            case 536: {
                this.jj_consume_token(536);
                s.add(this);
                sqlTypeName = SqlTypeName.SMALLINT;
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                s.add(this);
                sqlTypeName = SqlTypeName.BIGINT;
                break;
            }
            case 453: {
                this.jj_consume_token(453);
                s.add(this);
                sqlTypeName = SqlTypeName.REAL;
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 437: {
                        this.jj_consume_token(437);
                        break;
                    }
                    default: {
                        this.jj_la1[295] = this.jj_gen;
                    }
                }
                sqlTypeName = SqlTypeName.DOUBLE;
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                s.add(this);
                sqlTypeName = SqlTypeName.FLOAT;
                break;
            }
            case 695: {
                this.jj_consume_token(695);
                s.add(this);
                sqlTypeName = SqlTypeName.VARIANT;
                break;
            }
            case 687: {
                this.jj_consume_token(687);
                s.add(this);
                sqlTypeName = SqlTypeName.UUID;
                break;
            }
            default: {
                this.jj_la1[296] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, s.end(this));
    }

    public final SqlTypeNameSpec SqlTypeName2(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 696: {
                        this.jj_consume_token(696);
                        sqlTypeName = SqlTypeName.VARBINARY;
                        break block0;
                    }
                }
                this.jj_la1[297] = this.jj_gen;
                sqlTypeName = SqlTypeName.BINARY;
                break;
            }
            case 693: {
                this.jj_consume_token(693);
                s.add(this);
                sqlTypeName = SqlTypeName.VARBINARY;
                break;
            }
            default: {
                this.jj_la1[298] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        precision = this.PrecisionOpt();
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, s.end(this));
    }

    public final SqlTypeNameSpec SqlTypeName3(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        int scale = Integer.MIN_VALUE;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 147: 
            case 149: 
            case 376: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 149: {
                        this.jj_consume_token(149);
                        break;
                    }
                    case 147: {
                        this.jj_consume_token(147);
                        break;
                    }
                    case 376: {
                        this.jj_consume_token(376);
                        break;
                    }
                    default: {
                        this.jj_la1[299] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                sqlTypeName = SqlTypeName.DECIMAL;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                s.add(this);
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            default: {
                this.jj_la1[300] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                this.jj_consume_token(733);
                precision = this.UnsignedIntLiteral();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 745: {
                        this.jj_consume_token(745);
                        scale = this.IntLiteral();
                        break;
                    }
                    default: {
                        this.jj_la1[301] = this.jj_gen;
                    }
                }
                this.jj_consume_token(734);
                break;
            }
            default: {
                this.jj_la1[302] = this.jj_gen;
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, s.end(this));
    }

    public final SqlJdbcDataTypeName JdbcOdbcDataTypeName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: 
            case 552: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 552: {
                        this.jj_consume_token(552);
                        break;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[303] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_CHAR;
            }
            case 595: 
            case 694: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 595: {
                        this.jj_consume_token(595);
                        break;
                    }
                    case 694: {
                        this.jj_consume_token(694);
                        break;
                    }
                    default: {
                        this.jj_la1[304] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_VARCHAR;
            }
            case 134: 
            case 554: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 554: {
                        this.jj_consume_token(554);
                        break;
                    }
                    case 134: {
                        this.jj_consume_token(134);
                        break;
                    }
                    default: {
                        this.jj_la1[305] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DATE;
            }
            case 581: 
            case 627: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 581: {
                        this.jj_consume_token(581);
                        break;
                    }
                    case 627: {
                        this.jj_consume_token(627);
                        break;
                    }
                    default: {
                        this.jj_la1[306] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TIME;
            }
            case 582: 
            case 630: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 582: {
                        this.jj_consume_token(582);
                        break;
                    }
                    case 630: {
                        this.jj_consume_token(630);
                        break;
                    }
                    default: {
                        this.jj_la1[307] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TIMESTAMP;
            }
            case 149: 
            case 555: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 555: {
                        this.jj_consume_token(555);
                        break;
                    }
                    case 149: {
                        this.jj_consume_token(149);
                        break;
                    }
                    default: {
                        this.jj_la1[308] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DECIMAL;
            }
            case 376: 
            case 577: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 577: {
                        this.jj_consume_token(577);
                        break;
                    }
                    case 376: {
                        this.jj_consume_token(376);
                        break;
                    }
                    default: {
                        this.jj_la1[309] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_NUMERIC;
            }
            case 46: 
            case 551: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 551: {
                        this.jj_consume_token(551);
                        break;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        break;
                    }
                    default: {
                        this.jj_la1[310] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BOOLEAN;
            }
            case 273: 
            case 558: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 558: {
                        this.jj_consume_token(558);
                        break;
                    }
                    case 273: {
                        this.jj_consume_token(273);
                        break;
                    }
                    default: {
                        this.jj_la1[311] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_INTEGER;
            }
            case 43: 
            case 548: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 548: {
                        this.jj_consume_token(548);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        break;
                    }
                    default: {
                        this.jj_la1[312] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BINARY;
            }
            case 594: 
            case 693: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 594: {
                        this.jj_consume_token(594);
                        break;
                    }
                    case 693: {
                        this.jj_consume_token(693);
                        break;
                    }
                    default: {
                        this.jj_la1[313] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_VARBINARY;
            }
            case 583: 
            case 637: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 583: {
                        this.jj_consume_token(583);
                        break;
                    }
                    case 637: {
                        this.jj_consume_token(637);
                        break;
                    }
                    default: {
                        this.jj_la1[314] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_TINYINT;
            }
            case 536: 
            case 580: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 580: {
                        this.jj_consume_token(580);
                        break;
                    }
                    case 536: {
                        this.jj_consume_token(536);
                        break;
                    }
                    default: {
                        this.jj_la1[315] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_SMALLINT;
            }
            case 42: 
            case 547: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 547: {
                        this.jj_consume_token(547);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[316] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_BIGINT;
            }
            case 453: 
            case 579: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 579: {
                        this.jj_consume_token(579);
                        break;
                    }
                    case 453: {
                        this.jj_consume_token(453);
                        break;
                    }
                    default: {
                        this.jj_la1[317] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_REAL;
            }
            case 176: 
            case 556: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 556: {
                        this.jj_consume_token(556);
                        break;
                    }
                    case 176: {
                        this.jj_consume_token(176);
                        break;
                    }
                    default: {
                        this.jj_la1[318] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_DOUBLE;
            }
            case 215: 
            case 557: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 557: {
                        this.jj_consume_token(557);
                        break;
                    }
                    case 215: {
                        this.jj_consume_token(215);
                        break;
                    }
                    default: {
                        this.jj_la1[319] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlJdbcDataTypeName.SQL_FLOAT;
            }
            case 570: {
                this.jj_consume_token(570);
                return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR;
            }
            case 571: {
                this.jj_consume_token(571);
                return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 568: {
                this.jj_consume_token(568);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MONTH;
            }
            case 559: {
                this.jj_consume_token(559);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY;
            }
            case 560: {
                this.jj_consume_token(560);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 561: {
                this.jj_consume_token(561);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 562: {
                this.jj_consume_token(562);
                return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 563: {
                this.jj_consume_token(563);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR;
            }
            case 564: {
                this.jj_consume_token(564);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 565: {
                this.jj_consume_token(565);
                return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 566: {
                this.jj_consume_token(566);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE;
            }
            case 567: {
                this.jj_consume_token(567);
                return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 569: {
                this.jj_consume_token(569);
                return SqlJdbcDataTypeName.SQL_INTERVAL_SECOND;
            }
        }
        this.jj_la1[320] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlLiteral JdbcOdbcDataType() throws ParseException {
        SqlJdbcDataTypeName typeName = this.JdbcOdbcDataTypeName();
        return typeName.symbol(this.getPos());
    }

    public final SqlTypeNameSpec CollectionsTypeName(SqlTypeNameSpec elementTypeName) throws ParseException {
        SqlTypeName collectionTypeName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 352: {
                this.jj_consume_token(352);
                collectionTypeName = SqlTypeName.MULTISET;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                collectionTypeName = SqlTypeName.ARRAY;
                break;
            }
            default: {
                this.jj_la1[321] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlCollectionTypeNameSpec(elementTypeName, collectionTypeName, this.getPos());
    }

    public final boolean NullableOptDefaultTrue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 371: {
                this.jj_consume_token(371);
                return true;
            }
            case 368: {
                this.jj_consume_token(368);
                this.jj_consume_token(371);
                return false;
            }
        }
        this.jj_la1[322] = this.jj_gen;
        return true;
    }

    public final boolean NullableOptDefaultFalse() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 371: {
                this.jj_consume_token(371);
                return true;
            }
            case 368: {
                this.jj_consume_token(368);
                this.jj_consume_token(371);
                return false;
            }
        }
        this.jj_la1[323] = this.jj_gen;
        return false;
    }

    public final boolean NotNullOpt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 368: {
                this.jj_consume_token(368);
                this.jj_consume_token(371);
                return false;
            }
        }
        this.jj_la1[324] = this.jj_gen;
        return true;
    }

    public final void AddFieldNameTypes(List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes) throws ParseException {
        this.AddFieldNameType(fieldNames, fieldTypes);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 745: {
                    break;
                }
                default: {
                    this.jj_la1[325] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(745);
            this.AddFieldNameType(fieldNames, fieldTypes);
        }
    }

    public final void AddFieldNameType(List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes) throws ParseException {
        SqlIdentifier fName = this.SimpleIdentifier();
        SqlDataTypeSpec fType = this.DataType();
        boolean nullable = this.NullableOptDefaultFalse();
        fieldNames.add(fName);
        fieldTypes.add(fType.withNullable(nullable, this.getPos()));
    }

    public final SqlTypeNameSpec RowTypeName() throws ParseException {
        ArrayList<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
        ArrayList<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
        this.jj_consume_token(493);
        this.jj_consume_token(733);
        this.AddFieldNameTypes(fieldNames, fieldTypes);
        this.jj_consume_token(734);
        return new SqlRowTypeNameSpec(this.getPos(), fieldNames, fieldTypes);
    }

    public final SqlTypeNameSpec MapTypeName() throws ParseException {
        SqlDataTypeSpec keyType = null;
        SqlDataTypeSpec valType = null;
        this.jj_consume_token(321);
        this.jj_consume_token(748);
        keyType = this.DataType();
        this.jj_consume_token(745);
        valType = this.DataType();
        this.jj_consume_token(747);
        return new SqlMapTypeNameSpec(keyType, valType, this.getPos());
    }

    public final SqlTypeNameSpec CharacterTypeName(Span s) throws ParseException {
        SqlTypeName sqlTypeName;
        int precision = -1;
        String charSetName = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: 
            case 66: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        break;
                    }
                    default: {
                        this.jj_la1[326] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                s.add(this);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 696: {
                        this.jj_consume_token(696);
                        sqlTypeName = SqlTypeName.VARCHAR;
                        break block0;
                    }
                }
                this.jj_la1[327] = this.jj_gen;
                sqlTypeName = SqlTypeName.CHAR;
                break;
            }
            case 694: {
                this.jj_consume_token(694);
                s.add(this);
                sqlTypeName = SqlTypeName.VARCHAR;
                break;
            }
            default: {
                this.jj_la1[328] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        precision = this.PrecisionOpt();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(528);
                charSetName = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[329] = this.jj_gen;
            }
        }
        return new SqlBasicTypeNameSpec(sqlTypeName, precision, charSetName, s.end(this));
    }

    public final SqlTypeNameSpec DateTimeTypeName() throws ParseException {
        int precision = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 134: {
                this.jj_consume_token(134);
                SqlTypeName typeName = SqlTypeName.DATE;
                return new SqlBasicTypeNameSpec(typeName, this.getPos());
            }
        }
        this.jj_la1[330] = this.jj_gen;
        if (this.jj_2_88(2)) {
            this.jj_consume_token(627);
            Span s = this.span();
            precision = this.PrecisionOpt();
            SqlTypeName typeName = this.TimeZoneOpt(true);
            return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 630: {
                this.jj_consume_token(630);
                Span s = this.span();
                precision = this.PrecisionOpt();
                SqlTypeName typeName = this.TimeZoneOpt(false);
                return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));
            }
        }
        this.jj_la1[331] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int PrecisionOpt() throws ParseException {
        int precision = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 733: {
                this.jj_consume_token(733);
                precision = this.UnsignedIntLiteral();
                this.jj_consume_token(734);
                return precision;
            }
        }
        this.jj_la1[332] = this.jj_gen;
        return -1;
    }

    public final SqlTypeName TimeZoneOpt(boolean timeType) throws ParseException {
        boolean local = false;
        if (this.jj_2_89(3)) {
            this.jj_consume_token(710);
            this.jj_consume_token(627);
            this.jj_consume_token(717);
            return timeType ? SqlTypeName.TIME : SqlTypeName.TIMESTAMP;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: {
                this.jj_consume_token(708);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 315: {
                        this.jj_consume_token(315);
                        local = true;
                        break;
                    }
                    default: {
                        this.jj_la1[333] = this.jj_gen;
                    }
                }
                this.jj_consume_token(627);
                this.jj_consume_token(717);
                return timeType ? (local ? SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE : SqlTypeName.TIME_TZ) : (local ? SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE : SqlTypeName.TIMESTAMP_TZ);
            }
        }
        this.jj_la1[334] = this.jj_gen;
        return timeType ? SqlTypeName.TIME : SqlTypeName.TIMESTAMP;
    }

    public final SqlNode CursorExpression(SqlAbstractParserImpl.ExprContext exprContext) throws ParseException {
        this.jj_consume_token(129);
        Span s = this.span();
        if (exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_ALL && exprContext != SqlAbstractParserImpl.ExprContext.ACCEPT_CURSOR) {
            throw SqlUtil.newContextException(s.end(this), Static.RESOURCE.illegalCursorExpression());
        }
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_QUERY);
        return SqlStdOperatorTable.CURSOR.createCall(s.end(e), e);
    }

    public final SqlNode BuiltinFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: 
            case 498: 
            case 659: {
                SqlFunction f;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        this.jj_consume_token(57);
                        f = SqlStdOperatorTable.CAST;
                        break;
                    }
                    case 498: {
                        this.jj_consume_token(498);
                        f = SqlLibraryOperators.SAFE_CAST;
                        break;
                    }
                    case 659: {
                        this.jj_consume_token(659);
                        f = SqlLibraryOperators.TRY_CAST;
                        break;
                    }
                    default: {
                        this.jj_la1[335] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Span s = this.span();
                this.jj_consume_token(733);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(23);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 42: 
                    case 43: 
                    case 46: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 215: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 453: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 536: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 637: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        SqlDataTypeSpec dt = this.DataType();
                        args.add(dt);
                        break;
                    }
                    case 276: {
                        this.jj_consume_token(276);
                        SqlIntervalQualifier e = this.IntervalQualifier();
                        args.add(e);
                        break;
                    }
                    default: {
                        this.jj_la1[336] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 219: {
                        this.jj_consume_token(219);
                        SqlNode format = this.StringLiteral();
                        args.add(format);
                        break;
                    }
                    default: {
                        this.jj_la1[337] = this.jj_gen;
                    }
                }
                this.jj_consume_token(734);
                return f.createCall(s.end(this), args);
            }
            case 208: {
                this.jj_consume_token(208);
                Span s = this.span();
                this.jj_consume_token(733);
                SqlIntervalQualifier unit = this.TimeUnitOrName();
                args.add(unit);
                this.jj_consume_token(227);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(734);
                return SqlStdOperatorTable.EXTRACT.createCall(s.end(this), args);
            }
            case 432: {
                this.jj_consume_token(432);
                Span s = this.span();
                this.jj_consume_token(733);
                SqlNode e = this.AtomicRowExpression();
                args.add(e);
                this.jj_consume_token(258);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 227: {
                        this.jj_consume_token(227);
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[338] = this.jj_gen;
                    }
                }
                this.jj_consume_token(734);
                return SqlStdOperatorTable.POSITION.createCall(s.end(this), args);
            }
            case 107: {
                this.jj_consume_token(107);
                Span s = this.span();
                this.jj_consume_token(733);
                if (this.jj_2_90(2)) {
                    this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 683: {
                            this.jj_consume_token(683);
                            SqlIdentifier name = this.SimpleIdentifier();
                            args.add(name);
                            this.jj_consume_token(734);
                            return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this), args);
                        }
                        case 745: {
                            this.jj_consume_token(745);
                            SqlIdentifier e = this.SimpleIdentifier();
                            args.add(e);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 745: {
                                    this.jj_consume_token(745);
                                    e = this.SimpleIdentifier();
                                    args.add(e);
                                    this.jj_consume_token(734);
                                    SqlOperator op = SqlStdOperatorTable.getConvertFuncByConformance(this.conformance);
                                    return op.createCall(s.end(this), args);
                                }
                                case 734: {
                                    this.jj_consume_token(734);
                                    return SqlLibraryOperators.CONVERT_ORACLE.createCall(s.end(this), args);
                                }
                            }
                            this.jj_la1[339] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_la1[340] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 42: 
                    case 43: 
                    case 46: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 215: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 453: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 536: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 637: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 693: 
                    case 694: 
                    case 695: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 16: 
                            case 17: 
                            case 20: 
                            case 21: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 32: 
                            case 33: 
                            case 36: 
                            case 40: 
                            case 42: 
                            case 43: 
                            case 46: 
                            case 48: 
                            case 50: 
                            case 54: 
                            case 58: 
                            case 59: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 66: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 75: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 91: 
                            case 93: 
                            case 94: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 130: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 138: 
                            case 139: 
                            case 140: 
                            case 141: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 147: 
                            case 148: 
                            case 149: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 161: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 169: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 176: 
                            case 177: 
                            case 178: 
                            case 181: 
                            case 182: 
                            case 187: 
                            case 192: 
                            case 194: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 212: 
                            case 213: 
                            case 215: 
                            case 217: 
                            case 219: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 237: 
                            case 238: 
                            case 240: 
                            case 242: 
                            case 246: 
                            case 248: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 264: 
                            case 267: 
                            case 270: 
                            case 271: 
                            case 272: 
                            case 273: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 302: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 318: 
                            case 320: 
                            case 321: 
                            case 323: 
                            case 329: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 338: 
                            case 339: 
                            case 340: 
                            case 343: 
                            case 344: 
                            case 350: 
                            case 351: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 361: 
                            case 367: 
                            case 372: 
                            case 374: 
                            case 375: 
                            case 376: 
                            case 377: 
                            case 380: 
                            case 389: 
                            case 390: 
                            case 393: 
                            case 395: 
                            case 396: 
                            case 399: 
                            case 403: 
                            case 404: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 414: 
                            case 415: 
                            case 416: 
                            case 417: 
                            case 418: 
                            case 427: 
                            case 428: 
                            case 429: 
                            case 430: 
                            case 436: 
                            case 439: 
                            case 442: 
                            case 443: 
                            case 445: 
                            case 447: 
                            case 448: 
                            case 451: 
                            case 453: 
                            case 467: 
                            case 469: 
                            case 470: 
                            case 472: 
                            case 473: 
                            case 474: 
                            case 477: 
                            case 478: 
                            case 479: 
                            case 480: 
                            case 481: 
                            case 485: 
                            case 486: 
                            case 489: 
                            case 490: 
                            case 491: 
                            case 492: 
                            case 493: 
                            case 494: 
                            case 503: 
                            case 504: 
                            case 505: 
                            case 506: 
                            case 508: 
                            case 509: 
                            case 510: 
                            case 514: 
                            case 515: 
                            case 516: 
                            case 519: 
                            case 521: 
                            case 522: 
                            case 523: 
                            case 524: 
                            case 525: 
                            case 526: 
                            case 529: 
                            case 533: 
                            case 534: 
                            case 536: 
                            case 538: 
                            case 539: 
                            case 541: 
                            case 547: 
                            case 548: 
                            case 549: 
                            case 550: 
                            case 551: 
                            case 552: 
                            case 553: 
                            case 554: 
                            case 555: 
                            case 556: 
                            case 557: 
                            case 558: 
                            case 559: 
                            case 560: 
                            case 561: 
                            case 562: 
                            case 563: 
                            case 564: 
                            case 565: 
                            case 566: 
                            case 567: 
                            case 568: 
                            case 569: 
                            case 570: 
                            case 571: 
                            case 572: 
                            case 573: 
                            case 574: 
                            case 575: 
                            case 576: 
                            case 577: 
                            case 578: 
                            case 579: 
                            case 580: 
                            case 581: 
                            case 582: 
                            case 583: 
                            case 584: 
                            case 585: 
                            case 586: 
                            case 587: 
                            case 588: 
                            case 589: 
                            case 590: 
                            case 591: 
                            case 592: 
                            case 593: 
                            case 594: 
                            case 595: 
                            case 598: 
                            case 599: 
                            case 604: 
                            case 605: 
                            case 606: 
                            case 607: 
                            case 610: 
                            case 621: 
                            case 623: 
                            case 626: 
                            case 627: 
                            case 628: 
                            case 629: 
                            case 630: 
                            case 631: 
                            case 632: 
                            case 633: 
                            case 634: 
                            case 637: 
                            case 639: 
                            case 641: 
                            case 642: 
                            case 643: 
                            case 644: 
                            case 645: 
                            case 646: 
                            case 652: 
                            case 653: 
                            case 654: 
                            case 661: 
                            case 662: 
                            case 664: 
                            case 665: 
                            case 666: 
                            case 667: 
                            case 671: 
                            case 672: 
                            case 677: 
                            case 679: 
                            case 680: 
                            case 681: 
                            case 682: 
                            case 684: 
                            case 685: 
                            case 686: 
                            case 687: 
                            case 693: 
                            case 694: 
                            case 695: 
                            case 697: 
                            case 699: 
                            case 701: 
                            case 702: 
                            case 711: 
                            case 712: 
                            case 713: 
                            case 714: 
                            case 716: 
                            case 717: 
                            case 782: 
                            case 783: 
                            case 784: 
                            case 785: 
                            case 786: 
                            case 787: 
                            case 789: {
                                SqlDataTypeSpec dt = this.DataType();
                                args.add(dt);
                                break;
                            }
                            case 276: {
                                this.jj_consume_token(276);
                                SqlIntervalQualifier e = this.IntervalQualifier();
                                args.add(e);
                                break;
                            }
                            default: {
                                this.jj_la1[341] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(745);
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        block63 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 745: {
                                this.jj_consume_token(745);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 149: 
                                    case 718: 
                                    case 719: 
                                    case 720: {
                                        SqlNumericLiteral style = this.UnsignedNumericLiteral();
                                        args.add(style);
                                        break block63;
                                    }
                                    case 371: {
                                        this.jj_consume_token(371);
                                        args.add(SqlLiteral.createNull(this.getPos()));
                                        break block63;
                                    }
                                }
                                this.jj_la1[342] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[343] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(734);
                        return SqlLibraryOperators.MSSQL_CONVERT.createCall(s.end(this), args);
                    }
                }
                this.jj_la1[344] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 647: {
                this.jj_consume_token(647);
                Span s = this.span();
                this.jj_consume_token(733);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 683: {
                        this.jj_consume_token(683);
                        SqlIdentifier name = this.SimpleIdentifier();
                        args.add(name);
                        this.jj_consume_token(734);
                        return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this), args);
                    }
                    case 734: 
                    case 745: {
                        block110: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 745: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[345] = this.jj_gen;
                                    break block110;
                                }
                            }
                            this.jj_consume_token(745);
                            this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        }
                        this.jj_consume_token(734);
                        return SqlLibraryOperators.TRANSLATE3.createCall(s.end(this), args);
                    }
                }
                this.jj_la1[346] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 402: {
                this.jj_consume_token(402);
                Span s = this.span();
                this.jj_consume_token(733);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(428);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(227);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 218: {
                        this.jj_consume_token(218);
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[347] = this.jj_gen;
                    }
                }
                this.jj_consume_token(734);
                return SqlStdOperatorTable.OVERLAY.createCall(s.end(this), args);
            }
            case 216: {
                this.jj_consume_token(216);
                Span s = this.span();
                SqlNode e = this.FloorCeilOptions(s, true);
                return e;
            }
            case 60: 
            case 61: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 60: {
                        this.jj_consume_token(60);
                        break;
                    }
                    case 61: {
                        this.jj_consume_token(61);
                        break;
                    }
                    default: {
                        this.jj_la1[348] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Span s = this.span();
                SqlNode e = this.FloorCeilOptions(s, false);
                return e;
            }
            case 611: {
                this.jj_consume_token(611);
                Span s = this.span();
                this.jj_consume_token(733);
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 227: {
                        this.jj_consume_token(227);
                        break;
                    }
                    case 745: {
                        this.jj_consume_token(745);
                        break;
                    }
                    default: {
                        this.jj_la1[349] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 218: 
                    case 745: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 218: {
                                this.jj_consume_token(218);
                                break;
                            }
                            case 745: {
                                this.jj_consume_token(745);
                                break;
                            }
                            default: {
                                this.jj_la1[350] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    default: {
                        this.jj_la1[351] = this.jj_gen;
                    }
                }
                this.jj_consume_token(734);
                return SqlStdOperatorTable.SUBSTRING.createCall(s.end(this), args);
            }
            case 655: {
                SqlNode e;
                this.jj_consume_token(655);
                SqlLiteral flag = null;
                SqlNode trimChars = null;
                SqlParserPos fromPos = SqlParserPos.ZERO;
                Span s = this.span();
                this.jj_consume_token(733);
                block95 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: 
                    case 306: 
                    case 640: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 47: {
                                this.jj_consume_token(47);
                                s.add(this);
                                flag = SqlTrimFunction.Flag.BOTH.symbol(this.getPos());
                                break;
                            }
                            case 640: {
                                this.jj_consume_token(640);
                                s.add(this);
                                flag = SqlTrimFunction.Flag.TRAILING.symbol(this.getPos());
                                break;
                            }
                            case 306: {
                                this.jj_consume_token(306);
                                s.add(this);
                                flag = SqlTrimFunction.Flag.LEADING.symbol(this.getPos());
                                break;
                            }
                            default: {
                                this.jj_la1[352] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 14: 
                            case 17: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 32: 
                            case 33: 
                            case 35: 
                            case 36: 
                            case 40: 
                            case 48: 
                            case 50: 
                            case 53: 
                            case 54: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 74: 
                            case 75: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 91: 
                            case 93: 
                            case 94: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: 
                            case 124: 
                            case 125: 
                            case 126: 
                            case 128: 
                            case 129: 
                            case 130: 
                            case 132: 
                            case 133: 
                            case 134: 
                            case 135: 
                            case 136: 
                            case 137: 
                            case 138: 
                            case 139: 
                            case 140: 
                            case 141: 
                            case 143: 
                            case 144: 
                            case 145: 
                            case 148: 
                            case 149: 
                            case 152: 
                            case 153: 
                            case 154: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 160: 
                            case 161: 
                            case 163: 
                            case 164: 
                            case 166: 
                            case 167: 
                            case 169: 
                            case 172: 
                            case 174: 
                            case 175: 
                            case 177: 
                            case 178: 
                            case 181: 
                            case 182: 
                            case 184: 
                            case 187: 
                            case 192: 
                            case 194: 
                            case 196: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 203: 
                            case 204: 
                            case 208: 
                            case 209: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 219: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 230: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 237: 
                            case 238: 
                            case 240: 
                            case 242: 
                            case 243: 
                            case 246: 
                            case 248: 
                            case 249: 
                            case 250: 
                            case 252: 
                            case 253: 
                            case 254: 
                            case 255: 
                            case 256: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 264: 
                            case 267: 
                            case 270: 
                            case 271: 
                            case 275: 
                            case 276: 
                            case 278: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 285: 
                            case 286: 
                            case 287: 
                            case 288: 
                            case 289: 
                            case 290: 
                            case 291: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 302: 
                            case 303: 
                            case 305: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 314: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 320: 
                            case 321: 
                            case 323: 
                            case 326: 
                            case 328: 
                            case 329: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 338: 
                            case 339: 
                            case 340: 
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 361: 
                            case 362: 
                            case 363: 
                            case 367: 
                            case 368: 
                            case 369: 
                            case 370: 
                            case 371: 
                            case 372: 
                            case 373: 
                            case 374: 
                            case 375: 
                            case 377: 
                            case 379: 
                            case 380: 
                            case 389: 
                            case 390: 
                            case 393: 
                            case 395: 
                            case 396: 
                            case 399: 
                            case 402: 
                            case 403: 
                            case 404: 
                            case 406: 
                            case 407: 
                            case 408: 
                            case 409: 
                            case 410: 
                            case 411: 
                            case 412: 
                            case 414: 
                            case 415: 
                            case 416: 
                            case 417: 
                            case 418: 
                            case 422: 
                            case 423: 
                            case 424: 
                            case 425: 
                            case 427: 
                            case 428: 
                            case 429: 
                            case 430: 
                            case 432: 
                            case 434: 
                            case 436: 
                            case 439: 
                            case 440: 
                            case 442: 
                            case 443: 
                            case 445: 
                            case 447: 
                            case 448: 
                            case 450: 
                            case 451: 
                            case 460: 
                            case 464: 
                            case 466: 
                            case 467: 
                            case 469: 
                            case 470: 
                            case 472: 
                            case 473: 
                            case 474: 
                            case 477: 
                            case 478: 
                            case 479: 
                            case 480: 
                            case 481: 
                            case 484: 
                            case 485: 
                            case 486: 
                            case 489: 
                            case 490: 
                            case 491: 
                            case 492: 
                            case 493: 
                            case 494: 
                            case 495: 
                            case 497: 
                            case 498: 
                            case 503: 
                            case 504: 
                            case 505: 
                            case 506: 
                            case 508: 
                            case 509: 
                            case 510: 
                            case 513: 
                            case 514: 
                            case 515: 
                            case 516: 
                            case 519: 
                            case 521: 
                            case 522: 
                            case 523: 
                            case 524: 
                            case 525: 
                            case 526: 
                            case 527: 
                            case 529: 
                            case 533: 
                            case 534: 
                            case 537: 
                            case 538: 
                            case 539: 
                            case 540: 
                            case 541: 
                            case 547: 
                            case 548: 
                            case 549: 
                            case 550: 
                            case 551: 
                            case 552: 
                            case 553: 
                            case 554: 
                            case 555: 
                            case 556: 
                            case 557: 
                            case 558: 
                            case 559: 
                            case 560: 
                            case 561: 
                            case 562: 
                            case 563: 
                            case 564: 
                            case 565: 
                            case 566: 
                            case 567: 
                            case 568: 
                            case 569: 
                            case 570: 
                            case 571: 
                            case 572: 
                            case 573: 
                            case 574: 
                            case 575: 
                            case 576: 
                            case 577: 
                            case 578: 
                            case 579: 
                            case 580: 
                            case 581: 
                            case 582: 
                            case 583: 
                            case 584: 
                            case 585: 
                            case 586: 
                            case 587: 
                            case 588: 
                            case 589: 
                            case 590: 
                            case 591: 
                            case 592: 
                            case 593: 
                            case 594: 
                            case 595: 
                            case 596: 
                            case 598: 
                            case 599: 
                            case 601: 
                            case 602: 
                            case 604: 
                            case 605: 
                            case 606: 
                            case 607: 
                            case 610: 
                            case 611: 
                            case 614: 
                            case 619: 
                            case 621: 
                            case 623: 
                            case 626: 
                            case 627: 
                            case 628: 
                            case 629: 
                            case 630: 
                            case 631: 
                            case 632: 
                            case 633: 
                            case 634: 
                            case 639: 
                            case 641: 
                            case 642: 
                            case 643: 
                            case 644: 
                            case 645: 
                            case 646: 
                            case 647: 
                            case 652: 
                            case 653: 
                            case 654: 
                            case 655: 
                            case 657: 
                            case 658: 
                            case 659: 
                            case 661: 
                            case 662: 
                            case 664: 
                            case 665: 
                            case 666: 
                            case 667: 
                            case 669: 
                            case 670: 
                            case 671: 
                            case 672: 
                            case 675: 
                            case 677: 
                            case 678: 
                            case 679: 
                            case 680: 
                            case 681: 
                            case 682: 
                            case 684: 
                            case 685: 
                            case 686: 
                            case 687: 
                            case 691: 
                            case 692: 
                            case 697: 
                            case 699: 
                            case 701: 
                            case 702: 
                            case 711: 
                            case 712: 
                            case 713: 
                            case 714: 
                            case 715: 
                            case 716: 
                            case 717: 
                            case 718: 
                            case 719: 
                            case 720: 
                            case 724: 
                            case 725: 
                            case 726: 
                            case 727: 
                            case 728: 
                            case 730: 
                            case 731: 
                            case 733: 
                            case 735: 
                            case 736: 
                            case 737: 
                            case 738: 
                            case 749: 
                            case 755: 
                            case 756: 
                            case 782: 
                            case 783: 
                            case 784: 
                            case 785: 
                            case 786: 
                            case 787: 
                            case 789: {
                                trimChars = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                break;
                            }
                            default: {
                                this.jj_la1[353] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(227);
                        fromPos = this.getPos();
                        e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 203: 
                    case 204: 
                    case 208: 
                    case 209: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 276: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 286: 
                    case 287: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 326: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 352: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 432: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 440: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 493: 
                    case 494: 
                    case 495: 
                    case 497: 
                    case 498: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 540: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    case 602: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 611: 
                    case 614: 
                    case 619: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 627: 
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 647: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 655: 
                    case 657: 
                    case 658: 
                    case 659: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 675: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 687: 
                    case 691: 
                    case 692: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 715: 
                    case 716: 
                    case 717: 
                    case 718: 
                    case 719: 
                    case 720: 
                    case 724: 
                    case 725: 
                    case 726: 
                    case 727: 
                    case 728: 
                    case 730: 
                    case 731: 
                    case 733: 
                    case 735: 
                    case 736: 
                    case 737: 
                    case 738: 
                    case 749: 
                    case 755: 
                    case 756: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 227: {
                                this.jj_consume_token(227);
                                trimChars = e;
                                fromPos = this.getPos();
                                e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                                break block95;
                            }
                        }
                        this.jj_la1[354] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[355] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(734);
                if (flag == null) {
                    flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                }
                args.add(flag);
                args.add(trimChars);
                args.add(e);
                return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);
            }
            case 105: {
                SqlCall node = this.ContainsSubstrFunctionCall();
                return node;
            }
            case 134: 
            case 137: 
            case 627: 
            case 630: {
                SqlNode node = this.DateTimeConstructorCall();
                return node;
            }
            case 135: {
                SqlCall node = this.DateDiffFunctionCall();
                return node;
            }
            case 136: {
                SqlCall node = this.DateTruncFunctionCall();
                return node;
            }
            case 141: {
                SqlNode node = this.DatetimeTruncFunctionCall();
                return node;
            }
            case 631: {
                SqlCall node = this.TimestampAddFunctionCall();
                return node;
            }
            case 138: {
                SqlCall node = this.DatetimeDiffFunctionCall();
                return node;
            }
            case 632: {
                SqlCall node = this.TimestampDiffFunctionCall();
                return node;
            }
            case 633: {
                SqlCall node = this.TimestampDiff3FunctionCall();
                return node;
            }
            case 634: {
                SqlCall node = this.TimestampTruncFunctionCall();
                return node;
            }
            case 628: {
                SqlCall node = this.TimeDiffFunctionCall();
                return node;
            }
            case 629: {
                SqlCall node = this.TimeTruncFunctionCall();
                return node;
            }
            case 74: 
            case 212: 
            case 213: 
            case 302: 
            case 326: 
            case 363: 
            case 440: 
            case 497: {
                SqlCall node = this.MatchRecognizeFunctionCall();
                return node;
            }
            case 288: {
                SqlCall node = this.JsonExistsFunctionCall();
                return node;
            }
            case 293: {
                SqlCall node = this.JsonValueFunctionCall();
                return node;
            }
            case 291: {
                SqlCall node = this.JsonQueryFunctionCall();
                return node;
            }
            case 289: {
                SqlCall node = this.JsonObjectFunctionCall();
                return node;
            }
            case 290: {
                SqlCall node = this.JsonObjectAggFunctionCall();
                return node;
            }
            case 286: {
                SqlCall node = this.JsonArrayFunctionCall();
                return node;
            }
            case 287: {
                SqlCall node = this.JsonArrayAggFunctionCall();
                return node;
            }
            case 248: 
            case 526: 
            case 661: {
                SqlCall node = this.GroupByWindowingCall();
                return node;
            }
        }
        this.jj_la1[356] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlJsonEncoding JsonRepresentation() throws ParseException {
        this.jj_consume_token(285);
        if (this.jj_2_91(2)) {
            this.jj_consume_token(187);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 684: {
                    this.jj_consume_token(684);
                    return SqlJsonEncoding.UTF8;
                }
                case 685: {
                    this.jj_consume_token(685);
                    return SqlJsonEncoding.UTF16;
                }
                case 686: {
                    this.jj_consume_token(686);
                    return SqlJsonEncoding.UTF32;
                }
            }
            this.jj_la1[357] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return SqlJsonEncoding.UTF8;
    }

    public final void JsonInputClause() throws ParseException {
        this.jj_consume_token(219);
        this.JsonRepresentation();
    }

    public final SqlDataTypeSpec JsonReturningClause() throws ParseException {
        this.jj_consume_token(481);
        SqlDataTypeSpec dt = this.DataType();
        return dt;
    }

    public final SqlDataTypeSpec JsonOutputClause() throws ParseException {
        SqlDataTypeSpec dataType = this.JsonReturningClause();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 219: {
                this.jj_consume_token(219);
                this.JsonRepresentation();
                break;
            }
            default: {
                this.jj_la1[358] = this.jj_gen;
            }
        }
        return dataType;
    }

    public final SqlNode JsonPathSpec() throws ParseException {
        SqlNode e = this.StringLiteral();
        return e;
    }

    public final List<SqlNode> JsonApiCommonSyntax() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 415: {
                this.jj_consume_token(415);
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                this.jj_consume_token(23);
                e = this.SimpleIdentifier();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 745: {
                            break;
                        }
                        default: {
                            this.jj_la1[359] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(745);
                    e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                    this.jj_consume_token(23);
                    e = this.SimpleIdentifier();
                }
            }
            default: {
                this.jj_la1[360] = this.jj_gen;
            }
        }
        return args;
    }

    public final SqlJsonExistsErrorBehavior JsonExistsErrorBehavior() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 657: {
                this.jj_consume_token(657);
                return SqlJsonExistsErrorBehavior.TRUE;
            }
            case 209: {
                this.jj_consume_token(209);
                return SqlJsonExistsErrorBehavior.FALSE;
            }
            case 670: {
                this.jj_consume_token(670);
                return SqlJsonExistsErrorBehavior.UNKNOWN;
            }
            case 194: {
                this.jj_consume_token(194);
                return SqlJsonExistsErrorBehavior.ERROR;
            }
        }
        this.jj_la1[361] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonExistsFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(288);
        Span span = this.span();
        this.jj_consume_token(733);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args.addAll(commonSyntax);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 194: 
            case 209: 
            case 657: 
            case 670: {
                SqlJsonExistsErrorBehavior errorBehavior = this.JsonExistsErrorBehavior();
                args.add(errorBehavior.symbol(this.getPos()));
                this.jj_consume_token(385);
                this.jj_consume_token(194);
                break;
            }
            default: {
                this.jj_la1[362] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        return SqlStdOperatorTable.JSON_EXISTS.createCall(span.end(this), args);
    }

    public final List<SqlNode> JsonValueEmptyOrErrorBehavior() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 194: {
                this.jj_consume_token(194);
                list.add(SqlJsonValueEmptyOrErrorBehavior.ERROR.symbol(this.getPos()));
                break;
            }
            case 371: {
                this.jj_consume_token(371);
                list.add(SqlJsonValueEmptyOrErrorBehavior.NULL.symbol(this.getPos()));
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                list.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT.symbol(this.getPos()));
                this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
                break;
            }
            default: {
                this.jj_la1[363] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(385);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 186: {
                this.jj_consume_token(186);
                list.add(SqlJsonEmptyOrError.EMPTY.symbol(this.getPos()));
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                list.add(SqlJsonEmptyOrError.ERROR.symbol(this.getPos()));
                break;
            }
            default: {
                this.jj_la1[364] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return list;
    }

    public final SqlCall JsonValueFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>(7);
        this.jj_consume_token(293);
        Span span = this.span();
        this.jj_consume_token(733);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args.addAll(commonSyntax);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 481: {
                SqlDataTypeSpec e = this.JsonReturningClause();
                args.add(SqlJsonValueReturning.RETURNING.symbol(this.getPos()));
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[365] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 151: 
                case 194: 
                case 371: {
                    break;
                }
                default: {
                    this.jj_la1[366] = this.jj_gen;
                    break block6;
                }
            }
            List<SqlNode> behavior = this.JsonValueEmptyOrErrorBehavior();
            args.addAll(behavior);
        }
        this.jj_consume_token(734);
        return SqlStdOperatorTable.JSON_VALUE.createCall(span.end(this), args);
    }

    public final List<SqlNode> JsonQueryEmptyOrErrorBehavior() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 194: {
                this.jj_consume_token(194);
                list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.ERROR, this.getPos()));
                break;
            }
            case 371: {
                this.jj_consume_token(371);
                list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, this.getPos()));
                break;
            }
            default: {
                this.jj_la1[367] = this.jj_gen;
                if (this.jj_2_92(2)) {
                    this.jj_consume_token(186);
                    this.jj_consume_token(19);
                    list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, this.getPos()));
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 186: {
                        this.jj_consume_token(186);
                        this.jj_consume_token(377);
                        list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, this.getPos()));
                        break block0;
                    }
                }
                this.jj_la1[368] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(385);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 186: {
                this.jj_consume_token(186);
                list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.EMPTY, this.getPos()));
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.ERROR, this.getPos()));
                break;
            }
            default: {
                this.jj_la1[369] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return list;
    }

    public final SqlNode JsonQueryWrapperBehavior() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 710: {
                this.jj_consume_token(710);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[370] = this.jj_gen;
                    }
                }
                return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, this.getPos());
            }
        }
        this.jj_la1[374] = this.jj_gen;
        if (this.jj_2_93(2)) {
            this.jj_consume_token(708);
            this.jj_consume_token(93);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[371] = this.jj_gen;
                }
            }
            return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, this.getPos());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: {
                this.jj_consume_token(708);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 666: {
                        this.jj_consume_token(666);
                        break;
                    }
                    default: {
                        this.jj_la1[372] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    default: {
                        this.jj_la1[373] = this.jj_gen;
                    }
                }
                return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, this.getPos());
            }
        }
        this.jj_la1[375] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonQueryFunctionCall() throws ParseException {
        SqlNode e;
        SqlNode[] args = new SqlNode[6];
        this.jj_consume_token(291);
        Span span = this.span();
        this.jj_consume_token(733);
        List<SqlNode> commonSyntax = this.JsonApiCommonSyntax();
        args[0] = commonSyntax.get(0);
        args[1] = commonSyntax.get(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 481: {
                e = this.JsonReturningClause();
                args[5] = e;
                break;
            }
            default: {
                this.jj_la1[376] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 708: 
            case 710: {
                e = this.JsonQueryWrapperBehavior();
                this.jj_consume_token(712);
                args[2] = e;
                break;
            }
            default: {
                this.jj_la1[377] = this.jj_gen;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 186: 
                case 194: 
                case 371: {
                    break;
                }
                default: {
                    this.jj_la1[378] = this.jj_gen;
                    break block13;
                }
            }
            List<SqlNode> behavior = this.JsonQueryEmptyOrErrorBehavior();
            SqlJsonEmptyOrError symbol = ((SqlLiteral)behavior.get(1)).getValueAs(SqlJsonEmptyOrError.class);
            switch (symbol) {
                case EMPTY: {
                    args[3] = behavior.get(0);
                    break;
                }
                case ERROR: {
                    args[4] = behavior.get(0);
                }
            }
        }
        this.jj_consume_token(734);
        return SqlStdOperatorTable.JSON_QUERY.createCall(span.end(this), args);
    }

    public final SqlNode JsonName() throws ParseException {
        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return e;
    }

    public final List<SqlNode> JsonNameAndValue() throws ParseException {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        boolean kvMode = false;
        if (this.jj_2_94(2)) {
            this.jj_consume_token(295);
            kvMode = true;
        }
        SqlNode e = this.JsonName();
        list.add(e);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 688: {
                this.jj_consume_token(688);
                break;
            }
            case 745: {
                this.jj_consume_token(745);
                if (!kvMode) break;
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalComma());
            }
            case 750: {
                this.jj_consume_token(750);
                if (!kvMode) break;
                throw SqlUtil.newContextException(this.getPos(), Static.RESOURCE.illegalColon());
            }
            default: {
                this.jj_la1[379] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.AddExpression(list, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        return list;
    }

    public final SqlNode JsonConstructorNullClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 371: {
                this.jj_consume_token(371);
                this.jj_consume_token(385);
                this.jj_consume_token(371);
                return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, this.getPos());
            }
            case 3: {
                this.jj_consume_token(3);
                this.jj_consume_token(385);
                this.jj_consume_token(371);
                return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, this.getPos());
            }
        }
        this.jj_la1[380] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall JsonObjectFunctionCall() throws ParseException {
        ArrayList<SqlNode> nvArgs = new ArrayList<SqlNode>();
        SqlNode[] otherArgs = new SqlNode[1];
        this.jj_consume_token(289);
        Span span = this.span();
        this.jj_consume_token(733);
        if (this.jj_2_95(2)) {
            List<SqlNode> list = this.JsonNameAndValue();
            nvArgs.addAll(list);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 745: {
                        break;
                    }
                    default: {
                        this.jj_la1[381] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(745);
                list = this.JsonNameAndValue();
                nvArgs.addAll(list);
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 371: {
                SqlNode e;
                otherArgs[0] = e = this.JsonConstructorNullClause();
                break;
            }
            default: {
                this.jj_la1[382] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(nvArgs);
        return SqlStdOperatorTable.JSON_OBJECT.createCall(span.end(this), args);
    }

    public final SqlCall JsonObjectAggFunctionCall() throws ParseException {
        SqlNode[] args = new SqlNode[2];
        SqlJsonConstructorNullClause nullClause = SqlJsonConstructorNullClause.NULL_ON_NULL;
        this.jj_consume_token(290);
        Span span = this.span();
        this.jj_consume_token(733);
        List<SqlNode> list = this.JsonNameAndValue();
        args[0] = list.get(0);
        args[1] = list.get(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 371: {
                SqlNode e = this.JsonConstructorNullClause();
                nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)e).getValue());
                break;
            }
            default: {
                this.jj_la1[383] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        return SqlStdOperatorTable.JSON_OBJECTAGG.with(nullClause).createCall(span.end(this), args);
    }

    public final SqlCall JsonArrayFunctionCall() throws ParseException {
        ArrayList<SqlNode> elements = new ArrayList<SqlNode>();
        SqlNode[] otherArgs = new SqlNode[1];
        this.jj_consume_token(286);
        Span span = this.span();
        this.jj_consume_token(733);
        if (this.jj_2_96(2)) {
            this.AddExpression(elements, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 745: {
                        break;
                    }
                    default: {
                        this.jj_la1[384] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_consume_token(745);
                this.AddExpression(elements, SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 371: {
                SqlNode e;
                otherArgs[0] = e = this.JsonConstructorNullClause();
                break;
            }
            default: {
                this.jj_la1[385] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(elements);
        return SqlStdOperatorTable.JSON_ARRAY.createCall(span.end(this), args);
    }

    public final SqlNodeList JsonArrayAggOrderByClause() throws ParseException {
        SqlNodeList orderList = this.OrderBy(true);
        return orderList;
    }

    public final SqlCall JsonArrayAggFunctionCall() throws ParseException {
        SqlJsonConstructorNullClause nullClause;
        SqlNodeList orderList;
        SqlNode e;
        this.jj_consume_token(287);
        Span span = this.span();
        this.jj_consume_token(733);
        SqlNode valueExpr = e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_NON_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 392: {
                orderList = this.JsonArrayAggOrderByClause();
                break;
            }
            default: {
                this.jj_la1[386] = this.jj_gen;
                orderList = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 371: {
                e = this.JsonConstructorNullClause();
                nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)e).getValue());
                break;
            }
            default: {
                this.jj_la1[387] = this.jj_gen;
                nullClause = SqlJsonConstructorNullClause.ABSENT_ON_NULL;
            }
        }
        this.jj_consume_token(734);
        SqlCall aggCall = SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr, orderList);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 709: {
                e = this.withinGroup(aggCall);
                if (orderList != null) {
                    throw SqlUtil.newContextException(span.pos().plus(e.getParserPosition()), Static.RESOURCE.ambiguousSortOrderInJsonArrayAggFunc());
                }
                return (SqlCall)e;
            }
        }
        this.jj_la1[388] = this.jj_gen;
        if (orderList == null) {
            return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr);
        }
        return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause).createCall(span.end(this), valueExpr, orderList);
    }

    public final SqlCall ContainsSubstrFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(105);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 734: {
                this.jj_consume_token(734);
                break;
            }
            case 745: {
                this.jj_consume_token(745);
                this.jj_consume_token(292);
                this.jj_consume_token(762);
                SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                args.add(e);
                this.jj_consume_token(734);
                break;
            }
            default: {
                this.jj_la1[389] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return SqlLibraryOperators.CONTAINS_SUBSTR.createCall(s.end(this), args);
    }

    public final SqlCall DateDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(135);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.DATE_DIFF.createCall(s.end(this), args);
    }

    public final SqlCall TimestampAddFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(631);
        Span s = this.span();
        this.jj_consume_token(733);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(s.end(this), args);
    }

    public final SqlCall TimestampDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(632);
        Span s = this.span();
        this.jj_consume_token(733);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(s.end(this), args);
    }

    public final SqlCall TimestampDiff3FunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(633);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.TIMESTAMP_DIFF3.createCall(s.end(this), args);
    }

    public final SqlCall DatetimeDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(138);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.DATETIME_DIFF.createCall(s.end(this), args);
    }

    public final SqlCall DateTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(136);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        if (this.jj_2_97(2)) {
            SqlIntervalQualifier unit = this.TimeUnit();
            args.add(unit);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 125: 
                case 126: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 160: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 184: 
                case 187: 
                case 192: 
                case 194: 
                case 196: 
                case 198: 
                case 199: 
                case 200: 
                case 203: 
                case 204: 
                case 208: 
                case 209: 
                case 212: 
                case 213: 
                case 214: 
                case 216: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 243: 
                case 246: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 275: 
                case 276: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 323: 
                case 326: 
                case 328: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 349: 
                case 350: 
                case 351: 
                case 352: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 362: 
                case 363: 
                case 367: 
                case 368: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 402: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 422: 
                case 423: 
                case 424: 
                case 425: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 432: 
                case 434: 
                case 436: 
                case 439: 
                case 440: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 450: 
                case 451: 
                case 460: 
                case 464: 
                case 466: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 484: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: 
                case 497: 
                case 498: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 527: 
                case 529: 
                case 533: 
                case 534: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 596: 
                case 598: 
                case 599: 
                case 601: 
                case 602: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 611: 
                case 614: 
                case 619: 
                case 621: 
                case 623: 
                case 626: 
                case 627: 
                case 628: 
                case 629: 
                case 630: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 647: 
                case 652: 
                case 653: 
                case 654: 
                case 655: 
                case 657: 
                case 658: 
                case 659: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 669: 
                case 670: 
                case 671: 
                case 672: 
                case 675: 
                case 677: 
                case 678: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 687: 
                case 691: 
                case 692: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 715: 
                case 716: 
                case 717: 
                case 718: 
                case 719: 
                case 720: 
                case 724: 
                case 725: 
                case 726: 
                case 727: 
                case 728: 
                case 730: 
                case 731: 
                case 733: 
                case 735: 
                case 736: 
                case 737: 
                case 738: 
                case 749: 
                case 755: 
                case 756: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    break;
                }
                default: {
                    this.jj_la1[390] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(734);
        return SqlLibraryOperators.DATE_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall TimestampTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(634);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.TIMESTAMP_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall TimeDiffFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(628);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.TIME_DIFF.createCall(s.end(this), args);
    }

    public final SqlNode DatetimeTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(141);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.DATETIME_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall TimeTruncFunctionCall() throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(629);
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(745);
        SqlIntervalQualifier unit = this.TimeUnitOrName();
        args.add(unit);
        this.jj_consume_token(734);
        return SqlLibraryOperators.TIME_TRUNC.createCall(s.end(this), args);
    }

    public final SqlCall GroupByWindowingCall() throws ParseException {
        SqlGroupedWindowFunction op;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 661: {
                this.jj_consume_token(661);
                op = SqlStdOperatorTable.TUMBLE_OLD;
                break;
            }
            case 248: {
                this.jj_consume_token(248);
                op = SqlStdOperatorTable.HOP_OLD;
                break;
            }
            case 526: {
                this.jj_consume_token(526);
                op = SqlStdOperatorTable.SESSION_OLD;
                break;
            }
            default: {
                this.jj_la1[391] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        List<SqlNode> args = this.UnquantifiedFunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        return op.createCall(s.end(this), args);
    }

    public final SqlCall MatchRecognizeFunctionCall() throws ParseException {
        SqlCall func;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                Span s = this.span();
                this.jj_consume_token(733);
                this.jj_consume_token(734);
                func = SqlStdOperatorTable.CLASSIFIER.createCall(s.end(this), new SqlNode[0]);
                break;
            }
            case 326: {
                this.jj_consume_token(326);
                Span s = this.span();
                this.jj_consume_token(733);
                this.jj_consume_token(734);
                func = SqlStdOperatorTable.MATCH_NUMBER.createCall(s.end(this), new SqlNode[0]);
                break;
            }
            default: {
                this.jj_la1[392] = this.jj_gen;
                if (this.jj_2_98(3)) {
                    func = this.MatchRecognizeNavigationLogical();
                    break;
                }
                if (this.jj_2_99(2)) {
                    func = this.MatchRecognizeNavigationPhysical();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 212: 
                    case 497: {
                        func = this.MatchRecognizeCallWithModifier();
                        break block0;
                    }
                }
                this.jj_la1[393] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return func;
    }

    public final SqlCall MatchRecognizeCallWithModifier() throws ParseException {
        SqlPrefixOperator runningOp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 497: {
                this.jj_consume_token(497);
                runningOp = SqlStdOperatorTable.RUNNING;
                break;
            }
            case 212: {
                this.jj_consume_token(212);
                runningOp = SqlStdOperatorTable.FINAL;
                break;
            }
            default: {
                this.jj_la1[394] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        SqlNode func = this.NamedFunctionCall();
        return runningOp.createCall(s.end(func), func);
    }

    public final SqlCall MatchRecognizeNavigationLogical() throws ParseException {
        SqlFunction funcOp;
        SqlPrefixOperator runningOp;
        Span s = Span.of();
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 497: {
                this.jj_consume_token(497);
                runningOp = SqlStdOperatorTable.RUNNING;
                s.add(this);
                break;
            }
            case 212: {
                this.jj_consume_token(212);
                runningOp = SqlStdOperatorTable.FINAL;
                s.add(this);
                break;
            }
            default: {
                this.jj_la1[395] = this.jj_gen;
                runningOp = null;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 213: {
                this.jj_consume_token(213);
                funcOp = SqlStdOperatorTable.FIRST;
                break;
            }
            case 302: {
                this.jj_consume_token(302);
                funcOp = SqlStdOperatorTable.LAST;
                break;
            }
            default: {
                this.jj_la1[396] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        s.add(this);
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 745: {
                this.jj_consume_token(745);
                SqlLiteral e = this.NumericLiteral();
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[397] = this.jj_gen;
                args.add(LITERAL_ZERO);
            }
        }
        this.jj_consume_token(734);
        SqlCall func = funcOp.createCall(s.end(this), args);
        if (runningOp != null) {
            return runningOp.createCall(s.end(this), func);
        }
        return func;
    }

    public final SqlCall MatchRecognizeNavigationPhysical() throws ParseException {
        SqlFunction funcOp;
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 440: {
                this.jj_consume_token(440);
                funcOp = SqlStdOperatorTable.PREV;
                break;
            }
            case 363: {
                this.jj_consume_token(363);
                funcOp = SqlStdOperatorTable.NEXT;
                break;
            }
            default: {
                this.jj_la1[398] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Span s = this.span();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 745: {
                this.jj_consume_token(745);
                SqlLiteral e = this.NumericLiteral();
                args.add(e);
                break;
            }
            default: {
                this.jj_la1[399] = this.jj_gen;
                args.add(LITERAL_ONE);
            }
        }
        this.jj_consume_token(734);
        return funcOp.createCall(s.end(this), args);
    }

    public final SqlCall withinDistinct(SqlNode arg) throws ParseException {
        this.jj_consume_token(709);
        Span s = this.span();
        this.jj_consume_token(173);
        this.jj_consume_token(733);
        SqlNodeList distinctList = this.ExpressionCommaList(s, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.WITHIN_DISTINCT.createCall(s.end(this), arg, distinctList);
    }

    public final SqlCall withinGroup(SqlNode arg) throws ParseException {
        this.jj_consume_token(709);
        Span s = this.span();
        this.jj_consume_token(241);
        this.jj_consume_token(733);
        SqlNodeList orderList = this.OrderBy(true);
        this.jj_consume_token(734);
        return SqlStdOperatorTable.WITHIN_GROUP.createCall(s.end(this), arg, orderList);
    }

    public final Pair<SqlParserPos, SqlOperator> NullTreatment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 252: {
                this.jj_consume_token(252);
                Span span = this.span();
                this.jj_consume_token(374);
                return Pair.of(span.end(this), SqlStdOperatorTable.IGNORE_NULLS);
            }
            case 472: {
                this.jj_consume_token(472);
                Span span = this.span();
                this.jj_consume_token(374);
                return Pair.of(span.end(this), SqlStdOperatorTable.RESPECT_NULLS);
            }
        }
        this.jj_la1[400] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final SqlCall nullTreatment(SqlCall arg) throws ParseException {
        Pair<SqlParserPos, SqlOperator> pair = this.NullTreatment();
        return ((SqlOperator)pair.right).createCall((SqlParserPos)pair.left, arg);
    }

    public final SqlNode NamedFunctionCall() throws ParseException {
        SqlCall call;
        if (this.jj_2_100(2)) {
            call = this.StringAggFunctionCall();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 422: 
                case 423: {
                    call = this.PercentileFunctionCall();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 14: 
                case 17: 
                case 20: 
                case 21: 
                case 25: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 40: 
                case 48: 
                case 50: 
                case 53: 
                case 54: 
                case 58: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 75: 
                case 78: 
                case 79: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 87: 
                case 88: 
                case 89: 
                case 91: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 106: 
                case 110: 
                case 111: 
                case 112: 
                case 116: 
                case 119: 
                case 125: 
                case 126: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 152: 
                case 153: 
                case 154: 
                case 156: 
                case 157: 
                case 158: 
                case 160: 
                case 161: 
                case 163: 
                case 164: 
                case 166: 
                case 167: 
                case 169: 
                case 172: 
                case 174: 
                case 175: 
                case 177: 
                case 178: 
                case 181: 
                case 182: 
                case 184: 
                case 187: 
                case 192: 
                case 194: 
                case 196: 
                case 198: 
                case 199: 
                case 200: 
                case 204: 
                case 212: 
                case 213: 
                case 214: 
                case 216: 
                case 217: 
                case 219: 
                case 221: 
                case 222: 
                case 223: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 243: 
                case 246: 
                case 248: 
                case 249: 
                case 250: 
                case 252: 
                case 253: 
                case 254: 
                case 255: 
                case 256: 
                case 259: 
                case 260: 
                case 261: 
                case 264: 
                case 267: 
                case 270: 
                case 271: 
                case 275: 
                case 278: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 305: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 323: 
                case 328: 
                case 329: 
                case 334: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 349: 
                case 350: 
                case 351: 
                case 353: 
                case 354: 
                case 355: 
                case 356: 
                case 361: 
                case 367: 
                case 369: 
                case 370: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 380: 
                case 389: 
                case 390: 
                case 393: 
                case 395: 
                case 396: 
                case 399: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 418: 
                case 424: 
                case 427: 
                case 428: 
                case 429: 
                case 430: 
                case 434: 
                case 436: 
                case 439: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 448: 
                case 450: 
                case 451: 
                case 460: 
                case 464: 
                case 466: 
                case 467: 
                case 469: 
                case 470: 
                case 472: 
                case 473: 
                case 474: 
                case 477: 
                case 478: 
                case 479: 
                case 480: 
                case 481: 
                case 484: 
                case 485: 
                case 486: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 494: 
                case 495: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 508: 
                case 509: 
                case 510: 
                case 513: 
                case 514: 
                case 515: 
                case 516: 
                case 519: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 529: 
                case 533: 
                case 534: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 547: 
                case 548: 
                case 549: 
                case 550: 
                case 551: 
                case 552: 
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 557: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 562: 
                case 563: 
                case 564: 
                case 565: 
                case 566: 
                case 567: 
                case 568: 
                case 569: 
                case 570: 
                case 571: 
                case 572: 
                case 573: 
                case 574: 
                case 575: 
                case 576: 
                case 577: 
                case 578: 
                case 579: 
                case 580: 
                case 581: 
                case 582: 
                case 583: 
                case 584: 
                case 585: 
                case 586: 
                case 587: 
                case 588: 
                case 589: 
                case 590: 
                case 591: 
                case 592: 
                case 593: 
                case 594: 
                case 595: 
                case 596: 
                case 598: 
                case 599: 
                case 601: 
                case 602: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 610: 
                case 614: 
                case 621: 
                case 623: 
                case 626: 
                case 628: 
                case 629: 
                case 631: 
                case 632: 
                case 633: 
                case 634: 
                case 639: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: 
                case 646: 
                case 652: 
                case 653: 
                case 654: 
                case 658: 
                case 661: 
                case 662: 
                case 664: 
                case 665: 
                case 666: 
                case 667: 
                case 671: 
                case 672: 
                case 675: 
                case 677: 
                case 678: 
                case 679: 
                case 680: 
                case 681: 
                case 682: 
                case 684: 
                case 685: 
                case 686: 
                case 691: 
                case 692: 
                case 697: 
                case 699: 
                case 701: 
                case 702: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 715: 
                case 716: 
                case 717: 
                case 782: 
                case 783: 
                case 784: 
                case 785: 
                case 786: 
                case 787: 
                case 789: {
                    call = this.NamedCall();
                    break;
                }
                default: {
                    this.jj_la1[401] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (this.jj_2_101(2)) {
            call = this.nullTreatment(call);
        }
        if (this.jj_2_102(2)) {
            call = this.withinDistinct(call);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 709: {
                call = this.withinGroup(call);
                break;
            }
            default: {
                this.jj_la1[402] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 211: {
                this.jj_consume_token(211);
                Span filterSpan = this.span();
                this.jj_consume_token(733);
                this.jj_consume_token(705);
                SqlNode filter = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                this.jj_consume_token(734);
                call = SqlStdOperatorTable.FILTER.createCall(filterSpan.end(this), call, filter);
                break;
            }
            default: {
                this.jj_la1[403] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 400: {
                SqlNode over;
                this.jj_consume_token(400);
                Span overSpan = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        over = this.SimpleIdentifier();
                        break;
                    }
                    case 733: {
                        over = this.WindowSpecification();
                        break;
                    }
                    default: {
                        this.jj_la1[404] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                call = SqlStdOperatorTable.OVER.createCall(overSpan.end(over), call, over);
                break;
            }
            default: {
                this.jj_la1[405] = this.jj_gen;
            }
        }
        return call;
    }

    public final SqlCall NamedCall() throws ParseException {
        Object args;
        SqlFunctionCategory funcType;
        SqlLiteral quantifier = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 540: {
                this.jj_consume_token(540);
                funcType = SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION;
                break;
            }
            default: {
                this.jj_la1[406] = this.jj_gen;
                funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
            }
        }
        SqlIdentifier qualifiedName = this.FunctionName();
        Span s = this.span();
        if (this.jj_2_103(2)) {
            this.jj_consume_token(733);
            this.jj_consume_token(758);
            args = ImmutableList.of((Object)SqlIdentifier.star(this.getPos()));
            this.jj_consume_token(734);
        } else if (this.jj_2_104(2)) {
            this.jj_consume_token(733);
            this.jj_consume_token(734);
            args = ImmutableList.of();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 733: {
                    args = this.FunctionParameterList(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                    quantifier = (SqlLiteral)args.get(0);
                    args.remove(0);
                    break;
                }
                default: {
                    this.jj_la1[407] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return this.createCall(qualifiedName, s.end(this), funcType, quantifier, (Iterable<? extends SqlNode>)args);
    }

    public final SqlNode StandardFloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
        ArrayList<SqlNode> args = new ArrayList<SqlNode>();
        this.jj_consume_token(733);
        this.AddExpression(args, SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 638: {
                this.jj_consume_token(638);
                SqlIntervalQualifier unit = this.TimeUnitOrName();
                args.add(unit);
                break;
            }
            default: {
                this.jj_la1[408] = this.jj_gen;
            }
        }
        this.jj_consume_token(734);
        SqlOperator op = SqlStdOperatorTable.floorCeil(floorFlag, this.conformance);
        SqlCall function = op.createCall(s.end(this), args);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 400: {
                SqlNode e;
                this.jj_consume_token(400);
                Span s1 = this.span();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 212: 
                    case 213: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 246: 
                    case 248: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 270: 
                    case 271: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 302: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 318: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 343: 
                    case 344: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 372: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 451: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 598: 
                    case 599: 
                    case 604: 
                    case 605: 
                    case 606: 
                    case 607: 
                    case 610: 
                    case 621: 
                    case 623: 
                    case 626: 
                    case 628: 
                    case 629: 
                    case 631: 
                    case 632: 
                    case 633: 
                    case 634: 
                    case 639: 
                    case 641: 
                    case 642: 
                    case 643: 
                    case 644: 
                    case 645: 
                    case 646: 
                    case 652: 
                    case 653: 
                    case 654: 
                    case 661: 
                    case 662: 
                    case 664: 
                    case 665: 
                    case 666: 
                    case 667: 
                    case 671: 
                    case 672: 
                    case 677: 
                    case 679: 
                    case 680: 
                    case 681: 
                    case 682: 
                    case 684: 
                    case 685: 
                    case 686: 
                    case 697: 
                    case 699: 
                    case 701: 
                    case 702: 
                    case 711: 
                    case 712: 
                    case 713: 
                    case 714: 
                    case 716: 
                    case 717: 
                    case 782: 
                    case 783: 
                    case 784: 
                    case 785: 
                    case 786: 
                    case 787: 
                    case 789: {
                        e = this.SimpleIdentifier();
                        break;
                    }
                    case 733: {
                        e = this.WindowSpecification();
                        break;
                    }
                    default: {
                        this.jj_la1[409] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return SqlStdOperatorTable.OVER.createCall(s1.end(this), function, e);
            }
        }
        this.jj_la1[410] = this.jj_gen;
        return function;
    }

    public final String NonReservedJdbcFunctionName() throws ParseException {
        this.jj_consume_token(611);
        return this.unquotedIdentifier();
    }

    public final SqlIdentifier FunctionName() throws ParseException {
        SqlIdentifier qualifiedName;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 36: 
            case 40: 
            case 48: 
            case 50: 
            case 54: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 157: 
            case 158: 
            case 161: 
            case 163: 
            case 164: 
            case 166: 
            case 167: 
            case 169: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 181: 
            case 182: 
            case 187: 
            case 192: 
            case 194: 
            case 198: 
            case 199: 
            case 200: 
            case 212: 
            case 213: 
            case 217: 
            case 219: 
            case 221: 
            case 222: 
            case 223: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 237: 
            case 238: 
            case 240: 
            case 242: 
            case 246: 
            case 248: 
            case 250: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 259: 
            case 260: 
            case 261: 
            case 264: 
            case 267: 
            case 270: 
            case 271: 
            case 278: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 285: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 302: 
            case 308: 
            case 309: 
            case 310: 
            case 318: 
            case 320: 
            case 321: 
            case 323: 
            case 329: 
            case 334: 
            case 335: 
            case 336: 
            case 338: 
            case 339: 
            case 340: 
            case 343: 
            case 344: 
            case 350: 
            case 351: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 361: 
            case 367: 
            case 372: 
            case 374: 
            case 375: 
            case 377: 
            case 380: 
            case 389: 
            case 390: 
            case 393: 
            case 395: 
            case 396: 
            case 399: 
            case 403: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 418: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 436: 
            case 439: 
            case 442: 
            case 443: 
            case 445: 
            case 447: 
            case 448: 
            case 451: 
            case 467: 
            case 469: 
            case 470: 
            case 472: 
            case 473: 
            case 474: 
            case 477: 
            case 478: 
            case 479: 
            case 480: 
            case 481: 
            case 485: 
            case 486: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 494: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 509: 
            case 510: 
            case 514: 
            case 515: 
            case 516: 
            case 519: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 529: 
            case 533: 
            case 534: 
            case 538: 
            case 539: 
            case 541: 
            case 547: 
            case 548: 
            case 549: 
            case 550: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 562: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 568: 
            case 569: 
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: 
            case 575: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 589: 
            case 590: 
            case 591: 
            case 592: 
            case 593: 
            case 594: 
            case 595: 
            case 598: 
            case 599: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 610: 
            case 621: 
            case 623: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 632: 
            case 633: 
            case 634: 
            case 639: 
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: 
            case 646: 
            case 652: 
            case 653: 
            case 654: 
            case 661: 
            case 662: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 671: 
            case 672: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 684: 
            case 685: 
            case 686: 
            case 697: 
            case 699: 
            case 701: 
            case 702: 
            case 711: 
            case 712: 
            case 713: 
            case 714: 
            case 716: 
            case 717: 
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: 
            case 789: {
                qualifiedName = this.CompoundIdentifier();
                break;
            }
            case 2: 
            case 35: 
            case 53: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 78: 
            case 85: 
            case 110: 
            case 111: 
            case 112: 
            case 116: 
            case 119: 
            case 125: 
            case 126: 
            case 160: 
            case 184: 
            case 196: 
            case 204: 
            case 214: 
            case 216: 
            case 230: 
            case 243: 
            case 249: 
            case 275: 
            case 299: 
            case 303: 
            case 305: 
            case 307: 
            case 314: 
            case 316: 
            case 317: 
            case 319: 
            case 328: 
            case 341: 
            case 342: 
            case 345: 
            case 349: 
            case 369: 
            case 370: 
            case 373: 
            case 379: 
            case 422: 
            case 423: 
            case 424: 
            case 434: 
            case 450: 
            case 460: 
            case 464: 
            case 466: 
            case 484: 
            case 495: 
            case 513: 
            case 537: 
            case 596: 
            case 601: 
            case 602: 
            case 614: 
            case 658: 
            case 675: 
            case 678: 
            case 691: 
            case 692: 
            case 715: {
                qualifiedName = this.ReservedFunctionName();
                break;
            }
            default: {
                this.jj_la1[411] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qualifiedName;
    }

    public final SqlIdentifier ReservedFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 125: {
                this.jj_consume_token(125);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                break;
            }
            case 184: {
                this.jj_consume_token(184);
                break;
            }
            case 196: {
                this.jj_consume_token(196);
                break;
            }
            case 204: {
                this.jj_consume_token(204);
                break;
            }
            case 214: {
                this.jj_consume_token(214);
                break;
            }
            case 216: {
                this.jj_consume_token(216);
                break;
            }
            case 230: {
                this.jj_consume_token(230);
                break;
            }
            case 275: {
                this.jj_consume_token(275);
                break;
            }
            case 243: {
                this.jj_consume_token(243);
                break;
            }
            case 249: {
                this.jj_consume_token(249);
                break;
            }
            case 299: {
                this.jj_consume_token(299);
                break;
            }
            case 305: {
                this.jj_consume_token(305);
                break;
            }
            case 307: {
                this.jj_consume_token(307);
                break;
            }
            case 303: {
                this.jj_consume_token(303);
                break;
            }
            case 314: {
                this.jj_consume_token(314);
                break;
            }
            case 316: {
                this.jj_consume_token(316);
                break;
            }
            case 317: {
                this.jj_consume_token(317);
                break;
            }
            case 319: {
                this.jj_consume_token(319);
                break;
            }
            case 328: {
                this.jj_consume_token(328);
                break;
            }
            case 341: {
                this.jj_consume_token(341);
                break;
            }
            case 342: {
                this.jj_consume_token(342);
                break;
            }
            case 345: {
                this.jj_consume_token(345);
                break;
            }
            case 349: {
                this.jj_consume_token(349);
                break;
            }
            case 369: {
                this.jj_consume_token(369);
                break;
            }
            case 370: {
                this.jj_consume_token(370);
                break;
            }
            case 373: {
                this.jj_consume_token(373);
                break;
            }
            case 379: {
                this.jj_consume_token(379);
                break;
            }
            case 422: {
                this.jj_consume_token(422);
                break;
            }
            case 423: {
                this.jj_consume_token(423);
                break;
            }
            case 424: {
                this.jj_consume_token(424);
                break;
            }
            case 434: {
                this.jj_consume_token(434);
                break;
            }
            case 450: {
                this.jj_consume_token(450);
                break;
            }
            case 460: {
                this.jj_consume_token(460);
                break;
            }
            case 464: {
                this.jj_consume_token(464);
                break;
            }
            case 466: {
                this.jj_consume_token(466);
                break;
            }
            case 484: {
                this.jj_consume_token(484);
                break;
            }
            case 495: {
                this.jj_consume_token(495);
                break;
            }
            case 513: {
                this.jj_consume_token(513);
                break;
            }
            case 537: {
                this.jj_consume_token(537);
                break;
            }
            case 596: {
                this.jj_consume_token(596);
                break;
            }
            case 601: {
                this.jj_consume_token(601);
                break;
            }
            case 602: {
                this.jj_consume_token(602);
                break;
            }
            case 614: {
                this.jj_consume_token(614);
                break;
            }
            case 675: {
                this.jj_consume_token(675);
                break;
            }
            case 658: {
                this.jj_consume_token(658);
                break;
            }
            case 678: {
                this.jj_consume_token(678);
                break;
            }
            case 691: {
                this.jj_consume_token(691);
                break;
            }
            case 692: {
                this.jj_consume_token(692);
                break;
            }
            case 715: {
                this.jj_consume_token(715);
                break;
            }
            default: {
                this.jj_la1[412] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIdentifier(this.unquotedIdentifier(), this.getPos());
    }

    public final SqlIdentifier ContextVariable() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 125: {
                this.jj_consume_token(125);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 316: {
                this.jj_consume_token(316);
                break;
            }
            case 317: {
                this.jj_consume_token(317);
                break;
            }
            case 527: {
                this.jj_consume_token(527);
                break;
            }
            case 619: {
                this.jj_consume_token(619);
                break;
            }
            case 678: {
                this.jj_consume_token(678);
                break;
            }
            default: {
                this.jj_la1[413] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new SqlIdentifier(this.unquotedIdentifier(), this.getPos());
    }

    public final SqlNode JdbcFunctionCall() throws ParseException {
        SqlNodeList args;
        String name;
        this.jj_consume_token(738);
        Span s = this.span();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                SqlCall call = this.ContainsSubstrFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 135: {
                SqlCall call = this.DateDiffFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 138: {
                SqlCall call = this.DatetimeDiffFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 631: {
                SqlCall call = this.TimestampAddFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 136: {
                SqlCall call = this.DateTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 634: {
                SqlCall call = this.TimestampTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 629: {
                SqlCall call = this.TimeTruncFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 633: {
                SqlCall call = this.TimestampDiff3FunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            case 628: {
                SqlCall call = this.TimeDiffFunctionCall();
                name = call.getOperator().getName();
                args = new SqlNodeList(call.getOperandList(), this.getPos());
                break;
            }
            default: {
                this.jj_la1[417] = this.jj_gen;
                if (this.jj_2_107(3)) {
                    SqlCall call = this.TimestampDiffFunctionCall();
                    name = call.getOperator().getName();
                    args = new SqlNodeList(call.getOperandList(), this.getPos());
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 107: {
                        this.jj_consume_token(107);
                        name = this.unquotedIdentifier();
                        this.jj_consume_token(733);
                        SqlNode e = this.Expression(SqlAbstractParserImpl.ExprContext.ACCEPT_SUB_QUERY);
                        args = new SqlNodeList(this.getPos());
                        args.add(e);
                        this.jj_consume_token(745);
                        SqlLiteral tl = this.JdbcOdbcDataType();
                        args.add(tl);
                        this.jj_consume_token(734);
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 20: 
                    case 21: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 48: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 58: 
                    case 59: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 75: 
                    case 78: 
                    case 79: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 105: 
                    case 106: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 116: 
                    case 119: 
                    case 125: 
                    case 126: 
                    case 130: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 160: 
                    case 161: 
                    case 163: 
                    case 164: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 172: 
                    case 174: 
                    case 175: 
                    case 177: 
                    case 178: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 194: 
                    case 196: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 204: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 216: 
                    case 217: 
                    case 219: 
                    case 221: 
                    case 222: 
                    case 223: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 237: 
                    case 238: 
                    case 240: 
                    case 242: 
                    case 243: 
                    case 246: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: 
                    case 256: 
                    case 259: 
                    case 260: 
                    case 261: 
                    case 264: 
                    case 267: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 275: 
                    case 278: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 285: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 314: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 323: 
                    case 328: 
                    case 329: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 338: 
                    case 339: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 345: 
                    case 349: 
                    case 350: 
                    case 351: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 361: 
                    case 367: 
                    case 369: 
                    case 370: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 377: 
                    case 379: 
                    case 380: 
                    case 389: 
                    case 390: 
                    case 393: 
                    case 395: 
                    case 396: 
                    case 399: 
                    case 403: 
                    case 404: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 414: 
                    case 415: 
                    case 416: 
                    case 417: 
                    case 418: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 434: 
                    case 436: 
                    case 439: 
                    case 442: 
                    case 443: 
                    case 445: 
                    case 447: 
                    case 448: 
                    case 450: 
                    case 451: 
                    case 460: 
                    case 464: 
                    case 466: 
                    case 467: 
                    case 469: 
                    case 470: 
                    case 472: 
                    case 473: 
                    case 474: 
                    case 477: 
                    case 478: 
                    case 479: 
                    case 480: 
                    case 481: 
                    case 484: 
                    case 485: 
                    case 486: 
                    case 489: 
                    case 490: 
                    case 491: 
                    case 492: 
                    case 494: 
                    case 495: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 506: 
                    case 508: 
                    case 509: 
                    case 510: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 519: 
                    case 521: 
                    case 522: 
                    case 523: 
                    case 524: 
                    case 525: 
                    case 526: 
                    case 529: 
                    case 533: 
                    case 534: 
                    case 537: 
                    case 538: 
                    case 539: 
                    case 541: 
                    case 547: 
                    case 548: 
                    case 549: 
                    case 550: 
                    case 551: 
                    case 552: 
                    case 553: 
                    case 554: 
                    case 555: 
                    case 556: 
                    case 557: 
                    case 558: 
                    case 559: 
                    case 560: 
                    case 561: 
                    case 562: 
                    case 563: 
                    case 564: 
                    case 565: 
                    case 566: 
                    case 567: 
                    case 568: 
                    case 569: 
                    case 570: 
                    case 571: 
                    case 572: 
                    case 573: 
                    case 574: 
                    case 575: 
                    case 576: 
                    case 577: 
                    case 578: 
                    case 579: 
                    case 580: 
                    case 581: 
                    case 582: 
                    case 583: 
                    case 584: 
                    case 585: 
                    case 586: 
                    case 587: 
                    case 588: 
                    case 589: 
                    case 590: 
                    case 591: 
                    case 592: 
                    case 593: 
                    case 594: 
                    case 595: 
                    case 596: 
                    case 598: 
                    case 599: 
                    case 601: 
                    ca