/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.model.JsonColumn;
import org.apache.calcite.model.JsonCustomSchema;
import org.apache.calcite.model.JsonCustomTable;
import org.apache.calcite.model.JsonFunction;
import org.apache.calcite.model.JsonJdbcSchema;
import org.apache.calcite.model.JsonLattice;
import org.apache.calcite.model.JsonMapSchema;
import org.apache.calcite.model.JsonMaterialization;
import org.apache.calcite.model.JsonMeasure;
import org.apache.calcite.model.JsonRoot;
import org.apache.calcite.model.JsonSchema;
import org.apache.calcite.model.JsonTile;
import org.apache.calcite.model.JsonType;
import org.apache.calcite.model.JsonTypeAttribute;
import org.apache.calcite.model.JsonView;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.calcite.schema.impl.TableMacroImpl;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ModelHandler {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private static final ObjectMapper YAML_MAPPER = new YAMLMapper();
    private final CalciteConnection connection;
    private final Deque<Pair<? extends @Nullable String, SchemaPlus>> schemaStack = new ArrayDeque<Pair<? extends String, SchemaPlus>>();
    private final String modelUri;
    @Nullable Lattice.Builder latticeBuilder;
    @Nullable Lattice.TileBuilder tileBuilder;

    public ModelHandler(CalciteConnection connection, String uri) throws IOException {
        JsonRoot root;
        this.connection = connection;
        this.modelUri = uri;
        if (uri.startsWith("inline:")) {
            String inline = uri.substring("inline:".length()).trim();
            ObjectMapper mapper = inline.startsWith("/*") || inline.startsWith("{") ? JSON_MAPPER : YAML_MAPPER;
            root = (JsonRoot)mapper.readValue(inline, JsonRoot.class);
        } else {
            ObjectMapper mapper = uri.endsWith(".yaml") || uri.endsWith(".yml") ? YAML_MAPPER : JSON_MAPPER;
            root = (JsonRoot)mapper.readValue(new File(uri), JsonRoot.class);
        }
        this.visit(root);
    }

    @Deprecated
    public static void create(SchemaPlus schema, String functionName, List<String> path, String className, String methodName) {
        ModelHandler.addFunctions(schema, functionName, path, className, methodName, false);
    }

    public static void addFunctions(SchemaPlus schema, @Nullable String functionName, List<String> unusedPath, String className, @Nullable String methodName, boolean upCase) {
        AggregateFunctionImpl aggFunction;
        TableFunction tableFunction;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("UDF class '" + className + "' not found");
        }
        String methodNameOrDefault = Util.first(methodName, "eval");
        String actualFunctionName = functionName != null ? functionName : methodNameOrDefault;
        if (upCase) {
            actualFunctionName = actualFunctionName.toUpperCase(Locale.ROOT);
        }
        if ((tableFunction = TableFunctionImpl.create(clazz, methodNameOrDefault)) != null) {
            schema.add(Util.first(functionName, methodNameOrDefault), tableFunction);
            return;
        }
        TableMacro macro = TableMacroImpl.create(clazz);
        if (macro != null) {
            schema.add(actualFunctionName, macro);
            return;
        }
        if (methodName != null && methodName.equals("*")) {
            for (Map.Entry entry : ScalarFunctionImpl.functions(clazz).entries()) {
                String name = (String)entry.getKey();
                if (upCase) {
                    name = name.toUpperCase(Locale.ROOT);
                }
                schema.add(name, (Function)entry.getValue());
            }
            return;
        }
        ScalarFunction function = ScalarFunctionImpl.create(clazz, methodNameOrDefault);
        if (function != null) {
            schema.add(actualFunctionName, function);
            return;
        }
        if (methodName == null && (aggFunction = AggregateFunctionImpl.create(clazz)) != null) {
            schema.add(actualFunctionName, aggFunction);
            return;
        }
        throw new RuntimeException("Not a valid function class: " + clazz + ". Scalar functions and table macros have an 'eval' method; aggregate functions have 'init' and 'add' methods, and optionally 'initAdd', 'merge' and 'result' methods.");
    }

    public void visit(JsonRoot jsonRoot) {
        Pair<@Nullable Object, SchemaPlus> pair = Pair.of(null, this.connection.getRootSchema());
        this.schemaStack.push(pair);
        for (JsonType rootType : jsonRoot.types) {
            rootType.accept(this);
        }
        for (JsonSchema schema : jsonRoot.schemas) {
            schema.accept(this);
        }
        Pair<? extends @Nullable String, SchemaPlus> p = this.schemaStack.pop();
        assert (p == pair);
        if (jsonRoot.defaultSchema != null) {
            try {
                this.connection.setSchema(jsonRoot.defaultSchema);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void visit(JsonMapSchema jsonSchema) {
        SchemaPlus parentSchema = this.currentMutableSchema("schema");
        SchemaPlus schema = parentSchema.add(jsonSchema.name, new AbstractSchema());
        if (jsonSchema.path != null) {
            schema.setPath(ModelHandler.stringListList(jsonSchema.path));
        }
        this.populateSchema(jsonSchema, schema);
    }

    private static ImmutableList<ImmutableList<String>> stringListList(List path) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object s : path) {
            builder.add(ModelHandler.stringList(s));
        }
        return builder.build();
    }

    private static ImmutableList<String> stringList(Object s) {
        if (s instanceof String) {
            return ImmutableList.of((Object)((String)s));
        }
        if (s instanceof List) {
            ImmutableList.Builder builder2 = ImmutableList.builder();
            for (Object o : (List)s) {
                if (o instanceof String) {
                    builder2.add((Object)((String)o));
                    continue;
                }
                throw new RuntimeException("Invalid path element " + o + "; was expecting string");
            }
            return builder2.build();
        }
        throw new RuntimeException("Invalid path element " + s + "; was expecting string or list of string");
    }

    private void populateSchema(JsonSchema jsonSchema, SchemaPlus schema) {
        if (jsonSchema.cache != null) {
            schema.setCacheEnabled(jsonSchema.cache);
        }
        Pair<String, SchemaPlus> pair = Pair.of(jsonSchema.name, schema);
        this.schemaStack.push(pair);
        jsonSchema.visitChildren(this);
        Pair<? extends @Nullable String, SchemaPlus> p = this.schemaStack.pop();
        assert (p == pair);
    }

    public void visit(JsonCustomSchema jsonSchema) {
        try {
            SchemaPlus parentSchema = this.currentMutableSchema("sub-schema");
            SchemaFactory schemaFactory = (SchemaFactory)AvaticaUtils.instantiatePlugin(SchemaFactory.class, (String)jsonSchema.factory);
            Schema schema = schemaFactory.create(parentSchema, jsonSchema.name, this.operandMap(jsonSchema, jsonSchema.operand));
            SchemaPlus schemaPlus = parentSchema.add(jsonSchema.name, schema);
            this.populateSchema(jsonSchema, schemaPlus);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonSchema, e);
        }
    }

    protected Map<String, Object> operandMap(@Nullable JsonSchema jsonSchema, @Nullable Map<String, Object> operand) {
        if (operand == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(operand);
        block5: for (ExtraOperand extraOperand : ExtraOperand.values()) {
            if (operand.containsKey(extraOperand.camelName)) continue;
            switch (extraOperand) {
                case MODEL_URI: {
                    builder.put((Object)extraOperand.camelName, (Object)this.modelUri);
                    continue block5;
                }
                case BASE_DIRECTORY: {
                    File f = null;
                    if (!this.modelUri.startsWith("inline:")) {
                        File file = new File(this.modelUri);
                        f = file.getParentFile();
                    }
                    if (f == null) {
                        f = new File("");
                    }
                    builder.put((Object)extraOperand.camelName, (Object)f);
                    continue block5;
                }
                case TABLES: {
                    if (!(jsonSchema instanceof JsonCustomSchema)) continue block5;
                    builder.put((Object)extraOperand.camelName, (Object)((JsonCustomSchema)jsonSchema).tables);
                    continue block5;
                }
            }
        }
        return builder.build();
    }

    public void visit(JsonJdbcSchema jsonSchema) {
        JdbcSchema schema;
        SchemaPlus parentSchema = this.currentMutableSchema("jdbc schema");
        DataSource dataSource = JdbcSchema.dataSource(jsonSchema.jdbcUrl, jsonSchema.jdbcDriver, jsonSchema.jdbcUser, jsonSchema.jdbcPassword);
        if (jsonSchema.sqlDialectFactory == null || jsonSchema.sqlDialectFactory.isEmpty()) {
            schema = JdbcSchema.create(parentSchema, jsonSchema.name, dataSource, jsonSchema.jdbcCatalog, jsonSchema.jdbcSchema);
        } else {
            SqlDialectFactory factory = (SqlDialectFactory)AvaticaUtils.instantiatePlugin(SqlDialectFactory.class, (String)jsonSchema.sqlDialectFactory);
            schema = JdbcSchema.create(parentSchema, jsonSchema.name, dataSource, factory, jsonSchema.jdbcCatalog, jsonSchema.jdbcSchema);
        }
        SchemaPlus schemaPlus = parentSchema.add(jsonSchema.name, schema);
        this.populateSchema(jsonSchema, schemaPlus);
    }

    public void visit(JsonMaterialization jsonMaterialization) {
        try {
            boolean existing;
            String viewName;
            SchemaPlus schema = this.currentSchema();
            if (!schema.isMutable()) {
                throw new RuntimeException("Cannot define materialization; parent schema '" + this.currentSchemaName() + "' is not a SemiMutableSchema");
            }
            CalciteSchema calciteSchema = CalciteSchema.from(schema);
            if (jsonMaterialization.view == null) {
                viewName = "$" + schema.tables().getNames(LikePattern.any()).size();
                existing = true;
            } else {
                viewName = jsonMaterialization.view;
                existing = false;
            }
            List<String> viewPath = calciteSchema.path(viewName);
            schema.add(viewName, MaterializedViewTable.create(calciteSchema, jsonMaterialization.getSql(), jsonMaterialization.viewSchemaPath, viewPath, jsonMaterialization.table, existing));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonMaterialization, e);
        }
    }

    public void visit(JsonLattice jsonLattice) {
        try {
            SchemaPlus schema = this.currentSchema();
            if (!schema.isMutable()) {
                throw new RuntimeException("Cannot define lattice; parent schema '" + this.currentSchemaName() + "' is not a SemiMutableSchema");
            }
            CalciteSchema calciteSchema = CalciteSchema.from(schema);
            Lattice.Builder latticeBuilder = Lattice.builder(calciteSchema, jsonLattice.getSql()).auto(jsonLattice.auto).algorithm(jsonLattice.algorithm);
            if (jsonLattice.rowCountEstimate != null) {
                latticeBuilder.rowCountEstimate(jsonLattice.rowCountEstimate);
            }
            if (jsonLattice.statisticProvider != null) {
                latticeBuilder.statisticProvider(jsonLattice.statisticProvider);
            }
            this.populateLattice(jsonLattice, latticeBuilder);
            schema.add(jsonLattice.name, latticeBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonLattice, e);
        }
    }

    private void populateLattice(JsonLattice jsonLattice, Lattice.Builder latticeBuilder) {
        assert (this.latticeBuilder == null);
        this.latticeBuilder = latticeBuilder;
        jsonLattice.visitChildren(this);
        this.latticeBuilder = null;
    }

    public void visit(JsonCustomTable jsonTable) {
        try {
            SchemaPlus schema = this.currentMutableSchema("table");
            TableFactory tableFactory = (TableFactory)AvaticaUtils.instantiatePlugin(TableFactory.class, (String)jsonTable.factory);
            Object table = tableFactory.create(schema, jsonTable.name, this.operandMap(null, jsonTable.operand), null);
            for (JsonColumn column : jsonTable.columns) {
                column.accept(this);
            }
            schema.add(jsonTable.name, (Table)table);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonTable, e);
        }
    }

    public void visit(JsonColumn jsonColumn) {
    }

    public void visit(JsonView jsonView) {
        try {
            SchemaPlus schema = this.currentMutableSchema("view");
            List<String> path = Util.first(jsonView.path, this.currentSchemaPath());
            ImmutableList viewPath = ImmutableList.builder().addAll(path).add((Object)jsonView.name).build();
            schema.add(jsonView.name, ViewTable.viewMacro(schema, jsonView.getSql(), path, (List<String>)viewPath, jsonView.modifiable));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonView, e);
        }
    }

    private List<String> currentSchemaPath() {
        return Collections.singletonList(this.currentSchemaName());
    }

    private Pair<? extends @Nullable String, SchemaPlus> nameAndSchema() {
        return this.schemaStack.getFirst();
    }

    private SchemaPlus currentSchema() {
        return (SchemaPlus)this.nameAndSchema().right;
    }

    private String currentSchemaName() {
        return (String)Objects.requireNonNull(this.nameAndSchema().left, "currentSchema.name");
    }

    private SchemaPlus currentMutableSchema(String elementType) {
        SchemaPlus schema = this.currentSchema();
        if (!schema.isMutable()) {
            throw new RuntimeException("Cannot define " + elementType + "; parent schema '" + schema.getName() + "' is not mutable");
        }
        return schema;
    }

    public void visit(JsonType jsonType) {
        try {
            SchemaPlus schema = this.currentMutableSchema("type");
            schema.add(jsonType.name, typeFactory -> {
                if (jsonType.type != null) {
                    return typeFactory.createSqlType(Objects.requireNonNull(SqlTypeName.get(jsonType.type), () -> "SqlTypeName.get for " + jsonType.type));
                }
                RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
                for (JsonTypeAttribute jsonTypeAttribute : jsonType.attributes) {
                    SqlTypeName typeName = Objects.requireNonNull(SqlTypeName.get(jsonTypeAttribute.type), () -> "SqlTypeName.get for " + jsonTypeAttribute.type);
                    RelDataType type = typeFactory.createSqlType(typeName);
                    if (type == null) {
                        type = (RelDataType)Objects.requireNonNull(this.currentSchema().getType(jsonTypeAttribute.type), () -> "type " + jsonTypeAttribute.type + " is not found in schema " + this.currentSchemaName()).apply(typeFactory);
                    }
                    ((RelDataTypeFactory.Builder)builder).add(jsonTypeAttribute.name, type);
                }
                return builder.build();
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonType, e);
        }
    }

    public void visit(JsonFunction jsonFunction) {
        try {
            SchemaPlus schema = this.currentMutableSchema("function");
            List<String> path = Util.first(jsonFunction.path, this.currentSchemaPath());
            ModelHandler.addFunctions(schema, jsonFunction.name, path, jsonFunction.className, jsonFunction.methodName, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonFunction, e);
        }
    }

    public void visit(JsonMeasure jsonMeasure) {
        Objects.requireNonNull(this.latticeBuilder, "latticeBuilder");
        boolean distinct = false;
        Lattice.Measure measure = this.latticeBuilder.resolveMeasure(jsonMeasure.agg, false, jsonMeasure.args);
        if (this.tileBuilder != null) {
            this.tileBuilder.addMeasure(measure);
        } else if (this.latticeBuilder != null) {
            this.latticeBuilder.addMeasure(measure);
        } else {
            throw new AssertionError((Object)"nowhere to put measure");
        }
    }

    public void visit(JsonTile jsonTile) {
        assert (this.tileBuilder == null);
        Lattice.TileBuilder tileBuilder = this.tileBuilder = Lattice.Tile.builder();
        for (JsonMeasure jsonMeasure : jsonTile.measures) {
            jsonMeasure.accept(this);
        }
        Lattice.Builder latticeBuilder = Objects.requireNonNull(this.latticeBuilder, "latticeBuilder");
        for (Object dimension : jsonTile.dimensions) {
            Lattice.Column column = latticeBuilder.resolveColumn(dimension);
            tileBuilder.addDimension(column);
        }
        latticeBuilder.addTile(tileBuilder.build());
        this.tileBuilder = null;
    }

    public static enum ExtraOperand {
        MODEL_URI("modelUri"),
        BASE_DIRECTORY("baseDirectory"),
        TABLES("tables");

        public final String camelName;

        private ExtraOperand(String camelName) {
            this.camelName = camelName;
        }
    }
}

