/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dflib.ByteSource;

class ZipStreamSeekByteSource
implements ByteSource {
    private final ByteSource zipSource;
    private final String zipEntryName;

    public ZipStreamSeekByteSource(ByteSource zipSource, String zipEntryName) {
        this.zipEntryName = Objects.requireNonNull(zipEntryName);
        this.zipSource = Objects.requireNonNull(zipSource);
    }

    @Override
    public Optional<String> uri() {
        return Optional.of(this.zipEntryName);
    }

    @Override
    public InputStream stream() {
        ZipInputStream in = new ZipInputStream(this.zipSource.stream());
        try {
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if (!this.zipEntryName.equals(entry.getName())) continue;
                if (entry.isDirectory()) {
                    throw new IllegalArgumentException("Zip entry is a directory and can not be used in a ByteSource: " + this.zipEntryName);
                }
                return in;
            }
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Error reading ZIP stream", e);
        }
        throw new RuntimeException("Entry is not present in the ZIP: " + this.zipEntryName);
    }
}

