/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dflib.ByteSource;

class ZipStreamByteSource
implements ByteSource {
    private final InputStream in;
    private final AtomicBoolean streamUsed;
    private final String uri;

    public ZipStreamByteSource(InputStream in, String uri) {
        this.in = Objects.requireNonNull(in);
        this.uri = uri;
        this.streamUsed = new AtomicBoolean(false);
    }

    @Override
    public Optional<String> uri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    public InputStream stream() {
        if (this.streamUsed.compareAndExchange(false, true)) {
            throw new IllegalStateException("Stream was already consumed. This ByteSource works over an already open stream and can not be reused");
        }
        return new UnclosableStream(this.in);
    }

    static class UnclosableStream
    extends InputStream {
        private final InputStream delegate;

        public UnclosableStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }
    }
}

