/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.dflib.ByteSource;
import org.dflib.ByteSources;
import org.dflib.zip.ZipFileByteSource;
import org.dflib.zip.ZipStreamByteSources;
import org.dflib.zip.ZipStreamSeekByteSource;

public abstract class Zip {
    public static Zip of(String fileName) {
        return Zip.of(new File(fileName));
    }

    public static Zip of(Path path) {
        return Zip.of(path.toFile());
    }

    public static Zip of(File file) {
        try {
            return new RandomAccessZip(new ZipFile(file));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening ZIP file: " + String.valueOf(file), e);
        }
    }

    public static Zip of(ByteSource parentSource) {
        return new SequentialZip(parentSource);
    }

    public abstract List<ZipEntry> list();

    public abstract ByteSource source(String var1);

    public abstract ByteSources sources();

    static class RandomAccessZip
    extends Zip {
        private final ZipFile zipFile;
        private volatile Map<String, ZipEntry> sources;

        public RandomAccessZip(ZipFile zipFile) {
            this.zipFile = Objects.requireNonNull(zipFile);
        }

        @Override
        public List<ZipEntry> list() {
            return this.getOrCreateSources().values().stream().collect(Collectors.toList());
        }

        @Override
        public ByteSource source(String zipPath) {
            ZipEntry entry = this.getOrCreateSources().get(zipPath);
            if (entry == null) {
                throw new IllegalArgumentException("Entry is not present in the ZIP: " + zipPath);
            }
            if (entry.isDirectory()) {
                throw new IllegalArgumentException("Zip entry is a directory and can not be used to create a ByteSource: " + zipPath);
            }
            return new ZipFileByteSource(this.zipFile, entry);
        }

        @Override
        public ByteSources sources() {
            HashMap sources = new HashMap();
            this.getOrCreateSources().entrySet().stream().filter(e -> !((ZipEntry)e.getValue()).isDirectory()).forEach(e -> sources.put((String)e.getKey(), new ZipFileByteSource(this.zipFile, (ZipEntry)e.getValue())));
            return ByteSources.of(sources);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, ZipEntry> getOrCreateSources() {
            if (this.sources == null) {
                RandomAccessZip randomAccessZip = this;
                synchronized (randomAccessZip) {
                    if (this.sources == null) {
                        HashMap<String, ZipEntry> index = new HashMap<String, ZipEntry>();
                        this.zipFile.stream().forEach(e -> index.put(e.getName(), (ZipEntry)e));
                        this.sources = index;
                    }
                }
            }
            return this.sources;
        }
    }

    static class SequentialZip
    extends Zip {
        private final ByteSource source;
        private volatile List<ZipEntry> index;

        public SequentialZip(ByteSource source) {
            this.source = source;
        }

        @Override
        public List<ZipEntry> list() {
            return this.getOrCreateIndex();
        }

        @Override
        public ByteSource source(String zipPath) {
            if (zipPath.endsWith("/")) {
                throw new IllegalArgumentException("Zip entry is a directory and can not be used to create a ByteSource: " + zipPath);
            }
            return new ZipStreamSeekByteSource(this.source, zipPath);
        }

        @Override
        public ByteSources sources() {
            return new ZipStreamByteSources(this.source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ZipEntry> getOrCreateIndex() {
            if (this.index == null) {
                SequentialZip sequentialZip = this;
                synchronized (sequentialZip) {
                    if (this.index == null) {
                        this.index = this.source.processStream(this::extractIndex);
                    }
                }
            }
            return this.index;
        }

        private List<ZipEntry> extractIndex(InputStream in) {
            ZipInputStream zin = new ZipInputStream(in);
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            try {
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    entries.add(entry);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading zip entries", e);
            }
            return entries;
        }
    }
}

