/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.window;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dflib.DataFrame;
import org.dflib.Environment;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;
import org.dflib.window.WindowRange;

abstract class WindowColumnEvaluator {
    protected final DataFrame source;

    public static WindowColumnEvaluator of(DataFrame df, WindowRange range) {
        return range.alwaysInRange(df.height()) ? new NoRangeEvaluator(df) : new PerRangeEvaluator(df, range);
    }

    protected WindowColumnEvaluator(DataFrame source) {
        this.source = source;
    }

    public abstract Series<?>[] eval(Exp<?> ... var1);

    static class NoRangeEvaluator
    extends WindowColumnEvaluator {
        NoRangeEvaluator(DataFrame source) {
            super(source);
        }

        @Override
        public Series<?>[] eval(Exp<?> ... exps) {
            int w = exps.length;
            int h = this.source.height();
            if (h == 0) {
                Object[] columns = new Series[w];
                Arrays.fill(columns, Series.of(new Object[0]));
                return columns;
            }
            Series[] columns = new Series[w];
            Environment env = Environment.commonEnv();
            if (w <= 1 || this.source.height() < env.parallelExecThreshold()) {
                for (int i = 0; i < w; ++i) {
                    columns[i] = exps[i].eval(this.source);
                }
            } else {
                int i;
                ExecutorService pool = env.threadPool();
                Future[] tasks = new Future[w];
                for (i = 0; i < w; ++i) {
                    Exp<?> exp = exps[i];
                    tasks[i] = pool.submit(() -> exp.eval(this.source));
                }
                for (i = 0; i < w; ++i) {
                    try {
                        columns[i] = (Series)tasks[i].get();
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return columns;
        }
    }

    static class PerRangeEvaluator
    extends WindowColumnEvaluator {
        private final WindowRange range;

        PerRangeEvaluator(DataFrame source, WindowRange range) {
            super(source);
            this.range = range;
        }

        @Override
        public Series<?>[] eval(Exp<?> ... exps) {
            int w = exps.length;
            int h = this.source.height();
            Series[] data = new Series[w];
            for (int i = 0; i < w; ++i) {
                ObjectAccum accum = new ObjectAccum(h);
                Exp<?> exp = exps[i];
                for (int j = 0; j < h; ++j) {
                    DataFrame rangeDf = this.range.selectRows(this.source, j);
                    Series<?> s = exp.eval(rangeDf);
                    accum.push(s.get(this.range.rowOffset(j)));
                }
                data[i] = accum.toSeries();
            }
            return data;
        }
    }
}

