/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.Arrays;
import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.slice.AllRowSetMerger;
import org.dflib.slice.ColumnExpander;
import org.dflib.slice.DefaultRowSetMerger;
import org.dflib.slice.RangeRowSetMerger;

public abstract class RowSetMerger {
    public static RowSetMerger of(int srcLen, IntSeries rowIndex) {
        int[] mi = new int[srcLen];
        for (int i = 0; i < srcLen; ++i) {
            mi[i] = i;
        }
        int[] mie = null;
        int h = rowIndex.size();
        int ei = 0;
        for (int i = 0; i < h; ++i) {
            int pos = rowIndex.getInt(i);
            if (mi[pos] >= 0) {
                mi[pos] = -i - 1;
                continue;
            }
            if (ei == 0) {
                mie = new int[h - i];
            }
            mie[ei++] = -i - 1;
        }
        if (ei > 0) {
            int[] miCombined = Arrays.copyOf(mi, srcLen + ei);
            System.arraycopy(mie, 0, miCombined, srcLen, ei);
            return new DefaultRowSetMerger(miCombined);
        }
        return new DefaultRowSetMerger(mi);
    }

    public static RowSetMerger of(BooleanSeries rowIndex) {
        int h = rowIndex.size();
        int[] mergeIndex = new int[h];
        int rsi = 0;
        for (int i = 0; i < h; ++i) {
            mergeIndex[i] = rowIndex.getBool(i) ? -rsi++ - 1 : i;
        }
        return new DefaultRowSetMerger(mergeIndex);
    }

    public static RowSetMerger ofAll() {
        return AllRowSetMerger.instance;
    }

    public static RowSetMerger ofRange(int srcLen, int fromInclusive, int toExclusive) {
        return new RangeRowSetMerger(srcLen, fromInclusive, toExclusive);
    }

    public abstract <T> Series<T> merge(Series<T> var1, Series<T> var2);

    public abstract RowSetMerger removeUnmatchedRows(BooleanSeries var1);

    public abstract RowSetMerger expandCols(ColumnExpander var1);
}

