/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.Arrays;
import org.dflib.BooleanSeries;
import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.RowSet;
import org.dflib.Series;
import org.dflib.range.Range;
import org.dflib.series.IntSequenceSeries;
import org.dflib.slice.BaseRowSet;
import org.dflib.slice.IndexedRowSet;
import org.dflib.slice.RowSetMerger;

public class RangeRowSet
extends BaseRowSet {
    private final int fromInclusive;
    private final int toExclusive;

    public RangeRowSet(DataFrame source, Series<?>[] sourceColumns, int fromInclusive, int toExclusive) {
        this(source, sourceColumns, -1, fromInclusive, toExclusive);
    }

    protected RangeRowSet(DataFrame source, Series<?>[] sourceColumns, int expansionColumn, int fromInclusive, int toExclusive) {
        super(source, sourceColumns, expansionColumn);
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, source.height());
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
    }

    @Override
    public RowSet expand(int columnPos) {
        return this.expansionColumn != columnPos ? new RangeRowSet(this.source, this.sourceColumns, columnPos, this.fromInclusive, this.toExclusive) : this;
    }

    @Override
    public DataFrame drop() {
        int srcLen = this.source.height();
        int[] index = new int[srcLen - this.size()];
        int ii = 0;
        int i = 0;
        while (i < this.fromInclusive) {
            index[ii++] = i++;
        }
        i = this.toExclusive;
        while (i < srcLen) {
            index[ii++] = i++;
        }
        return new IndexedRowSet(this.source, this.sourceColumns, Series.ofInt(index)).select();
    }

    @Override
    public BooleanSeries locate() {
        int h = this.source.height();
        boolean[] values = new boolean[h];
        Arrays.fill(values, this.fromInclusive, this.toExclusive, true);
        return Series.ofBool(values);
    }

    @Override
    public IntSeries index() {
        return new IntSequenceSeries(this.fromInclusive, this.toExclusive);
    }

    @Override
    protected int size() {
        return this.toExclusive - this.fromInclusive;
    }

    @Override
    protected <T> Series<T> doSelect(Series<T> sourceColumn) {
        return sourceColumn.selectRange(this.fromInclusive, this.toExclusive);
    }

    @Override
    protected RowSetMerger merger() {
        return RowSetMerger.ofRange(this.source.height(), this.fromInclusive, this.toExclusive);
    }
}

