/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.Arrays;
import org.dflib.BooleanSeries;
import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.RowSet;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.slice.BaseRowSet;
import org.dflib.slice.ConditionalRowSet;
import org.dflib.slice.RowSetMerger;

public class IndexedRowSet
extends BaseRowSet {
    private final IntSeries intIndex;

    public IndexedRowSet(DataFrame source, Series<?>[] sourceColumns, IntSeries intIndex) {
        this(source, sourceColumns, -1, intIndex);
    }

    protected IndexedRowSet(DataFrame source, Series<?>[] sourceColumns, int expansionColumn, IntSeries intIndex) {
        super(source, sourceColumns, expansionColumn);
        this.intIndex = intIndex;
    }

    @Override
    public RowSet expand(int columnPos) {
        return this.expansionColumn != columnPos ? new IndexedRowSet(this.source, this.sourceColumns, columnPos, this.intIndex) : this;
    }

    @Override
    public DataFrame drop() {
        int srcLen = this.source.height();
        boolean[] condition = new boolean[srcLen];
        Arrays.fill(condition, true);
        int iiLen = this.intIndex.size();
        for (int i = 0; i < iiLen; ++i) {
            condition[this.intIndex.getInt((int)i)] = false;
        }
        return new ConditionalRowSet(this.source, this.sourceColumns, Series.ofBool(condition)).select();
    }

    @Override
    public DataFrame sort(Sorter ... sorters) {
        if (this.intIndex.size() < 2) {
            return this.source;
        }
        return super.sort(sorters);
    }

    @Override
    public BooleanSeries locate() {
        int h = this.source.height();
        int ih = this.intIndex.size();
        boolean[] values = new boolean[h];
        for (int i = 0; i < ih; ++i) {
            values[this.intIndex.getInt((int)i)] = true;
        }
        return Series.ofBool(values);
    }

    @Override
    public IntSeries index() {
        return this.intIndex;
    }

    @Override
    protected int size() {
        return this.intIndex.size();
    }

    @Override
    protected <T> Series<T> doSelect(Series<T> sourceColumn) {
        return sourceColumn.select(this.intIndex);
    }

    @Override
    protected RowSetMerger merger() {
        return RowSetMerger.of(this.source.height(), this.intIndex);
    }
}

