/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.dflib.BoolValueMapper;
import org.dflib.BooleanSeries;
import org.dflib.ColumnDataFrame;
import org.dflib.ColumnSet;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.DoubleValueMapper;
import org.dflib.Exp;
import org.dflib.FloatValueMapper;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.IntValueMapper;
import org.dflib.LongValueMapper;
import org.dflib.RowColumnSet;
import org.dflib.RowMapper;
import org.dflib.RowPredicate;
import org.dflib.RowToValueMapper;
import org.dflib.Series;
import org.dflib.agg.DataFrameAggregator;
import org.dflib.row.MultiArrayRowBuilder;
import org.dflib.row.RowProxy;
import org.dflib.series.RowMappedSeries;
import org.dflib.series.SingleValueSeries;
import org.dflib.slice.ColumnSetMerger;
import org.dflib.slice.FixedColumnSetIndex;

public class FixedColumnSet
implements ColumnSet {
    protected final DataFrame source;
    protected final String[] csIndex;

    public static FixedColumnSet of(DataFrame source, Index csIndex) {
        return new FixedColumnSet(source, csIndex.toArray());
    }

    public static FixedColumnSet of(DataFrame source, String[] csIndex) {
        return new FixedColumnSet(source, csIndex);
    }

    public static FixedColumnSet ofAppend(DataFrame source, String[] csIndex) {
        return new FixedColumnSet(source, FixedColumnSetIndex.ofAppend(source.getColumnsIndex(), csIndex).getLabels());
    }

    public static FixedColumnSet of(DataFrame source, int[] csIndex) {
        return new FixedColumnSet(source, FixedColumnSetIndex.of(source.getColumnsIndex(), csIndex).getLabels());
    }

    protected FixedColumnSet(DataFrame source, String[] csIndex) {
        this.source = source;
        this.csIndex = csIndex;
    }

    public Index getColumnSetIndex() {
        return Index.ofDeduplicated(this.csIndex);
    }

    @Override
    public RowColumnSet rows() {
        return this.source.rows().cols(this.csIndex);
    }

    @Override
    public RowColumnSet rows(IntSeries positions) {
        return this.source.rows(positions).cols(this.csIndex);
    }

    @Override
    public RowColumnSet rows(RowPredicate condition) {
        return this.source.rows(condition).cols(this.csIndex);
    }

    @Override
    public RowColumnSet rows(Condition condition) {
        return this.source.rows(condition).cols(this.csIndex);
    }

    @Override
    public RowColumnSet rows(BooleanSeries condition) {
        return this.source.rows(condition).cols(this.csIndex);
    }

    @Override
    public RowColumnSet rowsRange(int fromInclusive, int toExclusive) {
        return this.source.rowsRange(fromInclusive, toExclusive).cols(this.csIndex);
    }

    @Override
    public DataFrame drop() {
        return this.source.colsExcept(this.csIndex).select();
    }

    @Override
    public DataFrame as(String ... newColumnNames) {
        int w = newColumnNames.length;
        if (w != this.csIndex.length) {
            throw new IllegalArgumentException("Can't perform 'rename': column names size is different from the ColumnSet size: " + w + " vs. " + this.csIndex.length);
        }
        HashMap<String, String> oldToNewMap = new HashMap<String, String>((int)Math.ceil((double)w / 0.75));
        for (int i = 0; i < w; ++i) {
            oldToNewMap.put(this.csIndex[i], newColumnNames[i]);
        }
        return this.as(oldToNewMap);
    }

    @Override
    public DataFrame selectAs(String ... newColumnNames) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(newColumnNames), this.doSelect());
    }

    @Override
    public DataFrame as(UnaryOperator<String> renamer) {
        HashMap<String, String> oldToNewMap = new HashMap<String, String>((int)Math.ceil((double)this.csIndex.length / 0.75));
        for (String l : this.csIndex) {
            oldToNewMap.put(l, (String)renamer.apply(l));
        }
        return this.as(oldToNewMap);
    }

    @Override
    public DataFrame selectAs(UnaryOperator<String> renamer) {
        return new ColumnDataFrame(null, Index.of(this.csIndex).replace(renamer), this.doSelect());
    }

    @Override
    public DataFrame as(Map<String, String> oldToNewNames) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.getOrCreateColumn(i);
        }
        return this.doMerge(columns, oldToNewNames);
    }

    @Override
    public DataFrame selectAs(Map<String, String> oldToNewNames) {
        return new ColumnDataFrame(null, Index.of(this.csIndex).replace(oldToNewNames), this.doSelect());
    }

    @Override
    public DataFrame fill(Object ... values) {
        int w = values.length;
        if (w != this.csIndex.length) {
            throw new IllegalArgumentException("Can't perform 'fill': values size is different from the ColumnSet size: " + w + " vs. " + this.csIndex.length);
        }
        int h = this.source.height();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofVal(values[i], h);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame fillNulls(Object value) {
        if (value == null) {
            return this.source;
        }
        int w = this.csIndex.length;
        int h = this.source.height();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.getOrCreateColumn(i, e -> e.fillNulls(value), () -> Series.ofVal(value, h));
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame fillNullsBackwards() {
        int w = this.csIndex.length;
        int h = this.source.height();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.getOrCreateColumn(i, e -> e.fillNullsBackwards(), () -> new SingleValueSeries<Object>(null, h));
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame fillNullsForward() {
        int w = this.csIndex.length;
        int h = this.source.height();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.getOrCreateColumn(i, e -> e.fillNullsForward(), () -> new SingleValueSeries<Object>(null, h));
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame fillNullsFromSeries(Series<?> series) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.fillNullsFromSeries(series);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame fillNullsWithExp(Exp<?> replacementValuesExp) {
        return this.fillNullsFromSeries(replacementValuesExp.eval(this.source));
    }

    @Override
    public DataFrame compactBool() {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactBool();
        }
        return this.doMerge(columns);
    }

    @Override
    public <V> DataFrame compactBool(BoolValueMapper<V> mapper) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactBool(mapper);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame compactInt(int forNull) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactInt(forNull);
        }
        return this.doMerge(columns);
    }

    @Override
    public <V> DataFrame compactInt(IntValueMapper<V> mapper) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactInt(mapper);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame compactLong(long forNull) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactLong(forNull);
        }
        return this.doMerge(columns);
    }

    @Override
    public <V> DataFrame compactLong(LongValueMapper<V> mapper) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactLong(mapper);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame compactFloat(float forNull) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactFloat(forNull);
        }
        return this.doMerge(columns);
    }

    @Override
    public <V> DataFrame compactFloat(FloatValueMapper<V> mapper) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactFloat(mapper);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame compactDouble(double forNull) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactDouble(forNull);
        }
        return this.doMerge(columns);
    }

    @Override
    public <V> DataFrame compactDouble(DoubleValueMapper<V> mapper) {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<?> s = this.getOrCreateColumn(i);
            columns[i] = s.compactDouble(mapper);
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame merge() {
        return this.doMerge(this.doSelect());
    }

    @Override
    public DataFrame select() {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), this.doSelect());
    }

    @Override
    public DataFrame merge(Exp<?> ... exps) {
        return this.doMerge(this.doMap(exps));
    }

    @Override
    public DataFrame select(Exp<?> ... exps) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), this.doMap(exps));
    }

    private Series<?>[] doMap(Exp<?>[] exps) {
        int w = exps.length;
        if (w != this.csIndex.length) {
            throw new IllegalArgumentException("Can't perform 'map': Exp[] size is different from the ColumnSet size: " + w + " vs. " + this.csIndex.length);
        }
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = exps[i].eval(this.source);
        }
        return columns;
    }

    @Override
    public DataFrame merge(Series<?> ... columns) {
        int w = this.csIndex.length;
        if (columns.length != w) {
            throw new IllegalArgumentException("Can't perform 'map': Series[] size is different from the ColumnSet size: " + columns.length + " vs. " + w);
        }
        int h = this.source.height();
        for (int i = 0; i < w; ++i) {
            if (columns[i].size() == h) continue;
            throw new IllegalArgumentException("The mapped column height (" + columns[i].size() + ") is different from the DataFrame height (" + h + ")");
        }
        return this.doMerge(columns);
    }

    @Override
    public DataFrame merge(RowToValueMapper<?> ... exps) {
        return this.doMerge(this.doMap(exps));
    }

    @Override
    public DataFrame select(RowToValueMapper<?> ... exps) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), this.doMap(exps));
    }

    private Series<?>[] doMap(RowToValueMapper<?>[] mappers) {
        int w = mappers.length;
        if (w != this.csIndex.length) {
            throw new IllegalArgumentException("Can't perform 'map': RowToValueMappers size is different from the ColumnSet size: " + w + " vs. " + this.csIndex.length);
        }
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = new RowMappedSeries(this.source, mappers[i]);
        }
        return columns;
    }

    @Override
    public DataFrame merge(RowMapper mapper) {
        MultiArrayRowBuilder b = new MultiArrayRowBuilder(Index.of(this.csIndex), this.source.height());
        this.source.forEach(from -> {
            b.next();
            mapper.map((RowProxy)from, b);
        });
        return this.doMerge(b.getData());
    }

    @Override
    public DataFrame select(RowMapper mapper) {
        MultiArrayRowBuilder b = new MultiArrayRowBuilder(Index.of(this.csIndex), this.source.height());
        this.source.forEach(from -> {
            b.next();
            mapper.map((RowProxy)from, b);
        });
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), b.getData());
    }

    @Override
    public DataFrame expand(Exp<? extends Iterable<?>> splitExp) {
        return this.doMerge(this.doMapIterables(splitExp));
    }

    @Override
    public DataFrame selectExpand(Exp<? extends Iterable<?>> splitExp) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), this.doMapIterables(splitExp));
    }

    private Series<?>[] doMapIterables(Exp<? extends Iterable<?>> mapper) {
        Series<Iterable<?>> ranges = mapper.eval(this.source);
        int w = this.csIndex.length;
        int h = this.source.height();
        Object[][] data = new Object[w][h];
        for (int j = 0; j < w; ++j) {
            data[j] = new Object[h];
        }
        for (int i = 0; i < h; ++i) {
            Iterable<?> r = ranges.get(i);
            if (r == null) continue;
            Iterator<?> rit = r.iterator();
            for (int j = 0; j < w && rit.hasNext(); ++j) {
                data[j][i] = rit.next();
            }
        }
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.of(data[i]);
        }
        return columns;
    }

    @Override
    public DataFrame expandArray(Exp<? extends Object[]> splitExp) {
        return this.doMerge(this.doMapArrays(splitExp));
    }

    @Override
    public DataFrame selectExpandArray(Exp<? extends Object[]> splitExp) {
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), this.doMapArrays(splitExp));
    }

    @Override
    public DataFrame agg(Exp<?> ... aggregators) {
        int w = aggregators.length;
        if (w != this.csIndex.length) {
            throw new IllegalArgumentException("Can't perform 'agg': Exp[] size is different from the ColumnSet size: " + w + " vs. " + this.csIndex.length);
        }
        Series<?>[] aggregated = DataFrameAggregator.agg(this.source, aggregators);
        return new ColumnDataFrame(null, Index.ofDeduplicated(this.csIndex), aggregated);
    }

    private Series<?>[] doMapArrays(Exp<? extends Object[]> mapper) {
        Series<? extends Object[]> ranges = mapper.eval(this.source);
        int w = this.csIndex.length;
        int h = this.source.height();
        Object[][] data = new Object[w][h];
        for (int j = 0; j < w; ++j) {
            data[j] = new Object[h];
        }
        for (int i = 0; i < h; ++i) {
            Object[] r = ranges.get(i);
            if (r == null) continue;
            int rw = Math.min(r.length, w);
            for (int j = 0; j < rw; ++j) {
                data[j][i] = r[j];
            }
        }
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.of(data[i]);
        }
        return columns;
    }

    private Series<?> getOrCreateColumn(int pos) {
        String name = this.csIndex[pos];
        return this.source.getColumnsIndex().contains(name) ? this.source.getColumn(name) : new SingleValueSeries<Object>(null, this.source.height());
    }

    private Series<?> getOrCreateColumn(int pos, UnaryOperator<Series<?>> andApplyToExisting, Supplier<Series<?>> createNew) {
        String name = this.csIndex[pos];
        return this.source.getColumnsIndex().contains(name) ? (Series)andApplyToExisting.apply(this.source.getColumn(name)) : createNew.get();
    }

    private DataFrame doMerge(Series<?>[] columns) {
        return ColumnSetMerger.merge(this.source, this.csIndex, columns);
    }

    private DataFrame doMerge(Series<?>[] columns, Map<String, String> oldToNewNames) {
        return ColumnSetMerger.mergeAs(this.source, this.csIndex, Index.of(this.csIndex).replace(oldToNewNames).toArray(), columns);
    }

    private Series<?>[] doSelect() {
        int w = this.csIndex.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.getOrCreateColumn(i);
        }
        return columns;
    }
}

