/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.dflib.BoolValueMapper;
import org.dflib.BooleanSeries;
import org.dflib.ColumnDataFrame;
import org.dflib.ColumnSet;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.DoubleValueMapper;
import org.dflib.Exp;
import org.dflib.FloatValueMapper;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.IntValueMapper;
import org.dflib.LongValueMapper;
import org.dflib.RowColumnSet;
import org.dflib.RowMapper;
import org.dflib.RowPredicate;
import org.dflib.RowToValueMapper;
import org.dflib.Series;
import org.dflib.agg.DataFrameAggregator;
import org.dflib.exp.Exps;
import org.dflib.row.DynamicColsRowBuilder;
import org.dflib.row.RowProxy;
import org.dflib.series.RowMappedSeries;
import org.dflib.slice.FixedColumnSet;

public class DeferredColumnSet
implements ColumnSet {
    private final DataFrame source;
    private final Series<?>[] sourceColumns;

    public DeferredColumnSet(DataFrame source, Series<?>[] sourceColumns) {
        this.source = source;
        this.sourceColumns = sourceColumns;
    }

    @Override
    public RowColumnSet rows() {
        return this.source.rows().cols();
    }

    @Override
    public RowColumnSet rows(IntSeries positions) {
        return this.source.rows(positions).cols();
    }

    @Override
    public RowColumnSet rows(RowPredicate condition) {
        return this.source.rows(condition).cols();
    }

    @Override
    public RowColumnSet rows(Condition condition) {
        return this.source.rows(condition).cols();
    }

    @Override
    public RowColumnSet rows(BooleanSeries condition) {
        return this.source.rows(condition).cols();
    }

    @Override
    public RowColumnSet rowsRange(int fromInclusive, int toExclusive) {
        return this.source.rowsRange(fromInclusive, toExclusive).cols();
    }

    @Override
    public DataFrame drop() {
        return DataFrame.empty(new String[0]);
    }

    @Override
    public DataFrame as(String ... newColumnNames) {
        return new ColumnDataFrame(null, Index.of(newColumnNames), this.sourceColumns);
    }

    @Override
    public DataFrame selectAs(String ... newColumnNames) {
        return new ColumnDataFrame(null, Index.of(newColumnNames), this.sourceColumns);
    }

    @Override
    public DataFrame as(UnaryOperator<String> renamer) {
        return new ColumnDataFrame(null, this.source.getColumnsIndex().replace(renamer), this.sourceColumns);
    }

    @Override
    public DataFrame selectAs(UnaryOperator<String> renamer) {
        return new ColumnDataFrame(null, this.source.getColumnsIndex().replace(renamer), this.sourceColumns);
    }

    @Override
    public DataFrame as(Map<String, String> oldToNewNames) {
        return new ColumnDataFrame(null, this.source.getColumnsIndex().replace(oldToNewNames), this.sourceColumns);
    }

    @Override
    public DataFrame selectAs(Map<String, String> oldToNewNames) {
        return new ColumnDataFrame(null, this.source.getColumnsIndex().replace(oldToNewNames), this.sourceColumns);
    }

    @Override
    public DataFrame fill(Object ... values) {
        int w = this.source.width();
        if (values.length != w) {
            throw new IllegalArgumentException("Can't perform 'fill': values size is different from the ColumnSet size: " + values.length + " vs. " + w);
        }
        int h = this.source.height();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.ofVal(values[i], h);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame fillNulls(Object value) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.source.getColumn(i).fillNulls(value);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame fillNullsBackwards() {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.source.getColumn(i).fillNullsBackwards();
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame fillNullsForward() {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.source.getColumn(i).fillNullsForward();
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame fillNullsFromSeries(Series<?> series) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.source.getColumn(i).fillNullsFromSeries(series);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame fillNullsWithExp(Exp<?> replacementValuesExp) {
        return this.fillNullsFromSeries(replacementValuesExp.eval(this.source));
    }

    @Override
    public DataFrame compactBool() {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series s = this.source.getColumn(i);
            columns[i] = s.compactBool();
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public <V> DataFrame compactBool(BoolValueMapper<V> mapper) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<V> s = this.source.getColumn(i);
            columns[i] = s.compactBool(mapper);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame compactInt(int forNull) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series s = this.source.getColumn(i);
            columns[i] = s.compactInt(forNull);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public <V> DataFrame compactInt(IntValueMapper<V> mapper) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<V> s = this.source.getColumn(i);
            columns[i] = s.compactInt(mapper);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame compactLong(long forNull) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series s = this.source.getColumn(i);
            columns[i] = s.compactLong(forNull);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public <V> DataFrame compactLong(LongValueMapper<V> mapper) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<V> s = this.source.getColumn(i);
            columns[i] = s.compactLong(mapper);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame compactFloat(float forNull) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series s = this.source.getColumn(i);
            columns[i] = s.compactFloat(forNull);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public <V> DataFrame compactFloat(FloatValueMapper<V> mapper) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<V> s = this.source.getColumn(i);
            columns[i] = s.compactFloat(mapper);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame compactDouble(double forNull) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series s = this.source.getColumn(i);
            columns[i] = s.compactDouble(forNull);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public <V> DataFrame compactDouble(DoubleValueMapper<V> mapper) {
        int w = this.source.width();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            Series<V> s = this.source.getColumn(i);
            columns[i] = s.compactDouble(mapper);
        }
        return new ColumnDataFrame(null, this.source.getColumnsIndex(), columns);
    }

    @Override
    public DataFrame merge() {
        return this.source;
    }

    @Override
    public DataFrame select() {
        return this.source;
    }

    @Override
    public DataFrame merge(Exp<?> ... exps) {
        return this.delegate(Exps.labels(this.source, exps)).merge(exps);
    }

    @Override
    public DataFrame select(Exp<?> ... exps) {
        int w = exps.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = exps[i].eval(this.source);
        }
        return new ColumnDataFrame(null, Index.ofDeduplicated(Exps.labels(this.source, exps)), columns);
    }

    @Override
    public DataFrame merge(Series<?> ... columns) {
        int w = columns.length;
        int h = this.source.height();
        int srcW = this.source.width();
        String[] labels = new String[w];
        for (int i = 0; i < w; ++i) {
            if (columns[i].size() != h) {
                throw new IllegalArgumentException("The mapped column height (" + columns[i].size() + ") is different from the DataFrame height (" + h + ")");
            }
            labels[i] = String.valueOf(srcW + i);
        }
        return this.delegate(labels).merge(columns);
    }

    @Override
    public DataFrame merge(RowToValueMapper<?> ... mappers) {
        int w = mappers.length;
        int srcW = this.source.width();
        String[] labels = new String[w];
        for (int i = 0; i < w; ++i) {
            labels[i] = String.valueOf(srcW + i);
        }
        return this.delegate(labels).merge(mappers);
    }

    @Override
    public DataFrame select(RowToValueMapper<?> ... mappers) {
        int w = mappers.length;
        String[] labels = new String[w];
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            labels[i] = String.valueOf(i);
            columns[i] = new RowMappedSeries(this.source, mappers[i]);
        }
        return new ColumnDataFrame(null, Index.of(labels), columns);
    }

    @Override
    public DataFrame merge(RowMapper mapper) {
        DynamicColsRowBuilder b = new DynamicColsRowBuilder(this.source.height());
        this.source.forEach(from -> {
            b.next();
            mapper.map((RowProxy)from, b);
        });
        return this.delegate(b.getLabels()).merge(b.getData());
    }

    @Override
    public DataFrame select(RowMapper mapper) {
        DynamicColsRowBuilder b = new DynamicColsRowBuilder(this.source.height());
        this.source.forEach(from -> {
            b.next();
            mapper.map((RowProxy)from, b);
        });
        return new ColumnDataFrame(null, Index.of(b.getLabels()), b.getData());
    }

    @Override
    public DataFrame expand(Exp<? extends Iterable<?>> splitExp) {
        Series<?>[] columns = this.doMapIterables(splitExp);
        int w = columns.length;
        int srcW = this.source.width();
        int[] positions = new int[w];
        for (int i = 0; i < w; ++i) {
            positions[i] = srcW + i;
        }
        return this.delegate(positions).expand(splitExp);
    }

    @Override
    public DataFrame selectExpand(Exp<? extends Iterable<?>> splitExp) {
        Series<?>[] columns = this.doMapIterables(splitExp);
        int w = columns.length;
        String[] labels = new String[w];
        for (int i = 0; i < w; ++i) {
            labels[i] = String.valueOf(i);
        }
        return new ColumnDataFrame(null, Index.of(labels), columns);
    }

    private Series<?>[] doMapIterables(Exp<? extends Iterable<?>> mapper) {
        Series<Iterable<?>> ranges = mapper.eval(this.source);
        int h = this.source.height();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < h; ++i) {
            Iterable<?> r = ranges.get(i);
            if (r == null) continue;
            Iterator<?> rit = r.iterator();
            int j = 0;
            while (rit.hasNext()) {
                if (j >= data.size()) {
                    data.add(new Object[h]);
                }
                ((Object[])data.get((int)j))[i] = rit.next();
                ++j;
            }
        }
        int w = data.size();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.of((Object[])data.get(i));
        }
        return columns;
    }

    @Override
    public DataFrame expandArray(Exp<? extends Object[]> splitExp) {
        Series<?>[] columns = this.doMapArrays(splitExp);
        int w = columns.length;
        int[] positions = new int[w];
        int srcW = this.source.width();
        for (int i = 0; i < w; ++i) {
            positions[i] = srcW + i;
        }
        return this.delegate(positions).expandArray(splitExp);
    }

    @Override
    public DataFrame selectExpandArray(Exp<? extends Object[]> splitExp) {
        Series<?>[] columns = this.doMapArrays(splitExp);
        int w = columns.length;
        String[] labels = new String[w];
        for (int i = 0; i < w; ++i) {
            labels[i] = String.valueOf(i);
        }
        return new ColumnDataFrame(null, Index.of(labels), this.doMapArrays(splitExp));
    }

    @Override
    public DataFrame agg(Exp<?> ... aggregators) {
        Series<?>[] aggregated = DataFrameAggregator.agg(this.source, aggregators);
        Index index = Exps.index(this.source, aggregators);
        return new ColumnDataFrame(null, index, aggregated);
    }

    private Series<?>[] doMapArrays(Exp<? extends Object[]> mapper) {
        Series<? extends Object[]> ranges = mapper.eval(this.source);
        int h = this.source.height();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < h; ++i) {
            Object[] r = ranges.get(i);
            if (r == null) continue;
            int rw = r.length;
            for (int j = 0; j < rw; ++j) {
                if (j >= data.size()) {
                    data.add(new Object[h]);
                }
                ((Object[])data.get((int)j))[i] = r[j];
            }
        }
        int w = data.size();
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = Series.of((Object[])data.get(i));
        }
        return columns;
    }

    private ColumnSet delegate(String[] csIndex) {
        return FixedColumnSet.of(this.source, csIndex);
    }

    private ColumnSet delegate(int[] csIndex) {
        return FixedColumnSet.of(this.source, csIndex);
    }
}

