/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;

public class ColumnSetMerger {
    private final int mergeLen;
    private final int[] mergeIndex;

    public static DataFrame merge(DataFrame source, String[] csLabels, Series<?>[] csColumns) {
        return ColumnSetMerger.createMerger(source.getColumnsIndex(), csLabels).doMerge(source, csLabels, csColumns);
    }

    public static DataFrame mergeAs(DataFrame source, String[] csLabels, String[] csAsLabels, Series<?>[] csColumns) {
        return ColumnSetMerger.createMerger(source.getColumnsIndex(), csLabels).doMerge(source, csAsLabels, csColumns);
    }

    private static ColumnSetMerger createMerger(Index sourceIndex, String[] csLabels) {
        int sLen = sourceIndex.size();
        int csLen = csLabels.length;
        int[] mergeIndex = new int[sLen + csLen];
        for (int i = 0; i < sLen; ++i) {
            mergeIndex[i] = i;
        }
        int expandBy = 0;
        for (int i = 0; i < csLen; ++i) {
            if (sourceIndex.contains(csLabels[i])) {
                int srcPos = sourceIndex.position(csLabels[i]);
                int mPos = mergeIndex[srcPos] >= 0 ? srcPos : sLen + expandBy++;
                mergeIndex[mPos] = -1 - i;
                continue;
            }
            mergeIndex[sLen + expandBy++] = -1 - i;
        }
        return new ColumnSetMerger(sLen + expandBy, mergeIndex);
    }

    protected ColumnSetMerger(int mergeLen, int[] mergeIndex) {
        this.mergeLen = mergeLen;
        this.mergeIndex = mergeIndex;
    }

    private DataFrame doMerge(DataFrame source, String[] csLabels, Series<?>[] csColumns) {
        Index sIndex = source.getColumnsIndex();
        String[] labels = new String[this.mergeLen];
        Series[] columns = new Series[this.mergeLen];
        for (int i = 0; i < this.mergeLen; ++i) {
            int si = this.mergeIndex[i];
            if (si < 0) {
                int csi = -1 - si;
                labels[i] = csLabels[csi];
                columns[i] = csColumns[csi];
                continue;
            }
            labels[i] = sIndex.get(si);
            columns[i] = source.getColumn(si);
        }
        return new ColumnDataFrame(null, Index.ofDeduplicated(labels), columns);
    }
}

