/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.Arrays;
import java.util.Iterator;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.ValueAccum;

class ColumnExpander {
    private final Series<?> expanded;
    private final IntSeries stretchCounts;

    private ColumnExpander(Series<?> expanded, IntSeries stretchCounts) {
        this.expanded = expanded;
        this.stretchCounts = stretchCounts;
    }

    public Series<?> getExpanded() {
        return this.expanded;
    }

    public IntSeries getStretchCounts() {
        return this.stretchCounts;
    }

    public int[] getStretchIndex() {
        int shrunkLen = this.stretchCounts.size();
        int stretchLen = this.expanded.size();
        int[] stretchIndex = new int[stretchLen];
        int si = 0;
        for (int i = 0; i < shrunkLen; ++i) {
            int stretchBy = this.stretchCounts.getInt(i);
            if (stretchBy > 1) {
                Arrays.fill(stretchIndex, si, si + stretchBy, i);
                si += stretchBy;
                continue;
            }
            stretchIndex[si++] = i;
        }
        return stretchIndex;
    }

    public static ColumnExpander expand(Series<?> s) {
        int h = s.size();
        ObjectAccum<Object> explodedAccum = new ObjectAccum<Object>(h);
        IntAccum indexAccum = new IntAccum(h);
        for (int i = 0; i < h; ++i) {
            Object v = s.get(i);
            if (v == null) {
                explodedAccum.push(null);
                indexAccum.push(1);
                continue;
            }
            if (v instanceof Iterable) {
                ColumnExpander.explodeIterable(explodedAccum, indexAccum, (Iterable)v);
                continue;
            }
            if (v.getClass().isArray()) {
                ColumnExpander.explodeArray(explodedAccum, indexAccum, v);
                continue;
            }
            explodedAccum.push(v);
            indexAccum.push(1);
        }
        return new ColumnExpander(explodedAccum.toSeries(), indexAccum.toSeries());
    }

    private static void explodeIterable(ValueAccum<Object> explodedAccum, IntAccum indexAccum, Iterable<?> iterable) {
        Iterator<?> it = iterable.iterator();
        if (!it.hasNext()) {
            explodedAccum.push(null);
            indexAccum.push(1);
        } else {
            int c = 0;
            while (it.hasNext()) {
                explodedAccum.push(it.next());
                ++c;
            }
            indexAccum.push(c);
        }
    }

    private static void explodeArray(ValueAccum<Object> explodedAccum, IntAccum indexAccum, Object array) {
        if (array instanceof Object[]) {
            Object[] a = (Object[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (Object sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else if (array instanceof int[]) {
            int[] a = (int[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (int sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else if (array instanceof double[]) {
            double[] a = (double[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (double sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else if (array instanceof long[]) {
            long[] a = (long[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (long sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else if (array instanceof boolean[]) {
            boolean[] a = (boolean[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (boolean sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else if (array instanceof byte[]) {
            byte[] a = (byte[])array;
            if (a.length == 0) {
                explodedAccum.push(null);
                indexAccum.push(1);
            } else {
                for (byte sv : a) {
                    explodedAccum.push(sv);
                }
                indexAccum.push(a.length);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized array type: " + array.getClass().getName());
        }
    }
}

