/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.dflib.BooleanSeries;
import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Index;
import org.dflib.RowColumnSet;
import org.dflib.RowMapper;
import org.dflib.RowSet;
import org.dflib.RowToValueMapper;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.f.IntObjectFunction2;
import org.dflib.f.Tuple2;
import org.dflib.series.IntSingleValueSeries;
import org.dflib.series.RowMappedSeries;
import org.dflib.slice.ColumnExpander;
import org.dflib.slice.DefaultRowColumnSet;
import org.dflib.slice.RowSetMerger;
import org.dflib.sort.Comparators;
import org.dflib.sort.DataFrameSorter;
import org.dflib.sort.IntComparator;

public abstract class BaseRowSet
implements RowSet {
    protected final DataFrame source;
    protected final Index sourceColumnsIndex;
    protected final Series[] sourceColumns;
    protected final int expansionColumn;

    protected BaseRowSet(DataFrame source, Series<?>[] sourceColumns, int expansionColumn) {
        this.source = source;
        this.sourceColumnsIndex = source.getColumnsIndex();
        this.sourceColumns = sourceColumns;
        this.expansionColumn = expansionColumn;
    }

    @Override
    public RowColumnSet cols() {
        return new DefaultRowColumnSet(this.source, this, df -> df.cols(), this::merger);
    }

    @Override
    public RowColumnSet cols(String ... columns) {
        return new DefaultRowColumnSet(this.source, this, df -> df.cols(columns), this::merger);
    }

    @Override
    public RowColumnSet cols(Index columnsIndex) {
        return new DefaultRowColumnSet(this.source, this, df -> df.cols(columnsIndex), this::merger);
    }

    @Override
    public RowColumnSet cols(int ... columns) {
        return new DefaultRowColumnSet(this.source, this, df -> df.cols(columns), this::merger);
    }

    @Override
    public RowColumnSet cols(Predicate<String> condition) {
        return new DefaultRowColumnSet(this.source, this, df -> df.cols(condition), this::merger);
    }

    @Override
    public RowColumnSet colsExcept(String ... columns) {
        return new DefaultRowColumnSet(this.source, this, df -> df.colsExcept(columns), this::merger);
    }

    @Override
    public RowColumnSet colsExcept(int ... columns) {
        return new DefaultRowColumnSet(this.source, this, df -> df.colsExcept(columns), this::merger);
    }

    @Override
    public RowSet expand(String columnName) {
        return this.expand(this.sourceColumnsIndex.position(columnName));
    }

    @Override
    public DataFrame merge() {
        return this.mergeByColumn((i, rowsAsDf) -> rowsAsDf.getColumn(i));
    }

    @Override
    public DataFrame merge(Exp<?> ... exps) {
        int w = exps.length;
        if (w != this.sourceColumnsIndex.size()) {
            throw new IllegalArgumentException("The number of column expressions (" + w + ") is different from the DataFrame width (" + this.sourceColumnsIndex.size() + ")");
        }
        return this.mergeByColumn((i, rowsAsDf) -> exps[i].eval((DataFrame)rowsAsDf));
    }

    @Override
    public DataFrame merge(RowToValueMapper<?> ... mappers) {
        int w = mappers.length;
        if (w != this.sourceColumnsIndex.size()) {
            throw new IllegalArgumentException("The number of column mappers (" + w + ") is different from the DataFrame width (" + this.sourceColumnsIndex.size() + ")");
        }
        return this.mergeByColumn((i, rowsAsDf) -> new RowMappedSeries((DataFrame)rowsAsDf, mappers[i]));
    }

    @Override
    public DataFrame merge(RowMapper mapper) {
        if (this.sourceColumns.length == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        Tuple2<Series<?>[], ColumnExpander> rows = this.doSelect();
        RowSetMerger merger = this.expansionColumn >= 0 ? this.merger().expandCols((ColumnExpander)rows.two) : this.merger();
        DataFrame rowsAsDf = new ColumnDataFrame(null, this.sourceColumnsIndex, (Series[])rows.one).cols(this.sourceColumnsIndex).merge(mapper);
        int w = this.sourceColumnsIndex.size();
        Series[] resultColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            resultColumns[i] = merger.merge(this.sourceColumns[i], rowsAsDf.getColumn(i));
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(resultColumns);
    }

    @Override
    public DataFrame sort(Sorter ... sorters) {
        if (sorters.length == 0) {
            return this.source;
        }
        if (this.sourceColumns.length == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() < 2) {
            return this.source;
        }
        DataFrame rsDf = this.select();
        IntComparator comparator = Comparators.of(rsDf, sorters);
        DataFrame rowsAsDf = rsDf.rows(DataFrameSorter.sort(comparator, rsDf.height())).select();
        RowSetMerger merger = this.merger();
        int w = this.sourceColumnsIndex.size();
        Series[] to = new Series[w];
        for (int i = 0; i < w; ++i) {
            to[i] = merger.merge(this.sourceColumns[i], rowsAsDf.getColumn(i));
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(to);
    }

    @Override
    public DataFrame unique() {
        return this.unique(this.sourceColumnsIndex.toArray());
    }

    @Override
    public DataFrame unique(String ... uniqueKeyColumns) {
        if (uniqueKeyColumns.length == 0) {
            throw new IllegalArgumentException("No 'columnNamesToCompare' for uniqueness checks");
        }
        int w = this.sourceColumns.length;
        if (w == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        DataFrame rowsAsDf = this.select();
        BooleanSeries uniqueIndex = rowsAsDf.over().partitioned(uniqueKeyColumns).rowNumber().eq(new IntSingleValueSeries(1, rowsAsDf.height()));
        if (uniqueIndex.isTrue()) {
            return this.source;
        }
        RowSetMerger merger = this.merger().removeUnmatchedRows(uniqueIndex);
        Series[] to = new Series[w];
        for (int i = 0; i < w; ++i) {
            to[i] = merger.merge(this.sourceColumns[i], rowsAsDf.getColumn(i));
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(to);
    }

    @Override
    public DataFrame unique(int ... uniqueKeyColumns) {
        if (uniqueKeyColumns.length == 0) {
            throw new IllegalArgumentException("No 'columnPositionsToCompare' for uniqueness checks");
        }
        int w = this.sourceColumns.length;
        if (w == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        DataFrame rowsAsDf = this.select();
        BooleanSeries uniqueIndex = rowsAsDf.over().partitioned(uniqueKeyColumns).rowNumber().eq(new IntSingleValueSeries(1, rowsAsDf.height()));
        if (uniqueIndex.isTrue()) {
            return this.source;
        }
        RowSetMerger merger = this.merger().removeUnmatchedRows(uniqueIndex);
        Series[] to = new Series[w];
        for (int i = 0; i < w; ++i) {
            to[i] = merger.merge(this.sourceColumns[i], rowsAsDf.getColumn(i));
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(to);
    }

    @Override
    public DataFrame select() {
        return new ColumnDataFrame(null, this.sourceColumnsIndex, (Series[])this.doSelect().one);
    }

    @Override
    public DataFrame selectAs(Map<String, String> oldToNewNames) {
        return new ColumnDataFrame(null, this.sourceColumnsIndex.replace(oldToNewNames), (Series[])this.doSelect().one);
    }

    @Override
    public DataFrame selectAs(UnaryOperator<String> renamer) {
        return new ColumnDataFrame(null, this.sourceColumnsIndex.replace(renamer), (Series[])this.doSelect().one);
    }

    @Override
    public DataFrame selectAs(String ... newColumnNames) {
        return new ColumnDataFrame(null, Index.of(newColumnNames), (Series[])this.doSelect().one);
    }

    @Override
    public DataFrame select(Exp<?> ... exps) {
        int w = exps.length;
        if (w != this.sourceColumnsIndex.size()) {
            throw new IllegalArgumentException("The number of column expressions (" + w + ") is different from the DataFrame width (" + this.sourceColumnsIndex.size() + ")");
        }
        return this.selectByColumn((i, rowsAsDf) -> exps[i].eval((DataFrame)rowsAsDf));
    }

    @Override
    public DataFrame select(RowMapper mapper) {
        if (this.sourceColumns.length == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        Tuple2<Series<?>[], ColumnExpander> rows = this.doSelect();
        return new ColumnDataFrame(null, this.sourceColumnsIndex, (Series[])rows.one).cols(this.sourceColumnsIndex).merge(mapper);
    }

    @Override
    public DataFrame select(RowToValueMapper<?> ... mappers) {
        int w = mappers.length;
        if (w != this.sourceColumnsIndex.size()) {
            throw new IllegalArgumentException("The number of column mappers (" + w + ") is different from the DataFrame width (" + this.sourceColumnsIndex.size() + ")");
        }
        return this.selectByColumn((i, rowsAsDf) -> new RowMappedSeries((DataFrame)rowsAsDf, mappers[i]));
    }

    @Override
    public DataFrame selectUnique() {
        return this.selectUnique(this.source.getColumnsIndex().toArray());
    }

    @Override
    public DataFrame selectUnique(String ... uniqueKeyColumns) {
        return this.selectUnique(this.sourceColumnsIndex.positions(uniqueKeyColumns));
    }

    @Override
    public DataFrame selectUnique(int ... uniqueKeyColumns) {
        if (uniqueKeyColumns.length == 0) {
            throw new IllegalArgumentException("No 'columnPositionsToCompare' for uniqueness checks");
        }
        int w = this.sourceColumns.length;
        if (w == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        DataFrame rowsAsDf = this.select();
        BooleanSeries uniqueIndex = rowsAsDf.over().partitioned(uniqueKeyColumns).rowNumber().eq(new IntSingleValueSeries(1, rowsAsDf.height()));
        if (uniqueIndex.isTrue()) {
            return rowsAsDf;
        }
        return rowsAsDf.rows(uniqueIndex).select();
    }

    protected DataFrame mergeByColumn(IntObjectFunction2<DataFrame, Series<?>> columnMaker) {
        if (this.sourceColumns.length == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        Tuple2<Series<?>[], ColumnExpander> rows = this.doSelect();
        RowSetMerger merger = this.expansionColumn >= 0 ? this.merger().expandCols((ColumnExpander)rows.two) : this.merger();
        int w = this.sourceColumnsIndex.size();
        Series[] resultColumns = new Series[w];
        ColumnDataFrame rowsAsDf = new ColumnDataFrame(null, this.sourceColumnsIndex, (Series[])rows.one);
        for (int i = 0; i < w; ++i) {
            resultColumns[i] = merger.merge(this.sourceColumns[i], columnMaker.apply(i, rowsAsDf));
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(resultColumns);
    }

    protected DataFrame selectByColumn(IntObjectFunction2<DataFrame, Series<?>> columnMaker) {
        if (this.sourceColumns.length == 0) {
            return this.source;
        }
        if (this.sourceColumns[0].size() == 0) {
            return this.source;
        }
        Tuple2<Series<?>[], ColumnExpander> rows = this.doSelect();
        ColumnDataFrame rowsAsDf = new ColumnDataFrame(null, this.sourceColumnsIndex, (Series[])rows.one);
        int w = this.sourceColumnsIndex.size();
        Series[] to = new Series[w];
        for (int i = 0; i < w; ++i) {
            to[i] = columnMaker.apply(i, rowsAsDf);
        }
        return DataFrame.byColumn(this.sourceColumnsIndex).of(to);
    }

    protected abstract int size();

    protected Tuple2<Series<?>[], ColumnExpander> doSelect() {
        int w = this.sourceColumns.length;
        Series[] to = new Series[w];
        for (int i = 0; i < w; ++i) {
            to[i] = this.doSelect(this.sourceColumns[i]);
        }
        if (this.expansionColumn >= 0) {
            ColumnExpander expander = ColumnExpander.expand(to[this.expansionColumn]);
            int[] stretchIndex = expander.getStretchIndex();
            for (int i = 0; i < w; ++i) {
                to[i] = i == this.expansionColumn ? expander.getExpanded() : to[i].select(stretchIndex);
            }
            return new Tuple2<Series<?>[], ColumnExpander>(to, expander);
        }
        return new Tuple2<Series[], Object>(to, null);
    }

    protected abstract <T> Series<T> doSelect(Series<T> var1);

    protected abstract RowSetMerger merger();
}

