/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.slice;

import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.slice.ColumnExpander;
import org.dflib.slice.DefaultRowSetMerger;
import org.dflib.slice.RowSetMerger;

class AllRowSetMerger
extends RowSetMerger {
    static final AllRowSetMerger instance = new AllRowSetMerger();

    AllRowSetMerger() {
    }

    @Override
    public <T> Series<T> merge(Series<T> srcColumn, Series<T> rsColumn) {
        return rsColumn;
    }

    @Override
    public RowSetMerger removeUnmatchedRows(BooleanSeries rsCondition) {
        int rsh = rsCondition.size();
        int h = rsCondition.countTrue();
        int[] shrunkIndex = new int[h];
        int si = 0;
        for (int i = 0; i < rsh; ++i) {
            if (!rsCondition.getBool(i)) continue;
            shrunkIndex[si++] = i;
        }
        return new DefaultRowSetMerger(shrunkIndex);
    }

    @Override
    public RowSetMerger expandCols(ColumnExpander expander) {
        IntSeries rsStretchCounts = expander.getStretchCounts();
        int rsLen = expander.getExpanded().size();
        int ch = rsStretchCounts.size();
        int[] explodeIndex = new int[rsLen];
        int si = 0;
        int rsi = 0;
        int et = 0;
        for (int i = 0; i < ch; ++i) {
            int explodeBy = rsStretchCounts.getInt(rsi++);
            for (int j = 0; j < explodeBy; ++j) {
                explodeIndex[si++] = -i - 1 - et - j;
            }
            et += explodeBy - 1;
        }
        return new DefaultRowSetMerger(explodeIndex);
    }
}

