/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.series.BooleanBaseSeries;
import org.dflib.series.IntArraySeries;

public class TrueSeries
extends BooleanBaseSeries {
    private final int size;

    public TrueSeries(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean getBool(int index) {
        return true;
    }

    @Override
    public void copyToBool(boolean[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, true);
    }

    @Override
    public BooleanSeries materialize() {
        return this;
    }

    @Override
    public BooleanSeries rangeBool(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new TrueSeries(toExclusive - fromInclusive);
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.size > 0;
    }

    @Override
    public int firstTrue() {
        return this.size > 0 ? 0 : -1;
    }

    @Override
    public int firstFalse() {
        return -1;
    }

    @Override
    public int countTrue() {
        return 0;
    }

    @Override
    public int countFalse() {
        return this.size;
    }

    @Override
    public IntSeries cumSum() {
        int[] cumSum = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            cumSum[i] = i + 1;
        }
        return new IntArraySeries(cumSum);
    }
}

