/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Objects;
import org.dflib.Series;
import org.dflib.range.Range;
import org.dflib.series.EmptySeries;
import org.dflib.series.ObjectSeries;

public class SingleValueSeries<T>
extends ObjectSeries<T> {
    private final T value;
    private final int size;

    public SingleValueSeries(T value, int size) {
        super(value != null ? value.getClass() : Object.class);
        this.value = value;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Class<?> getInferredType() {
        return this.getNominalType();
    }

    @Override
    public T get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.value;
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, this.value);
    }

    @Override
    public Series<T> materialize() {
        return this;
    }

    @Override
    public Series<T> diff(Series<? extends T> other) {
        if (this.size == 0 || other.size() == 0) {
            return this;
        }
        for (T t : other) {
            if (!Objects.equals(this.value, t)) continue;
            return Series.of(new Object[0]);
        }
        return this;
    }

    @Override
    public Series<T> intersect(Series<? extends T> other) {
        if (this.size == 0) {
            return this;
        }
        if (other.size() == 0) {
            return other;
        }
        for (T t : other) {
            if (!Objects.equals(this.value, t)) continue;
            return this;
        }
        return Series.of(new Object[0]);
    }

    @Override
    public Series<T> selectRange(int fromInclusive, int toExclusive) {
        if (fromInclusive == toExclusive) {
            return new EmptySeries();
        }
        if (fromInclusive == 0 && toExclusive == this.size) {
            return this;
        }
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, this.size);
        return new SingleValueSeries<T>(this.value, toExclusive - fromInclusive);
    }

    @Override
    public Series<T> fillNulls(T value) {
        return this.value == null ? new SingleValueSeries<T>(value, this.size) : this;
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        return this.value == null ? this.alignAndReplace(values) : this;
    }

    @Override
    public Series<T> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<T> fillNullsForward() {
        return this;
    }

    private Series<T> alignAndReplace(Series<? extends T> another) {
        int as = another.size();
        if (this.size == as) {
            return another;
        }
        if (this.size < as) {
            return another.head(this.size);
        }
        throw new IllegalArgumentException("Another Series is smaller than this size: " + as + " < " + this.size);
    }
}

