/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.DataFrame;
import org.dflib.RowToValueMapper;
import org.dflib.Series;
import org.dflib.row.RowProxy;
import org.dflib.series.ArraySeries;
import org.dflib.series.ObjectSeries;

public class RowMappedSeries<T>
extends ObjectSeries<T> {
    private DataFrame source;
    private RowToValueMapper<T> mapper;
    private Series<T> materialized;

    public RowMappedSeries(DataFrame source, RowToValueMapper<T> mapper) {
        super(Object.class);
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public int size() {
        return this.source != null ? this.source.height() : this.materialize().size();
    }

    @Override
    public T get(int index) {
        return this.materialize().get(index);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyTo(to, fromOffset, toOffset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Series<T> materialize() {
        if (this.materialized == null) {
            RowMappedSeries rowMappedSeries = this;
            synchronized (rowMappedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.doMaterialize();
                }
            }
        }
        return this.materialized;
    }

    protected Series<T> doMaterialize() {
        Object[] data = new Object[this.source.height()];
        int i = 0;
        for (RowProxy row : this.source) {
            data[i++] = this.mapper.map(row);
        }
        this.source = null;
        this.mapper = null;
        return new ArraySeries<Object>(data);
    }

    @Override
    public Series<T> fillNulls(T value) {
        return this.materialize().fillNulls(value);
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        return this.materialize().fillNullsFromSeries(values);
    }

    @Override
    public Series<T> fillNullsBackwards() {
        return this.materialize().fillNullsBackwards();
    }

    @Override
    public Series<T> fillNullsForward() {
        return this.materialize().fillNullsForward();
    }
}

