/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.Series;
import org.dflib.range.Range;
import org.dflib.series.ArraySeries;
import org.dflib.series.ObjectSeries;

public class RangeSeries<T>
extends ObjectSeries<T> {
    private Series<T> delegate;
    private int offset;
    private int size;

    public RangeSeries(Series<T> delegate, int offset, int size) {
        super(delegate.getNominalType());
        this.delegate = delegate;
        this.offset = offset;
        this.size = size;
        Range.checkRange(offset, size, delegate.size());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.delegate.get(this.offset + index);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        this.delegate.copyTo(to, this.offset + fromOffset, toOffset, len);
    }

    @Override
    public Series<T> materialize() {
        Object[] range = new Object[this.size];
        this.delegate.copyTo(range, this.offset, 0, this.size);
        return new ArraySeries<Object>(range);
    }

    @Override
    public Series<T> fillNulls(T value) {
        return this.materialize().fillNulls(value);
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        return this.materialize().fillNullsFromSeries(values);
    }

    @Override
    public Series<T> fillNullsBackwards() {
        return this.materialize().fillNullsBackwards();
    }

    @Override
    public Series<T> fillNullsForward() {
        return this.materialize().fillNullsForward();
    }
}

