/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Objects;
import org.dflib.Series;
import org.dflib.series.ArraySeries;
import org.dflib.series.OffsetSeries;

public class OffsetLagSeries<T>
extends OffsetSeries<T> {
    private final int offset;

    public OffsetLagSeries(Series<T> delegate, int offset, T filler) {
        super(delegate, filler);
        if (offset >= 0) {
            throw new IllegalArgumentException("Expected negative offset: " + offset);
        }
        this.offset = offset;
    }

    @Override
    public Series<T> shift(int offset, T filler) {
        return offset < 0 && Objects.equals(filler, this.filler) ? new OffsetLagSeries<T>(this.delegate, this.offset + offset, filler) : super.shift(offset, filler);
    }

    @Override
    public T get(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (T)(index < size + this.offset ? this.delegate.get(index - this.offset) : this.filler);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        int size = this.size();
        if (fromOffset + len > size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        int delegateLen = Math.max(size - fromOffset + this.offset, 0);
        if (delegateLen > 0) {
            this.delegate.copyTo(to, fromOffset - this.offset, toOffset, Math.min(len, delegateLen));
        }
        if (len > delegateLen) {
            Arrays.fill(to, toOffset + delegateLen, toOffset + len, this.filler);
        }
    }

    @Override
    public Series<T> materialize() {
        int size = this.size();
        int splitPoint = size + this.offset;
        Object[] buffer = new Object[size];
        this.delegate.copyTo(buffer, -this.offset, 0, splitPoint);
        if (this.filler != null) {
            Arrays.fill(buffer, splitPoint, size, this.filler);
        }
        return new ArraySeries<Object>(buffer);
    }
}

