/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.EmptySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.IndexedSeries;
import org.dflib.series.RangeSeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;
import org.dflib.sort.SeriesSorter;

public abstract class ObjectSeries<T>
implements Series<T> {
    protected Class<?> nominalType;
    protected Class<?> inferredType;

    protected ObjectSeries(Class<?> nominalType) {
        this.nominalType = Objects.requireNonNull(nominalType);
    }

    @Override
    public Class<?> getNominalType() {
        return this.nominalType;
    }

    @Override
    public Class<?> getInferredType() {
        return this.inferredType != null ? this.inferredType : (this.inferredType = this.inferType());
    }

    protected Class<?> inferType() {
        Class type = null;
        Class<Object> terminal = Object.class;
        int size = this.size();
        for (int i = 0; i < size && type != terminal; ++i) {
            Object v = this.get(i);
            if (v == null) continue;
            type = type != null ? this.findMostSpecificCommonSuperclass(type, v.getClass()) : v.getClass();
        }
        return type != null ? type : Object.class;
    }

    private Class<?> findMostSpecificCommonSuperclass(Class<?> t1, Class<?> t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.isAssignableFrom(t2)) {
            return t1;
        }
        while ((t1 = t1.getSuperclass()) != null) {
            if (!t1.isAssignableFrom(t2)) continue;
            return t1;
        }
        return Object.class;
    }

    @Override
    public int position(T value) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(value, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<T> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public <S> Series<S> castAs(Class<S> type) {
        Class<?> inferredType = this.getInferredType();
        if (!type.isAssignableFrom(inferredType)) {
            throw new ClassCastException("Inferred type of Series elements " + inferredType.getName() + " can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public Series<T> selectRange(int fromInclusive, int toExclusive) {
        if (fromInclusive == toExclusive) {
            return new EmptySeries();
        }
        return fromInclusive == 0 && toExclusive == this.size() ? this : new RangeSeries(this, fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    @SafeVarargs
    public final Series<T> concat(Series<? extends T> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public Series<T> diff(Series<? extends T> other) {
        return Diff.diff(this, other);
    }

    @Override
    public Series<T> intersect(Series<? extends T> other) {
        return Intersect.intersect(this, other);
    }

    @Override
    public Series<T> head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.selectRange(0, len);
    }

    @Override
    public Series<T> tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.selectRange(size - len, size);
    }

    @Override
    public Series<T> select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public Series<T> select(IntSeries positions) {
        return new IndexedSeries(this, positions);
    }

    @Override
    public Series<T> select(Predicate<T> p) {
        int i;
        int len = this.size();
        for (i = 0; i < len && !p.test(this.get(i)); ++i) {
        }
        if (i == len) {
            return Series.of(new Object[0]);
        }
        ObjectAccum filtered = new ObjectAccum(len - i);
        filtered.push(this.get(i));
        ++i;
        while (i < len) {
            Object v = this.get(i);
            if (p.test(v)) {
                filtered.push(v);
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public Series<T> select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.of(new Object[0]);
        }
        ObjectAccum filtered = new ObjectAccum(len - i);
        filtered.push(this.get(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.push(this.get(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public Series<T> sort(Sorter ... sorters) {
        return new SeriesSorter(this).sort(sorters);
    }

    @Override
    public Series<T> sort(Comparator<? super T> comparator) {
        return new SeriesSorter<T>(this).sort(comparator);
    }

    @Override
    public IntSeries index(Predicate<T> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public Series<T> replace(IntSeries positions, Series<T> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        ObjectAccum<T> values = new ObjectAccum<T>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<T> replace(Map<T, T> oldToNewValues) {
        int len = this.size();
        Object[] replaced = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object val = this.get(i);
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<T> replace(BooleanSeries condition, T with) {
        int i;
        int s = this.size();
        int r = Math.min(s, condition.size());
        ObjectAccum values = new ObjectAccum(s);
        for (i = 0; i < r; ++i) {
            values.push(condition.getBool(i) ? with : this.get(i));
        }
        for (i = r; i < s; ++i) {
            values.push(this.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<T> replaceExcept(BooleanSeries condition, T with) {
        int s = this.size();
        int r = Math.min(s, condition.size());
        ObjectAccum<T> values = new ObjectAccum<T>(s);
        for (int i = 0; i < r; ++i) {
            values.push(condition.getBool(i) ? this.get(i) : with);
        }
        if (s > r) {
            values.fill(r, s, with);
        }
        return values.toSeries();
    }

    @Override
    public BooleanSeries isNull() {
        return BoolBuilder.buildSeries(i -> this.get(i) == null, this.size());
    }

    @Override
    public BooleanSeries isNotNull() {
        return BoolBuilder.buildSeries(i -> this.get(i) != null, this.size());
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int s = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(s);
        }
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(values));
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), s);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int s = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(s);
        }
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(values));
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), s);
    }

    @Override
    public Series<T> unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        Set unique = this.toSet();
        return unique.size() < this.size() ? new ArraySeries(unique.toArray(Object[]::new)) : this;
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsMaybeNulls(this);
    }

    @Override
    public SeriesGroupBy<T> group() {
        return this.group(t -> t);
    }

    @Override
    public SeriesGroupBy<T> group(ValueMapper<T, ?> by) {
        return new SeriesGrouper<T>(by).group(this);
    }

    @Override
    public Series<T> sample(int size) {
        return this.select(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public Series<T> sample(int size, Random random) {
        return this.select(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

