/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.series.IndexedSeries;
import org.dflib.series.LongArraySeries;
import org.dflib.series.LongBaseSeries;

public class LongIndexedSeries
extends LongBaseSeries {
    protected volatile Raw raw;
    protected volatile LongSeries materialized;

    public static Series<Long> of(LongSeries source, IntSeries includePositions) {
        int len = includePositions.size();
        for (int i = 0; i < len; ++i) {
            if (includePositions.getInt(i) >= 0) continue;
            return new IndexedSeries<Long>(source, includePositions);
        }
        return new LongIndexedSeries(source, includePositions);
    }

    public LongIndexedSeries(LongSeries source, IntSeries includePositions) {
        this.raw = new Raw(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public int size() {
        Raw raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public long getLong(int index) {
        Raw raw = this.raw;
        return raw != null ? raw.getLong(index) : this.materialized.getLong(index);
    }

    @Override
    public void copyToLong(long[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyToLong(to, fromOffset, toOffset, len);
    }

    @Override
    public LongSeries rangeLong(int fromInclusive, int toExclusive) {
        Raw raw = this.raw;
        return raw != null ? new LongIndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.rangeLong(fromInclusive, toExclusive);
    }

    @Override
    public LongSeries cumSum() {
        return this.materialize().cumSum();
    }

    @Override
    public long max() {
        return this.materialize().max();
    }

    @Override
    public long min() {
        return this.materialize().min();
    }

    @Override
    public long sum() {
        return this.materialize().sum();
    }

    @Override
    public double avg() {
        return this.materialize().avg();
    }

    @Override
    public double quantile(double q) {
        return this.materialize().quantile(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongSeries materialize() {
        if (this.materialized == null) {
            LongIndexedSeries longIndexedSeries = this;
            synchronized (longIndexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    protected static class Raw {
        final LongSeries source;
        final IntSeries includePositions;

        Raw(LongSeries source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        long getLong(int index) {
            return this.source.getLong(this.includePositions.getInt(index));
        }

        LongSeries materialize() {
            int h = this.includePositions.size();
            long[] data = new long[h];
            for (int i = 0; i < h; ++i) {
                data[i] = this.getLong(i);
            }
            return new LongArraySeries(data);
        }
    }
}

