/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.LongSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.LongArrayRangeSeries;
import org.dflib.series.LongBaseSeries;

public class LongArraySeries
extends LongBaseSeries {
    private final long[] data;

    public LongArraySeries(long ... data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public LongSeries add(LongSeries s) {
        if (!(s instanceof LongArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArraySeries as = (LongArraySeries)s;
        long[] l = this.data;
        long[] r = as.data;
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] + r[i];
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries sub(LongSeries s) {
        if (!(s instanceof LongArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArraySeries as = (LongArraySeries)s;
        long[] l = this.data;
        long[] r = as.data;
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] - r[i];
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries mul(LongSeries s) {
        if (!(s instanceof LongArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArraySeries as = (LongArraySeries)s;
        long[] l = this.data;
        long[] r = as.data;
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] * r[i];
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries div(LongSeries s) {
        if (!(s instanceof LongArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArraySeries as = (LongArraySeries)s;
        long[] l = this.data;
        long[] r = as.data;
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] / r[i];
        }
        return new LongArraySeries(data);
    }

    @Override
    public LongSeries mod(LongSeries s) {
        if (!(s instanceof LongArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        LongArraySeries as = (LongArraySeries)s;
        long[] l = this.data;
        long[] r = as.data;
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] % r[i];
        }
        return new LongArraySeries(data);
    }

    @Override
    public long getLong(int index) {
        return this.data[index];
    }

    @Override
    public void copyToLong(long[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size()) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, fromOffset, to, toOffset, len);
    }

    @Override
    public LongSeries rangeLong(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new LongArrayRangeSeries(this.data, fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public LongSeries materialize() {
        return this;
    }

    @Override
    public long max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, 0, this.size());
    }

    @Override
    public long min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, 0, this.size());
    }

    @Override
    public long sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, 0, this.size());
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, 0, this.size());
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, 0, this.size());
        return new LongArraySeries(cumSum);
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, 0, this.size(), q);
    }
}

