/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.IntArraySeries;
import org.dflib.series.IntBaseSeries;
import org.dflib.series.LongArraySeries;

public class IntSingleValueSeries
extends IntBaseSeries {
    private final int value;
    private final Integer boxedValue;
    private final int size;

    public IntSingleValueSeries(int value, int size) {
        this.value = value;
        this.size = size;
        this.boxedValue = value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer get(int index) {
        return this.boxedValue;
    }

    @Override
    public int getInt(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.value;
    }

    @Override
    public void copyToInt(int[] to, int fromOffset, int toOffset, int len) {
        Arrays.fill(to, toOffset, toOffset + len, this.value);
    }

    @Override
    public IntSeries diff(Series<? extends Integer> other) {
        if (this.size == 0 || other.size() == 0) {
            return this;
        }
        for (Integer n : other) {
            if (n == null || n != this.value) continue;
            return Series.ofInt(new int[0]);
        }
        return this;
    }

    @Override
    public IntSeries intersect(Series<? extends Integer> other) {
        if (this.size == 0) {
            return this;
        }
        if (other.size() == 0) {
            return Series.ofInt(new int[0]);
        }
        for (Integer n : other) {
            if (n == null || n != this.value) continue;
            return this;
        }
        return Series.ofInt(new int[0]);
    }

    @Override
    public IntSeries materialize() {
        return this;
    }

    @Override
    public IntSeries rangeInt(int fromInclusive, int toExclusive) {
        if (fromInclusive == toExclusive) {
            return new IntArraySeries(new int[0]);
        }
        if (fromInclusive == 0 && toExclusive == this.size) {
            return this;
        }
        Range.checkRange(fromInclusive, toExclusive - fromInclusive, this.size);
        return new IntSingleValueSeries(this.value, toExclusive - fromInclusive);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfValue(this.value, this.size);
        return new LongArraySeries(cumSum);
    }

    @Override
    public int max() {
        return this.value;
    }

    @Override
    public int min() {
        return this.value;
    }

    @Override
    public long sum() {
        return this.value * this.size;
    }

    @Override
    public double avg() {
        return this.value;
    }

    @Override
    public double median() {
        return this.value;
    }

    @Override
    public double quantile(double q) {
        return this.value;
    }
}

