/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.SeriesGroupBy;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.ValueToRowMapper;
import org.dflib.builder.BoolBuilder;
import org.dflib.builder.IntAccum;
import org.dflib.builder.ObjectAccum;
import org.dflib.builder.UniqueIntAccum;
import org.dflib.concat.SeriesConcat;
import org.dflib.groupby.SeriesGrouper;
import org.dflib.map.Mapper;
import org.dflib.sample.Sampler;
import org.dflib.series.ArraySeries;
import org.dflib.series.FalseSeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.ToString;
import org.dflib.series.TrueSeries;
import org.dflib.series.ValueCounts;
import org.dflib.sort.IntComparator;
import org.dflib.sort.IntTimSort;
import org.dflib.sort.SeriesSorter;

public abstract class IntBaseSeries
implements IntSeries {
    @Override
    public <S> Series<S> castAs(Class<S> type) {
        if (!type.isAssignableFrom(Integer.class) && !type.equals(Integer.TYPE)) {
            throw new ClassCastException("IntSeries can not be cast to " + String.valueOf(type));
        }
        return this;
    }

    @Override
    public Series<Integer> selectRange(int fromInclusive, int toExclusive) {
        return this.rangeInt(fromInclusive, toExclusive);
    }

    @Override
    public DataFrame map(Index resultColumns, ValueToRowMapper<Integer> mapper) {
        return Mapper.map(this, resultColumns, mapper);
    }

    @Override
    public IntSeries select(Predicate<Integer> p) {
        return this.selectInt(p::test);
    }

    @Override
    public IntSeries select(Condition condition) {
        return this.select((BooleanSeries)condition.eval((Series)this));
    }

    @Override
    public IntSeries select(BooleanSeries positions) {
        int i;
        int len = this.size();
        if (len != positions.size()) {
            throw new IllegalArgumentException("Positions size " + positions.size() + " is not the same as this size " + len);
        }
        for (i = 0; i < len && !positions.getBool(i); ++i) {
        }
        if (i == len) {
            return Series.ofInt(new int[0]);
        }
        IntAccum filtered = new IntAccum(len - i);
        filtered.pushInt(this.getInt(i));
        ++i;
        while (i < len) {
            if (positions.getBool(i)) {
                filtered.pushInt(this.getInt(i));
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public IntSeries selectInt(IntPredicate p) {
        int i;
        int len = this.size();
        for (i = 0; i < len && !p.test(this.getInt(i)); ++i) {
        }
        if (i == len) {
            return Series.ofInt(new int[0]);
        }
        IntAccum filtered = new IntAccum(len - i);
        filtered.pushInt(this.getInt(i));
        ++i;
        while (i < len) {
            int v = this.getInt(i);
            if (p.test(v)) {
                filtered.pushInt(v);
            }
            ++i;
        }
        return filtered.toSeries();
    }

    @Override
    public IntSeries sort(Sorter ... sorters) {
        return this.selectAsIntSeries(new SeriesSorter<Integer>(this).sortIndex(sorters));
    }

    @Override
    public IntSeries sort(Comparator<? super Integer> comparator) {
        return this.sortInt(comparator::compare);
    }

    @Override
    public IntSeries sortInt() {
        int size = this.size();
        int[] sorted = new int[size];
        this.copyToInt(sorted, 0, 0, size);
        Arrays.sort(sorted);
        return new IntArraySeries(sorted);
    }

    @Override
    public IntSeries sortInt(IntComparator comparator) {
        int size = this.size();
        int[] sorted = new int[size];
        this.copyToInt(sorted, 0, 0, size);
        IntTimSort.sort(sorted, comparator);
        return new IntArraySeries(sorted);
    }

    @Override
    public IntSeries sortIndex(Comparator<? super Integer> comparator) {
        return this.sortIndexInt(comparator::compare);
    }

    @Override
    public IntSeries sortIndexInt() {
        return this.doSortIndexInt((i1, i2) -> this.getInt(i1) - this.getInt(i2));
    }

    @Override
    public IntSeries sortIndexInt(IntComparator comparator) {
        return this.doSortIndexInt((i1, i2) -> comparator.compare(this.getInt(i1), this.getInt(i2)));
    }

    private IntSeries doSortIndexInt(IntComparator comparator) {
        int[] mutableIndex = SeriesSorter.rowNumberSequence(this.size());
        IntTimSort.sort(mutableIndex, comparator);
        return new IntArraySeries(mutableIndex);
    }

    private IntSeries selectAsIntSeries(IntSeries positions) {
        int h = positions.size();
        int[] data = new int[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = this.getInt(index);
        }
        return new IntArraySeries(data);
    }

    private Series<Integer> selectAsObjectSeries(IntSeries positions) {
        int h = positions.size();
        Integer[] data = new Integer[h];
        for (int i = 0; i < h; ++i) {
            int index = positions.getInt(i);
            data[i] = index < 0 ? null : Integer.valueOf(this.getInt(index));
        }
        return new ArraySeries<Integer>(data);
    }

    @Override
    public IntSeries concatInt(IntSeries ... other) {
        int size;
        if (other.length == 0) {
            return this;
        }
        int h = size = this.size();
        for (IntSeries s : other) {
            h += s.size();
        }
        int[] data = new int[h];
        this.copyToInt(data, 0, 0, size);
        int offset = size;
        for (IntSeries s : other) {
            int len = s.size();
            s.copyToInt(data, 0, offset, len);
            offset += len;
        }
        return new IntArraySeries(data);
    }

    @Override
    public Series<Integer> fillNulls(Integer value) {
        return this;
    }

    @Override
    public Series<Integer> fillNullsFromSeries(Series<? extends Integer> values) {
        return this;
    }

    @Override
    public Series<Integer> fillNullsBackwards() {
        return this;
    }

    @Override
    public Series<Integer> fillNullsForward() {
        return this;
    }

    @Override
    @SafeVarargs
    public final Series<Integer> concat(Series<? extends Integer> ... other) {
        if (other.length == 0) {
            return this;
        }
        Series[] combined = new Series[other.length + 1];
        combined[0] = this;
        System.arraycopy(other, 0, combined, 1, other.length);
        return SeriesConcat.concat(combined);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        for (int i = 0; i < len; ++i) {
            to[toOffset + i] = this.getInt(fromOffset + i);
        }
    }

    @Override
    public IntSeries indexInt(IntPredicate predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.getInt(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public IntSeries index(Predicate<Integer> predicate) {
        int len = this.size();
        IntAccum index = new IntAccum(len);
        for (int i = 0; i < len; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index.pushInt(i);
        }
        return index.toSeries();
    }

    @Override
    public BooleanSeries locateInt(IntPredicate predicate) {
        return BoolBuilder.buildSeries(i -> predicate.test(this.getInt(i)), this.size());
    }

    @Override
    public Series<Integer> replace(Map<Integer, Integer> oldToNewValues) {
        int len = this.size();
        int[] replaced = new int[len];
        for (int i = 0; i < len; ++i) {
            Integer val = this.getInt(i);
            Integer newVal = oldToNewValues.getOrDefault(val, val);
            if (newVal == null) {
                return this.replaceAsObjects(oldToNewValues);
            }
            replaced[i] = newVal;
        }
        return Series.ofInt(replaced);
    }

    private Series<Integer> replaceAsObjects(Map<Integer, Integer> oldToNewValues) {
        int len = this.size();
        Integer[] replaced = new Integer[len];
        for (int i = 0; i < len; ++i) {
            Integer val = this.getInt(i);
            replaced[i] = oldToNewValues.getOrDefault(val, val);
        }
        return Series.of(replaced);
    }

    @Override
    public Series<Integer> replace(IntSeries positions, Series<Integer> with) {
        int rs = positions.size();
        if (rs != with.size()) {
            throw new IllegalArgumentException("Positions size " + rs + " is not the same replacement Series size " + with.size());
        }
        if (rs == 0) {
            return this;
        }
        int s = this.size();
        if (with instanceof IntSeries) {
            IntSeries withInt = (IntSeries)with;
            IntAccum values = new IntAccum(s);
            values.fill(this, 0, 0, s);
            for (int i = 0; i < rs; ++i) {
                values.replace(positions.getInt(i), withInt.getInt(i));
            }
            return values.toSeries();
        }
        ObjectAccum<Integer> values = new ObjectAccum<Integer>(s);
        values.fill(this, 0, 0, s);
        for (int i = 0; i < rs; ++i) {
            values.replace(positions.getInt(i), with.get(i));
        }
        return values.toSeries();
    }

    @Override
    public Series<Integer> replace(BooleanSeries condition, Integer with) {
        return with != null ? this.replaceInt(condition, (int)with) : this.nullify(condition);
    }

    @Override
    public Series<Integer> replaceExcept(BooleanSeries condition, Integer with) {
        return with != null ? this.replaceNoMatchInt(condition, with) : this.nullifyNoMatch(condition);
    }

    private IntSeries replaceInt(BooleanSeries condition, int with) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        int[] data = new int[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? with : this.getInt(i);
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getInt(i);
        }
        return new IntArraySeries(data);
    }

    private IntSeries replaceNoMatchInt(BooleanSeries condition, int with) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        int[] data = new int[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? this.getInt(i) : with;
        }
        if (len > r) {
            Arrays.fill(data, r, len, with);
        }
        return new IntArraySeries(data);
    }

    private Series<Integer> nullify(BooleanSeries condition) {
        int i;
        int len = this.size();
        int r = Math.min(len, condition.size());
        Integer[] data = new Integer[len];
        for (i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? null : Integer.valueOf(this.getInt(i));
        }
        for (i = r; i < len; ++i) {
            data[i] = this.getInt(i);
        }
        return new ArraySeries<Integer>(data);
    }

    private Series<Integer> nullifyNoMatch(BooleanSeries condition) {
        int len = this.size();
        int r = Math.min(len, condition.size());
        Object[] data = new Integer[len];
        for (int i = 0; i < r; ++i) {
            data[i] = condition.getBool(i) ? Integer.valueOf(this.getInt(i)) : null;
        }
        if (len > r) {
            Arrays.fill(data, r, len, null);
        }
        return new ArraySeries<Integer>(data);
    }

    @Override
    public BooleanSeries in(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new FalseSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Integer)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new FalseSeries(len);
        }
        return BoolBuilder.buildSeries(i -> set.contains(this.get(i)), len);
    }

    @Override
    public BooleanSeries notIn(Object ... values) {
        int len = this.size();
        if (values == null || values.length == 0) {
            return new TrueSeries(len);
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : values) {
            if (!(o instanceof Integer)) continue;
            set.add(o);
        }
        if (set.isEmpty()) {
            return new TrueSeries(len);
        }
        return BoolBuilder.buildSeries(i -> !set.contains(this.get(i)), len);
    }

    @Override
    public IntSeries unique() {
        int size = this.size();
        if (size < 2) {
            return this;
        }
        UniqueIntAccum unique = new UniqueIntAccum();
        for (int i = 0; i < size; ++i) {
            unique.push(this.get(i));
        }
        return unique.size() < this.size() ? unique.toSeries() : this;
    }

    @Override
    public DataFrame valueCounts() {
        return ValueCounts.valueCountsNoNulls(this);
    }

    @Override
    public SeriesGroupBy<Integer> group() {
        return this.group((Integer i) -> i);
    }

    @Override
    public SeriesGroupBy<Integer> group(ValueMapper<Integer, ?> by) {
        return new SeriesGrouper<Integer>(by).group(this);
    }

    @Override
    public IntSeries sample(int size) {
        return this.selectAsIntSeries(Sampler.sampleIndex(size, this.size()));
    }

    @Override
    public IntSeries sample(int size, Random random) {
        return this.selectAsIntSeries(Sampler.sampleIndex(size, this.size(), random));
    }

    public String toString() {
        return ToString.toString(this);
    }
}

