/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.IntArrayRangeSeries;
import org.dflib.series.IntBaseSeries;
import org.dflib.series.LongArraySeries;

public class IntArraySeries
extends IntBaseSeries {
    private final int[] data;

    public IntArraySeries(int ... data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public IntSeries add(IntSeries s) {
        if (!(s instanceof IntArraySeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArraySeries as = (IntArraySeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] + r[i];
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries sub(IntSeries s) {
        if (!(s instanceof IntArraySeries)) {
            return super.sub(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArraySeries as = (IntArraySeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] - r[i];
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries mul(IntSeries s) {
        if (!(s instanceof IntArraySeries)) {
            return super.mul(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArraySeries as = (IntArraySeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] * r[i];
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries div(IntSeries s) {
        if (!(s instanceof IntArraySeries)) {
            return super.div(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArraySeries as = (IntArraySeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] / r[i];
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries mod(IntSeries s) {
        if (!(s instanceof IntArraySeries)) {
            return super.mod(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArraySeries as = (IntArraySeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = l[i] % r[i];
        }
        return new IntArraySeries(data);
    }

    @Override
    public int getInt(int index) {
        return this.data[index];
    }

    @Override
    public void copyToInt(int[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size()) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, fromOffset, to, toOffset, len);
    }

    @Override
    public IntSeries rangeInt(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new IntArrayRangeSeries(this.data, fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public IntSeries materialize() {
        return this;
    }

    @Override
    public int max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, 0, this.size());
    }

    @Override
    public int min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, 0, this.size());
    }

    @Override
    public long sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, 0, this.size());
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, 0, this.size());
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, 0, this.size(), q);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, 0, this.size());
        return new LongArraySeries(cumSum);
    }
}

