/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.IntSeries;
import org.dflib.LongSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.range.Range;
import org.dflib.series.IntArraySeries;
import org.dflib.series.IntBaseSeries;
import org.dflib.series.LongArraySeries;

public class IntArrayRangeSeries
extends IntBaseSeries {
    private final int[] data;
    private final int offset;
    private final int size;

    public IntArrayRangeSeries(int[] data, int offset, int size) {
        Range.checkRange(offset, size, data.length);
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IntSeries add(IntSeries s) {
        if (!(s instanceof IntArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArrayRangeSeries as = (IntArrayRangeSeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        int[] data = new int[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] + r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] + r[i];
            }
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries sub(IntSeries s) {
        if (!(s instanceof IntArrayRangeSeries)) {
            return super.sub(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArrayRangeSeries as = (IntArrayRangeSeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        int[] data = new int[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] - r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] - r[i];
            }
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries mul(IntSeries s) {
        if (!(s instanceof IntArrayRangeSeries)) {
            return super.mul(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArrayRangeSeries as = (IntArrayRangeSeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        int[] data = new int[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] * r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] * r[i];
            }
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries div(IntSeries s) {
        if (!(s instanceof IntArrayRangeSeries)) {
            return super.div(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArrayRangeSeries as = (IntArrayRangeSeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        int[] data = new int[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] / r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] / r[i];
            }
        }
        return new IntArraySeries(data);
    }

    @Override
    public IntSeries mod(IntSeries s) {
        if (!(s instanceof IntArrayRangeSeries)) {
            return super.mod(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        IntArrayRangeSeries as = (IntArrayRangeSeries)s;
        int[] l = this.data;
        int[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        int[] data = new int[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] % r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] % r[i];
            }
        }
        return new IntArraySeries(data);
    }

    @Override
    public int getInt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyToInt(int[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public IntSeries rangeInt(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new IntArrayRangeSeries(this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public IntSeries materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new IntArraySeries(this.data);
        }
        int[] data = new int[this.size];
        this.copyToInt(data, 0, 0, this.size);
        return new IntArraySeries(data);
    }

    @Override
    public int max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, this.offset, this.size);
    }

    @Override
    public int min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, this.offset, this.size);
    }

    @Override
    public long sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double quantile(double q) {
        return Percentiles.ofArray(this.data, this.offset, this.size, q);
    }

    @Override
    public LongSeries cumSum() {
        long[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, this.offset, this.size);
        return new LongArraySeries(cumSum);
    }
}

