/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.DoubleSeries;
import org.dflib.FloatSeries;
import org.dflib.agg.Percentiles;
import org.dflib.agg.PrimitiveSeriesAvg;
import org.dflib.agg.PrimitiveSeriesMinMax;
import org.dflib.agg.PrimitiveSeriesSum;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.FloatBaseSeries;

public class FloatArrayRangeSeries
extends FloatBaseSeries {
    private final float[] data;
    private final int offset;
    private final int size;

    public FloatArrayRangeSeries(float[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public FloatSeries add(FloatSeries s) {
        if (!(s instanceof FloatArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatArrayRangeSeries as = (FloatArrayRangeSeries)s;
        float[] l = this.data;
        float[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        float[] data = new float[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] + r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] + r[i];
            }
        }
        return new FloatArraySeries(data);
    }

    @Override
    public FloatSeries sub(FloatSeries s) {
        if (!(s instanceof FloatArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatArrayRangeSeries as = (FloatArrayRangeSeries)s;
        float[] l = this.data;
        float[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        float[] data = new float[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] - r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] - r[i];
            }
        }
        return new FloatArraySeries(data);
    }

    @Override
    public FloatSeries mul(FloatSeries s) {
        if (!(s instanceof FloatArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatArrayRangeSeries as = (FloatArrayRangeSeries)s;
        float[] l = this.data;
        float[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        float[] data = new float[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] * r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] * r[i];
            }
        }
        return new FloatArraySeries(data);
    }

    @Override
    public FloatSeries div(FloatSeries s) {
        if (!(s instanceof FloatArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatArrayRangeSeries as = (FloatArrayRangeSeries)s;
        float[] l = this.data;
        float[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        float[] data = new float[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] / r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] / r[i];
            }
        }
        return new FloatArraySeries(data);
    }

    @Override
    public FloatSeries mod(FloatSeries s) {
        if (!(s instanceof FloatArrayRangeSeries)) {
            return super.add(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatArrayRangeSeries as = (FloatArrayRangeSeries)s;
        float[] l = this.data;
        float[] r = as.data;
        int lo = this.offset;
        int ro = as.offset;
        float[] data = new float[len];
        if (lo > 0 || ro > 0) {
            for (int i = 0; i < len; ++i) {
                data[i] = l[lo + i] % r[ro + i];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                data[i] = l[i] % r[i];
            }
        }
        return new FloatArraySeries(data);
    }

    @Override
    public float getFloat(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[this.offset + index];
    }

    @Override
    public void copyToFloat(float[] to, int fromOffset, int toOffset, int len) {
        if (fromOffset + len > this.size) {
            throw new ArrayIndexOutOfBoundsException(fromOffset + len);
        }
        System.arraycopy(this.data, this.offset + fromOffset, to, toOffset, len);
    }

    @Override
    public FloatSeries rangeFloat(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new FloatArrayRangeSeries(this.data, this.offset + fromInclusive, toExclusive - fromInclusive);
    }

    @Override
    public FloatSeries materialize() {
        if (this.offset == 0 && this.size == this.data.length) {
            return new FloatArraySeries(this.data);
        }
        float[] data = new float[this.size];
        this.copyToFloat(data, 0, 0, this.size);
        return new FloatArraySeries(data);
    }

    @Override
    public float max() {
        return PrimitiveSeriesMinMax.maxOfArray(this.data, this.offset, this.size);
    }

    @Override
    public float min() {
        return PrimitiveSeriesMinMax.minOfArray(this.data, this.offset, this.size);
    }

    @Override
    public double sum() {
        return PrimitiveSeriesSum.sumOfArray(this.data, this.offset, this.size);
    }

    @Override
    public float avg() {
        return PrimitiveSeriesAvg.avgOfArray(this.data, this.offset, this.size);
    }

    @Override
    public float quantile(double q) {
        return Percentiles.ofArray(q, this.offset, this.size, this.data);
    }

    @Override
    public DoubleSeries cumSum() {
        double[] cumSum = PrimitiveSeriesSum.cumSumOfArray(this.data, this.offset, this.size);
        return new DoubleArraySeries(cumSum);
    }
}

