/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.DoubleSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.DoubleBaseSeries;
import org.dflib.series.IndexedSeries;

public class DoubleIndexedSeries
extends DoubleBaseSeries {
    protected volatile Raw raw;
    protected volatile DoubleSeries materialized;

    public static Series<Double> of(DoubleSeries source, IntSeries includePositions) {
        int len = includePositions.size();
        for (int i = 0; i < len; ++i) {
            if (includePositions.getInt(i) >= 0) continue;
            return new IndexedSeries<Double>(source, includePositions);
        }
        return new DoubleIndexedSeries(source, includePositions);
    }

    public DoubleIndexedSeries(DoubleSeries source, IntSeries includePositions) {
        this.raw = new Raw(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public int size() {
        Raw raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public double getDouble(int index) {
        Raw raw = this.raw;
        return raw != null ? raw.getDouble(index) : this.materialized.getDouble(index);
    }

    @Override
    public void copyToDouble(double[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyToDouble(to, fromOffset, toOffset, len);
    }

    @Override
    public DoubleSeries rangeDouble(int fromInclusive, int toExclusive) {
        Raw raw = this.raw;
        return raw != null ? new DoubleIndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.rangeDouble(fromInclusive, toExclusive);
    }

    @Override
    public DoubleSeries cumSum() {
        return this.materialize().cumSum();
    }

    @Override
    public double max() {
        return this.materialize().max();
    }

    @Override
    public double min() {
        return this.materialize().min();
    }

    @Override
    public double sum() {
        return this.materialize().sum();
    }

    @Override
    public double avg() {
        return this.materialize().avg();
    }

    @Override
    public double quantile(double q) {
        return this.materialize().quantile(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleSeries materialize() {
        if (this.materialized == null) {
            DoubleIndexedSeries doubleIndexedSeries = this;
            synchronized (doubleIndexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    protected static class Raw {
        final DoubleSeries source;
        final IntSeries includePositions;

        Raw(DoubleSeries source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        double getDouble(int index) {
            return this.source.getDouble(this.includePositions.getInt(index));
        }

        DoubleSeries materialize() {
            int h = this.includePositions.size();
            double[] data = new double[h];
            for (int i = 0; i < h; ++i) {
                data[i] = this.getDouble(i);
            }
            return new DoubleArraySeries(data);
        }
    }
}

