/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;
import org.dflib.row.RowProxy;
import org.dflib.series.ObjectSeries;

public class ByRowSeries
extends ObjectSeries<Object> {
    private DataFrame source;
    private final int width;
    private final int size;
    private Series<Object> materialized;

    public ByRowSeries(DataFrame source) {
        super(Object.class);
        this.source = source;
        this.width = source.width();
        this.size = this.width * source.height();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int index) {
        DataFrame source = this.source;
        if (source != null) {
            int row = index / this.width;
            int column = index % this.width;
            return source.getColumn(column).get(row);
        }
        return this.materialize().get(index);
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyTo(to, fromOffset, toOffset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Series<Object> materialize() {
        if (this.materialized == null) {
            ByRowSeries byRowSeries = this;
            synchronized (byRowSeries) {
                if (this.materialized == null) {
                    this.materialized = this.doMaterialize();
                }
            }
        }
        return this.materialized;
    }

    protected Series<Object> doMaterialize() {
        ObjectAccum<Object> data = new ObjectAccum<Object>(this.size);
        for (RowProxy r : this.source) {
            for (int i = 0; i < this.width; ++i) {
                data.push(r.get(i));
            }
        }
        this.source = null;
        return data.toSeries();
    }

    @Override
    public Series<Object> fillNulls(Object value) {
        return this.materialize().fillNulls(value);
    }

    @Override
    public Series<Object> fillNullsFromSeries(Series<?> values) {
        return this.materialize().fillNullsFromSeries(values);
    }

    @Override
    public Series<Object> fillNullsBackwards() {
        return this.materialize().fillNullsBackwards();
    }

    @Override
    public Series<Object> fillNullsForward() {
        return this.materialize().fillNullsForward();
    }
}

