/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Objects;
import org.dflib.BooleanSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.builder.BoolBuilder;
import org.dflib.series.BooleanBaseSeries;
import org.dflib.series.IndexedSeries;

public class BooleanIndexedSeries
extends BooleanBaseSeries {
    protected volatile Raw raw;
    protected volatile BooleanSeries materialized;

    public static Series<Boolean> of(BooleanSeries source, IntSeries includePositions) {
        int len = includePositions.size();
        for (int i = 0; i < len; ++i) {
            if (includePositions.getInt(i) >= 0) continue;
            return new IndexedSeries<Boolean>(source, includePositions);
        }
        return new BooleanIndexedSeries(source, includePositions);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public BooleanIndexedSeries(BooleanSeries source, IntSeries includePositions) {
        this.raw = new Raw(source, includePositions);
    }

    public boolean isMaterialized() {
        return this.materialized != null;
    }

    @Override
    public BooleanSeries concatBool(BooleanSeries ... other) {
        return other.length == 0 ? this : this.materialize().concatBool(other);
    }

    @Override
    public int size() {
        Raw raw = this.raw;
        return raw != null ? raw.size() : this.materialized.size();
    }

    @Override
    public boolean getBool(int index) {
        Raw raw = this.raw;
        return raw != null ? raw.getBool(index) : this.materialized.getBool(index);
    }

    @Override
    public void copyToBool(boolean[] to, int fromOffset, int toOffset, int len) {
        this.materialize().copyToBool(to, fromOffset, toOffset, len);
    }

    @Override
    public BooleanSeries rangeBool(int fromInclusive, int toExclusive) {
        Raw raw = this.raw;
        return raw != null ? new BooleanIndexedSeries(raw.source, raw.includePositions.rangeInt(fromInclusive, toExclusive)) : this.materialized.rangeBool(fromInclusive, toExclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanSeries materialize() {
        if (this.materialized == null) {
            BooleanIndexedSeries booleanIndexedSeries = this;
            synchronized (booleanIndexedSeries) {
                if (this.materialized == null) {
                    this.materialized = this.raw.materialize();
                    this.raw = null;
                }
            }
        }
        return this.materialized;
    }

    @Override
    public int firstTrue() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getBool(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int firstFalse() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.getBool(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int countTrue() {
        return this.materialize().countTrue();
    }

    @Override
    public int countFalse() {
        return this.materialize().countFalse();
    }

    @Override
    public IntSeries cumSum() {
        return this.materialize().cumSum();
    }

    protected static class Raw {
        final BooleanSeries source;
        final IntSeries includePositions;

        Raw(BooleanSeries source, IntSeries includePositions) {
            this.source = Objects.requireNonNull(source);
            this.includePositions = Objects.requireNonNull(includePositions);
        }

        int size() {
            return this.includePositions.size();
        }

        boolean getBool(int index) {
            return this.source.getBool(this.includePositions.getInt(index));
        }

        BooleanSeries materialize() {
            int h = this.includePositions.size();
            return BoolBuilder.buildSeries(this::getBool, h);
        }
    }
}

