/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.series;

import java.util.Arrays;
import org.dflib.Series;
import org.dflib.series.ArrayRangeSeries;
import org.dflib.series.ObjectSeries;

public class ArraySeries<T>
extends ObjectSeries<T> {
    private final T[] data;

    @SafeVarargs
    public ArraySeries(T ... data) {
        super(Object.class);
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public T get(int index) {
        return this.data[index];
    }

    @Override
    public void copyTo(Object[] to, int fromOffset, int toOffset, int len) {
        System.arraycopy(this.data, fromOffset, to, toOffset, len);
    }

    @Override
    public Series<T> materialize() {
        return this;
    }

    @Override
    public Series<T> fillNulls(T value) {
        int len = this.data.length;
        Object[] copy = null;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] != null) continue;
            if (copy == null) {
                copy = new Object[len];
                System.arraycopy(this.data, 0, copy, 0, len);
            }
            copy[i] = value;
        }
        return copy != null ? new ArraySeries<T>(copy) : this;
    }

    @Override
    public Series<T> fillNullsFromSeries(Series<? extends T> values) {
        int len = this.data.length;
        Object[] copy = null;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] != null) continue;
            if (copy == null) {
                copy = new Object[len];
                System.arraycopy(this.data, 0, copy, 0, len);
            }
            copy[i] = values.get(i);
        }
        return copy != null ? new ArraySeries<T>(copy) : this;
    }

    @Override
    public Series<T> fillNullsBackwards() {
        int len = this.data.length;
        Object[] copy = null;
        int fillFrom = -1;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] == null) {
                if (copy == null) {
                    copy = new Object[len];
                    System.arraycopy(this.data, 0, copy, 0, len);
                }
                if (fillFrom >= 0) continue;
                fillFrom = i;
                continue;
            }
            if (fillFrom < 0) continue;
            Arrays.fill(copy, fillFrom, i, this.data[i]);
            fillFrom = -1;
        }
        return copy != null ? new ArraySeries<T>(copy) : this;
    }

    @Override
    public Series<T> fillNullsForward() {
        int len = this.data.length;
        Object[] copy = null;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] != null || i == 0) continue;
            if (copy == null) {
                copy = new Object[len];
                System.arraycopy(this.data, 0, copy, 0, len);
            }
            copy[i] = copy[i - 1];
        }
        return copy != null ? new ArraySeries<T>(copy) : this;
    }

    @Override
    public Series<T> selectRange(int fromInclusive, int toExclusive) {
        return fromInclusive == 0 && toExclusive == this.size() ? this : new ArrayRangeSeries<T>(this.getNominalType(), this.data, fromInclusive, toExclusive - fromInclusive);
    }
}

