/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.row;

import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.builder.ValueHolder;
import org.dflib.row.RowBuilder;
import org.dflib.row.RowProxy;

public class ValueHolderRowProxy<S>
implements RowProxy {
    private final Index index;
    private final ValueExtractor<S, ?>[] row;

    public ValueHolderRowProxy(Index index, Extractor<S, ?>[] extractors) {
        this.index = index;
        this.row = this.createRow(extractors);
    }

    private ValueExtractor<S, ?>[] createRow(Extractor<S, ?>[] extractors) {
        int w = extractors.length;
        ValueExtractor[] row = new ValueExtractor[w];
        for (int i = 0; i < w; ++i) {
            row[i] = new ValueExtractor(extractors[i]);
        }
        return row;
    }

    public void reset(S source) {
        int w = this.row.length;
        for (int i = 0; i < w; ++i) {
            this.row[i].reset(source);
        }
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public Object get(int columnPos) {
        return this.row[columnPos].holder.get();
    }

    @Override
    public Object get(String columnName) {
        return this.row[this.index.position((String)columnName)].holder.get();
    }

    @Override
    public int getInt(int columnPos) {
        return (Integer)this.row[columnPos].holder.get();
    }

    @Override
    public int getInt(String columnName) {
        return this.getInt(this.index.position(columnName));
    }

    @Override
    public long getLong(int columnPos) {
        return (Long)this.row[columnPos].holder.get();
    }

    @Override
    public long getLong(String columnName) {
        return this.getLong(this.index.position(columnName));
    }

    @Override
    public double getDouble(int columnPos) {
        return (Double)this.row[columnPos].holder.get();
    }

    @Override
    public double getDouble(String columnName) {
        return this.getDouble(this.index.position(columnName));
    }

    @Override
    public boolean getBool(int columnPos) {
        return (Boolean)this.row[columnPos].holder.get();
    }

    @Override
    public boolean getBool(String columnName) {
        return this.getBool(this.index.position(columnName));
    }

    @Override
    public void copyRange(RowBuilder to, int fromOffset, int toOffset, int len) {
        throw new UnsupportedOperationException("Not supported");
    }

    static class ValueExtractor<S, T> {
        private final Extractor<S, T> extractor;
        private final ValueHolder<T> holder;

        ValueExtractor(Extractor<S, T> extractor) {
            this.extractor = extractor;
            this.holder = extractor.createHolder();
        }

        void reset(S s) {
            this.extractor.extractAndStore(s, this.holder);
        }
    }
}

