/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.row;

import org.dflib.Index;
import org.dflib.Series;
import org.dflib.row.RowBuilder;
import org.dflib.series.ArraySeries;

public class MultiArrayRowBuilder
implements RowBuilder {
    private final Index index;
    private final Object[][] data;
    private int rowIndex;

    public MultiArrayRowBuilder(Index index, int height) {
        this.index = index;
        this.data = new Object[index.size()][height];
        this.rowIndex = -1;
    }

    public void next() {
        ++this.rowIndex;
    }

    public void next(int index) {
        this.rowIndex = index;
    }

    public void fill(int column, Series<?> values, int valuesOffset, int builderOffset, int len) {
        values.copyTo(this.data[column], valuesOffset, builderOffset, len);
    }

    public Series<?>[] getData() {
        int w = this.index.size();
        Series[] series = new Series[w];
        for (int i = 0; i < w; ++i) {
            series[i] = new ArraySeries<Object>(this.data[i]);
        }
        return series;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public RowBuilder set(String columnName, Object value) {
        this.data[this.index.position((String)columnName)][this.rowIndex] = value;
        return this;
    }

    @Override
    public RowBuilder set(int columnPos, Object value) {
        this.data[columnPos][this.rowIndex] = value;
        return this;
    }

    @Override
    public RowBuilder setRange(Object[] values, int fromOffset, int toOffset, int len) {
        if (len + toOffset > this.index.size()) {
            throw new IllegalArgumentException("Provided values won't fit in the row: " + (len + toOffset) + " > " + this.index.size());
        }
        for (int i = 0; i < len; ++i) {
            this.data[toOffset + i][this.rowIndex] = values[fromOffset + i];
        }
        return this;
    }
}

