/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.row;

import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.row.RowBuilder;
import org.dflib.series.ArraySeries;

public class DynamicColsRowBuilder
implements RowBuilder {
    private final Map<String, Object[]> columns = new LinkedHashMap<String, Object[]>();
    private final int height;
    private int rowIndex;

    public DynamicColsRowBuilder(int height) {
        this.height = height;
        this.rowIndex = -1;
    }

    public void next() {
        ++this.rowIndex;
    }

    public String[] getLabels() {
        return this.columns.keySet().toArray(new String[0]);
    }

    public Series<?>[] getData() {
        int w = this.columns.size();
        Series[] series = new Series[w];
        Iterator<Object[]> it = this.columns.values().iterator();
        for (int i = 0; i < w; ++i) {
            series[i] = new ArraySeries<Object>(it.next());
        }
        return series;
    }

    @Override
    public Index getIndex() {
        throw new UnsupportedOperationException("Access to index is not supported by DynamicColsRowBuilder");
    }

    @Override
    public RowBuilder set(String columnName, Object value) {
        this.columns.computeIfAbsent((String)columnName, (Function<String, Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$set$0(java.lang.String ), (Ljava/lang/String;)[Ljava/lang/Object;)((DynamicColsRowBuilder)this))[this.rowIndex] = value;
        return this;
    }

    @Override
    public RowBuilder set(int columnPos, Object value) {
        throw new UnsupportedOperationException("'set' by position is not supported by DynamicColsRowBuilder. Use 'set(String..)' instead");
    }

    @Override
    public RowBuilder setRange(Object[] values, int fromOffset, int toOffset, int len) {
        throw new UnsupportedOperationException("'setRange' is not supported by DynamicColsRowBuilder. Use 'set(String..)' instead");
    }

    private /* synthetic */ Object[] lambda$set$0(String n) {
        return new Object[this.height];
    }
}

