/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.print;

import org.dflib.Series;
import org.dflib.print.BasePrintWorker;
import org.dflib.print.SeriesTruncator;

public class SeriesInlinePrintWorker
extends BasePrintWorker {
    public SeriesInlinePrintWorker(StringBuilder out, int maxDisplayRows, int maxDisplayColumnWidth) {
        super(out, maxDisplayRows, maxDisplayColumnWidth);
    }

    public StringBuilder print(Series<?> s) {
        if (s == null) {
            this.out.append("null");
            return this.out;
        }
        SeriesTruncator<?> truncator = SeriesTruncator.create(s, this.maxDisplayRows);
        Series<?> head = truncator.head();
        int hs = head.size();
        for (int i = 0; i < hs; ++i) {
            if (i > 0) {
                this.out.append(",");
            }
            this.appendTruncate(String.valueOf(s.get(i)));
        }
        if (truncator.isTruncated()) {
            this.out.append(",...");
            Series<?> tail = truncator.tail();
            int ts = tail.size();
            for (int i = 0; i < ts; ++i) {
                this.out.append(",");
                String val = String.valueOf(tail.get(i));
                this.appendTruncate(val);
            }
        }
        return this.out;
    }
}

