/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.pivot;

import java.util.ArrayList;
import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.GroupBy;
import org.dflib.Series;

public class PivotBuilder {
    private static final Exp<?> oneValueAgg = Exp.$col(0).agg(PivotBuilder::oneValueAggregator);
    private final DataFrame dataFrame;
    private int columnForColumns = -1;
    private int columnForRows = -1;

    public PivotBuilder(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    private static <T> T oneValueAggregator(Series<? extends T> series) {
        switch (series.size()) {
            case 0: {
                throw new IllegalArgumentException("Unexpected empty Series");
            }
            case 1: {
                return series.get(0);
            }
        }
        throw new IllegalArgumentException("Duplicate rows in the pivot table. Consider passing an explicit aggregator to the pivot operation.");
    }

    public PivotBuilder cols(String columnName) {
        this.columnForColumns = this.validateColumn(columnName);
        return this;
    }

    public PivotBuilder cols(int columnPos) {
        this.columnForColumns = this.validateColumn(columnPos);
        return this;
    }

    public PivotBuilder rows(String columnName) {
        this.columnForRows = this.validateColumn(columnName);
        return this;
    }

    public PivotBuilder rows(int columnPos) {
        this.columnForRows = this.validateColumn(columnPos);
        return this;
    }

    public DataFrame vals(String columnName) {
        int pos = this.validateColumn(columnName);
        return this.doPivot(pos, oneValueAgg);
    }

    public DataFrame vals(int columnPos) {
        return this.doPivot(columnPos, oneValueAgg);
    }

    public <T> DataFrame vals(String columnName, Exp<T> valuesAggregator) {
        int pos = this.validateColumn(columnName);
        return this.doPivot(pos, valuesAggregator);
    }

    public <T> DataFrame vals(int columnPos, Exp<T> valuesAggregator) {
        return this.doPivot(columnPos, valuesAggregator);
    }

    protected <T> DataFrame doPivot(int columnPos, Exp<T> valuesAggregator) {
        Objects.requireNonNull(valuesAggregator, "Null 'valuesAggregator'");
        int columnForValues = this.validateColumn(columnPos);
        if (this.columnForColumns < 0) {
            throw new IllegalStateException("Column for pivot columns is not specified. Call 'columns(..)'.");
        }
        if (this.columnForRows < 0) {
            throw new IllegalStateException("Column for pivot rows is not specified. Call 'rows(..)'.");
        }
        String rowColumnName = this.dataFrame.getColumnsIndex().get(this.columnForRows);
        GroupBy byColumn = this.dataFrame.group(this.columnForColumns);
        ArrayList<DataFrame> chunks = new ArrayList<DataFrame>(byColumn.size());
        for (Object col : byColumn.getGroupKeys()) {
            DataFrame byColumnDf = byColumn.getGroup(col);
            DataFrame pivotChunk = DataFrame.byColumn(rowColumnName, col.toString()).of(byColumnDf.getColumn(this.columnForRows), byColumnDf.getColumn(columnForValues)).map(df -> this.aggregateChunk((DataFrame)df, valuesAggregator));
            chunks.add(pivotChunk);
        }
        switch (chunks.size()) {
            case 0: {
                return DataFrame.empty(rowColumnName);
            }
            case 1: {
                return (DataFrame)chunks.get(0);
            }
        }
        return chunks.stream().reduce(this::joinChunks).orElseGet(() -> this.empty(rowColumnName));
    }

    private DataFrame joinChunks(DataFrame left, DataFrame right) {
        int rightRowPos = left.width();
        return left.fullJoin(right).on(0).select().cols(0).fillNullsWithExp(Exp.$col(rightRowPos)).cols(rightRowPos).drop();
    }

    private DataFrame empty(String rowColumnName) {
        return DataFrame.empty(rowColumnName);
    }

    private <T> DataFrame aggregateChunk(DataFrame chunk, Exp<T> aggregator) {
        String rowColumnName = chunk.getColumnsIndex().get(0);
        String valueColumnName = chunk.getColumnsIndex().get(1);
        Exp[] expArray = new Exp[2];
        expArray[0] = Exp.$col(rowColumnName).first().as(rowColumnName);
        expArray[1] = Exp.$col(valueColumnName).agg(aggregator::reduce).as(valueColumnName);
        return chunk.group(rowColumnName).agg(expArray);
    }

    private int validateColumn(String name) {
        return this.dataFrame.getColumnsIndex().position(name);
    }

    private int validateColumn(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative column position: " + pos);
        }
        if (this.dataFrame.width() <= pos) {
            throw new IllegalArgumentException("Column position " + pos + " is out of bounds. DataFrame width: " + this.dataFrame.width());
        }
        return pos;
    }
}

