/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.join;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.dflib.Index;
import org.dflib.join.JoinColumn;

class JoinIndex {
    private final Set<String> uniqueNames;
    private final JoinColumn[] columns;
    private Map<String, JoinColumn> columnsByAllPossibleAliases;

    static JoinIndex of(String leftAlias, String rightAlias, Index leftIndex, Index rightIndex, String indicatorColumn) {
        String aliasedName;
        String name;
        int baseLen = leftIndex.size() + rightIndex.size();
        int len = indicatorColumn != null ? baseLen + 1 : baseLen;
        String lp = leftAlias != null ? leftAlias + "." : null;
        String rp = rightAlias != null ? rightAlias + "." : null;
        HashSet<String> uniqueNames = new HashSet<String>();
        JoinColumn[] columns = new JoinColumn[len];
        int i = 0;
        for (String label : leftIndex) {
            name = JoinIndex.uniqueName(uniqueNames, label);
            aliasedName = lp != null ? JoinIndex.uniqueName(uniqueNames, lp + label) : null;
            columns[i] = new JoinColumn(i, name, aliasedName, null);
            ++i;
        }
        for (String label : rightIndex) {
            name = JoinIndex.uniqueName(uniqueNames, label);
            aliasedName = rp != null ? JoinIndex.uniqueName(uniqueNames, rp + label) : null;
            columns[i] = new JoinColumn(i, name, aliasedName, null);
            ++i;
        }
        if (indicatorColumn != null) {
            String name2 = JoinIndex.uniqueName(uniqueNames, indicatorColumn);
            columns[i] = new JoinColumn(i, name2, null, null);
        }
        return new JoinIndex(columns, uniqueNames);
    }

    private static String uniqueName(Set<String> uniqueNames, String name) {
        while (!uniqueNames.add((String)name)) {
            name = (String)name + "_";
        }
        return name;
    }

    private JoinIndex(JoinColumn[] columns, Set<String> uniqueNames) {
        this.columns = columns;
        this.uniqueNames = uniqueNames;
    }

    public int size() {
        return this.columns.length;
    }

    public Index getIndex() {
        int len = this.columns.length;
        String[] labels = new String[len];
        for (int i = 0; i < len; ++i) {
            labels[i] = this.columns[i].indexName();
        }
        return Index.of(labels);
    }

    public int[] getPositions() {
        int len = this.columns.length;
        int[] pos = new int[len];
        for (int i = 0; i < len; ++i) {
            pos[i] = this.columns[i].pos;
        }
        return pos;
    }

    public JoinIndex cols(int ... csIndex) {
        int sLen = this.columns.length;
        int csLen = csIndex.length;
        JoinColumn[] cols = new JoinColumn[csLen];
        for (int i = 0; i < csLen; ++i) {
            cols[i] = csIndex[i] < sLen ? this.columns[csIndex[i]] : this.createColumn(String.valueOf(csIndex[i]), csIndex[i]);
        }
        return new JoinIndex(cols, this.uniqueNames);
    }

    public JoinIndex cols(String ... labels) {
        int len = labels.length;
        JoinColumn[] cols = new JoinColumn[len];
        int extras = this.columns.length;
        for (int i = 0; i < len; ++i) {
            String name = labels[i];
            JoinColumn c = this.resolveColumn(name);
            cols[i] = c != null ? c.nameResult(name) : this.createColumn(name, extras++);
        }
        return new JoinIndex(cols, this.uniqueNames);
    }

    public JoinIndex cols(Predicate<String> predicate) {
        ArrayList<JoinColumn> cols = new ArrayList<JoinColumn>(this.columns.length);
        for (JoinColumn column : this.columns) {
            if (!column.test(predicate)) continue;
            cols.add(column);
        }
        return new JoinIndex(cols.toArray(new JoinColumn[0]), this.uniqueNames);
    }

    public JoinIndex colsExcept(Predicate<String> predicate) {
        ArrayList<JoinColumn> included = new ArrayList<JoinColumn>(this.columns.length);
        for (JoinColumn column : this.columns) {
            if (column.test(predicate)) continue;
            included.add(column);
        }
        return new JoinIndex(included.toArray(new JoinColumn[0]), this.uniqueNames);
    }

    public JoinIndex colsExcept(int ... positions) {
        int exceptLen = positions.length;
        if (exceptLen == 0) {
            return this;
        }
        HashSet<Integer> excludes = new HashSet<Integer>((int)Math.ceil((double)exceptLen / 0.75));
        for (int e : positions) {
            excludes.add(e);
        }
        ArrayList<JoinColumn> included = new ArrayList<JoinColumn>(this.columns.length - excludes.size());
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            if (excludes.contains(i)) continue;
            included.add(this.columns[i]);
        }
        return new JoinIndex(included.toArray(new JoinColumn[0]), this.uniqueNames);
    }

    public JoinIndex colsExcept(String ... labels) {
        if (labels.length == 0) {
            return this;
        }
        Set<String> excludes = Set.of(labels);
        ArrayList<JoinColumn> included = new ArrayList<JoinColumn>(this.columns.length - excludes.size());
        for (JoinColumn c : this.columns) {
            if (c.testIn(excludes)) continue;
            included.add(c);
        }
        return new JoinIndex(included.toArray(new JoinColumn[0]), this.uniqueNames);
    }

    public JoinIndex colsExpandAliases() {
        ArrayList<JoinColumn> expanded = new ArrayList<JoinColumn>(this.columns.length * 2);
        for (JoinColumn c : this.columns) {
            expanded.add(c);
            if (c.prefixedName == null) continue;
            expanded.add(c.unalias());
        }
        return new JoinIndex(expanded.toArray(new JoinColumn[0]), this.uniqueNames);
    }

    private JoinColumn resolveColumn(String label) {
        if (this.columnsByAllPossibleAliases == null) {
            HashMap<String, JoinColumn> map = new HashMap<String, JoinColumn>();
            for (JoinColumn c : this.columns) {
                map.put(c.name, c);
                if (c.prefixedName == null) continue;
                map.put(c.prefixedName, c);
            }
            this.columnsByAllPossibleAliases = map;
        }
        return this.columnsByAllPossibleAliases.get(label);
    }

    private JoinColumn createColumn(String label, int pos) {
        String name = this.uniqueName(label);
        return new JoinColumn(pos, name, null, name);
    }

    private String uniqueName(String name) {
        return JoinIndex.uniqueName(this.uniqueNames, name);
    }
}

