/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.join;

import java.util.Set;
import java.util.function.Predicate;

class JoinColumn {
    final int pos;
    final String name;
    final String prefixedName;
    private final String resultName;

    JoinColumn(int pos, String name, String prefixedName, String resultName) {
        this.pos = pos;
        this.name = name;
        this.prefixedName = prefixedName;
        this.resultName = resultName;
    }

    JoinColumn nameResult(String resultName) {
        return new JoinColumn(this.pos, this.name, this.prefixedName, resultName);
    }

    JoinColumn unalias() {
        return new JoinColumn(this.pos, this.name, this.name, null);
    }

    String indexName() {
        return this.resultName != null ? this.resultName : (this.prefixedName != null ? this.prefixedName : this.name);
    }

    boolean test(Predicate<String> predicate) {
        return predicate.test(this.name) || this.prefixedName != null && predicate.test(this.prefixedName);
    }

    boolean testIn(Set<String> names) {
        return names.contains(this.name) || this.prefixedName != null && names.contains(this.prefixedName);
    }

    public String toString() {
        return "[" + this.pos + "," + this.indexName() + "]";
    }
}

