/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.join;

import java.util.LinkedHashSet;
import org.dflib.DataFrame;
import org.dflib.GroupBy;
import org.dflib.Hasher;
import org.dflib.IntSeries;
import org.dflib.JoinType;
import org.dflib.builder.IntAccum;
import org.dflib.join.BaseJoiner;
import org.dflib.row.RowProxy;

public class HashJoiner
extends BaseJoiner {
    private final Hasher leftHasher;
    private final Hasher rightHasher;

    public HashJoiner(Hasher leftHasher, Hasher rightHasher, JoinType semantics) {
        super(semantics);
        this.leftHasher = leftHasher;
        this.rightHasher = rightHasher;
    }

    @Override
    protected IntSeries[] innerJoin(DataFrame lf, DataFrame rf) {
        IntAccum li = new IntAccum();
        IntAccum ri = new IntAccum();
        GroupBy rightIndex = rf.group(this.rightHasher);
        int i = 0;
        for (RowProxy lr : lf) {
            Object lKey = this.leftHasher.map(lr);
            IntSeries rgi = rightIndex.getGroupIndex(lKey);
            if (rgi != null) {
                int js = rgi.size();
                for (int j = 0; j < js; ++j) {
                    li.pushInt(i);
                    ri.pushInt(rgi.getInt(j));
                }
            }
            ++i;
        }
        return new IntSeries[]{li.toSeries(), ri.toSeries()};
    }

    @Override
    protected IntSeries[] leftJoin(DataFrame lf, DataFrame rf) {
        IntAccum li = new IntAccum();
        IntAccum ri = new IntAccum();
        GroupBy rightIndex = rf.group(this.rightHasher);
        int i = 0;
        for (RowProxy lr : lf) {
            Object lKey = this.leftHasher.map(lr);
            IntSeries rgi = rightIndex.getGroupIndex(lKey);
            if (rgi != null) {
                int js = rgi.size();
                for (int j = 0; j < js; ++j) {
                    li.pushInt(i);
                    ri.pushInt(rgi.getInt(j));
                }
            } else {
                li.pushInt(i);
                ri.pushInt(-1);
            }
            ++i;
        }
        return new IntSeries[]{li.toSeries(), ri.toSeries()};
    }

    @Override
    protected IntSeries[] rightJoin(DataFrame lf, DataFrame rf) {
        IntAccum li = new IntAccum();
        IntAccum ri = new IntAccum();
        GroupBy leftIndex = lf.group(this.leftHasher);
        int i = 0;
        for (RowProxy rr : rf) {
            Object rKey = this.rightHasher.map(rr);
            IntSeries lgi = leftIndex.getGroupIndex(rKey);
            if (lgi != null) {
                int js = lgi.size();
                for (int j = 0; j < js; ++j) {
                    li.pushInt(lgi.getInt(j));
                    ri.pushInt(i);
                }
            } else {
                li.pushInt(-1);
                ri.pushInt(i);
            }
            ++i;
        }
        return new IntSeries[]{li.toSeries(), ri.toSeries()};
    }

    @Override
    protected IntSeries[] fullJoin(DataFrame lf, DataFrame rf) {
        IntAccum li = new IntAccum();
        IntAccum ri = new IntAccum();
        GroupBy rightIndex = rf.group(this.rightHasher);
        LinkedHashSet<Object> seenRightKeys = new LinkedHashSet<Object>();
        int i = 0;
        for (RowProxy lr : lf) {
            Object lKey = this.leftHasher.map(lr);
            IntSeries rgi = rightIndex.getGroupIndex(lKey);
            if (rgi != null) {
                seenRightKeys.add(lKey);
                int js = rgi.size();
                for (int j = 0; j < js; ++j) {
                    li.pushInt(i);
                    ri.pushInt(rgi.getInt(j));
                }
            } else {
                li.pushInt(i);
                ri.pushInt(-1);
            }
            ++i;
        }
        for (Object key : rightIndex.getGroupKeys()) {
            if (seenRightKeys.contains(key)) continue;
            IntSeries rgi = rightIndex.getGroupIndex(key);
            int js = rgi.size();
            for (int j = 0; j < js; ++j) {
                li.pushInt(-1);
                ri.pushInt(rgi.getInt(j));
            }
        }
        return new IntSeries[]{li.toSeries(), ri.toSeries()};
    }
}

