/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.http;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dflib.ByteSource;
import org.dflib.http.HttpByteSource;

public class Http {
    final String url;
    final Map<String, Set<Object>> headers;
    final Map<String, Set<Object>> queryParams;

    public static Http of(String url) {
        return new Http(url, Map.of(), Map.of());
    }

    private Http(String url, Map<String, Set<Object>> headers, Map<String, Set<Object>> queryParams) {
        this.url = Objects.requireNonNull(url);
        this.headers = Objects.requireNonNull(headers);
        this.queryParams = Objects.requireNonNull(queryParams);
    }

    public Http path(String path) {
        return new Http(Http.concatUrls(this.url, path), this.headers, this.queryParams);
    }

    public Http queryParam(String name, Object ... values) {
        return new Http(this.url, this.headers, Http.appendToMap(this.queryParams, name, values));
    }

    public Http header(String name, Object values) {
        return new Http(this.url, Http.appendToMap(this.headers, name, values), this.queryParams);
    }

    public ByteSource source() {
        return new HttpByteSource(this.createClient(), this.createRequest());
    }

    private HttpClient createClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    }

    private HttpRequest createRequest() {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(this.createURI()));
        this.headers.forEach((n, vs) -> vs.forEach(v -> builder.header((String)n, Http.encodeHeader(v))));
        return builder.build();
    }

    String createURI() {
        String tail;
        if (this.queryParams.isEmpty()) {
            return this.url;
        }
        StringBuilder uri = new StringBuilder(this.url);
        String string = tail = uri.indexOf("?") > 0 ? "&" : "?";
        if (!this.url.endsWith(tail)) {
            uri.append(tail);
        }
        this.queryParams.forEach((n, vs) -> vs.forEach(v -> uri.append((String)n).append("=").append(Http.encodeQueryParam(v)).append("&")));
        return uri.deleteCharAt(uri.length() - 1).toString();
    }

    private static String encodeHeader(Object value) {
        return value != null ? value.toString() : "";
    }

    private static String encodeQueryParam(Object value) {
        return value != null ? URLEncoder.encode(value.toString(), StandardCharsets.UTF_8) : "";
    }

    static String concatUrls(String base, String path) {
        if (base == null || ((String)base).length() == 0) {
            base = "/";
        }
        if (path == null || path.length() == 0) {
            return base;
        }
        if (!((String)base).endsWith("/")) {
            base = (String)base + "/";
        }
        if (path == null) {
            path = "";
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return (String)base + path;
    }

    static Map<String, Set<Object>> appendToMap(Map<String, Set<Object>> source, String key, Object ... vals) {
        if (vals == null || vals.length == 0) {
            return source;
        }
        LinkedHashMap<String, Set<Object>> result = new LinkedHashMap<String, Set<Object>>((int)(1.0 + (double)source.size() / 0.75));
        source.forEach((k, v) -> result.put((String)k, new LinkedHashSet(v)));
        result.computeIfAbsent(key, k -> new LinkedHashSet()).addAll(Arrays.asList(vals));
        return result;
    }
}

