/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.LongSeries;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.DoubleAggregators;
import org.dflib.exp.agg.DoubleReduceExp1;
import org.dflib.exp.agg.LongAggregators;
import org.dflib.exp.agg.LongReduceExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.LongCondition2;
import org.dflib.exp.num.LongCondition3;
import org.dflib.exp.num.LongExp1;
import org.dflib.exp.num.LongExp2;
import org.dflib.exp.num.NumericExpFactory;

public class LongExpFactory
extends NumericExpFactory {
    protected static Exp<Long> cast(Exp<?> exp) {
        Class<?> t = exp.getType();
        if (t.equals(Long.class)) {
            return exp;
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<Long> nExp = exp;
            return LongExp1.mapVal("castAsLong", nExp, Number::longValue);
        }
        if (t.equals(String.class)) {
            Exp<Long> sExp = exp;
            return LongExp1.mapVal("castAsLong", sExp, Long::parseLong);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to Long");
    }

    @Override
    public NumExp<?> add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongExp2.mapVal("+", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 + n2, LongSeries::add);
    }

    @Override
    public NumExp<?> sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongExp2.mapVal("-", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 - n2, LongSeries::sub);
    }

    @Override
    public NumExp<?> mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongExp2.mapVal("*", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 * n2, LongSeries::mul);
    }

    @Override
    public NumExp<?> div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongExp2.mapVal("/", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 / n2, LongSeries::div);
    }

    @Override
    public NumExp<?> mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongExp2.mapVal("%", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 % n2, LongSeries::mod);
    }

    @Override
    public NumExp<?> abs(Exp<? extends Number> exp) {
        return LongExp1.mapVal("abs", LongExpFactory.cast(exp), Math::abs);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExp1.mapVal("castAsDecimal", LongExpFactory.cast(exp), BigDecimal::valueOf);
    }

    public NumExp<Long> cumSum(Exp<? extends Number> exp) {
        return LongExp1.map("cumSum", exp, LongAggregators::cumSum);
    }

    public NumExp<Long> sum(Exp<? extends Number> exp, Condition filter) {
        return new LongReduceExp1<Number>("sum", exp, LongAggregators::sum, filter);
    }

    @Override
    public NumExp<?> min(Exp<? extends Number> exp, Condition filter) {
        return new LongReduceExp1<Number>("min", exp, LongAggregators::min, filter);
    }

    @Override
    public NumExp<?> max(Exp<? extends Number> exp, Condition filter) {
        return new LongReduceExp1<Number>("max", exp, LongAggregators::max, filter);
    }

    @Override
    public NumExp<?> avg(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("avg", exp, DoubleAggregators::avg, filter);
    }

    @Override
    public NumExp<?> median(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("median", exp, s -> Percentiles.ofDoubles(s, 0.5), filter);
    }

    @Override
    public NumExp<?> quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new DoubleReduceExp1<Number>("quantile", exp, s -> Percentiles.ofDoubles(s, q), filter);
    }

    public NumExp<Long> round(Exp<? extends Number> exp) {
        return LongExpFactory.cast(exp).castAsLong();
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal("=", LongExpFactory.cast(left), LongExpFactory.cast(right), Long::equals, LongSeries::eq);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal("!=", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> !n1.equals(n2), LongSeries::ne);
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal("<", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 < n2, LongSeries::lt);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal("<=", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 <= n2, LongSeries::le);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal(">", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 > n2, LongSeries::gt);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return LongCondition2.mapVal(">=", LongExpFactory.cast(left), LongExpFactory.cast(right), (n1, n2) -> n1 >= n2, LongSeries::ge);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return LongCondition3.mapVal("between", "and", LongExpFactory.cast(left), LongExpFactory.cast(from), LongExpFactory.cast(to), (n1, n2, n3) -> n1 >= n2 && n1 <= n3, LongSeries::between);
    }
}

