/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.FloatSeries;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.DoubleReduceExp1;
import org.dflib.exp.agg.FloatAggregators;
import org.dflib.exp.agg.FloatReduceExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.DoubleExp1;
import org.dflib.exp.num.FloatCondition2;
import org.dflib.exp.num.FloatCondition3;
import org.dflib.exp.num.FloatExp1;
import org.dflib.exp.num.FloatExp2;
import org.dflib.exp.num.IntExp1;
import org.dflib.exp.num.NumericExpFactory;

public class FloatExpFactory
extends NumericExpFactory {
    protected static Exp<Float> cast(Exp<?> exp) {
        Class<?> t = exp.getType();
        if (t.equals(Float.class)) {
            return exp;
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<Float> nExp = exp;
            return FloatExp1.mapVal("castAsFloat", nExp, Number::floatValue);
        }
        if (t.equals(String.class)) {
            Exp<Float> sExp = exp;
            return FloatExp1.mapVal("castAsFloat", sExp, Float::parseFloat);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to Float");
    }

    @Override
    public NumExp<?> add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatExp2.mapVal("+", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> Float.valueOf(n1.floatValue() + n2.floatValue()), FloatSeries::add);
    }

    @Override
    public NumExp<?> sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatExp2.mapVal("-", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> Float.valueOf(n1.floatValue() - n2.floatValue()), FloatSeries::sub);
    }

    @Override
    public NumExp<?> mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatExp2.mapVal("*", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> Float.valueOf(n1.floatValue() * n2.floatValue()), FloatSeries::mul);
    }

    @Override
    public NumExp<?> div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatExp2.mapVal("/", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> Float.valueOf(n1.floatValue() / n2.floatValue()), FloatSeries::div);
    }

    @Override
    public NumExp<?> mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatExp2.mapVal("%", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> Float.valueOf(n1.floatValue() % n2.floatValue()), FloatSeries::mod);
    }

    @Override
    public NumExp<?> abs(Exp<? extends Number> exp) {
        return FloatExp1.mapVal("abs", FloatExpFactory.cast(exp), Math::abs);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExp1.mapVal("castAsDecimal", FloatExpFactory.cast(exp), BigDecimal::valueOf);
    }

    public NumExp<Double> cumSum(Exp<? extends Number> exp) {
        return DoubleExp1.map("cumSum", exp, FloatAggregators::cumSum);
    }

    public NumExp<Double> sum(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("sum", exp, FloatAggregators::sum, filter);
    }

    @Override
    public NumExp<?> min(Exp<? extends Number> exp, Condition filter) {
        return new FloatReduceExp1<Number>("min", exp, FloatAggregators::min, filter);
    }

    @Override
    public NumExp<?> max(Exp<? extends Number> exp, Condition filter) {
        return new FloatReduceExp1<Number>("max", exp, FloatAggregators::max, filter);
    }

    @Override
    public NumExp<?> avg(Exp<? extends Number> exp, Condition filter) {
        return new FloatReduceExp1<Number>("avg", exp, FloatAggregators::avg, filter);
    }

    @Override
    public NumExp<?> median(Exp<? extends Number> exp, Condition filter) {
        return new FloatReduceExp1<Number>("median", exp, s -> Float.valueOf(Percentiles.ofFloats(s, 0.5)), filter);
    }

    @Override
    public NumExp<?> quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new FloatReduceExp1<Number>("quantile", exp, s -> Float.valueOf(Percentiles.ofFloats(s, q)), filter);
    }

    public NumExp<Integer> round(Exp<? extends Number> exp) {
        return IntExp1.mapVal("round", FloatExpFactory.cast(exp), n -> Math.round(n.floatValue()));
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal("=", FloatExpFactory.cast(left), FloatExpFactory.cast(right), Float::equals, FloatSeries::eq);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal("!=", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> !n1.equals(n2), FloatSeries::ne);
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal("<", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> n1.floatValue() < n2.floatValue(), FloatSeries::lt);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal("<=", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> n1.floatValue() <= n2.floatValue(), FloatSeries::le);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal(">", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> n1.floatValue() > n2.floatValue(), FloatSeries::gt);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return FloatCondition2.mapVal(">=", FloatExpFactory.cast(left), FloatExpFactory.cast(right), (n1, n2) -> n1.floatValue() >= n2.floatValue(), FloatSeries::ge);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return FloatCondition3.mapVal("between", "and", FloatExpFactory.cast(left), FloatExpFactory.cast(from), FloatExpFactory.cast(to), (n1, n2, n3) -> n1.floatValue() >= n2.floatValue() && n1.floatValue() <= n3.floatValue(), FloatSeries::between);
    }
}

