/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.DoubleSeries;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.DoubleAggregators;
import org.dflib.exp.agg.DoubleReduceExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.DoubleCondition2;
import org.dflib.exp.num.DoubleCondition3;
import org.dflib.exp.num.DoubleExp1;
import org.dflib.exp.num.DoubleExp2;
import org.dflib.exp.num.LongExp1;
import org.dflib.exp.num.NumericExpFactory;

public class DoubleExpFactory
extends NumericExpFactory {
    protected static Exp<Double> cast(Exp<?> exp) {
        Class<?> t = exp.getType();
        if (t.equals(Double.class)) {
            return exp;
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<Double> nExp = exp;
            return DoubleExp1.mapVal("castAsDouble", nExp, Number::doubleValue);
        }
        if (t.equals(String.class)) {
            Exp<Double> sExp = exp;
            return DoubleExp1.mapVal("castAsDouble", sExp, Double::parseDouble);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to Double");
    }

    @Override
    public NumExp<?> add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleExp2.mapVal("+", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 + n2, DoubleSeries::add);
    }

    @Override
    public NumExp<?> sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleExp2.mapVal("-", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 - n2, DoubleSeries::sub);
    }

    @Override
    public NumExp<?> mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleExp2.mapVal("*", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 * n2, DoubleSeries::mul);
    }

    @Override
    public NumExp<?> div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleExp2.mapVal("/", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 / n2, DoubleSeries::div);
    }

    @Override
    public NumExp<?> mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleExp2.mapVal("%", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 % n2, DoubleSeries::mod);
    }

    @Override
    public NumExp<?> abs(Exp<? extends Number> exp) {
        return DoubleExp1.mapVal("abs", DoubleExpFactory.cast(exp), Math::abs);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExp1.mapVal("castAsDecimal", DoubleExpFactory.cast(exp), BigDecimal::valueOf);
    }

    public NumExp<Double> cumSum(Exp<? extends Number> exp) {
        return DoubleExp1.map("cumSum", exp, DoubleAggregators::cumSum);
    }

    public NumExp<Double> sum(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("sum", exp, DoubleAggregators::sum, filter);
    }

    @Override
    public NumExp<?> min(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("min", exp, DoubleAggregators::min, filter);
    }

    @Override
    public NumExp<?> max(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("max", exp, DoubleAggregators::max, filter);
    }

    @Override
    public NumExp<?> avg(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("avg", exp, DoubleAggregators::avg, filter);
    }

    @Override
    public NumExp<?> median(Exp<? extends Number> exp, Condition filter) {
        return new DoubleReduceExp1<Number>("median", exp, s -> Percentiles.ofDoubles(s, 0.5), filter);
    }

    @Override
    public NumExp<?> quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new DoubleReduceExp1<Number>("quantile", exp, s -> Percentiles.ofDoubles(s, q), filter);
    }

    public NumExp<Long> round(Exp<? extends Number> exp) {
        return LongExp1.mapVal("round", DoubleExpFactory.cast(exp), n -> Math.round(n));
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal("=", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), Double::equals, DoubleSeries::eq);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal("!=", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> !n1.equals(n2), DoubleSeries::ne);
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal("<", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 < n2, DoubleSeries::lt);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal("<=", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 <= n2, DoubleSeries::le);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal(">", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 > n2, DoubleSeries::gt);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DoubleCondition2.mapVal(">=", DoubleExpFactory.cast(left), DoubleExpFactory.cast(right), (n1, n2) -> n1 >= n2, DoubleSeries::ge);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return DoubleCondition3.mapVal("between", "and", DoubleExpFactory.cast(left), DoubleExpFactory.cast(from), DoubleExpFactory.cast(to), (n1, n2, n3) -> n1 >= n2 && n1 <= n3, DoubleSeries::between);
    }
}

