/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.num;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.Function;
import org.dflib.Condition;
import org.dflib.DecimalExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.DecimalAggregators;
import org.dflib.exp.agg.DecimalReduceExp1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.num.BigintExp1;
import org.dflib.exp.num.DecimalExp1;
import org.dflib.exp.num.DecimalExp2;
import org.dflib.exp.num.NumericExpFactory;

public class DecimalExpFactory
extends NumericExpFactory {
    private static MathContext divisionContext(BigDecimal n1, BigDecimal n2) {
        return new MathContext(Math.max(15, 1 + Math.max(n1.precision(), n2.precision())), RoundingMode.HALF_UP);
    }

    protected static DecimalExp cast(Exp<?> exp) {
        if (exp instanceof DecimalExp) {
            return (DecimalExp)exp;
        }
        Class<?> t = exp.getType();
        if (t.equals(BigDecimal.class)) {
            Exp<?> bdExp = exp;
            return DecimalExp1.mapVal("castAsDecimal", bdExp, Function.identity());
        }
        if (t.equals(BigInteger.class)) {
            Exp<?> biExp = exp;
            return DecimalExp1.mapVal("castAsDecimal", biExp, BigDecimal::new);
        }
        if (Number.class.isAssignableFrom(t)) {
            Exp<?> nExp = exp;
            return DecimalExp1.mapVal("castAsDecimal", nExp, n -> BigDecimal.valueOf(n.doubleValue()).stripTrailingZeros());
        }
        if (t.equals(String.class)) {
            Exp<?> sExp = exp;
            return DecimalExp1.mapVal("castAsDecimal", sExp, BigDecimal::new);
        }
        throw new IllegalArgumentException("Expression type '" + t.getName() + "' can't be converted to 'decimal'");
    }

    public DecimalExp add(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DecimalExp2.mapVal("+", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), BigDecimal::add);
    }

    public DecimalExp sub(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DecimalExp2.mapVal("-", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), BigDecimal::subtract);
    }

    public DecimalExp mul(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DecimalExp2.mapVal("*", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), BigDecimal::multiply);
    }

    public DecimalExp div(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DecimalExp2.mapVal("/", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.divide((BigDecimal)n2, DecimalExpFactory.divisionContext(n1, n2)).stripTrailingZeros());
    }

    public DecimalExp mod(Exp<? extends Number> left, Exp<? extends Number> right) {
        return DecimalExp2.mapVal("%", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.remainder((BigDecimal)n2, DecimalExpFactory.divisionContext(n1, n2)).stripTrailingZeros());
    }

    public DecimalExp abs(Exp<? extends Number> exp) {
        return DecimalExp1.mapVal("abs", DecimalExpFactory.cast(exp), BigDecimal::abs);
    }

    @Override
    public NumExp<BigInteger> castAsBigint(NumExp<?> exp) {
        return BigintExp1.mapVal("castAsBigint", DecimalExpFactory.cast(exp), BigDecimal::toBigInteger);
    }

    @Override
    public DecimalExp castAsDecimal(NumExp<?> exp) {
        return DecimalExpFactory.cast(exp);
    }

    public DecimalExp cumSum(Exp<? extends Number> exp) {
        return DecimalExp1.map("cumSum", DecimalExpFactory.cast(exp), DecimalAggregators::cumSum);
    }

    @Deprecated
    public DecimalExp sum(Exp<? extends Number> exp) {
        return this.sum((Exp)exp, (Condition)null);
    }

    public DecimalExp sum(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("sum", DecimalExpFactory.cast(exp), DecimalAggregators::sum, filter);
    }

    @Deprecated
    public DecimalExp min(Exp<? extends Number> exp) {
        return this.min((Exp)exp, (Condition)null);
    }

    public DecimalExp min(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("min", DecimalExpFactory.cast(exp), ComparableAggregators::min, filter);
    }

    @Deprecated
    public DecimalExp max(Exp<? extends Number> exp) {
        return this.max((Exp)exp, (Condition)null);
    }

    public DecimalExp max(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("max", DecimalExpFactory.cast(exp), ComparableAggregators::max, filter);
    }

    @Deprecated
    public DecimalExp avg(Exp<? extends Number> exp) {
        return this.avg((Exp)exp, (Condition)null);
    }

    public DecimalExp avg(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("avg", DecimalExpFactory.cast(exp), DecimalAggregators::avg, filter);
    }

    @Deprecated
    public DecimalExp median(Exp<? extends Number> exp) {
        return this.median((Exp)exp, (Condition)null);
    }

    public DecimalExp median(Exp<? extends Number> exp, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("median", DecimalExpFactory.cast(exp), s -> Percentiles.ofDecimals(s, 0.5), filter);
    }

    public DecimalExp quantile(Exp<? extends Number> exp, double q, Condition filter) {
        return new DecimalReduceExp1<BigDecimal>("quantile", DecimalExpFactory.cast(exp), s -> Percentiles.ofDecimals(s, q), filter);
    }

    public DecimalExp round(Exp<? extends Number> exp) {
        return DecimalExp1.mapVal("round", DecimalExpFactory.cast(exp), n -> n.setScale(0, RoundingMode.HALF_UP));
    }

    @Override
    public Condition eq(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("=", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) == 0);
    }

    @Override
    public Condition ne(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("!=", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) != 0);
    }

    @Override
    public Condition lt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("<", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) < 0);
    }

    @Override
    public Condition le(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal("<=", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) <= 0);
    }

    @Override
    public Condition gt(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal(">", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) > 0);
    }

    @Override
    public Condition ge(Exp<? extends Number> left, Exp<? extends Number> right) {
        return MapCondition2.mapVal(">=", DecimalExpFactory.cast(left), DecimalExpFactory.cast(right), (n1, n2) -> n1.compareTo((BigDecimal)n2) >= 0);
    }

    @Override
    public Condition between(Exp<? extends Number> left, Exp<? extends Number> from, Exp<? extends Number> to) {
        return MapCondition3.mapVal("between", "and", DecimalExpFactory.cast(left), DecimalExpFactory.cast(from), DecimalExpFactory.cast(to), (n1, n2, n3) -> n1.compareTo((BigDecimal)n2) >= 0 && n1.compareTo((BigDecimal)n3) <= 0);
    }
}

